<?php

namespace WPMinimize\TimeFix\Admin;

defined( 'ABSPATH' ) || exit;

class RegisterMenu {

	public static function init() {
		add_action( 'admin_menu', [ __CLASS__, 'register_menu' ] );
	}

	public static function register_menu() {
		add_submenu_page(
			'edit.php?post_type=' . wpm_timefix()->service_post_type,
			__( 'Appointments', 'timefix' ),
			__( 'Appointments', 'timefix' ),
			'manage_options',
			'timefix-appointments',
			[ __CLASS__, 'appointments_menu' ]
		);
		add_submenu_page(
			'edit.php?post_type=' . wpm_timefix()->service_post_type,
			__( 'Payments', 'timefix' ),
			__( 'Payments', 'timefix' ),
			'manage_options',
			'timefix-payments',
			[ __CLASS__, 'orders_menu' ]
		);
		add_submenu_page(
			'edit.php?post_type=' . wpm_timefix()->service_post_type,
			__( 'Customers', 'timefix' ),
			__( 'Customers', 'timefix' ),
			'manage_options',
			'timefix-customers',
			[ __CLASS__, 'customers_menu' ]
		);
		add_submenu_page(
			'edit.php?post_type=' . wpm_timefix()->service_post_type,
			__( 'Settings', 'timefix' ),
			__( 'Settings', 'timefix' ),
			'manage_options',
			'timefix-settings',
			[ __CLASS__, 'settings_menu' ]
		);
		/*add_submenu_page(
			'edit.php?post_type=' . wpm_timefix()->service_post_type,
			__( 'Support', 'timefix' ),
			__( 'Support', 'timefix' ),
			'manage_options',
			'timefix-support',
			[ __CLASS__, 'support_menu' ]
		);*/
	}

	public static function settings_menu() {
		require_once trailingslashit( WPM_TIMEFIX_PATH ) . 'views/settings.php';
	}

	public static function appointments_menu() {
		require_once trailingslashit( WPM_TIMEFIX_PATH ) . 'views/appointments.php';
	}

	public static function orders_menu() {
		require_once trailingslashit( WPM_TIMEFIX_PATH ) . 'views/orders.php';
	}

	public static function customers_menu() {
		require_once trailingslashit( WPM_TIMEFIX_PATH ) . 'views/customers.php';
	}

	public static function support_menu() {
		require_once trailingslashit( WPM_TIMEFIX_PATH ) . 'views/support.php';
	}

}