<?php

namespace WPMinimize\TimeFix\Admin;

defined( 'ABSPATH' ) || exit;

class FilterHooks {
	public static function init() {
		add_filter( 'use_block_editor_for_post_type', [ __CLASS__, 'disable_gutenberg' ], 10, 2 );
	}

	public static function disable_gutenberg( $use_block_editor, $post_type ) {

		if ( in_array( $post_type, [ wpm_timefix()->service_post_type, wpm_timefix()->staff_post_type ] ) ) {
			$use_block_editor = false;
		}

		return $use_block_editor;
	}
}