<?php

namespace WPMinimize\TimeFix\Admin;

defined( 'ABSPATH' ) || exit;

class ActionHooks {
	public static function init() {
		add_action( 'admin_head', [ __CLASS__, 'timefix_menu_admin_styles' ], 100 );
		add_action( 'in_admin_header', [ __CLASS__, 'remove_all_notices' ], 999 );
	}

	public static function timefix_menu_admin_styles() {
		?>
        <style>
            #adminmenu li.menu-top.menu-icon-timefix_services .wp-menu-image img {
                max-width: 20px;
                opacity: 1;
                padding: 7px 0;
            }
        </style>
		<?php
	}

	public static function remove_all_notices() {
		$screen = get_current_screen();

		if ( isset( $screen->base ) && ( 'timefix_services_page_timefix-settings' == $screen->base ) || 'timefix_services_page_timefix-appointments' == $screen->base || 'timefix_services_page_timefix-payments' == $screen->base || 'timefix_services_page_timefix-customers' == $screen->base ) {
			remove_all_actions( 'admin_notices' );
			remove_all_actions( 'all_admin_notices' );
		}
	}
}