;
(function ($) {
  var currentStep = 1;
  var selectedSlot = "";
  $.fn.timefixBlock = function (settings) {
    var defaults = {
      overlayCSS: {
        zIndex: 1000,
        border: 'none',
        margin: 0,
        padding: 0,
        width: '100%',
        height: '100%',
        top: 0,
        left: 0,
        background: 'rgb(255, 255, 255)',
        opacity: 0.6,
        cursor: 'wait',
        position: 'absolute',
        color: "#556b2f",
        backgroundColor: "white"
      }
    };
    var options = $.extend({}, defaults, settings || {});
    var overlayCSS = $.extend({}, defaults.overlayCSS, options.overlayCSS || {});
    return this.each(function () {
      var $element = $(this);
      if ($element.css('position') === 'static') {
        this.style.position = 'relative';
        $element.data('timefix-block.static', true);
      }
      this.style.zoom = 1;
      var overlay = $('<div class="timefix-loading-overlay" />').css(overlayCSS);
      $element.find('> .timefix-loading-overlay').remove();
      $element.addClass('timefix-loading').append(overlay);
    });
  };
  $.fn.timefixUnblock = function () {
    return this.each(function () {
      var $element = $(this);
      if ($element.data('timefix-block', 'static')) {
        $element.css('position', 'static'); // #22
      }
      $element.removeClass('timefix-loading').find('> .timefix-loading-overlay').remove();
    });
  };
  window.timefixFilter = {
    filters: {},
    add: function add(tag, callback_fn) {
      (this.filters[tag] || (this.filters[tag] = [])).push(callback_fn);
    },
    remove: function remove(tag) {
      if (this.filters[tag]) {
        delete this.filters[tag];
      }
    },
    apply: function apply(tag, val) {
      if (this.filters[tag]) {
        var filters = this.filters[tag];
        for (var i = 0; i < filters.length; i++) {
          val = filters[i](val);
        }
      }
      return val;
    }
  };
  window.timefixInitDateField = function () {
    if ($.fn.daterangepicker) {
      $(".timefix-date").each(function () {
        var input = $(this);
        var options = input.data("options") || {};
        options = timefixFilter.apply('dateRangePickerOptions', options);
        if (Array.isArray(options.invalidDateList) && options.invalidDateList.length) {
          options.isInvalidDate = function (param) {
            return options.invalidDateList.includes(param.format(options.locale.format));
          };
        }
        $(this).daterangepicker(options);
        if (options.autoUpdateInput === false) {
          input.on("apply.daterangepicker", function (ev, picker) {
            if (picker.singleDatePicker) {
              $(this).val(picker.startDate.format(picker.locale.format));
            } else {
              $(this).val(picker.startDate.format(picker.locale.format) + picker.locale.separator + picker.endDate.format(picker.locale.format));
            }
          });
          input.on("cancel.daterangepicker", function (ev, picker) {
            $(this).val("");
          });
        }
      });
    }
  };

  // Email validation helper
  function isValidEmail(email) {
    var emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
    return emailRegex.test(email);
  }

  // Validation logic per step
  function validateStep(step) {
    switch (step) {
      case 1:
        var fields = ["service-cats", "service-id", "staff-id", "booking-date", "timefix-booking-time-slot"];
        for (var _i = 0, _fields = fields; _i < _fields.length; _i++) {
          var field = _fields[_i];
          var $el = $("#".concat(field));
          if ($el.length) {
            if (($el.val() || '').trim() === '') {
              return false;
            }
          }
        }
        return true;
      case 2:
        var name = $("#customer-name").val().trim();
        var phone = $("#customer-phone").val().trim();
        return name !== "" && phone !== "";
      default:
        return true;
    }
  }

  // Enable/disable next button
  function updateNextButtonState(step) {
    var isValid = validateStep(step);
    $(".timefix-form-step[data-step=".concat(step, "] .timefix-next-btn")).prop("disabled", !isValid);
  }

  // Navigation
  function showStep(step) {
    $(".timefix-form-step").hide();
    $(".timefix-form-step[data-step=".concat(step, "]")).show();
    updateNextButtonState(step);
    currentStep = step;
  }
  function woocommerce_checkout() {
    var formSelector = '#timefix-appointment-form',
      $form = $(formSelector);
    var formData = new FormData($form[0]);
    formData.append('wpm_timefix_wpnonce', wpm_timefix_public.wpm_timefix_wpnonce);
    formData.append('action', 'timefix_appointment_wc_checkout');
    $.ajax({
      url: wpm_timefix_public.ajax_url,
      data: formData,
      cache: false,
      contentType: false,
      processData: false,
      type: 'POST',
      beforeSend: function beforeSend() {
        $form.timefixBlock();
      },
      success: function success(response) {
        $form.timefixUnblock();
        if (response.success && response !== null && response !== void 0 && response.redirect) {
          window.location.href = response.redirect;
        }
      },
      error: function error(jqXhr, json, errorThrown) {
        $form.timefixUnblock();
      }
    });
  }

  // Load services
  function loadServices() {
    var categoryId = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';
    var $form = $(".timefix-appointment-form-wrapper").find('form');
    var $serviceSelect = $form.find('#service-id');
    $.ajax({
      url: wpm_timefix_public.ajax_url,
      type: 'POST',
      data: {
        action: 'timefix_load_services_by_category',
        wpm_timefix_wpnonce: wpm_timefix_public.wpm_timefix_wpnonce,
        category_id: categoryId
      },
      dataType: 'json',
      beforeSend: function beforeSend() {
        $serviceSelect.empty();
        $form.timefixBlock();
      },
      success: function success(response) {
        var services = response.data;

        // Add placeholder
        $serviceSelect.append(new Option('Select Service', ''));
        $.each(services, function (id, text) {
          $serviceSelect.append(new Option(text, id));
        });
        $serviceSelect.trigger('change');
        updateNextButtonState(1);
        $form.timefixUnblock();
      },
      error: function error() {
        $form.timefixUnblock();
      }
    });
  }
  $(document).ready(function () {
    $("#customer-name, #customer-phone").on("input", function () {
      updateNextButtonState(2);
    });
    $(".timefix-next-btn").on("click", function (e) {
      e.preventDefault();
      if (!validateStep(currentStep)) {
        alert("Please fill all required fields before continuing.");
        return false;
      }
      if ($(this).closest('form').hasClass('timefix-enabled-wc-payment')) {
        woocommerce_checkout();
        return false;
      }
      $overview = $('.timefix-appointments-information-overview');
      if (currentStep === 2) {
        $overview.find(".selected-category span:last-child").text($('#service-cats').find(':selected').text());
        $overview.find(".selected-service span:last-child").text($('#service-id').find(':selected').text());
        $overview.find(".selected-staff span:last-child").text($('#staff-id').find(':selected').text());
        $overview.find(".selected-date span:last-child").text($("#booking-date").val());
        $overview.find(".selected-time span:last-child").text(selectedSlot);
        $overview.find(".selected-name span:last-child").text($("#customer-name").val());
        $overview.find(".selected-email span:last-child").text($("#customer-email").val());
        $overview.find(".selected-phone span:last-child").text($("#customer-phone").val());
        if ($('.timefix-service-details-content .timefix-service-title').length) {
          $overview.find(".selected-service span:last-child").text($('.timefix-service-details-content .timefix-service-title').html());
        }
        if ($('.timefix-staff-summary-section .timefix-staff-name').length) {
          $overview.find(".selected-staff span:last-child").text($('.timefix-staff-summary-section .timefix-staff-name').html());
        }
      }
      showStep(currentStep + 1);
    });
    $(".timefix-prev-btn").on("click", function (e) {
      e.preventDefault();
      showStep(currentStep - 1);
    });
    timefixInitDateField();
    if ($.fn.select2) {
      $(".timefix-select2").select2({
        placeholder: "Select Option"
      });
    }
    $(".timefix-appointment-form-wrapper").on('change', '#service-cats', function () {
      var categoryId = $(this).val();
      loadServices(categoryId);
    });
    if ($(".timefix-appointment-form-wrapper #service-cats").length === 0) {
      loadServices();
    }
    $(".timefix-appointment-form-wrapper").on('change', '#service-id', function () {
      var $this = $(this),
        $form = $this.closest('form'),
        $staffSelect = $form.find('#staff-id'),
        serviceId = $this.val();
      if (serviceId) {
        $.ajax({
          url: wpm_timefix_public.ajax_url,
          type: 'POST',
          data: {
            action: 'timefix_load_staffs_by_service',
            wpm_timefix_wpnonce: wpm_timefix_public.wpm_timefix_wpnonce,
            service_id: serviceId
          },
          dataType: 'json',
          beforeSend: function beforeSend() {
            $staffSelect.empty();
            $form.timefixBlock();
          },
          success: function success(response) {
            var staffs = response.data;
            // Add an empty option first
            $staffSelect.append(new Option('Select Staff', ''));
            // Loop through and add new options
            $.each(staffs, function (id, text) {
              $staffSelect.append(new Option(text, id));
            });
            // Refresh select2
            $staffSelect.trigger('change');
            updateNextButtonState(1);
            $form.timefixUnblock();
          },
          error: function error(xhr, textStatus, errorThrown) {
            console.error(errorThrown);
            $form.timefixUnblock();
          }
        });
      } else {
        $staffSelect.empty().trigger('change');
      }
    });
    $(".timefix-appointment-form-wrapper").on('change', '#staff-id', function () {
      var $this = $(this),
        $form = $this.closest('form'),
        staffId = $this.val();
      if (staffId) {
        updateNextButtonState(1);
      }
    });
    $(".timefix-appointment-form-wrapper").on('change', '#booking-date', function () {
      var $this = $(this),
        $wrapper = $this.closest('.timefix-appointment-form-wrapper'),
        $form = $wrapper.find('form'),
        $timeslotContainer = $form.find("#timefix-time-slots-container"),
        service_id = $form.find('#service-id').val(),
        staff_id = $form.find('#staff-id').val();
      if (!staff_id) {
        alert('Please, select staff first!');
        return false;
      }
      if (!service_id) {
        alert('Please, select service for an appointment!');
        return false;
      }
      var data = {
        service_id: service_id,
        staff_id: staff_id,
        booking_date: $this.val(),
        action: 'timefix_staff_time_slots',
        wpm_timefix_wpnonce: wpm_timefix_public.wpm_timefix_wpnonce
      };
      $.ajax({
        url: wpm_timefix_public.ajax_url,
        data: data,
        type: 'POST',
        beforeSend: function beforeSend() {
          $timeslotContainer.html('');
          $form.timefixBlock();
        },
        success: function success(data) {
          var timeSlots = data.data;
          if (Array.isArray(timeSlots) && timeSlots.length > 0) {
            timeSlots.forEach(function (slot) {
              console.log(slot);
              var start = slot.start;
              var end = slot.end;
              var status = slot.status;
              var $timeSlotHtml = "".concat(start, " - <span class=\"end-time\">").concat(end, "</span>");
              var $button = $("<button>").addClass("timeslot-button").attr("data-timeslot", "".concat(start, "-").concat(end)).html($timeSlotHtml);
              if (status === "booked") {
                $button.addClass("booked").prop("disabled", true);
              }
              $timeslotContainer.append($button);
            });
          } else {
            var $timeSlotHtml = "<span class=\"not-found\">Service not available for selected date, please try another date.</span>";
            $timeslotContainer.append($timeSlotHtml);
          }
          $form.timefixUnblock();
        },
        error: function error(e) {
          console.log(e);
          $form.timefixUnblock();
        }
      });
    });
    $("#timefix-time-slots-container").on('click', 'button', function (e) {
      e.preventDefault();
      var $this = $(this),
        $container = $this.closest('#timefix-time-slots-container'),
        timeslot = $this.attr('data-timeslot'),
        $input = $('#timefix-booking-time-slot');
      $input.val(timeslot).change();
      selectedSlot = timeslot;
      $container.find('button').removeClass('selected');
      $this.addClass('selected');
      updateNextButtonState(1);
    });
    $(document).on('click', '.timefix-appointment-success button', function (e) {
      e.preventDefault();
      location.reload();
    });
    if (!$('form.timefix-enabled-wc-payment').length) {
      $(document).on('submit', '.timefix-appointment-form-wrapper form', function (e) {
        e.preventDefault();
        var $this = $(this),
          $wrapper = $this.closest('.timefix-appointment-form-wrapper'),
          msgHolder = $("<div class='timefix-response'></div>"),
          $form = $wrapper.find('form');
        var formData = new FormData(this);
        formData.append('wpm_timefix_wpnonce', wpm_timefix_public.wpm_timefix_wpnonce);
        formData.append('action', 'timefix_submit_appointment_form');
        $.ajax({
          url: wpm_timefix_public.ajax_url,
          data: formData,
          cache: false,
          contentType: false,
          processData: false,
          type: 'POST',
          beforeSend: function beforeSend() {
            $form.find('.timefix-response').remove();
            $form.find('button[type=submit]').prop("disabled", true);
            $form.timefixBlock();
          },
          success: function success(response) {
            $form.timefixUnblock();
            if (response.success) {
              $form.find('.timefix-appointments-final-step-fields').remove();
              $form.find('.timefix-appointments-final-step').hide();
              $(".timefix-appointment-section").find(".timefix-section-heading").hide();
              msgHolder.removeClass('timefix-response-danger').addClass('timefix-appointment-success');
              msgHolder.append("<i class='fa-solid fa-check'></i>");
              msgHolder.append("<h4>" + response.title + "</h4>");
              msgHolder.append("<span>" + response.message + "</span>");
              msgHolder.append("<button class='timefix-btn' type='button'>" + response.btn_text + "</button>");
              msgHolder.appendTo($form);
              $form.change();
            } else {
              $form.find('button[type=submit]').prop("disabled", false);
              msgHolder.removeClass('timefix-appointment-success').addClass('timefix-response-danger').html(response.message).appendTo($form);
            }
          },
          error: function error(jqXhr, json, errorThrown) {
            msgHolder.removeClass('timefix-appointment-success').addClass('timefix-response-danger').html(e.responseText).appendTo($form);
            $form.find('button[type=submit]').prop("disabled", false);
            $form.timefixUnblock();
          }
        });
      });
    }
  });
})(jQuery);
