(function ($) {


	
	jQuery(document).off('tpfw_loaded_blocks').on('tpfw_loaded_blocks_timepicker_shipping', function () {
		//console.log('timepicker.js init shipping');
		init_events();

	});


	function init() {
		try {



			var stop, date, minTime;
			var extra = 0;
			if (tpfwcheckoutdelivery.is_rollover == 0) {
				stop = (tpfwcheckoutdelivery.todayclose)[0];
				date = (tpfwcheckoutdelivery.actual_date)[0];
				minTime = (tpfwcheckoutdelivery.todayopen)[0];
			} else {
				if (tpfwcheckoutdelivery.is_rollover in tpfwcheckoutdelivery.actual_date == false) {
					throw new Error("This was an error");
				}
				stop = tpfwcheckoutdelivery.is_rollover in tpfwcheckoutdelivery.todayclose ? (tpfwcheckoutdelivery.todayclose)[tpfwcheckoutdelivery.is_rollover] : 0;
				date = tpfwcheckoutdelivery.is_rollover in tpfwcheckoutdelivery.actual_date ? (tpfwcheckoutdelivery.actual_date)[tpfwcheckoutdelivery.is_rollover] : null;
				minTime = tpfwcheckoutdelivery.is_rollover in tpfwcheckoutdelivery.todayopen ? (tpfwcheckoutdelivery.todayopen)[tpfwcheckoutdelivery.is_rollover] : 0;
			}
			var disableRange = [];
			if (minTime === 0) {
				disableRange.push(['00:00', '23:59']);
			}
			if ((tpfwcheckoutdelivery.full_slots).length) {
				_.each(tpfwcheckoutdelivery.full_slots, function (element, i, list) {
					if (date == element.date) {
						disableRange.push([element.time, element.time_end]);
					}
				}, this);
			}
			if ((tpfwcheckoutdelivery.disable_array).length) {
				_.each(tpfwcheckoutdelivery.disable_array, function (element, i, list) {
					if (date == element.date) {
						disableRange.push([element.start, element.stop]);
					}
				}, this);
			}
			var args = {
				'scrollDefault': 'now',
				'minTime': minTime,
				'maxTime': stop,
				'step': tpfwcheckoutdelivery.step,
				'timeFormat': tpfwcheckoutdelivery.time_format,
				'disableTimeRanges': disableRange,
				'extra': 0,
				'showDuration': tpfwcheckoutdelivery.showDuration == 1 ? true : false,
				'listWidth': 1,
				'secondsfromMidnight': parseInt(tpfwcheckoutdelivery.secondsfromMidnight),

			};
			if (tpfwcheckoutdelivery.show_asap == 1 && tpfwcheckoutdelivery.is_open == 1 && tpfwcheckoutdelivery.is_rollover == 0) {
				args.noneOption = [{
					'label': tpfwcheckoutdelivery.asap_text,
					'value': tpfwcheckoutdelivery.asap_text,
					'className': 'tpfw-asap'
				}, ];
			}
			$('#tpfw-time').timepicker(args);
			if (tpfwcheckoutdelivery.show_asap == 1 && tpfwcheckoutdelivery.is_open == 1) {
				$('#tpfw-time').on('showTimepicker', function () {
					check_if_asap();
				});
			}


			var timer;
			clearInterval(timer);
			timer = setInterval(function () {
				extra = extra + 120;

				if ($('#tpfw-date').find('option:selected').val() == $('#tpfw-date').find('option').first().val()) {
					$('#tpfw-time').timepicker('show');
					var ulList = $('div.ui-timepicker-wrapper').last().find('ul.ui-timepicker-list');
					let first_text = ulList.find('li').not('.ui-timepicker-disabled').first().text();
					let selectedisfirst = !(_.isUndefined(first_text) || _.isNull(first_text) || first_text.trim().length === 0) && ulList.find('li').not('.ui-timepicker-disabled').first().text() == ulList.find('li').filter('.ui-timepicker-selected').text();
					let selected = ulList.find('li').filter('.ui-timepicker-selected').first();
					$('#tpfw-time').timepicker('hide');
					let time = selected.length ? selected.data('time') : false;
					update_form($('#tpfw-date'), extra, true, time, selectedisfirst);
					//alert(time);
				}
			}, 120000);
			setTimeout(function () {
				clearInterval(timer);
				window.location.reload();
			}, 60000 * 15);
			$('select#tpfw-date option[value=' + date + ']').prop('selected', true);
			trigger_change('tpfw-date');
			if (jQuery('select#tpfw-date').val() === date) {
				$('select#tpfw-date option[value=' + date + ']').prevAll().prop('disabled', true);
			}
			//Disable days that never opens
			var disabledates = [];
			_.each(tpfwcheckoutdelivery.disable_array, function (element, i, list) {
				if (element.start == "00:00" && element.stop == "23:59") {
					disabledates.push(element.date);
				}
			});
			$('#tpfw-date').off('change.tpfwdate').on('change.tpfwdate', function () {

				update_form(this, extra, false, false, false);
			});
			$('#tpfw-time').off('showTimepicker.tpfw').on('showTimepicker.tpfw', function () {
				remove_disabled_times();
			});




			var haschanged = false;
			_.each($("select#tpfw-date option"), function (element, i, list) {

				$(element).find('.tpfw-date-closed').remove();
				if (0 === tpfwcheckoutdelivery.todayopen[i]) {
					$(element).prop('disabled', true);
					if (!$(element).find('span').hasClass('tpfw-date-closed')) {
						$(element).append('<span class="tpfw-date-closed"> (' + tpfwcheckoutdelivery.closed_text + ')</span>');
					}
					if (!haschanged && $(element).is(':selected')) {
						$("select#tpfw-date option").not(':selected').not(':disabled').first().prop('selected', true);

						haschanged = true;
					}
				} else if (_.contains(disabledates, $(element).val())) {
					$(element).prop('disabled', true);
					if (!$(element).find('span').hasClass('tpfw-date-closed')) {
						$(element).append('<span class="tpfw-date-closed"> (' + tpfwcheckoutdelivery.closed_text + ')</span>');
					}
					if (!haschanged && $(element).is(':selected')) {
						$("select#tpfw-date option").not(':selected').not(':disabled').first().prop('selected', true);

						haschanged = true;
					}
				}

			});
			if (haschanged) {
				trigger_change('tpfw-date');
			}
			if (tpfwcheckoutdelivery.preselect_time == 1 && $('#tpfw-date').find('option:selected').val() == $('#tpfw-date').find('option').first().val()) {
				$('#tpfw-time').timepicker('show');
				var first = $('.ui-timepicker-wrapper').last().find('.ui-timepicker-list').find('li').not('.ui-timepicker-disabled').first();
				$('#tpfw-time').timepicker('hide');
				if (first.length) {
					insert_and_trigger('tpfw-time', first.text());




				}

			}





		} catch (err) {
			alert(err);
			let args = {
				'scrollDefault': 'now',
				'minTime': '00:00am',
				'maxTime': '11:58pm',
				'step': tpfwcheckoutdelivery.step,
				'disableTimeRanges': [
					['00:00am', '11:59pm'],
				],
				'extra': 0,
				'time_to_add': tpfwcheckoutdelivery.time_to_add,
				'showDuration': tpfwcheckoutdelivery.showDuration == 1 ? true : false,
				'listWidth': 1,
				'secondsfromMidnight': parseInt(tpfwcheckoutdelivery.secondsfromMidnight),
			};
			$('#tpfw-time').timepicker(args);
		}
	}

	function check_if_asap() {
		var wrapper = $('div.ui-timepicker-wrapper').last();
		if ($('#tpfw-date').find('option:selected').val() != $('#tpfw-date').find('option').first().val()) {
			wrapper.find('ul.ui-timepicker-list').find('li.tpfw-asap').remove();
		}
		if ($('#tpfw-date').find('option:selected').val() == $('#tpfw-date').find('option').first().val()) {
			var first = wrapper.find('ul.ui-timepicker-list').find('li').not('.ui-timepicker-disabled').not('.tpfw-asap').first();
			if (first.length) {} else {
				wrapper.find('ul.ui-timepicker-list').find('li.tpfw-asap').remove();
			}
		}
	}

	function remove_disabled_times() {
		$('div.ui-timepicker-wrapper').last().find('ul.ui-timepicker-list').find('li.ui-timepicker-disabled').remove();
	}

	function update_form($this, extra, fromtimeout, time, selectedisfirst) {
		var extra2 = 0;
		insert_and_trigger('tpfw-time', '');
		if ($('#tpfw-date').find('option:selected').val() == $('#tpfw-date').find('option').first().val()) {
			stop = (tpfwcheckoutdelivery.todayclose)[0];
			date = (tpfwcheckoutdelivery.actual_date)[0];
			minTime = (tpfwcheckoutdelivery.todayopen)[0];
			extra2 = extra;
		} else if (tpfwcheckoutdelivery.is_rollover == 1 && $('#tpfw-date').find('option:selected').val() == $("#tpfw-date option:nth-of-type(2)").val()) {
			stop = (tpfwcheckoutdelivery.todayclose)[1];
			date = (tpfwcheckoutdelivery.actual_date)[1];
			minTime = (tpfwcheckoutdelivery.todayopen)[1];
			extra2 = extra;
		} else {
			let index = $("option:selected", $this).index();
			stop = (tpfwcheckoutdelivery.todayclose)[index];
			date = (tpfwcheckoutdelivery.actual_date)[index];
			minTime = (tpfwcheckoutdelivery.todayopen)[index];
			extra2 = 0;
		}
		var disableRange = [];
		if (minTime === 0) {
			disableRange.push(['00:00', '23:59']);
		}
		if ((tpfwcheckoutdelivery.full_slots).length) {
			_.each(tpfwcheckoutdelivery.full_slots, function (element, i, list) {
				if (date == element.date) {
					disableRange.push([element.time, element.time_end]);
				}
			}, this);
		}
		if ((tpfwcheckoutdelivery.disable_array).length) {
			_.each(tpfwcheckoutdelivery.disable_array, function (element, i, list) {
				if (date == element.date) {
					disableRange.push([element.start, element.stop]);
				}
			}, this);
		}
		let args = {
			'scrollDefault': 'now',
			'minTime': minTime,
			'maxTime': stop,
			'step': tpfwcheckoutdelivery.step,
			'timeFormat': tpfwcheckoutdelivery.time_format,
			'disableTimeRanges': disableRange,
			'showDuration': tpfwcheckoutdelivery.showDuration == 1 ? true : false,
			'extra': extra2,
			'time_to_add': tpfwcheckoutdelivery.time_to_add,
			'listWidth': 1,
			'secondsfromMidnight': parseInt(tpfwcheckoutdelivery.secondsfromMidnight),
		};
		//	alert(JSON.stringify(args));
		if (tpfwcheckoutdelivery.show_asap == 1 && tpfwcheckoutdelivery.is_open == 1) {
			args.noneOption = [{
				'label': tpfwcheckoutdelivery.asap_text,
				'value': tpfwcheckoutdelivery.asap_text,
				'className': 'tpfw-asap'
			}, ];
		}
		$('#tpfw-time').timepicker('remove');
		$('#tpfw-time').timepicker(args);
		if (fromtimeout && !selectedisfirst && time !== false) {

			$('#tpfw-time').timepicker('show');
			let wrapper = $('div.ui-timepicker-wrapper').last();
			var trythisone = wrapper.find('ul.ui-timepicker-list').find('li').filter("[data-time='" + time + "']").not('.ui-timepicker-disabled').first();
			$('#tpfw-time').timepicker('hide');
			if (trythisone.length) {
				insert_and_trigger('tpfw-time', trythisone.text());


			} else {
				wrapper.find('ul.ui-timepicker-list').find('li').removeClass('ui-timepicker-selected');

			}
		} else if ((fromtimeout && selectedisfirst) ||
			(!fromtimeout && tpfwcheckoutdelivery.preselect_time == 1 && $('#tpfw-date').find('option:selected').val() == $('#tpfw-date').find('option').first().val())
		) {


			$('#tpfw-time').timepicker('show');
			let wrapper = $('div.ui-timepicker-wrapper').last();
			var first = wrapper.find('ul.ui-timepicker-list').find('li').not('.ui-timepicker-disabled').first();
			$('#tpfw-time').timepicker('hide');
			if (first.length) {
				insert_and_trigger('tpfw-time', first.text());


			}
		}
	}

	function insert_and_trigger(
		el_id,
		value = false,

	) {
		try {
			let input = document.getElementById(el_id);

			if (_.isNull(input)) {
				return;
			}
			
			value =
				value == false ?
				input.value :
				value;
			
			

			const valueSetter = Object.getOwnPropertyDescriptor(input, 'value').set;
			const prototype = Object.getPrototypeOf(input);
			const prototypeValueSetter = Object.getOwnPropertyDescriptor(prototype, 'value').set;
			if (valueSetter && valueSetter !== prototypeValueSetter) {
				prototypeValueSetter.call(input, value);
			} else {
				valueSetter.call(input, value);
			}
			input.dispatchEvent(new Event('input', {
				bubbles: true
			}));


		} catch (err) {
			console.debug(err);
		}
	}

	function trigger_change(
		el_id,


	) {
		try {


			var e = new Event('change', {
				bubbles: true,
			});
			const element = document.getElementById(el_id)
			element.dispatchEvent(e);



		} catch (err) {
			console.debug(err);
		}
	}

	function init_events() {
		
			init();
		

		if (tpfwcheckoutdelivery.ajax_updates == 1) {
			jQuery('body').off('updated_checkout.tpfw').on('updated_checkout.tpfw', function () {
				if (is_shortcode_delivery) {

					var data = {
						'action': 'tpfw_get_picktime_args',
						'nonce_ajax': tpfwdel.nonce,

					};

					$.post(
						woocommerce_params.ajax_url,
						data,
						function (response) {
							tpfwcheckoutdelivery = response;
							init();
						}).done(function () {

					});

				} else {
					init();
				}
			});
		}


		
	}
})(jQuery);