<?php
if (!defined('ABSPATH')) {
    exit;
}
use Automattic\WooCommerce\Utilities\OrderUtil;


if (!class_exists('TPFW_Admin')) {
    /**
     * Class TPFW_Admin
     *
     * @since 1.0
     */
    class TPFW_Admin
    {





        public function __construct()
        {



            if (is_admin() && is_user_logged_in()) {

                add_action('woocommerce_admin_order_preview_start', array(
                    $this,
                    'tpfw_preview_time'
                ));
            
                add_action('admin_notices', array( $this, 'premium_admin_notice'));
            }

            add_action('pre_get_posts', array(
                $this,
                'shop_order_column_meta_field_sortable_orderby'
            ));

            add_filter('woocommerce_email_recipient_new_order', array(
                $this,
                'new_order_filter_recipient'
            ), 999, 2);





            // Compatibility with HPOS Orders
            if (class_exists(\Automattic\WooCommerce\Utilities\OrderUtil::class) && OrderUtil::custom_orders_table_usage_is_enabled()) {


                add_filter('manage_woocommerce_page_wc-orders_columns', array($this, 'add_delivery_mode_order_column'), 20);
                add_action('manage_woocommerce_page_wc-orders_custom_column', array($this, 'tpfw_add_new_order_admin_list_column_content'), 20, 2);
                add_filter('manage_woocommerce_page_wc-orders_sortable_columns', array($this, 'shop_order_column_meta_field_sortable'), 20);

                add_filter('woocommerce_order_list_table_prepare_items_query_args', array($this, 'hpos_orderby_var'), 20, 1);
                add_filter('woocommerce_shop_order_list_table_sortable_columns', array($this, 'hpos_is_sortable'), 20, 1);

               


              



            } else {

                add_filter('manage_edit-shop_order_columns', array(
                    $this,
                    'add_delivery_mode_order_column'
                ));
                add_action('manage_shop_order_posts_custom_column', array(
                    $this,
                    'tpfw_add_new_order_admin_list_column_content'
                ), 10, 2);
                add_filter("manage_edit-shop_order_sortable_columns", array(
                    $this,
                    'shop_order_column_meta_field_sortable'
                ));

               

            }



        }






        function tpfw_add_new_order_admin_list_column_content($column, $order_id)
        {



            if ('tpfw_order_type' === $column) {
                $order = wc_get_order($order_id);
                $meta3 = $order->get_meta('tpfw_delivery_mode', true);
                if (is_string($meta3) && $meta3 != '' && !empty($meta3) && $meta3 !== false && $meta3 != 'undefined') {
                    $string = '';
                    if ($meta3 == 'delivery') {
                        $string = __('Delivery', 'time-picker-for-woocommerce');
                    } else if ($meta3 == 'pickup') {
                        $string = __('Pickup', 'time-picker-for-woocommerce');
                    }
                    echo esc_html($string);
                }

            } else if ('tpfw_order_time' === $column) {
                $order = wc_get_order($order_id);
                $meta3 = $order->get_meta('tpfw_picked_time', true);
                $meta4 = $order->get_meta('tpfw_picked_time_localized', true);
                $meta5 = $order->get_meta('tpfw_picked_time_range_end_localized', true);
                if (is_string($meta4) && $meta4 != '' && !empty($meta4) && $meta4 !== false && $meta4 != 'undefined') {
                    $echo = $meta4;
                    if (is_string($meta5) && $meta5 != '' && !empty($meta5) && $meta5 !== false && $meta5 != 'undefined') {
                        $echo .= ' - ' . $meta5;
                    }
                    echo esc_html($echo);
                } else if (is_string($meta3) && $meta3 != '' && !empty($meta3) && $meta3 !== false && $meta3 != 'undefined') {
                    echo esc_html(TPFW_Time::format_datetime($meta3));
                }
            }




        }

        function shop_order_column_meta_field_sortable_orderby($query)
        {
            global $pagenow;
            if (is_admin() && (('admin.php' === $pagenow ) || ($query->is_main_query() && 'edit.php' === $pagenow  ))) {
                $orderby = $query->get('orderby');
               
              

                if ('tpfw_picked_time' === $orderby) {
                    $meta_key = 'tpfw_picked_time_timestamp';
                    $query->set('meta_key', $meta_key);
                    $query->set('orderby', 'meta_value_num');
                }

            }

        }




       

       




        function new_order_filter_recipient($recipient, $order)
        {

            if (!$order instanceof WC_Order) {
                return $recipient;
            }
            if (!is_null($order) && !OrderUtil::is_order($order->get_id(), wc_get_order_types())) {
                return $recipient;
            }


            $meta = $order->get_meta('tpfw-pickup-location', true);
            if (isset($meta) && is_array($meta) && $meta != '' && !empty($meta) && $meta !== false) {

                if (isset($meta['email']) && is_string($meta['email']) && $meta['email'] != '' && is_email($meta['email'])) {
                    $recipient = $meta['email'];
                }

            }


            return $recipient;
        }
       
      









        function hpos_is_sortable($args)
        {

            $args['tpfw_picked_time'] = 'tpfw_picked_time';

            return $args;
        }

        function hpos_orderby_var($request)
        {

            if ($request['orderby'] === 'tpfw_picked_time') {
                $request['orderby'] = 'meta_value_num';
                $request['meta_key'] = 'tpfw_picked_time_timestamp';

            }


            return $request;
        }

        function add_delivery_mode_order_column($columns)
        {

            $columns['tpfw_order_type'] = __('Order Type', 'time-picker-for-woocommerce');
            if (get_option('tpfw_pickuptimes_enable', 'no') == 'yes' || get_option('tpfw_deliverytime_enable', 'no') == 'yes') {
                $order_actions = isset($columns['wc_actions']) ? $columns['wc_actions'] : null;
                if ($order_actions != null) {


                    unset($columns['wc_actions']);
                    $columns['wc_actions'] = $order_actions;
                }
                $columns['tpfw_order_time'] = __('Selected Time', 'time-picker-for-woocommerce');

            }

            return $columns;
        }

        function shop_order_column_meta_field_sortable($columns)
        {

            $meta_key = 'tpfw_picked_time';
            $args = wp_parse_args(array(
                'tpfw_order_time' => $meta_key,




            ), $columns);

            return $args;
        }

        function tpfw_preview_time()
        {



            ?>



            <# var tpfwmeta=data.data.meta_data; var tpfw_date_localized=false; var tpfw_date=false; 
             var tpfw_range_end='' ; _.each(tpfwmeta, function(el3, i2) { if (el3.key=='tpfw_picked_time_range_end_localized' ) {
                tpfw_range_end=' - ' + el3.value; } }); _.each(data.data.meta_data, function(el, i) { 
                     if(el.key=='tpfw_delivery_mode' ){ if (el.value=='pickup' ){#>

                    <div class="wc-order-preview-addresses" style="padding-bottom:0px">

                        <div class="wc-order-preview-address">

                            <h1><?php esc_html_e('Pickup Order', 'time-picker-for-woocommerce'); ?></h1>



                        </div>
                    </div>

                    <# } else if (el.value=='delivery' ){#>

                        <div class="wc-order-preview-addresses" style="padding-bottom:0px">

                            <div class="wc-order-preview-address">

                                <h1><?php esc_html_e('Delivery Order', 'time-picker-for-woocommerce'); ?></h1>



                            </div>



                        </div>





                        <# } }  if ( el.key=='tpfw_picked_time_localized' ) { tpfw_date_localized=el.value; }else
                                if(el.key=='tpfw_picked_time' ){ tpfw_date=el.value; } }); if( tpfw_date_localized !=false ){ #>

                                <div class="wc-order-preview-addresses">

                                    <div class="wc-order-preview-address">

                                        <h2>
                                            <?php esc_html_e('Selected Time', 'time-picker-for-woocommerce');
                                            ?>
                                        </h2>



                                        {{tpfw_date_localized + ' ' + tpfw_range_end}}

                                    </div>
                                </div>

                                <# }else if(tpfw_date !=false ){ #>



                                    <div class="wc-order-preview-addresses">

                                        <div class="wc-order-preview-address">

                                            <h2>
                                                <?php esc_html_e('Selected Time', 'time-picker-for-woocommerce');
                                                ?>
                                            </h2>



                                            {{tpfw_date + ' ' + tpfw_range_end}}

                                        </div>
                                    </div>

                                    <# } #>





                                        <?php
        }












    

    function premium_admin_notice(){

        if ( isset ($_GET['tab']) && $_GET['tab'] == 'tpfw' ) {

          if(  isset($_GET['section']) && $_GET['section'] == 'tpfw_ava_schedule'){

            echo '
            <div class="notice notice-success is-dismissible">
                <div >
                    <table>
                        <tbody>
                            <tr>
                                <td width="100%">
                                    <p style="font-size:1.3em"><strong><i>Important!! </i></strong>Time Picker for WooCommerce</p>
                                    <ul class="fa-ul" id="fdoe_premium_ad">
                                        <li><span class="dashicons dashicons-saved" style="color:#11b12aab"></span> Schedule categories and tags work as an AND condition if both are set for a schedule </li>
                                        <li><span class="dashicons dashicons-saved" style="color:#11b12aab"></span> If a schedule is added for a specific weekday in a category or tag, all other weekdays are disabled from the time picker for that category or tag. Therefore, it is mandatory to add a schedule for all weekdays that are meant to be activated </li>
                                        <li><span class="dashicons dashicons-saved" style="color:#11b12aab"></span> Premium! To have separate schedules for pickup and delivery orders, you need the premium version</li>
                                       
                                        <a target="_blank" rel="noopener noreferrer" href="https://arosoft.se/product/time-date-picker-for-woocommerce/" class=" ">
                                            <p style="display: inline-block;
                padding: 12px 20px;
                border-radius: 8px;
                border: 0;
                font-weight: bold;
                letter-spacing: 0.0625em;
                text-decoration: none;
                background: #11b12aab;
                color: #fff;
                text-align: center;">Go Premium!</p>
                                                <p></p>
                                        </a>
                                    </ul>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
            ';


            }else{
         if( mt_rand (1,4) == 1):
    
     echo '
    <div class="notice notice-success is-dismissible">
        <div class="fdoe_premium">
            <table>
                <tbody>
                    <tr>
                        <td width="100%">
                            <p style="font-size:1.3em"><strong><i>New Plugin! </i></strong>Live Order Confirmation</p>
                            <ul class="fa-ul" id="fdoe_premium_ad">
                                <li><span class="dashicons dashicons-saved" style="color:#11b12aab"></span> Confirm or Reject orders and notify the customer instantly when placing the order and through email </li>
                                <li><span class="dashicons dashicons-saved" style="color:#11b12aab"></span> Confirm order fulfillment time</li>
                                <li><span class="dashicons dashicons-saved" style="color:#11b12aab"></span> Add order comment</li>
                               
                                <a target="_blank" rel="noopener noreferrer" href="https://liveorderconfirmationplugin.com/" class=" ">
                                    <p style="display: inline-block;
        padding: 12px 20px;
        border-radius: 8px;
        border: 0;
        font-weight: bold;
        letter-spacing: 0.0625em;
        text-decoration: none;
        background: #11b12aab;
        color: #fff;
        text-align: center;">Go to Plugin!</p>
                                        <p></p>
                                </a>
                            </ul>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
    ';
           
             elseif( mt_rand (1,3) == 1):
    
     echo '
    <div class="notice notice-error is-dismissible">
        <div class="fdoe_premium">
            <table>
                <tbody>
                    <tr>
                        <td width="100%">
                            <p style="font-size:1.3em"><strong><i> </i></strong>Check My Address</p>
                            <ul class="fa-ul" id="fdoe_premium_ad">
                                <li><span class="dashicons dashicons-saved" style="color:#dc3232"></span> Let customers check if your store make deliveries to their address </li>
                                <li><span class="dashicons dashicons-saved" style="color:#dc3232"></span>  Add to any page with shortcode [checkmyaddress]</li>
                                <li><span class="dashicons dashicons-saved" style="color:#dc3232"></span> Choose if to show shipping rate</li>
                                <li><span class="dashicons dashicons-saved" style="color:#dc3232"></span>  Compatible with Shipping Zones by Drawing methods</li>
                                <a target="_blank" rel="noopener noreferrer" href="https://checkmyaddressplugin.com/" class=" ">
                                    <p style="display: inline-block;
        padding: 12px 20px;
        border-radius: 8px;
        border: 0;
        font-weight: bold;
        letter-spacing: 0.0625em;
        text-decoration: none;
        background: #dc3232;
        color: #fff;
        text-align: center;">Go to Plugin!</p>
                                        <p></p>
                                </a>
                            </ul>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
    ';
   
            else:
            echo '<div class="notice notice-info is-dismissible">
    
    <div class="fdoe_premium">
        <table>
            <tbody>
                <tr>
                    <td width="100%">
                        <p style="font-size:1.3em"><strong><i> Shipping Zones by Drawing Plugin </i></strong>let you draw your own shipping zones</p>
                        <ul class="fa-ul" id="fdoe_premium_ad">
                            <li><span class="dashicons dashicons-saved" style="color:#00a0d2"></span>  Define your own shipping areas by drawing into a map or by a radius from your store location</li>
                            <li><span class="dashicons dashicons-saved" style="color:#00a0d2"></span>  Define a shipping cost for every zone</li>
                             <li><span class="dashicons dashicons-saved" style="color:#00a0d2"></span> Distinguish shipping costs and zones depending on the product categories included in the delivery</li>

                           
                           
                            <a target="_blank" rel="noopener noreferrer" href="https://wordpress.org/plugins/shipping-zones-by-drawing-for-woocommerce/" class=" ">
                                <p style="display: inline-block;
        padding: 12px 20px;
        border-radius: 8px;
        border: 0;
        font-weight: bold;
        letter-spacing: 0.0625em;
        text-decoration: none;
        background: #00a0d2;
        color: #fff;
        text-align: center;">Get it for free!</p>
                                    <p></p>
                            </a>
                        </ul>
                    </td>
                </tr>
            </tbody>
        </table>
    </div>
    
    
             </div>';
             endif;
    
        }
    }
    
    }
}

    
    $TPFW_Admin = new TPFW_Admin();
}






add_action('woocommerce_checkout_update_order_meta', 'tpfw_checkout_field_update_order_meta', 2, 10);
function tpfw_checkout_field_update_order_meta($order_id, $data)
{

    wc_add_notice( $data['tpfw-time'], 'error' );

    if (!TPFW::cart_needs_shipping()) {
        return;
    }

    $type = isset($data['shipping_method'][0]) ? $data['shipping_method'][0] : '';
    $type = strtok($type, ':');

    $do_save = false;
    $order = wc_get_order($order_id);


    $mode = $type == 'flat_rate' || $type == 'free_shipping' || $type == 'szbd-shipping-method' ? 'delivery' : 'undefined';
    $mode = $type == 'local_pickup' || $type == 'pickup_location' ? 'pickup' : $mode;

    $order->update_meta_data('tpfw_delivery_mode', $mode);
    $do_save = true;

    $nonce_ok = ! empty( $_REQUEST['_tpfwfieldnonce'] ) && wp_verify_nonce( sanitize_text_field( stripslashes_from_strings_only( $_REQUEST['_tpfwfieldnonce'] ) ), 'tpfw_text_field_action' ) == 1;

    if ($nonce_ok && isset($_POST['tpfw-date']) && !empty($_POST['tpfw-date']) && $_POST['tpfw-date'] != '' && isset($_POST['tpfw-time']) && !empty($_POST['tpfw-time']) && $_POST['tpfw-time'] != '') {

        $time_ = wc_get_post_data_by_key('tpfw-time');
        $date = wc_get_post_data_by_key('tpfw-date');
        $time = str_contains($time_, '-') ? substr($time_, 0, strrpos($time_, '-')) : $time_;
        $order->update_meta_data('tpfw_picked_time_localized', stripslashes(TPFW_Time::format_datetime(sanitize_text_field($date . ' ' . $time), $date, $time)));
        $order->update_meta_data('tpfw_picked_time', stripslashes(sanitize_text_field($date . ' ' . $time)));

        $order->update_meta_data('tpfw_picked_time_timestamp', stripslashes(TPFW_Time::get_timestamp(sanitize_text_field($date . ' ' . $time))));
        $do_save = true;
        if (get_option('tpfw_timepicker_ranges', 'no') == 'yes') {
            $range_size = $mode == 'pickup' ? get_option('tpfw_pickuptime_step', 0) : ($mode == 'delivery' ? get_option('tpfw_deliverytime_step', 0) : 0);
            $order->update_meta_data('tpfw_picked_time_range_end_localized', stripslashes(TPFW_Time::format_datetime_range_end(sanitize_text_field($date . ' ' . $time), $range_size)));
        }
    }

    if ($do_save) {
        $order->save();
    }
}
add_action('woocommerce_admin_order_data_after_billing_address', 'tpfw_show_checkout_field_admin_order_meta', 10, 1);
function tpfw_show_checkout_field_admin_order_meta($order)
{
    $meta3 = $order->get_meta('tpfw_delivery_mode', true);
    $meta2 = $order->get_meta('tpfw_picked_time', true);
    $meta4 = $order->get_meta('tpfw_picked_time_localized', true);
    $meta5 = $order->get_meta('tpfw_picked_time_range_end_localized', true);
    if (is_string($meta4) && $meta4 != '' && !empty($meta4) && $meta4 !== false && $meta4 != 'undefined') {
        $time = $meta4;
        if (is_string($meta5) && $meta5 != '' && !empty($meta5) && $meta5 !== false && $meta5 != 'undefined') {
            $time .= ' - ' . $meta5;
        }
    } else if (is_string($meta2) && $meta2 != '' && !empty($meta2) && $meta2 !== false && $meta2 != 'undefined') {
        $time = TPFW_Time::format_datetime($meta2);
    }
    if (is_string($meta3) && $meta3 != '' && !empty($meta3) && $meta3 !== false && $meta3 != 'undefined') { {
            if ($meta3 == 'pickup') {
                if (isset($time)) {
                    $order_string = $order->has_status(array('fulfillment_con')) ? __('Fulfillment Time ', 'time-picker-for-woocommerce') : __('Selected Pickup Time ', 'time-picker-for-woocommerce');
                    echo '<h3>' . esc_html(__('Pickup Order', 'time-picker-for-woocommerce') ). '</h3><ul><li>' .esc_html( $order_string) . esc_html($time) . '</li></ul>';
                } else {
                    echo '<h3>' . esc_html( __('Pickup Order', 'time-picker-for-woocommerce')) . '</h3>';
                }
            } else if ($meta3 == 'delivery') {
                if (isset($time)) {
                    $order_string = $order->has_status(array('fulfillment_con')) ? __('Fulfillment Time ', 'time-picker-for-woocommerce') : __('Selected Delivery Time ', 'time-picker-for-woocommerce');

                    echo '<h3>' . esc_html( __('Delivery Order', 'time-picker-for-woocommerce')) . '</h3>';
                    echo esc_html($order_string) . esc_html($time);
                } else {
                    echo '<h3>' . esc_html( __('Delivery Order', 'time-picker-for-woocommerce')) . '</h3>';
                }
            }
        }
    }

}



add_action('woocommerce_thankyou', 'tpfw_add_picked_location_time_to_thankyou_page', 99, 1);
function tpfw_add_picked_location_time_to_thankyou_page($order_id)
{
    $order = wc_get_order($order_id);
    $type = $order->get_meta('tpfw_delivery_mode', true);
    ob_start();


    $meta3 = $order->get_meta('tpfw_picked_time', true);
    $meta4 = $order->get_meta('tpfw_picked_time_localized', true);
    $meta5 = $order->get_meta('tpfw_picked_time_range_end_localized', true);
    if (is_string($meta4) && $meta4 != '' && !empty($meta4) && $meta4 !== false && $meta4 != 'undefined') {
        $time = $meta4;
        if (is_string($meta5) && $meta5 != '' && !empty($meta5) && $meta5 !== false && $meta5 != 'undefined') {
            $time .= ' - ' . $meta5;
        }
    } else if (is_string($meta3) && $meta3 != '' && !empty($meta3) && $meta3 !== false && $meta3 != 'undefined') {
        $time = TPFW_Time::format_datetime($meta3);
    }


    if ($type == 'pickup' && get_option('tpfw_pickuptimes_enable', 'no') == 'yes') {
        if (isset($time)) {
            echo '<h2>' . esc_html( __('When to pick up?', 'time-picker-for-woocommerce')) . '</h2><ul><li>' .esc_html(  __('Your order will be ready ', 'time-picker-for-woocommerce')) . esc_html($time) . '</li></ul>';
        }
    } elseif ($type == 'delivery' && get_option('tpfw_deliverytime_enable', 'no') == 'yes') {
        if (isset($time)) {
            echo '<h2>' . esc_html( __('When will we deliver to you?', 'time-picker-for-woocommerce') ). '</h2>';
            echo '<p>' . esc_html( __('Your order will be delivered ', 'time-picker-for-woocommerce')) . esc_html( $time) . '</p>';
        }
    }


    $message = ob_get_clean();
    echo wp_kses( $message,array('h2'=> array(),'ul'=>array(),'li'=>array(),'p'=>array()) ) ;
}

