<?php
/*
Plugin Name: TileFlow Sorting Products
Description: A plugin to manage and sort products using drag-and-drop functionality.
Version: 1.1.7
Author URI: http://xsuri.servehttp.com/
Author: Hubert xSuri Kucharzak
Text Domain: tileflow-sorting-products
License: GPLv2 or later
License URI: https://www.gnu.org/licenses/gpl-2.0.html
Requires Plugins: woocommerce
*/

if ( ! defined( 'ABSPATH' ) ) exit;

define( 'XSURI_DND_VERSION', '1.1.7' );
define( 'XSURI_DND_FILE', __FILE__ );
define( 'XSURI_DND_DIR', plugin_dir_path( __FILE__ ) );
define( 'XSURI_DND_URL', plugin_dir_url( __FILE__ ) );
define( 'XSURI_DND_TEXTDOMAIN', 'tileflow-sorting-products' );

define( 'XSURI_DND_OPT_COLOR_SETTINGS','xsuri_dnd_color_settings' );
define( 'XSURI_DND_OPT_AUTOSAVE_MS', 'xsuri_dnd_autosave_ms' );
define( 'XSURI_DND_OPT_AUTOSAVE_ENABLED', 'xsuri_dnd_autosave_enabled' );


add_action('admin_notices', function(){
    if ( ! class_exists('WooCommerce') ) {
        echo '<div class="notice notice-error"><p><strong>' . esc_html__('TileFlow Sorting Products', 'tileflow-sorting-products') . ':</strong> ' .
             esc_html__('WooCommerce is required. Please install and activate WooCommerce to use this plugin.', 'tileflow-sorting-products') .
             '</p></div>';
    }
});


add_action('plugins_loaded', function() {


    if ( ! class_exists('WooCommerce') ) {
        return;
    }

    // Ładowanie plików
    require_once XSURI_DND_DIR . 'includes/helpers.php';
    require_once XSURI_DND_DIR . 'includes/pro.php';
    require_once XSURI_DND_DIR . 'includes/admin-page.php';
    require_once XSURI_DND_DIR . 'includes/ajax.php';
    require_once XSURI_DND_DIR . 'includes/hooks.php';

    // Rejestracja menu (wewnątrz sprawdzenia WC)
    add_action('admin_menu', function() {
        add_menu_page(
            __('TileFlow', 'tileflow-sorting-products'),
            __('TileFlow', 'tileflow-sorting-products'),
            'manage_woocommerce',
            'xsuri_sort_products',
            'xsuri_render_sort_products_page',
            'dashicons-sort',
            56
        );
        add_submenu_page(
            'xsuri_sort_products',
            __('Sorting', 'tileflow-sorting-products'),
            __('Sorting', 'tileflow-sorting-products'),
            'manage_woocommerce',
            'xsuri_sort_products',
            'xsuri_render_sort_products_page'
        );
        add_submenu_page(
            'xsuri_sort_products',
            __('Buy Pro', 'tileflow-sorting-products'),
            __('Buy Pro', 'tileflow-sorting-products'),
            'manage_woocommerce',
            'xsuri_sort_pro',
            'xsuri_render_pro_page'
        );
    });

    // Ładowanie skryptów (wewnątrz sprawdzenia WC)
    add_action('admin_enqueue_scripts', function($hook){
        if (isset($_GET['page']) && in_array($_GET['page'], ['xsuri_sort_products','xsuri_sort_settings'], true)) {
            wp_enqueue_style('xsuri-dnd-admin', XSURI_DND_URL . 'assets/admin.css', [], XSURI_DND_VERSION);
            wp_enqueue_script('jquery-ui-sortable');
            wp_enqueue_script('xsuri-dnd-admin', XSURI_DND_URL . 'assets/admin.js', ['jquery','jquery-ui-sortable'], XSURI_DND_VERSION, true);

            $color_settings = xsuri_dnd_get_color_settings();
            $autosave_ms = intval( get_option( XSURI_DND_OPT_AUTOSAVE_MS, 3000 ) );
            $autosave_enabled = (bool) get_option( XSURI_DND_OPT_AUTOSAVE_ENABLED, true );
            wp_localize_script('xsuri-dnd-admin', 'xsuriDnd', [
                'ajaxurl'    => admin_url('admin-ajax.php'),
                'nonce'      => wp_create_nonce('xsuri_sort_products_nonce'),
                'isPro'      => false,
                'colors'     => $color_settings,
                'autosaveMs' => max(1000, min(60000, $autosave_ms)),
                'autosaveEnabled' => $autosave_enabled,
                'i18n'       => [
                    'saving'    => __('Saving...', 'tileflow-sorting-products'),
                    'saved'     => __('Order saved!', 'tileflow-sorting-products'),
                    'error'     => __('Error', 'tileflow-sorting-products'),
                    'ajaxErr'   => __('Connection error (AJAX)', 'tileflow-sorting-products'),
                    'multiHint' => __('Hold Shift/Ctrl to multi-select.', 'tileflow-sorting-products'),
                    'savePartWarn' => __('Not all pages are loaded. Save will include only currently loaded products. Continue?', 'tileflow-sorting-products'),
                    'maxDrag'   => __('You can drag up to 200 products at once.', 'tileflow-sorting-products'),
                    'autosaveIn'=> __('Autosave in', 'tileflow-sorting-products'),
                ],
            ]);
        }
    });

});

register_activation_hook( XSURI_DND_FILE, function(){});
register_deactivation_hook( XSURI_DND_FILE, function(){});