<?php
if ( ! defined( 'ABSPATH' ) ) exit;

function xsuri_render_pro_page() {
    check_ajax_referer('xsuri_sort_products_nonce', 'nonce');
    $current_page = isset($_GET['page']) ? sanitize_key($_GET['page']) : '';
    ?>
    <div class="wrap">
        <div class="xsuri-nav-tabs">
            <a href="<?php echo esc_url( admin_url('admin.php?page=xsuri_sort_products') ); ?>" class="xsuri-nav-tab <?php echo $current_page==='xsuri_sort_products' ? 'active':''; ?>"><?php esc_html_e('Sorting','tileflow-sorting-products'); ?></a>
            <a href="<?php echo esc_url( admin_url('admin.php?page=xsuri_sort_pro') ); ?>" class="xsuri-nav-tab <?php echo $current_page==='xsuri_sort_license' ? 'active':''; ?>"><?php esc_html_e('License','tileflow-sorting-products'); ?></a>
        </div>
        <h1><?php esc_html_e('TileFlow - Pro', 'tileflow-sorting-products'); ?></h1>
        
        <hr/>
        <h2><?php esc_html_e('What Pro version offers', 'tileflow-sorting-products'); ?></h2>
        <p><a href="https://shop.contentlabs.pl" target="_blank" rel="noopener" class="button button-primary"><?php esc_html_e('Buy Pro', 'tileflow-sorting-products'); ?></a></p>
        <ul style="list-style:disc;padding-left:18px;">
            <li><?php esc_html_e('Multi-select products (Shift/Ctrl) and group dragging.', 'tileflow-sorting-products'); ?></li>
            <li><?php esc_html_e('Context menu (quick jump to top/bottom of list).', 'tileflow-sorting-products'); ?></li>
            <li><?php esc_html_e('Full drag&drop categories – tree sorting (siblings).', 'tileflow-sorting-products'); ?></li>
            <li><?php esc_html_e('Infinite scroll and larger per-page limits.', 'tileflow-sorting-products'); ?></li>
            <li><?php esc_html_e('Automatic product order saving (configurable interval).', 'tileflow-sorting-products'); ?></li>
            <li><?php esc_html_e('Creating backups and restoring from them.', 'tileflow-sorting-products'); ?></li>
        </ul>
        <p class="description">
            <?php esc_html_e('This version shows up to 100 products and does not include Pro features.', 'tileflow-sorting-products'); ?>
        </p>
    </div>
<?php
}
