<?php
if ( ! defined( 'ABSPATH' ) ) exit;

add_filter( 'woocommerce_get_catalog_ordering_args', function( $args, $orderby, $order ) {
    return $args;
}, 20, 3 );

add_filter( 'posts_clauses', function ( $clauses, $query ) {
    
    if ( is_admin() || $query->is_singular ) return $clauses;
    $post_type = $query->get('post_type');
    if ( $post_type && $post_type !== 'product' ) return $clauses;

   // phpcs:ignore WordPress.Security.NonceVerification.Recommended
    $orderby_param = isset($_GET['orderby']) ? sanitize_text_field(wp_unslash($_GET['orderby'])) : '';
    if ( $orderby_param && $orderby_param !== 'menu_order' ) return $clauses;

    $term_id = xsuri_get_query_product_cat_term_id( $query );
    $meta_key_term   = xsuri_get_pin_meta_key( $term_id );
    $meta_key_global = xsuri_get_pin_meta_key( 0 );

    $current_meta_key = $query->get( 'meta_key' );
    $current_orderby  = $query->get( 'orderby' );
    $is_sorted =
        ( $current_meta_key === $meta_key_term && is_string($current_orderby) && strpos($current_orderby,'meta_value') !== false );
    if ( $is_sorted ) return $clauses;

    global $wpdb;
    if ( $term_id > 0 ) {
        $clauses['join'] .= " LEFT JOIN {$wpdb->postmeta} AS xsuri_pin_t ON ({$wpdb->posts}.ID = xsuri_pin_t.post_id AND xsuri_pin_t.meta_key = '{$meta_key_term}')";
    }
    $clauses['join'] .= " LEFT JOIN {$wpdb->postmeta} AS xsuri_pin_g ON ({$wpdb->posts}.ID = xsuri_pin_g.post_id AND xsuri_pin_g.meta_key = '{$meta_key_global}')";

    $pin_present_case = ($term_id > 0)
        ? "CASE
            WHEN (xsuri_pin_t.meta_value IS NOT NULL AND xsuri_pin_t.meta_value <> '' AND CAST(xsuri_pin_t.meta_value AS UNSIGNED) > 0) THEN 0
            WHEN (xsuri_pin_g.meta_value IS NOT NULL AND xsuri_pin_g.meta_value <> '' AND CAST(xsuri_pin_g.meta_value AS UNSIGNED) > 0) THEN 0
            ELSE 1 END"
        : "CASE
            WHEN (xsuri_pin_g.meta_value IS NOT NULL AND xsuri_pin_g.meta_value <> '' AND CAST(xsuri_pin_g.meta_value AS UNSIGNED) > 0) THEN 0
            ELSE 1 END";

    $pos_case = ($term_id > 0)
        ? "CASE
            WHEN (CAST(xsuri_pin_t.meta_value AS UNSIGNED) > 0) THEN CAST(xsuri_pin_t.meta_value AS UNSIGNED)
            WHEN (CAST(xsuri_pin_g.meta_value AS UNSIGNED) > 0) THEN CAST(xsuri_pin_g.meta_value AS UNSIGNED)
            ELSE 999999999 END"
        : "CASE
            WHEN (CAST(xsuri_pin_g.meta_value AS UNSIGNED) > 0) THEN CAST(xsuri_pin_g.meta_value AS UNSIGNED)
            ELSE 999999999 END";

    $order_prefix = " {$pin_present_case} ASC, {$pos_case} ASC";
    if ( ! empty( $clauses['orderby'] ) ) {
        $clauses['orderby'] = $order_prefix . ', ' . $clauses['orderby'];
    } else {
        $clauses['orderby'] = $order_prefix;
    }
    return $clauses;
}, 999, 2 );

add_filter( 'the_posts', function ( $posts, $query ) {
    if ( is_admin() || empty($posts) || is_singular('product') ) return $posts;
   $orderby_param = isset($_GET['orderby']) ? sanitize_text_field( wp_unslash( $_GET['orderby'] ) ) : '';
    if ( $orderby_param && $orderby_param !== 'menu_order' ) return $posts;

    $term_id = xsuri_get_query_product_cat_term_id( $query );
    $meta_key_term   = xsuri_get_pin_meta_key( $term_id );
    $meta_key_global = xsuri_get_pin_meta_key( 0 );

    $cat_order = get_option('xsuri_category_order');
    $cat_pos_map_top = [];
    if ( is_array($cat_order) && ! empty($cat_order) ) {
        $seen = [];
        $pos = 1;
        foreach ( $cat_order as $tid ) {
            $tid = intval($tid);
            if ( $tid <= 0 ) continue;
            if ( isset($seen[$tid]) ) continue;
            $seen[$tid] = true;
            $term = get_term( $tid, 'product_cat' );
            if ( $term && ! is_wp_error($term) && intval($term->parent) === 0 ) {
                $cat_pos_map_top[$tid] = $pos++;
            }
        }
    }

    $data = [];
    foreach ( $posts as $i => $p ) {
        $pos_term   = intval( get_post_meta( $p->ID, $meta_key_term, true ) );
        $pos_global = intval( get_post_meta( $p->ID, $meta_key_global, true ) );
        $effective_pos = $pos_term > 0 ? $pos_term : ( $pos_global > 0 ? $pos_global : PHP_INT_MAX );
        $pin_flag  = $effective_pos === PHP_INT_MAX ? 1 : 0;
        $stock     = get_post_meta($p->ID, '_stock_status', true) === 'outofstock' ? 1 : 0;

        $cat_rank = PHP_INT_MAX;
        if ( ! empty($cat_pos_map_top) ) {
            $terms = wp_get_post_terms( $p->ID, 'product_cat', [ 'fields' => 'ids' ] );
            if ( is_array($terms) ) {
                foreach ( $terms as $tid ) {
                    $tid = intval($tid);
                    $top = $tid;
                    if ( ! isset($cat_pos_map_top[$tid]) ) {
                        $anc = get_ancestors( $tid, 'product_cat', 'taxonomy' );
                        if ( is_array($anc) && ! empty($anc) ) {
                            $top = intval( end($anc) );
                        }
                    }
                    if ( isset($cat_pos_map_top[$top]) && $cat_pos_map_top[$top] < $cat_rank ) {
                        $cat_rank = $cat_pos_map_top[$top];
                    }
                }
            }
        }

        $data[] = [
            'post'  => $p,
            'stock' => $stock,
            'pin'   => $pin_flag,
            'pos'   => $effective_pos,
            'cat'   => $cat_rank,
            'i'     => $i,
        ];
    }

    usort($data, function($a,$b){
        if ( $a['cat'] !== $b['cat'] ) return $a['cat'] <=> $b['cat'];
        if ( $a['stock'] !== $b['stock'] ) return $a['stock'] <=> $b['stock'];
        if ( $a['pin']   !== $b['pin'] )   return $a['pin']   <=> $b['pin'];
        if ( $a['pos']   !== $b['pos'] )   return $a['pos']   <=> $b['pos'];
        return $a['i'] <=> $b['i'];
    });

    $out = [];
    foreach ( $data as $row ) $out[] = $row['post'];
    return $out;
}, 999, 2 );

add_filter( 'terms_clauses', function( $clauses, $taxonomies, $args ) {
    if ( is_admin() ) return $clauses;
    if ( empty($taxonomies) || ! in_array( 'product_cat', (array)$taxonomies, true ) ) return $clauses;

    $order = get_option('xsuri_category_order');
    if ( ! is_array($order) || empty($order) ) return $clauses;

    $seen = [];
    $sorted = [];
    foreach ($order as $tid) {
        $tid = intval($tid);
        if ($tid <= 0) continue;
        if (!isset($seen[$tid])) { $seen[$tid] = true; $sorted[] = $tid; }
    }
    if (empty($sorted)) return $clauses;

    global $wpdb;
    $ids_sql = implode(',', array_map('intval', $sorted));
    $field = "FIELD(t.term_id, $ids_sql)";
    $prefix = "($field = 0), $field"; // (0 means not in list – goes to end)

    if ( ! empty( $clauses['orderby'] ) ) {
        $clauses['orderby'] = $prefix . ', ' . $clauses['orderby'];
    } else {
        $clauses['orderby'] = $prefix . ', t.name ASC';
    }
    return $clauses;
}, 10, 3 );