<?php
if ( ! defined( 'ABSPATH' ) ) exit;

function xsuri_render_sort_products_page() {
    $all_cats = get_terms([
        'taxonomy'   => 'product_cat',
        'hide_empty' => false,
        'orderby'    => 'name',
        'order'      => 'ASC',
        'number'     => 0,
    ]);
    $by_parent = [];
    foreach ( $all_cats as $term ) {
        $p = intval($term->parent);
        if ( ! isset($by_parent[$p]) ) $by_parent[$p] = [];
        $by_parent[$p][] = $term;
    }
    $cat_order = get_option('xsuri_category_order');
    $order_pos = [];
    if ( is_array($cat_order) ) {
        foreach ( $cat_order as $i => $tid ) { $order_pos[ intval($tid) ] = $i + 1; }
    }

    $sort_terms = function( array $terms ) use ( $order_pos ) {
        usort( $terms, function( $a, $b ) use ( $order_pos ) {
            $pa = isset($order_pos[$a->term_id]) ? $order_pos[$a->term_id] : PHP_INT_MAX;
            $pb = isset($order_pos[$b->term_id]) ? $order_pos[$b->term_id] : PHP_INT_MAX;
            if ( $pa === $pb ) return strcasecmp( $a->name, $b->name );
            return $pa <=> $pb;
        });
        return $terms;
    };

    $render_branch = function( $parent_id, $depth ) use ( &$render_branch, $by_parent, $sort_terms ) {
        if ( empty($by_parent[$parent_id]) ) return;
        $children = $sort_terms( $by_parent[$parent_id] );
        echo '<ul class="xsuri-cat-children">';
        foreach ( $children as $t ) {
            $tid = intval($t->term_id);
            $has_children = ! empty( $by_parent[$tid] );

            $li_class = 'xsuri-cat-row';
            if ( $has_children ) $li_class .= ' has-children';

            $li_class_depth = $li_class . ' depth-'. intval($depth);
            echo '<li class="'. esc_attr($li_class_depth) .'" data-cat-id="'. esc_attr($tid) .'" data-depth="'. intval($depth) .'">';
            echo '<div class="xsuri-cat-line">';
            if ( $has_children ) {
                echo '<span class="xsuri-cat-toggle" aria-label="toggle" role="button" tabindex="0" aria-expanded="true"></span>';
            } else {
                echo '<span class="xsuri-cat-toggle xsuri-cat-toggle--spacer" aria-hidden="true"></span>';
            }
            echo '<button class="xsuri-cat-btn" type="button">'. esc_html( $t->name ) .'</button>';
            echo '</div>';

            if ( $has_children ) {
                $render_branch( $tid, $depth + 1 );
            }
            echo '</li>';
        }

        echo '</ul>';
    };

    // phpcs:ignore WordPress.Security.NonceVerification.Recommended
    $current_page = isset($_GET['page']) ? sanitize_key($_GET['page']) : '';
    ?>
    <div class="wrap xsuri-sort-wrap">
        <div class="xsuri-nav-tabs">
            <a href="<?php echo esc_url( admin_url('admin.php?page=xsuri_sort_products') ); ?>" class="xsuri-nav-tab <?php echo $current_page==='xsuri_sort_products' ? 'active':''; ?>"><?php esc_html_e('Sorting','tileflow-sorting-products'); ?></a>
        </div>
        <h1><?php esc_html_e('Product Tile Sorter', 'tileflow-sorting-products'); ?></h1>

        <div class="xsuri-layout">
            <aside class="xsuri-sidebar">
                <div class="xsuri-sidebar-head">
                    <strong><?php esc_html_e('Categories', 'tileflow-sorting-products'); ?></strong>
                </div>
                <ul id="xsuri-category-list" class="<?php echo false ? 'xsuri-cat-enabled':'xsuri-cat-disabled'; ?>">
                    <li class="xsuri-cat-row xsuri-cat-fixed depth-0" data-cat-id="0" data-depth="0">
                        <div class="xsuri-cat-line">
                            <span class="xsuri-cat-toggle xsuri-cat-toggle--spacer" aria-hidden="true"></span>
                            <button class="xsuri-cat-btn xsuri-cat-btn--fixed" type="button"><?php esc_html_e('All','tileflow-sorting-products'); ?></button>
                        </div>
                    </li>
                    <?php
                    if ( ! empty($by_parent[0]) ) {
                        $top = $sort_terms( $by_parent[0] );
                        foreach ( $top as $t ) {
                            $tid = intval($t->term_id);
                            $has_children = ! empty( $by_parent[$tid] );
                            $li_class_top = 'xsuri-cat-row';
                            if ( $has_children ) $li_class_top .= ' has-children';
                            $li_class_top .= ' depth-0';
                            echo '<li class="'. esc_attr($li_class_top) .'" data-cat-id="'. esc_attr($tid) .'" data-depth="'. intval(0) .'">';
                            echo '<div class="xsuri-cat-line">';
                            if ( $has_children ) {
                                echo '<span class="xsuri-cat-toggle" aria-label="toggle" role="button" tabindex="0" aria-expanded="true"></span>';
                            } else {
                                echo '<span class="xsuri-cat-toggle xsuri-cat-toggle--spacer" aria-hidden="true"></span>';
                            }
                            echo '<button class="xsuri-cat-btn" type="button">'. esc_html( $t->name ) .'</button>';
                            echo '</div>';
                            if ( $has_children ) $render_branch( $tid, 1 );
                            echo '</li>';
                        }
                    }
                    ?>
                </ul>
                <p><em><?php esc_html_e('Drag to reorder siblings. Click the arrow to collapse/expand subcategories.', 'tileflow-sorting-products'); ?></em></p>
                <button id="xsuri-save-order" class="button button-primary" style="margin-top:10px;">
                    <?php esc_html_e('Save order', 'tileflow-sorting-products'); ?>
                </button>
                <div id="xsuri-save-status"></div>
            </aside>
            <main class="xsuri-main">
                <div class="xsuri-main-head">
                    <strong id="xsuri-current-cat-label"><?php esc_html_e('All products', 'tileflow-sorting-products'); ?></strong>
                </div>
                <ul id="xsuri-products-pane" class="xsuri-products-sortable xsuri-products-enabled"></ul>
            </main>
        </div>
    </div>
    <?php
}