jQuery(function($){
    const isPro = false; // Multiselect disabled; basic drag enabled
    const colorVars = xsuriDnd.colors || {};
    const root = document.documentElement;
    Object.entries(colorVars).forEach(([k,v])=>{
        root.style.setProperty('--xsuri-'+k, v);
    });

    
    let isCatDragging = false;
    if (isPro && $('#xsuri-category-list').length) {
        var $catList = $('#xsuri-category-list');
        if ($catList.data('ui-sortable')) { try { $catList.sortable('destroy'); } catch(_){} }

        var drag = { active:false, $item:null, $ghost:null, $ph:null, offsetY:0, listLeft:0, listTop:0, $list:null, $origList:null, origIndex:-1 };

        function buildGhost($row){
            var $line = $row.children('.xsuri-cat-line').first().clone();
            var $g = $('<div class="xsuri-cat-ghost"></div>').append($line);
            $g.css({ width: $row.outerWidth(), height: $row.outerHeight() });
            $('body').append($g);
            return $g;
        }
        function placePlaceholderByY(pageY){
            if (!drag.$list) return;
            var $rows = drag.$list.children('.xsuri-cat-row').not('.xsuri-cat-fixed,.xsuri-dragging');
            var placed = false;
            for (var i=0;i<$rows.length;i++){
                var $r = $rows.eq(i);
                var mid = $r.offset().top + $r.outerHeight()/2;
                if (pageY < mid){ drag.$ph.insertBefore($r); placed = true; break; }
            }
            if (!placed){ drag.$ph.appendTo(drag.$list); }
            if (drag.$list.is('#xsuri-category-list')){
                var $fixed = drag.$list.children('.xsuri-cat-fixed');
                if (drag.$ph.nextAll('.xsuri-cat-fixed').length){ drag.$ph.insertAfter($fixed); }
            }
        }
        function autoScroll(pageY){
            var winTop = $(window).scrollTop();
            var winH = $(window).height();
            if (pageY > winTop + winH - 60) { window.scrollTo({top: winTop + 30}); }
            if (pageY < winTop + 60) { window.scrollTo({top: Math.max(0, winTop - 30)}); }
        }

        $catList.on('mousedown', '.xsuri-cat-grip', function(e){
            if (e.which !== 1) return;
            var $row = $(this).closest('.xsuri-cat-row');
            if ($row.hasClass('xsuri-cat-fixed')) return;
            drag.active = true; isCatDragging = true;
            drag.$item = $row;
            drag.$list = $row.parent('ul');
            drag.$origList = drag.$list;
            drag.origIndex = $row.index();
            drag.offsetY = e.pageY - $row.offset().top;
            var listOffset = drag.$list.offset();
            drag.listLeft = listOffset ? listOffset.left : 0;
            drag.listTop = listOffset ? listOffset.top : 0;
            drag.$ph = $('<li class="xsuri-cat-manual-placeholder"></li>').css('height', $row.outerHeight());
            $row.after(drag.$ph);
            drag.$ghost = buildGhost($row);
            $row.addClass('xsuri-dragging').css('visibility','hidden');
            drag.$ghost.css({ left: drag.listLeft, top: e.pageY - drag.offsetY });
            placePlaceholderByY(e.pageY);
            e.preventDefault();
        });

        $(document).on('mousemove.xsuriCat', function(e){
            if (!drag.active) return;
            drag.$ghost.css({ top: e.pageY - drag.offsetY, left: drag.listLeft });
            placePlaceholderByY(e.pageY);
            autoScroll(e.pageY);
        });

        $(document).on('mouseup.xsuriCat', function(){
            if (!drag.active) return;
            
            var $phList = drag.$ph && drag.$ph.parent('ul');
            if ($phList && $phList.length && drag.$origList && drag.$origList.length && $phList[0] !== drag.$origList[0]){
                
                var $siblings = drag.$origList.children('.xsuri-cat-row').not('.xsuri-cat-fixed');
                if (drag.origIndex >= 0 && drag.origIndex < $siblings.length){
                    drag.$ph.insertBefore($siblings.eq(drag.origIndex));
                } else {
                    drag.$ph.appendTo(drag.$origList);
                }
            }
            drag.$item.css('visibility','').removeClass('xsuri-dragging');
            drag.$ph.after(drag.$item);
            drag.$ph.remove(); drag.$ph = null;
            if (drag.$ghost) { drag.$ghost.remove(); drag.$ghost = null; }

            
            var order = [];
            $('#xsuri-category-list .xsuri-cat-row').each(function(){
                var id = parseInt($(this).data('cat-id'), 10) || 0;
                if (id > 0) order.push(id);
            });
           $.post(xsuriDnd.ajaxurl, { action:'xsuri_save_category_order', cat_order: order, nonce: xsuriDnd.nonce })
             .always(function(){
                 
                 if (currentCatId === 0) {
                     currentPage = 1;
                     loadCategoryProducts(0, undefined, false);
                 }
             });

            drag.active = false; drag.$item = null; drag.$list = null; drag.$origList = null; drag.origIndex = -1; isCatDragging = false;
        });
    }

    
    let currentCatId = 0;
    let currentPage = 1;
    let perPage = 40;
    let currentSearch = '';
    let instockOnly = true;
    let lastMeta = { page:1, pages:1, has_more:false };
    let isLoading = false;
    let scrollAppendMode = true;
    function renderPagination(meta){
        const wrap = $('#xsuri-pagination');
        if (!wrap.length) return;
        if (scrollAppendMode) { wrap.empty(); return; }
        wrap.empty();
        if (meta.pages <= 1) return;
        const prev = $('<button type="button" class="button xsuri-page-btn">&laquo;</button>').prop('disabled', meta.page<=1);
        const next = $('<button type="button" class="button xsuri-page-btn">&raquo;</button>').prop('disabled', meta.page>=meta.pages);
        prev.on('click', function(){ if (meta.page>1){ currentPage = meta.page-1; loadCategoryProducts(currentCatId); } });
        next.on('click', function(){ if (meta.page<meta.pages){ currentPage = meta.page+1; loadCategoryProducts(currentCatId); } });
        wrap.append(prev);
        const windowSize = 5;
        let start = Math.max(1, meta.page - Math.floor(windowSize/2));
        let end = Math.min(meta.pages, start + windowSize -1);
        if (end - start + 1 < windowSize) start = Math.max(1, end - windowSize +1);
        for (let p=start; p<=end; p++) {
            const b = $('<button type="button" class="button xsuri-page-btn"></button>').text(p);
            if (p === meta.page) b.addClass('button-primary');
            b.on('click', function(){ currentPage = p; loadCategoryProducts(currentCatId); });
            wrap.append(b);
        }
        wrap.append(next);
    }

    
    function xsuriKillPlaceholders(scope){
        var $scope = scope ? $(scope) : $(document);
        $scope.find('.ui-sortable-placeholder, .ui-sortable-helper').remove();
    }

    
    window.__xsuriDraggingProducts = false;
    
    let phWatchTimer = null;
    function xsuriWatchPlaceholders(){
        const pane = document.getElementById('xsuri-products-pane');
        if (!pane || window.__xsuriPHObserver) return;
        const obs = new MutationObserver(function(){
            clearTimeout(phWatchTimer);
            phWatchTimer = setTimeout(function(){
                const placeholders = pane.querySelectorAll('.ui-sortable-placeholder');
                const limit = Math.min(placeholders.length, 50);
                for (let i = 0; i < limit; i++) {
                    const n = placeholders[i];
                    n.classList.remove('xsuri-product-item','ui-sortable-handle');
                    if (window.__xsuriDraggingProducts) {
                        n.style.removeProperty('display');
                        n.style.removeProperty('visibility');
                        n.style.removeProperty('width');
                        n.style.removeProperty('height');
                        n.style.removeProperty('margin');
                        n.style.removeProperty('padding');
                        n.style.removeProperty('border');
                    } else if (document.body.classList.contains('xsuri-hide-placeholders')) {
                        n.style.cssText = 'display:none!important;visibility:hidden!important;width:0!important;height:0!important;margin:0!important;padding:0!important;border:0!important;';
                    }
                }
            }, 50);
        });
        obs.observe(pane, { childList:true, subtree:true, attributes:true, attributeFilter:['class','style'] });
        window.__xsuriPHObserver = obs;
    }

    let refreshTimer = null;
    function loadCategoryProducts(catId, label, append){
        if (label) $('#xsuri-current-cat-label').text(label);
        if (!append) {
            $('#xsuri-products-pane').html('<li style="opacity:.6;list-style:none;">'+ (xsuriDnd.i18n?.saving || 'Loading...') +'</li>');
        }
        isLoading = true;
        $.post(xsuriDnd.ajaxurl, { action:'xsuri_get_products', cat_id: catId, page: currentPage, per_page: perPage, search: currentSearch, instock: instockOnly ? 1 : 0, nonce: xsuriDnd.nonce }, function(resp){
            isLoading = false;
            if (resp && resp.success) {
                lastMeta = resp.data || {};
                if (append) {
                    $('#xsuri-products-pane').append(resp.data.html);
                    
                    clearTimeout(refreshTimer);
                    refreshTimer = setTimeout(function(){
                        if ($('#xsuri-products-pane').data('ui-sortable')) {
                            $('#xsuri-products-pane').sortable('refresh');
                        }
                    }, 100);
                    xsuriWatchPlaceholders();
                } else {
                    $('#xsuri-products-pane').html(resp.data.html);
                    
                    if ($('#xsuri-products-pane').data('ui-sortable')) {
                        $('#xsuri-products-pane').sortable('destroy');
                    }
                    $('#xsuri-products-pane').sortable({
                    items: '> .xsuri-product-item:not(.outofstock)',
                    connectWith: false,
                    disabled: false,
                    tolerance: 'pointer',
                    appendTo: 'body',
                    zIndex: 10000,
                    forcePlaceholderSize: true,
                    placeholder: 'xsuri-sort-placeholder',
                    cursor: 'move',
                    cursorAt: { top: 30, left: 30 },
                    opacity: 0.8,
                    helper: function(e, item){
                        return $(item).clone();
                    },
                    start: function(e, ui){
                        window.__xsuriDraggingProducts = true;
                        $('body').removeClass('xsuri-hide-placeholders');
                        const $pane = $('#xsuri-products-pane');
                        $pane.removeClass('xsuri-no-placeholder').addClass('xsuri-grid-drag xsuri-drag-flex');
                        if (ui.placeholder) {
                            
                            const itemWidth = ui.item.outerWidth();
                            const itemHeight = ui.item.outerHeight();
                            const fresh = $('<li class="ui-sortable-placeholder xsuri-sort-placeholder"></li>');
                            fresh.css({ 
                                width: itemWidth + 'px', 
                                height: itemHeight + 'px', 
                                visibility: 'visible',
                                display: 'block',
                                opacity: '1',
                                margin: ui.item.css('margin'),
                                padding: '0',
                                border: '2px dashed ' + (getComputedStyle(document.documentElement).getPropertyValue('--xsuri-primary') || '#008aff'),
                                background: 'rgba(0, 138, 255, 0.1)',
                                borderRadius: '8px'
                            });
                            $(ui.placeholder).replaceWith(fresh);
                            ui.placeholder = fresh;
                        }
                    },
                    sort: function(e, ui){
                        if (ui.placeholder) {
                            ui.placeholder
                              .removeClass('xsuri-product-item ui-sortable-handle')
                              .addClass('xsuri-sort-placeholder')
                              .css({visibility:'visible'});
                        }
                    },
                    change: function(e, ui){
                        if (ui.placeholder) {
                            ui.placeholder
                              .removeClass('xsuri-product-item ui-sortable-handle')
                              .addClass('xsuri-sort-placeholder');
                        }
                    },
                    receive: function(){ xsuriKillPlaceholders('#xsuri-products-pane'); scheduleAutosave(); },
                    remove: function(){ xsuriKillPlaceholders('#xsuri-products-pane'); scheduleAutosave(); },
                    update: function(){ xsuriKillPlaceholders('#xsuri-products-pane'); scheduleAutosave(); },
                    stop: function(e, ui){
                        const $pane = $('#xsuri-products-pane');
                        $pane.removeClass('xsuri-grid-drag xsuri-drag-flex').addClass('xsuri-no-placeholder');
                        
                        if (ui.placeholder) { ui.placeholder.remove(); }
                        xsuriKillPlaceholders('#xsuri-products-pane');
                        
                        
                        $pane.children('.xsuri-product-item').not('.ui-sortable-placeholder,.ui-sortable-helper').css({ 
                            left:'', top:'', position:'', visibility:'', opacity:'', pointerEvents:'' 
                        });
                        
                        
                        setTimeout(function(){
                            xsuriKillPlaceholders(document);
                            $('body').addClass('xsuri-hide-placeholders');
                            window.__xsuriDraggingProducts = false;
                            scheduleAutosave();
                        }, 100);
                    }
                    ,
                    deactivate: function(e, ui){
                        
                        const $pane = $('#xsuri-products-pane');
                        $pane.addClass('xsuri-no-placeholder');
                        xsuriKillPlaceholders($pane);
                        $pane.children('.xsuri-product-item').css({ left:'', top:'', position:'', visibility:'' });
                        setTimeout(function(){ xsuriKillPlaceholders(document); }, 50);
                        $('body').addClass('xsuri-hide-placeholders');
                        $pane.removeClass('xsuri-drag-flex');
                        window.__xsuriDraggingProducts = false;
                        xsuriWatchPlaceholders();
                        scheduleAutosave();
                    }
                    });
                    xsuriWatchPlaceholders();
                }
                renderPagination(resp.data);
            } else {
                $('#xsuri-products-pane').html('<li style="opacity:.7;">'+ (xsuriDnd.i18n?.error || 'Error') +'</li>');
            }
        }, 'json');
    }
    function collectProductIds(){
        var ids = [];
        $('#xsuri-products-pane .xsuri-product-item').each(function(){ ids.push($(this).data('id')); });
        var seen = {}, dedup = [];
        for (var i=0;i<ids.length;i++){
            var v = String(ids[i]);
            if (!seen[v]) { seen[v]=true; dedup.push(v); }
        }
        return dedup;
    }
    function ensureAutosaveToast(){
        if (!$('#xsuri-autosave-toast').length) {
            const el = $('<div id="xsuri-autosave-toast">Autosaved ✓</div>');
            el.css({
                position: 'fixed',
                right: '16px',
                bottom: '16px',
                zIndex: 99999,
                background: 'rgba(0,0,0,0.8)',
                color: '#fff',
                padding: '8px 12px',
                borderRadius: '6px',
                boxShadow: '0 2px 8px rgba(0,0,0,.2)',
                fontSize: '13px',
                display: 'none'
            });
            $('body').append(el);
        }
        return $('#xsuri-autosave-toast');
    }
    function showAutosaveToast(){
        const $t = ensureAutosaveToast();
        $t.stop(true, true).fadeIn(120);
        setTimeout(function(){ $t.fadeOut(250); }, 1500);
    }
    function saveProductsOrder(opts){
        const isAuto = !!(opts && opts.autosave);
        var ids = collectProductIds();
        if (!isPro && ids.length > 100) {
            alert(xsuriDnd.i18n.demoLimit || 'Demo version: limited to 100 products.');
        }
        if (!isAuto) {
            $('#xsuri-save-status').text(xsuriDnd.i18n.saving || 'Saving...').css('color','inherit');
            clearInterval(autosaveCountdownInterval); autosaveCountdownInterval = null; $('#xsuri-autosave-countdown').text(''); autosaveTimer = null; autosaveLastChange = 0;
        }
        $.post(xsuriDnd.ajaxurl, {
            action: 'xsuri_save_products_order',
            nonce: xsuriDnd.nonce,
            ids: ids.join(','),
            cat_id: currentCatId
        }, function(response){
            if (response && response.success) {
                if (isAuto) {
                    showAutosaveToast();
                    clearInterval(autosaveCountdownInterval); autosaveCountdownInterval = null; $('#xsuri-autosave-countdown').text(''); autosaveTimer = null; autosaveLastChange = 0;
                } else {
                    $('#xsuri-save-status').text((response.data && response.data.msg) || xsuriDnd.i18n.saved || 'Order saved!').css('color','green');
                }
            } else {
                var msg = response && response.data && response.data.msg ? response.data.msg : (xsuriDnd.i18n.error || 'Error');
                $('#xsuri-save-status').text(msg).css('color','red');
            }
        }, 'json').fail(function(){
            $('#xsuri-save-status').text(xsuriDnd.i18n.ajaxErr || 'Connection error (AJAX)').css('color','red');
        });
    }
    let autosaveTimer = null;
    let autosaveLastChange = 0;
    const AUTOSAVE_DELAY = Math.max(1000, parseInt(xsuriDnd.autosaveMs || 3000, 10) || 3000);
    const AUTOSAVE_ENABLED = isPro && ((typeof xsuriDnd.autosaveEnabled === 'undefined') ? true : !!xsuriDnd.autosaveEnabled);
    let autosaveCountdownInterval = null;
    function updateAutosaveCountdown(){
        if (!AUTOSAVE_ENABLED){ $('#xsuri-autosave-countdown').text(''); return; }
        if (!autosaveLastChange || !autosaveTimer){ $('#xsuri-autosave-countdown').text(''); return; }
        const remaining = AUTOSAVE_DELAY - (Date.now() - autosaveLastChange);
        if (remaining <= 0){ $('#xsuri-autosave-countdown').text(''); return; }
        $('#xsuri-autosave-countdown').text((xsuriDnd.i18n?.autosaveIn || 'Autosave in') + ' ' + (remaining/1000).toFixed(1) + 's');
    }
    function startAutosaveCountdown(){
        if (!AUTOSAVE_ENABLED) return;
        clearInterval(autosaveCountdownInterval);
        autosaveCountdownInterval = setInterval(updateAutosaveCountdown, 250);
        updateAutosaveCountdown();
    }
    function scheduleAutosave(){
        if (!AUTOSAVE_ENABLED) return;
        autosaveLastChange = Date.now();
        startAutosaveCountdown();
        if (!autosaveTimer){
            autosaveTimer = setTimeout(function runAuto(){
                const since = Date.now() - autosaveLastChange;
                if (since >= AUTOSAVE_DELAY - 25){
                    autosaveTimer = null;
                    saveProductsOrder({ autosave: true });
                } else {
                    const remaining = AUTOSAVE_DELAY - since;
                    autosaveTimer = setTimeout(runAuto, remaining);
                    updateAutosaveCountdown();
                }
            }, AUTOSAVE_DELAY);
        }
    }
    setInterval(function(){
        if (!AUTOSAVE_ENABLED) return;
        if (!autosaveLastChange) return;
        if (!autosaveTimer) return;
        const since = Date.now() - autosaveLastChange;
        if (since > AUTOSAVE_DELAY * 3){
            clearTimeout(autosaveTimer); autosaveTimer = null;
            saveProductsOrder({ autosave: true });
            autosaveLastChange = 0; clearInterval(autosaveCountdownInterval); autosaveCountdownInterval = null; $('#xsuri-autosave-countdown').text('');
        }
    }, 2000);

    function getCollapsedSet(){
        try { return new Set(JSON.parse(localStorage.getItem('xsuriCollapsedCats')||'[]')); } catch(e){ return new Set(); }
    }
    function saveCollapsedSet(set){
        try { localStorage.setItem('xsuriCollapsedCats', JSON.stringify(Array.from(set))); } catch(e){}
    }
    const collapsedSet = getCollapsedSet();
    function applyCollapsedState(){
        $('#xsuri-category-list .xsuri-cat-row').each(function(){
            const $row = $(this);
            const id = parseInt($row.data('cat-id'), 10);
            if (!id) return; // skip 'All'
            const shouldCollapse = collapsedSet.has(id);
            $row.toggleClass('xsuri-cat-collapsed', shouldCollapse);
            const $children = $row.children('.xsuri-cat-children');
            if (shouldCollapse) { $children.hide(); } else { $children.show(); }
            const $toggle = $row.find('> .xsuri-cat-line > .xsuri-cat-toggle').first();
            if ($toggle.length && !$toggle.hasClass('xsuri-cat-toggle--spacer')) {
                $toggle.attr('aria-expanded', shouldCollapse ? 'false' : 'true');
            }
        });
    }
    $(document).on('click', '.xsuri-cat-toggle:not(.xsuri-cat-toggle--spacer)', function(e){
        e.stopPropagation();
        const $row = $(this).closest('.xsuri-cat-row');
        const id = parseInt($row.data('cat-id'), 10);
        const $children = $row.children('.xsuri-cat-children');
        const willCollapse = !$row.hasClass('xsuri-cat-collapsed');
        if (willCollapse) {
            $children.stop(true, true).slideUp(150, function(){ $row.addClass('xsuri-cat-collapsed'); });
        } else {
            $row.removeClass('xsuri-cat-collapsed');
            $children.stop(true, true).slideDown(150);
        }
        $(this).attr('aria-expanded', willCollapse ? 'false' : 'true');
        if (id) {
            if (willCollapse) collapsedSet.add(id); else collapsedSet.delete(id);
            saveCollapsedSet(collapsedSet);
        }
    });
    $(document).on('keydown', '.xsuri-cat-toggle:not(.xsuri-cat-toggle--spacer)', function(e){
        if (e.key === 'Enter' || e.key === ' ') { e.preventDefault(); $(this).trigger('click'); }
    });
    applyCollapsedState();

    let catClickTimer = null;
    $(document).on('click', '.xsuri-cat-btn', function(){
        if (isCatDragging) return;
        const $btn = $(this);
        clearTimeout(catClickTimer);
        catClickTimer = setTimeout(function(){
            $('.xsuri-cat-btn').removeClass('active');
            $btn.addClass('active');
            const $row = $btn.closest('.xsuri-cat-row');
            currentCatId = parseInt($row.data('cat-id')) || 0;
            console.log(currentCatId);
            currentPage = 1;
            const label = $btn.text().trim();
            loadCategoryProducts(currentCatId, label, false);
        }, 180);
    });
    $(document).on('dblclick', '.xsuri-cat-btn', function(e){
        if (isCatDragging) return;
        clearTimeout(catClickTimer);
        const $row = $(this).closest('.xsuri-cat-row');
        const $toggle = $row.find('> .xsuri-cat-line > .xsuri-cat-toggle').first();
        if ($toggle.length && !$toggle.hasClass('xsuri-cat-toggle--spacer')) {
            $toggle.trigger('click');
        }
    });
    const $firstCatBtn = $('#xsuri-category-list .xsuri-cat-btn').first();
    if ($firstCatBtn.length) { $firstCatBtn.trigger('click'); }
    
    // Multiselect removed: no selection toggling or hints

    // Context menu removed with multiselect

    if (!$('#xsuri-scroll-btns').length) {
        $("body").append('<div id="xsuri-scroll-btns">' +
            '<button class="xsuri-scroll-btn" id="xsuri-scroll-up"><svg width="30" height="30" viewBox="0 0 24 24"><path fill="white" d="M12 4l-8 8h16z"/></svg></button>' +
            '<button class="xsuri-scroll-btn" id="xsuri-scroll-down"><svg width="30" height="30" viewBox="0 0 24 24"><path fill="white" d="M12 20l8-8H4z"/></svg></button>' +
        '</div>');
    }
    $("#xsuri-scroll-up").on('click',()=> $('html, body').animate({scrollTop: 0}, 600));
    $("#xsuri-scroll-down").on('click',()=> $('html, body').animate({scrollTop: $(document).height()}, 600));

    $('#xsuri-save-order').on('click', function(){
        if (scrollAppendMode && lastMeta && lastMeta.has_more) {
            const proceed = confirm((xsuriDnd.i18n && xsuriDnd.i18n.savePartWarn) ? xsuriDnd.i18n.savePartWarn : 'Not all pages are loaded. The save will include only the currently loaded products. Continue?');
            if (!proceed) return;
        }
        saveProductsOrder();
    });

    if (!$('#xsuri-search-box').length) {
        $('.xsuri-main-head').append('<input type="search" id="xsuri-search-box" placeholder="Search..." style="flex:1; max-width:240px;" />');
    }
    let searchDebounce = null;
    $('#xsuri-search-box').on('input', function(){
        const val = $(this).val();
        clearTimeout(searchDebounce);
        searchDebounce = setTimeout(function(){
            currentSearch = val;
            currentPage = 1;
            loadCategoryProducts(currentCatId, undefined, false);
        }, 250);
    });

    if (!$('#xsuri-pagination').length) {
        $('.xsuri-main').append('<div id="xsuri-pagination" style="display:flex; gap:4px; flex-wrap:wrap; margin-top:8px;"></div>');
    }

    if (!$('#xsuri-dark-toggle').length) {
        $('.xsuri-main-head').append('<button type="button" id="xsuri-dark-toggle" class="button" style="margin-left:auto;">🌙</button>');
    }
    function applyTheme(mode){
        if (mode === 'dark') {
            document.documentElement.setAttribute('data-theme','dark');
        } else {
            document.documentElement.removeAttribute('data-theme');
        }
        localStorage.setItem('xsuriTheme', mode);
    }
    const savedTheme = localStorage.getItem('xsuriTheme');
    if (savedTheme) applyTheme(savedTheme);
    $('#xsuri-dark-toggle').on('click', function(){
        const current = document.documentElement.getAttribute('data-theme') === 'dark' ? 'dark' : 'light';
        const next = current === 'dark' ? 'light' : 'dark';
        applyTheme(next);
        $(this).text(next === 'dark' ? '🌙' : '☀️');
    });

    if (!$('#xsuri-per-page').length) {
        const perPageCtrl = $(`
            <select id="xsuri-per-page" class="xsuri-ctrl" style="margin-left:8px;">
                <option value="20">20/page</option>
                <option value="40" selected>40/page</option>
                <option value="80">80/page</option>
                <option value="200">200/page</option>
            </select>`);
        $('.xsuri-main-head').append(perPageCtrl);
    }
    $('#xsuri-per-page').on('change', function(){
        perPage = parseInt($(this).val(), 10) || 40;
        currentPage = 1;
        $('#xsuri-products-pane').empty();
        loadCategoryProducts(currentCatId, undefined, false);
    });

    if (!$('#xsuri-instock').length) {
        const instockCtrl = $(`
            <label style="display:flex;align-items:center;gap:6px;margin-left:8px;">
                <input type="checkbox" id="xsuri-instock" checked /> <span>In-stock only</span>
            </label>`);
        $('.xsuri-main-head').append(instockCtrl);
    }
    $('#xsuri-instock').on('change', function(){
        instockOnly = !!$(this).is(':checked');
        currentPage = 1;
        $('#xsuri-products-pane').empty();
        loadCategoryProducts(currentCatId, undefined, false);
    });

    if (!$('#xsuri-scroll-toggle').length) {
        const scrollBtn = $('<button type="button" id="xsuri-scroll-toggle" class="button" title="Infinite scroll" style="margin-left:8px;">∞</button>');
        $('.xsuri-main-head').append(scrollBtn);
    }
    $('#xsuri-scroll-toggle').on('click', function(){
        scrollAppendMode = !scrollAppendMode;
        $(this).toggleClass('button-primary', scrollAppendMode);
    });

    $(window).on('scroll.xsuriInf', function(){
        if (!scrollAppendMode) return;
        if (!lastMeta || !lastMeta.has_more) return;
        if (isLoading) return;
        const $pane = $('#xsuri-products-pane');
        if (!$pane.length) return;
        const paneBottom = $pane.offset().top + $pane.outerHeight();
        const viewBottom = $(window).scrollTop() + $(window).height();
        if (viewBottom + 200 >= paneBottom) {
            currentPage = (lastMeta.page || currentPage) + 1;
            loadCategoryProducts(currentCatId, undefined, true);
        }
    });
});