# TileFlow Sorting Products

## Plugin Name: TileFlow Sorting Products
## Description: A plugin to manage and sort products using drag-and-drop functionality.
## Version: 1.1.7
## Author: Hubert 'xsuri' Kucharzak
## Author URI: http://xsuri.servehttp.com/
## License: GPLv2
## License URI: https://www.gnu.org/licenses/gpl-2.0.html


## Project Description
TileFlow Sorting Products is a project designed to manage and sort products in the system using drag-and-drop functionality. The project includes various PHP files and resources that support administrative and security features.

## Project Structure

```
tileflow-sorting-products.php
assets/
    admin.css
    admin.js
includes/
    admin-page.php
    ajax.php
    helpers.php
    hooks.php
    pro.php
```

### Main Files and Folders:
- **xsuri-dnd-sorter.php**: The main file of the project.
- **assets/**: Contains CSS and JS files for the admin panel.
  - `admin.css`: Styles for the admin panel.
  - `admin.js`: JavaScript scripts for the admin panel.
- **includes/**: Contains PHP files supporting various project functionalities.
  - `admin-page.php`: Handles the admin page.
  - `ajax.php`: Handles AJAX requests.
  - `helpers.php`: Contains helper functions.
  - `hooks.php`: Handles WordPress hooks.
  - `pro.php`: Site to buy pro plugin.

## Requirements
- PHP 7.4 or newer
- WordPress 5.0 or newer

## Installation
1. Clone the repository to your local environment:
   ```bash
   git clone <repository-url>
   ```
2. Copy the files to the `wp-content/plugins` directory in your WordPress installation.
3. Activate the plugin in the WordPress admin panel.

## Usage
After activating the plugin, navigate to the admin section to manage products using drag-and-drop functionality.

## Authors
- **Creator**: Hubert 'xsuri' Kucharzak
- **Contact**: vaultedkolekcje@gmail.com
- **Site**: https://shop.contentlabs.pl/

## License
This plugin is licensed under the GNU General Public License v2.0 or later. See the LICENSE file for details.

---

*Thank you for using TileFlow Sorting Products!*