<?php
/**
 * Class ScreenShotMachineAPI
 * 
 * Package: Tida URL Screenshot
 * Author: Tida Web
 */

if (!defined('ABSPATH')) exit;

class ScreenShotMachineAPI extends \Tida_Screenshot_API_Core {
    
    /**
     * The base URL for the ScreenShotMachine API.
     *
     * @var string
     * @access protected
     * @since 1.0.0
     */
    protected static $api_url = 'https://api.screenshotmachine.com';
    
    /**
     * Constructor for the ScreenShotMachineAPI class.
     * Initializes the parent constructor to set up API token and any other required settings.
     * 
     * @return void
     */
    public function __construct()
    {
    	// initialize parent constructor
    	parent::__construct();
    }

    /**
     * Add the ScreenShotMachine API to the list of available APIs.
     *
     * @param array $list The current list of APIs.
     * @return array The modified list of APIs, now including the ScreenShotMachine API.
     */
    public function add_api_to_list($list)
    {
    	$list['screenshotmachine'] = 'Screenshot Machine';
    	return $list;
    }

    /**
     * Prepare and format the request data for the ScreenShotMachine API.
     *
     * @param string $web_url The URL that needs to be captured as a screenshot.
     * @return string The final image URL of the captured screenshot, encoded in base64.
     */
    public static function prepare_data_for_api($web_url)
    {
    	$final_url = add_query_arg([
    		'key' => self::$api_token,
    		'url' => esc_url($web_url),
    		'format' => 'jpg',
    		'dimension' => '1360xfull',
    		'delay' => 2000
    	], self::$api_url );
    	
    	// send data to api
    	$final_result = parent::send_data_to_api($final_url);
    
    	return $final_result;
    }
}

// Instantiate the ScreenShotMachine API handler for capturing screenshots
new ScreenShotMachineAPI();