<?php
/**
 * Class ScreenshotLayerAPI
 * 
 * Package: Tida URL Screenshot
 * Author: Tida Web
 */

if (!defined('ABSPATH')) exit;

class ScreenshotLayerAPI extends \Tida_Screenshot_API_Core {
    
    /**
     * The base URL for the ScreenshotLayer API.
     *
     * @var string
     * @access protected
     * @since 1.0.0
     */
    protected static $api_url = 'http://api.screenshotlayer.com/api/capture';
    
    /**
     * Constructor for the ScreenshotLayerAPI class.
     * Initializes the parent constructor to set up API token and any other required settings.
     * 
     * @return void
     */
    public function __construct()
    {
    	// initialize parent constructor
    	parent::__construct();
    }

    /**
     * Add the ScreenshotLayer API to the list of available APIs.
     *
     * @param array $list The current list of APIs.
     * @return array The modified list of APIs, now including the ScreenshotLayer API.
     */
    public function add_api_to_list($list)
    {
    	$list['screenshotlayer'] = 'Screenshot Layer';
    	return $list;
    }

    /**
     * Prepare and format the request data for the ScreenshotLayer API.
     *
     * @param string $web_url The URL that needs to be captured as a screenshot.
     * @return string The final image URL of the captured screenshot, encoded in base64.
     */
    public static function prepare_data_for_api($web_url)
    {
    	$final_url = add_query_arg([
    		'access_key' => self::$api_token,
    		'url' => esc_url($web_url),
    		'fullpage' => 1
    	], self::$api_url );
    	
    	// send data to api
    	$final_result = parent::send_data_to_api($final_url);
    
    	return $final_result;
    }

}

// Instantiate the ScreenshotLayer API handler for capturing screenshots
new ScreenshotLayerAPI();