<?php
/**
 * Class JsonLinkAPI
 * 
 * Package: Tida URL Screenshot
 * Author: Tida Web
 */

if (!defined('ABSPATH')) exit;

class JsonLinkAPI extends \Tida_Screenshot_API_Core {
    
    /**
     * The base URL for the ScreenshotOne API.
     *
     * @var string
     * @access protected
     * @since 1.0.0
     */
    protected static $api_url = 'https://jsonlink.io/api/screenshot';
    
    /**
     * Constructor for the ScreenshotOneAPI class.
     * Initializes the parent constructor to set up API token and any other required settings.
     * 
     * @return void
     */
    public function __construct()
    {
    	// initialize parent constructor
    	parent::__construct();
    }

    /**
     * Add the ScreenshotOne API to the list of available APIs.
     *
     * @param array $list The current list of APIs.
     * @return array The modified list of APIs, now including the ScreenshotOne API.
     */
    public function add_api_to_list($list)
    {
    	$list['jsonlink'] = 'JsonLink';
    	return $list;
    }

    /**
     * Prepare and format the request data for the ScreenshotOne API.
     *
     * @param string $web_url The URL that needs to be captured as a screenshot.
     * @return string The final image URL of the captured screenshot, encoded in base64.
     */
    public static function prepare_data_for_api($web_url)
    {
    	$final_url = add_query_arg([
    		'api_key' => self::$api_token,
    		'url' => esc_url($web_url),
    		'format' => 'jpg',
    		'full_page' => 'true',
    		'image_quality' => 100
    	], self::$api_url );
    	
    	// send data to api
    	$final_result = parent::send_data_to_api($final_url);
    
    	return $final_result;
    }
}

// Instantiate the ScreenshotOne API handler for capturing screenshots
new JsonLinkAPI();