<?php
/**
 * Class Tida_Screenshot_API_Core
 * 
 * Package: Tida URL Screenshot
 * Author: Tida Web
 */

if (!defined('ABSPATH')) exit;

class Tida_Screenshot_API_Core {

    /**
     * API token for authenticating requests to the API.
     *
     * @var string
     * @access public
     * @since 1.0.0
     */
    public static $api_token = '';

    /**
     * URL for the API.
     * This variable is populated when API settings are initialized.
     *
     * @var string
     * @access protected
     * @since 1.0.0
     */
    protected static $api_url = '';

    /**
     * Constructor method.
     * Initializes the API token from the plugin settings and adds available APIs to the list.
     * 
     * @return void
     */
    public function __construct()
    {
        // Initialize
        if( !empty( get_option('tida_url_screenshot_settings') ) )
            self::$api_token = get_option('tida_url_screenshot_settings')['api_key'];
        else
            self::$api_token = '';

        // Add API to the list
        add_filter('tida_screenshot_api_list', array($this, 'add_api_to_list'));
    }

    /**
     * Add API to the list.
     *
     * @param array $list The current list of APIs.
     * @return array The modified list of APIs, including any new additions.
     */
    public function add_api_to_list($list)
    {
        // You would typically add your API endpoint details here.
        // Example: $list['My New API'] = 'http://api.example.com';
        return $list;
    }

    /**
     * Get the API URL value.
     *
     * @return string The sanitized API URL.
     */
    public static function get_api_url()
    {
        return esc_url(self::$api_url);
    }

    /**
     * Send data to the specified API endpoint.
     *
     * @param string $web_api_url The URL of the API endpoint to which the request is sent.
     * @param array $body Optional. Additional data to include in the request body. Default is an empty array.
     * @return string The base64-encoded image URL, or an empty string if there was an error fetching the image.
     */
    public static function send_data_to_api($web_api_url, $body = [])
    {
        $final_image_url = '';

        // if (!empty($web_api_url)) {
        //     $request = wp_remote_get($web_api_url, array('timeout' => 7000));

        //     if (is_wp_error($request)) {
        //         // Handle error appropriately
        //     } else {
        //         $response = wp_remote_retrieve_body($request);
        //         error_log($response);
        //         $imageData = base64_encode($response);

        //         if (!is_wp_error($response)) {
        //             // Format the image SRC: data:{mime};base64,{data};
        //             $final_image_url = 'data:image/jpeg;base64,' . $imageData;
        //         }
        //     }
        // }
        
        if (!empty($web_api_url))
        {
            $request = wp_remote_get($web_api_url, array('timeout' => 7000));
        
            if (is_wp_error($request)) {
                // Handle error appropriately
            } else {
                $response = wp_remote_retrieve_body($request);
        
                // Check if response is JSON
                $response_data = json_decode($response, true);
        
                // If response data is an array, it means we likely got a JSON response
                if (is_array($response_data) && isset($response_data['url']))
                {
                    // Handle the case where response is a JSON object
                    $image_url = $response_data['url'];
                    
                    // Fetch the image data from the URL
                    $image_request = wp_remote_get($image_url);
        
                    if (is_wp_error($image_request))
                    {
                        // Handle error while fetching image
                    }
                    else
                    {
                        $image_response = wp_remote_retrieve_body($image_request);
                        $imageData = base64_encode($image_response);
                        
                        // Format the image SRC: data:{mime};base64,{data};
                        $final_image_url = 'data:image/jpeg;base64,' . $imageData;
                    }
                }
                else
                {
                    // Assume the response is image data and encode it directly
                    $imageData = base64_encode($response);
        
                    if (!is_wp_error($response)) {
                        // Format the image SRC: data:{mime};base64,{data};
                        $final_image_url = 'data:image/jpeg;base64,' . $imageData;
                    }
                }
            }
        }

        return apply_filters('api_result_data_output', $final_image_url);
    }
}

// Instantiate the core API class for handling requests
new Tida_Screenshot_API_Core();