<?php
/**
 * Class ApiFlashAPI
 * 
 * Package: Tida URL Screenshot
 * Author: Tida Web
 */

if (!defined('ABSPATH')) exit;

class ApiFlashAPI extends \Tida_Screenshot_API_Core {
    
    /**
     * The base URL for the ApiFlash API.
     *
     * @var string
     * @access protected
     * @since 1.0.0
     */
    protected static $api_url = 'https://api.apiflash.com/v1/urltoimage';
    
    /**
     * Constructor for the ApiFlashAPI class.
     * Initializes the parent constructor to set up API token and any other required settings.
     * 
     * @return void
     */
    public function __construct()
    {
        // initialize parent constructor
        parent::__construct();
    }

    /**
     * Add the ApiFlash API to the list of available APIs.
     *
     * @param array $list The current list of APIs.
     * @return array The modified list of APIs, now including the ApiFlash API.
     */
    public function add_api_to_list($list)
    {
        $list['apiflash'] = 'ApiFlash';
        return $list;
    }

    /**
     * Prepare and format the request data for the ApiFlash API.
     *
     * @param string $web_url The URL that needs to be captured as a screenshot.
     * @return string The final image URL of the captured screenshot, encoded in base64.
     */
    public static function prepare_data_for_api($web_url)
    {
    	$final_url = add_query_arg([
    		'access_key' => self::$api_token,
    		'url' => esc_url($web_url),
    		'format' => 'jpeg',
    		'full_page' => 'true',
    		'quality' => 100
    	], self::$api_url );
    	
    	// send data to api
    	$final_result = parent::send_data_to_api($final_url);
    
    	return $final_result;
    }

}

// Instantiate the ApiFlash API handler for capturing screenshots
new ApiFlashAPI();