<?php
/**
 * Class AbstractAPI
 * 
 * Package: Tida URL Screenshot
 * Author: Tida Web
 */

if (!defined('ABSPATH')) exit;

class AbstractAPI extends \Tida_Screenshot_API_Core {
    
    /**
     * The base URL for the Abstract API.
     *
     * @var string
     * @access protected
     * @since 1.0.0
     */
    protected static $api_url = 'https://screenshot.abstractapi.com/v1/';

    /**
     * Constructor for the AbstractAPI class.
     * Initializes the parent constructor to set up API token and any other required settings.
     * 
     * @return void
     */
    public function __construct()
    {
        // Initialize parent constructor
        parent::__construct();
    }

    /**
     * Add the Abstract API to the list of available APIs.
     *
     * @param array $list The current list of APIs.
     * @return array The modified list of APIs, now including the Abstract API.
     */
    public function add_api_to_list($list)
    {
        $list['abstractapi'] = 'Abstract API';
        return $list;
    }

    /**
     * Prepare and format the request data for the Abstract API.
     *
     * @param string $web_url The URL that needs to be captured as a screenshot.
     * @return string The final image URL of the captured screenshot, encoded in base64.
     */
    public static function prepare_data_for_api($web_url)
    {
        $final_url = add_query_arg([
            'api_key' => self::$api_token,
            'url' => esc_url($web_url),
            'capture_full_page' => 'true'
        ], self::$api_url);
        
        // Send data to API and return the result
        $final_result = parent::send_data_to_api($final_url);

        return $final_result;
    }
}

// Instantiate the Abstract API handler for capturing screenshots
new AbstractAPI();