jQuery(document).ready(function(){
    jQuery(".tida-screenshot-form").on('submit', function(e){
        e.preventDefault();
        var url = jQuery(this).find('input[type="text"]').val();
        jQuery.ajax({
            method: 'POST',
            url: tida_screenshot_params.ajax_url,
            data: { action : 'get_tida_url_screenshot', url : url },
            dataType: 'json',
            beforeSend: function() {
                jQuery('.screenshot-result img').attr('src', '');
                jQuery('.screenshot-msg').html('<span class="text-blink">' + tida_screenshot_params.please_text + '</span>');
            },
            success: function(response) {
                jQuery('.screenshot-msg').html(response.msg);
                if( response.status )
                    jQuery('.screenshot-result img').attr('src', response.src);
            },
            error: function(error) {
                console.log(error);
            }
        });
    });
    
    jQuery(".tida-post-screenshot").on('click', function(e){
        e.preventDefault();
        var pid = jQuery(this).data('pid');
        console.log(pid);
        jQuery.ajax({
            method: 'POST',
            url: tida_screenshot_params.ajax_url,
            data: { action : 'get_tida_post_screenshot', pid : pid },
            dataType: 'json',
            beforeSend: function() {
                jQuery('.screenshot-result img').attr('src', '');
                jQuery('.screenshot-msg').html('<span class="text-blink">' + tida_screenshot_params.please_text + '</span>');
            },
            success: function(response) {
                jQuery('.screenshot-msg').html(response.msg);
                if( response.status )
                    jQuery('.screenshot-result img').attr('src', response.src);
            },
            error: function(error) {
                console.log(error);
            }
        });
    });
});