<?php
/**
 * Uninstall TicketPayGo Lite
 * 
 * This file is executed when the plugin is deleted via WordPress admin.
 * It removes all plugin data including database tables and options.
 */

if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

global $wpdb;

// Delete all plugin options (Lite specific with tpgl_ prefix)
delete_option('tpgl_settings');
delete_option('tpgl_version');
delete_option('tpgl_activated');
delete_option('tpgl_db_version');
delete_option('tpgl_force_db_check');

// Delete all transients
delete_transient('tpgl_tables_created');
delete_transient('tpgl_tables_error');

// Clear scheduled cron jobs
wp_clear_scheduled_hook('tpgl_daily_reminders');

// Drop all plugin tables directly (don't modify $wpdb->prefix!)
// Allowlist of plugin tables - only these tables can be dropped
// All table names are constructed from $wpdb->prefix + hardcoded suffix
$tpgl_tables = array(
    $wpdb->prefix . 'ticketpaygo_lite_events',
    $wpdb->prefix . 'ticketpaygo_lite_orders',
    $wpdb->prefix . 'ticketpaygo_lite_tickets',
    $wpdb->prefix . 'ticketpaygo_lite_analytics',
    $wpdb->prefix . 'ticketpaygo_lite_payment_logs',
    $wpdb->prefix . 'ticketpaygo_lite_settings'
);

foreach ($tpgl_tables as $tpgl_table) {
    // Table name is validated via allowlist above - all names are $wpdb->prefix + hardcoded suffix
    // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching,WordPress.DB.PreparedSQL.InterpolatedNotPrepared -- DROP TABLE with allowlisted table names, all constructed from prefix + hardcoded suffix
    $wpdb->query("DROP TABLE IF EXISTS `{$tpgl_table}`");
}

// Remove capabilities from all roles
$tpgl_roles = array('administrator', 'editor', 'author');
foreach ($tpgl_roles as $tpgl_role_name) {
    $tpgl_role = get_role($tpgl_role_name);
    if ($tpgl_role) {
        $tpgl_role->remove_cap('manage_ticketpaygo_lite');
        $tpgl_role->remove_cap('edit_ticketpaygo_lite_events');
        $tpgl_role->remove_cap('delete_ticketpaygo_lite_events');
    }
}

// Flush rewrite rules
flush_rewrite_rules();
