<?php
/**
 * Checkout modal template
 * 
 * phpcs:disable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
 */

if (!defined('ABSPATH')) {
    exit;
}

$currency_symbol = TicketPayGo_Database::get_setting('currency_symbol', '€');
$currency_position = TicketPayGo_Database::get_setting('currency_position', 'before');
$current_user = wp_get_current_user();
$is_logged_in = $current_user->ID > 0;

// Get Terms and Privacy URLs from settings
$terms_url = TicketPayGo_Database::get_setting('terms_url', '');
$privacy_url = TicketPayGo_Database::get_setting('privacy_url', '');

// Check if user registration is enabled
$users_can_register = get_option('users_can_register');

// Check if WooCommerce is active
$woocommerce_active = class_exists('WooCommerce');

// Determine login URL - prefer WooCommerce if available, otherwise use WordPress frontend login
if ($woocommerce_active) {
    $login_url = wc_get_page_permalink('myaccount');
} else {
    $login_url = wp_login_url(get_permalink());
}

// Show login option only if users can register OR WooCommerce is active
$show_login_option = $users_can_register || $woocommerce_active;
?>

<div id="ticketpaygo-checkout-modal" class="ticketpaygo-checkout-modal" style="display: none;">
    <div class="checkout-modal-overlay"></div>
    <div class="checkout-modal-container">
        <button class="checkout-modal-close" aria-label="<?php esc_html_e('Close', 'ticketpaygo-lite'); ?>">
            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M18 6L6 18M6 6L18 18" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
            </svg>
        </button>
        
        <div class="checkout-modal-content">
            <div class="checkout-header">
                <h2><?php esc_html_e('Complete Your Purchase', 'ticketpaygo-lite'); ?></h2>
                <p class="checkout-subtitle"><?php esc_html_e('Just one more step to secure your tickets', 'ticketpaygo-lite'); ?></p>
            </div>
            
            <!-- Order Summary -->
            <div class="checkout-summary">
                <div class="summary-row">
                    <span class="summary-label"><?php esc_html_e('Event', 'ticketpaygo-lite'); ?>:</span>
                    <span class="summary-value" id="checkout-event-title"></span>
                </div>
                <div class="summary-row">
                    <span class="summary-label"><?php esc_html_e('Tickets', 'ticketpaygo-lite'); ?>:</span>
                    <span class="summary-value" id="checkout-quantity"></span>
                </div>
                <div class="summary-row total">
                    <span class="summary-label"><?php esc_html_e('Total', 'ticketpaygo-lite'); ?>:</span>
                    <span class="summary-value" id="checkout-total"></span>
                </div>
            </div>
            
            <?php if (!$is_logged_in && $show_login_option): ?>
            <!-- Guest/Login Toggle -->
            <div class="checkout-auth-toggle">
                <button type="button" class="auth-toggle-btn active" data-mode="guest">
                    <svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M20 21V19C20 17.9391 19.5786 16.9217 18.8284 16.1716C18.0783 15.4214 17.0609 15 16 15H8C6.93913 15 5.92172 15.4214 5.17157 16.1716C4.42143 16.9217 4 17.9391 4 19V21M16 7C16 9.20914 14.2091 11 12 11C9.79086 11 8 9.20914 8 7C8 4.79086 9.79086 3 12 3C14.2091 3 16 4.79086 16 7Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                    </svg>
                    <?php esc_html_e('Continue as Guest', 'ticketpaygo-lite'); ?>
                </button>
                <button type="button" class="auth-toggle-btn" data-mode="login">
                    <svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M15 3H19C19.5304 3 20.0391 3.21071 20.4142 3.58579C20.7893 3.96086 21 4.46957 21 5V19C21 19.5304 20.7893 20.0391 20.4142 20.4142C20.0391 20.7893 19.5304 21 19 21H15M10 17L15 12M15 12L10 7M15 12H3" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                    </svg>
                    <?php esc_html_e('Login to Account', 'ticketpaygo-lite'); ?>
                </button>
            </div>
            <?php endif; ?>
            
            <form id="checkout-form" class="checkout-form">
                <input type="hidden" name="action" value="ticketpaygo_purchase_ticket">
                <input type="hidden" name="nonce" value="<?php echo esc_attr(wp_create_nonce('ticketpaygo_frontend_nonce')); ?>">
                <input type="hidden" name="event_id" id="checkout-event-id" value="">
                <input type="hidden" name="quantity" id="checkout-quantity-input" value="">
                <input type="hidden" name="total_amount" id="checkout-total-input" value="">
                
                <?php if ($is_logged_in): ?>
                    <!-- Logged in user - auto-fill -->
                    <div class="checkout-user-info">
                        <div class="user-info-card">
                            <svg width="48" height="48" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M20 21V19C20 17.9391 19.5786 16.9217 18.8284 16.1716C18.0783 15.4214 17.0609 15 16 15H8C6.93913 15 5.92172 15.4214 5.17157 16.1716C4.42143 16.9217 4 17.9391 4 19V21M16 7C16 9.20914 14.2091 11 12 11C9.79086 11 8 9.20914 8 7C8 4.79086 9.79086 3 12 3C14.2091 3 16 4.79086 16 7Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                            </svg>
                            <div class="user-info-details">
                                <p class="user-name"><?php echo esc_html($current_user->display_name); ?></p>
                                <p class="user-email"><?php echo esc_html($current_user->user_email); ?></p>
                            </div>
                        </div>
                    </div>
                    <input type="hidden" name="customer_name" value="<?php echo esc_attr($current_user->display_name); ?>">
                    <input type="hidden" name="customer_email" value="<?php echo esc_attr($current_user->user_email); ?>">
                <?php else: ?>
                    <!-- Guest checkout form -->
                    <div class="checkout-guest-form" id="guest-form">
                        <div class="form-group">
                            <label for="checkout-name"><?php esc_html_e('Full Name', 'ticketpaygo-lite'); ?> *</label>
                            <input type="text" id="checkout-name" name="customer_name" required placeholder="<?php esc_html_e('John Doe', 'ticketpaygo-lite'); ?>">
                        </div>
                        
                        <div class="form-group">
                            <label for="checkout-email"><?php esc_html_e('Email Address', 'ticketpaygo-lite'); ?> *</label>
                            <input type="email" id="checkout-email" name="customer_email" required placeholder="<?php esc_html_e('john@example.com', 'ticketpaygo-lite'); ?>">
                        </div>
                        
                        <div class="form-group">
                            <label for="checkout-phone"><?php esc_html_e('Phone Number', 'ticketpaygo-lite'); ?></label>
                            <input type="tel" id="checkout-phone" name="customer_phone" placeholder="<?php esc_html_e('+31 6 12345678', 'ticketpaygo-lite'); ?>">
                        </div>
                    </div>
                    
                    <!-- Login form (hidden by default) -->
                    <?php if ($show_login_option): ?>
                    <div class="checkout-login-form" id="login-form" style="display: none;">
                        <p class="login-message">
                            <?php 
                            if ($woocommerce_active) {
                                esc_html_e('Login to your account to use your saved information and view your order history.', 'ticketpaygo-lite');
                            } else {
                                esc_html_e('Login to use your saved information and view your order history.', 'ticketpaygo-lite');
                            }
                            ?>
                        </p>
                        <div class="login-redirect">
                            <a href="<?php echo esc_url($login_url); ?>" class="btn-login">
                                <?php esc_html_e('Go to Login', 'ticketpaygo-lite'); ?>
                            </a>
                        </div>
                    </div>
                    <?php endif; ?>
                <?php endif; ?>
                
                <!-- Payment Method Selection -->
                <div class="checkout-payment-methods">
                    <h3><?php esc_html_e('Payment Method', 'ticketpaygo-lite'); ?></h3>
                    <div class="payment-methods-grid">
                        <?php
                        // Use the same payment method detection as the rest of the system
                        $payment_processor = new TicketPayGo_Payment();
                        $payment_methods = $payment_processor->get_supported_methods();
                        
                        if (empty($payment_methods)): ?>
                            <div class="payment-methods-empty">
                                <p style="color: #d32f2f; background: #ffebee; padding: 16px; border-radius: 8px; margin: 0; font-size: 14px;">
                                    <strong><?php esc_html_e('No payment methods configured', 'ticketpaygo-lite'); ?></strong><br>
                                    <?php esc_html_e('Please enable at least one payment gateway in TicketPayGo Settings → Payment Gateways', 'ticketpaygo-lite'); ?>
                                </p>
                            </div>
                        <?php else:
                            $first = true;
                            foreach ($payment_methods as $method_id => $method): ?>
                                <label class="payment-method-option">
                                    <input type="radio" name="payment_method" value="<?php echo esc_attr($method_id); ?>" <?php echo $first ? 'checked' : ''; ?>>
                                    <div class="payment-method-card">
                                        <span class="payment-method-name"><?php echo esc_html($method['name']); ?></span>
                                        <span class="payment-method-desc"><?php echo esc_html($method['description']); ?></span>
                                    </div>
                                </label>
                            <?php 
                            $first = false;
                            endforeach;
                        endif; ?>
                    </div>
                </div>
                
                <?php if (!empty($terms_url) || !empty($privacy_url)): ?>
                <!-- Terms Agreement -->
                <div class="checkout-terms-agreement" style="margin: 20px 0;">
                    <label class="terms-checkbox-container" style="display: flex; align-items: flex-start; gap: 10px; cursor: pointer;">
                        <input type="checkbox" name="agree_terms" required style="margin-top: 3px;">
                        <span style="font-size: 14px; color: #64748b; line-height: 1.5;">
                            <?php 
                            if (!empty($terms_url) && !empty($privacy_url)) {
                                /* translators: %1$s: Terms & Conditions link, %2$s: Privacy Policy link */
                                printf(esc_html__('I agree to the %1$s and %2$s', 'ticketpaygo-lite'), 
                                    '<a href="' . esc_url($terms_url) . '" target="_blank" style="color: #3b82f6;">' . esc_html__('Terms & Conditions', 'ticketpaygo-lite') . '</a>',
                                    '<a href="' . esc_url($privacy_url) . '" target="_blank" style="color: #3b82f6;">' . esc_html__('Privacy Policy', 'ticketpaygo-lite') . '</a>'
                                );
                            } elseif (!empty($terms_url)) {
                                /* translators: %s: Terms & Conditions link */
                                printf(esc_html__('I agree to the %s', 'ticketpaygo-lite'), 
                                    '<a href="' . esc_url($terms_url) . '" target="_blank" style="color: #3b82f6;">' . esc_html__('Terms & Conditions', 'ticketpaygo-lite') . '</a>'
                                );
                            } elseif (!empty($privacy_url)) {
                                /* translators: %s: Privacy Policy link */
                                printf(esc_html__('I agree to the %s', 'ticketpaygo-lite'), 
                                    '<a href="' . esc_url($privacy_url) . '" target="_blank" style="color: #3b82f6;">' . esc_html__('Privacy Policy', 'ticketpaygo-lite') . '</a>'
                                );
                            }
                            ?>
                        </span>
                    </label>
                </div>
                <?php endif; ?>
                
                <!-- Submit Button -->
                <button type="submit" class="btn-checkout-submit">
                    <span class="btn-text"><?php esc_html_e('Complete Purchase', 'ticketpaygo-lite'); ?></span>
                    <span class="btn-loading" style="display: none;">
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M12 2V6M12 18V22M6 12H2M22 12H18M19.07 19.07L16.24 16.24M19.07 4.93L16.24 7.76M4.93 19.07L7.76 16.24M4.93 4.93L7.76 7.76" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
                        </svg>
                        <?php esc_html_e('Processing...', 'ticketpaygo-lite'); ?>
                    </span>
                </button>
            </form>
        </div>
    </div>
</div>
