<?php
/**
 * Calendar view template
 * 
 * phpcs:disable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
 */

if (!defined('ABSPATH')) {
    exit;
}

$calendar_id = 'ticketpaygo-calendar-' . uniqid();
$view = isset($atts['view']) ? sanitize_text_field($atts['view']) : 'dayGridMonth';
$category = isset($atts['category']) ? sanitize_text_field($atts['category']) : '';
$show_filters = isset($atts['filters']) && $atts['filters'] === 'true';
?>

<div class="ticketpaygo-calendar-wrapper">
    <?php if ($show_filters): ?>
    <div class="calendar-filters">
        <div class="filter-group">
            <label for="calendar-view-select"><?php esc_html_e('View:', 'ticketpaygo-lite'); ?></label>
            <select id="calendar-view-select" class="calendar-view-select" data-calendar="<?php echo esc_attr($calendar_id); ?>">
                <option value="dayGridMonth" <?php selected($view, 'dayGridMonth'); ?>><?php esc_html_e('Month', 'ticketpaygo-lite'); ?></option>
                <option value="timeGridWeek" <?php selected($view, 'timeGridWeek'); ?>><?php esc_html_e('Week', 'ticketpaygo-lite'); ?></option>
                <option value="timeGridDay" <?php selected($view, 'timeGridDay'); ?>><?php esc_html_e('Day', 'ticketpaygo-lite'); ?></option>
                <option value="listMonth" <?php selected($view, 'listMonth'); ?>><?php esc_html_e('List', 'ticketpaygo-lite'); ?></option>
            </select>
        </div>
    </div>
    <?php endif; ?>
    
    <div id="<?php echo esc_attr($calendar_id); ?>" class="ticketpaygo-calendar" 
         data-view="<?php echo esc_attr($view); ?>"
         data-category="<?php echo esc_attr($category); ?>">
    </div>
    
    <!-- Event Details Popup -->
    <div id="calendar-event-popup" class="calendar-event-popup" style="display: none;">
        <div class="popup-overlay"></div>
        <div class="popup-content">
            <button type="button" class="popup-close" aria-label="<?php esc_html_e('Close', 'ticketpaygo-lite'); ?>">&times;</button>
            <div class="popup-event-image"></div>
            <div class="popup-event-details">
                <h3 class="popup-event-title"></h3>
                <div class="popup-event-meta">
                    <div class="meta-item popup-event-date">
                        <svg width="16" height="16" viewBox="0 0 24 24" fill="none"><path d="M19 3H18V1H16V3H8V1H6V3H5C3.89 3 3.01 3.9 3.01 5L3 19C3 20.1 3.89 21 5 21H19C20.1 21 21 20.1 21 19V5C21 3.9 20.1 3 19 3ZM19 19H5V8H19V19Z" fill="currentColor"/></svg>
                        <span></span>
                    </div>
                    <div class="meta-item popup-event-time">
                        <svg width="16" height="16" viewBox="0 0 24 24" fill="none"><path d="M11.99 2C6.47 2 2 6.48 2 12s4.47 10 9.99 10C17.52 22 22 17.52 22 12S17.52 2 11.99 2zM12 20c-4.42 0-8-3.58-8-8s3.58-8 8-8 8 3.58 8 8-3.58 8-8 8zm.5-13H11v6l5.25 3.15.75-1.23-4.5-2.67z" fill="currentColor"/></svg>
                        <span></span>
                    </div>
                    <div class="meta-item popup-event-location">
                        <svg width="16" height="16" viewBox="0 0 24 24" fill="none"><path d="M12 2C8.13 2 5 5.13 5 9c0 5.25 7 13 7 13s7-7.75 7-13c0-3.87-3.13-7-7-7zm0 9.5c-1.38 0-2.5-1.12-2.5-2.5s1.12-2.5 2.5-2.5 2.5 1.12 2.5 2.5-1.12 2.5-2.5 2.5z" fill="currentColor"/></svg>
                        <span></span>
                    </div>
                    <div class="meta-item popup-event-price">
                        <svg width="16" height="16" viewBox="0 0 24 24" fill="none"><path d="M22 10V6c0-1.1-.9-2-2-2H4c-1.1 0-2 .9-2 2v4c1.1 0 2 .9 2 2s-.9 2-2 2v4c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2v-4c-1.1 0-2-.9-2-2s.9-2 2-2z" fill="currentColor"/></svg>
                        <span></span>
                    </div>
                </div>
                <p class="popup-event-description"></p>
                <div class="popup-event-actions">
                    <a href="#" class="btn-book-tickets" target="_blank"><?php esc_html_e('Book Tickets', 'ticketpaygo-lite'); ?></a>
                    <a href="#" class="btn-view-details"><?php esc_html_e('View Details', 'ticketpaygo-lite'); ?></a>
                </div>
            </div>
        </div>
    </div>
</div>
