/**
 * Events List Template JavaScript
 * Handles expand/collapse functionality for event cards
 */

(function($) {
    'use strict';
    
    /**
     * Toggle event details visibility
     */
    window.toggleEventDetails = function(eventId) {
        var detailsPanel = $('#details-list-' + eventId);
        var card = $('#event-list-' + eventId);
        
        if (detailsPanel.length) {
            if (detailsPanel.is(':visible')) {
                detailsPanel.slideUp(300);
                card.removeClass('expanded');
            } else {
                // Close all other expanded panels first
                $('.event-details-expanded').slideUp(300);
                $('.ticketpaygo-event-card-list').removeClass('expanded');
                
                // Open this panel
                detailsPanel.slideDown(300);
                card.addClass('expanded');
            }
        }
    };
    
})(jQuery);
