/**
 * Events Admin Page Functionality
 */
(function($) {
    'use strict';
    
    window.copyToClipboard = function(elementId) {
        const element = document.getElementById(elementId);
        element.select();
        element.setSelectionRange(0, 99999);
        document.execCommand('copy');
        
        const button = element.nextElementSibling;
        const originalText = button.textContent;
        button.textContent = '✓ ' + (ticketpaygo_admin.strings.copied || 'Copied!');
        button.style.background = '#46b450';
        button.style.color = 'white';
        
        setTimeout(() => {
            button.textContent = originalText;
            button.style.background = '';
            button.style.color = '';
        }, 2000);
    };

    window.copyShortcode = function(shortcodeType, eventId) {
        let shortcode;
        if (shortcodeType === 'ticketpaygo_lite_event') {
            shortcode = `[ticketpaygo_lite_event id="${eventId}"]`;
        } else {
            shortcode = '[ticketpaygo_lite_events]';
        }
        
        const tempInput = document.createElement('input');
        tempInput.value = shortcode;
        document.body.appendChild(tempInput);
        tempInput.select();
        document.execCommand('copy');
        document.body.removeChild(tempInput);
        
        alert((ticketpaygo_admin.strings.shortcode_copied || 'Shortcode copied to clipboard!') + '\n' + shortcode);
    };
    
    $(document).ready(function() {
        let ticketTypeIndex = $('#ticket-types-container .ticket-type-row').length;
        
        $('#enable_ticket_types').on('change', function() {
            if ($(this).is(':checked')) {
                $('#simple-pricing').hide();
                $('#ticket-types-section').show();
                if ($('#ticket-types-container .ticket-type-row').length === 0) {
                    addTicketType();
                }
            } else {
                $('#simple-pricing').show();
                $('#ticket-types-section').hide();
            }
        });
        
        $('#add-ticket-type').on('click', function() {
            addTicketType();
        });
        
        function addTicketType() {
            const template = `
                <div class="ticket-type-row" data-index="${ticketTypeIndex}">
                    <div class="ticket-type-header">
                        <span class="ticket-type-title">${ticketpaygo_admin.strings.new_ticket_type || 'New Ticket Type'}</span>
                        <button type="button" class="button-link ticket-type-toggle">
                            <span class="dashicons dashicons-arrow-down-alt2"></span>
                        </button>
                        <button type="button" class="button-link ticket-type-remove" title="${ticketpaygo_admin.strings.remove || 'Remove'}">
                            <span class="dashicons dashicons-trash"></span>
                        </button>
                    </div>
                    <div class="ticket-type-fields">
                        <div class="ticket-type-field-row">
                            <div class="ticket-type-field">
                                <label>${ticketpaygo_admin.strings.name || 'Name'} *</label>
                                <input type="text" name="ticket_types[${ticketTypeIndex}][name]" 
                                       placeholder="${ticketpaygo_admin.strings.name_placeholder || 'e.g., General Admission'}" required>
                            </div>
                            <div class="ticket-type-field">
                                <label>${ticketpaygo_admin.strings.price || 'Price'} *</label>
                                <input type="number" name="ticket_types[${ticketTypeIndex}][price]" 
                                       step="0.01" min="0" placeholder="0.00" required>
                            </div>
                            <div class="ticket-type-field">
                                <label>${ticketpaygo_admin.strings.quantity || 'Quantity'} *</label>
                                <input type="number" name="ticket_types[${ticketTypeIndex}][quantity]" 
                                       min="1" placeholder="100" required>
                            </div>
                        </div>
                        <div class="ticket-type-field-row">
                            <div class="ticket-type-field" style="grid-column: 1 / -1;">
                                <label>${ticketpaygo_admin.strings.description || 'Description'}</label>
                                <input type="text" name="ticket_types[${ticketTypeIndex}][description]" 
                                       placeholder="${ticketpaygo_admin.strings.description_placeholder || 'Optional description'}">
                            </div>
                        </div>
                    </div>
                </div>
            `;
            
            $('#ticket-types-container').append(template);
            ticketTypeIndex++;
        }
        
        $(document).on('click', '.ticket-type-toggle', function() {
            $(this).closest('.ticket-type-row').find('.ticket-type-fields').slideToggle();
            $(this).find('.dashicons').toggleClass('dashicons-arrow-down-alt2 dashicons-arrow-up-alt2');
        });
        
        $(document).on('click', '.ticket-type-remove', function() {
            if (confirm(ticketpaygo_admin.strings.confirm_delete || 'Are you sure you want to remove this ticket type?')) {
                $(this).closest('.ticket-type-row').slideUp(function() {
                    $(this).remove();
                });
            }
        });
        
        $(document).on('input', '.ticket-type-row input[name*="[name]"]', function() {
            const name = $(this).val() || (ticketpaygo_admin.strings.new_ticket_type || 'New Ticket Type');
            $(this).closest('.ticket-type-row').find('.ticket-type-title').text(name);
        });
        
        // Copy to Clipboard Functions
        window.copyToClipboard = function(elementId) {
            const element = document.getElementById(elementId);
            element.select();
            element.setSelectionRange(0, 99999);
            document.execCommand('copy');
            
            const button = element.nextElementSibling;
            const originalText = button.textContent;
            button.textContent = '✓ ' + (ticketpaygo_admin.strings.copied || 'Copied!');
            button.style.background = '#46b450';
            button.style.color = 'white';
            
            setTimeout(() => {
                button.textContent = originalText;
                button.style.background = '';
                button.style.color = '';
            }, 2000);
        };

        window.copyShortcode = function(shortcodeType, eventId) {
            let shortcode;
            if (shortcodeType === 'ticketpaygo_lite_event') {
                shortcode = `[ticketpaygo_lite_event id="${eventId}"]`;
            } else {
                shortcode = '[ticketpaygo_lite_events]';
            }
            
            const tempInput = document.createElement('input');
            tempInput.value = shortcode;
            document.body.appendChild(tempInput);
            tempInput.select();
            document.execCommand('copy');
            document.body.removeChild(tempInput);
            
            alert((ticketpaygo_admin.strings.shortcode_copied || 'Shortcode copied to clipboard!') + '\n' + shortcode);
        };
        
        $('.ticketpaygo-form-container form').on('keypress', function(e) {
            if (e.which === 13 || e.keyCode === 13) {
                if (e.target.tagName.toLowerCase() === 'textarea') {
                    return true;
                }
                e.preventDefault();
                return false;
            }
        });
        
        $('.ticketpaygo-form-container form input[type="submit"]').on('click', function(e) {
            return true;
        });
        
        // Prevent form submission on Enter key press in input fields
        $('.ticketpaygo-form-container form').on('keypress', function(e) {
            // Check if Enter key was pressed (keyCode 13)
            if (e.which === 13 || e.keyCode === 13) {
                // Allow Enter in textarea fields
                if (e.target.tagName.toLowerCase() === 'textarea') {
                    return true;
                }
                // Prevent form submission for all other input fields
                e.preventDefault();
                return false;
            }
        });
    });
})(jQuery);
