/**
 * Event Modal Functionality
 * Handles opening/closing event modals and ticket selection
 */
(function() {
    'use strict';
    
    window.openEventModal = function(eventId) {
        var modal = document.getElementById('modal-' + eventId);
        if (modal) {
            modal.style.display = 'flex';
            document.body.style.overflow = 'hidden';
        }
    };

    window.closeEventModal = function(eventId) {
        var modal = document.getElementById('modal-' + eventId);
        if (modal) {
            modal.style.display = 'none';
            document.body.style.overflow = '';
        }
    };

    if (!window.tpglEscapeHandlerAdded) {
        document.addEventListener('keydown', function(e) {
            if (e.key === 'Escape') {
                var modals = document.querySelectorAll('.ticketpaygo-modal');
                modals.forEach(function(modal) {
                    if (modal.style.display === 'flex') {
                        modal.style.display = 'none';
                        document.body.style.overflow = '';
                    }
                });
            }
        });
        window.tpglEscapeHandlerAdded = true;
    }
})();
