jQuery(document).ready(function($) {
    'use strict';

    // Color picker
    if (typeof $.fn.wpColorPicker !== 'undefined') {
        $('.color-picker').wpColorPicker();
    }
    
    // Media uploader for logo
    $('#upload_logo_button').click(function(e) {
        e.preventDefault();
        
        var uploadTitle = (typeof ticketpaygo_settings !== 'undefined' && ticketpaygo_settings.strings && ticketpaygo_settings.strings.upload_logo) 
            ? ticketpaygo_settings.strings.upload_logo 
            : 'Upload Logo';
            
        var image = wp.media({ 
            title: uploadTitle,
            multiple: false
        }).open()
        .on('select', function(e){
            var uploaded_image = image.state().get('selection').first();
            var image_url = uploaded_image.toJSON().url;
            $('#ticket_organizer_logo').val(image_url);
            
            // Show preview
            if ($('#ticket_organizer_logo').next('div').length) {
                $('#ticket_organizer_logo').next('div').find('img').attr('src', image_url);
            } else {
                $('#ticket_organizer_logo').parent().append('<div style="margin-top: 10px;"><img src="' + image_url + '" style="max-width: 200px; height: auto; border: 1px solid #ddd; padding: 5px; background: white;"></div>');
            }
        });
    });
});
