jQuery(document).ready(function($) {
    'use strict';

    // Make functions globally available for inline onclick handlers
    window.viewOrderDetails = function(orderId) {
        // TODO: Implement order details modal
        alert((ticketpaygo_orders.strings.view_details || 'Order details for Order ID: ') + orderId);
    };

    window.editOrder = function(orderId) {
        // TODO: Implement order editing
        alert((ticketpaygo_orders.strings.edit_feature || 'Edit order functionality coming soon for Order ID: ') + orderId);
    };

    window.resendTickets = function(orderId) {
        if (confirm(ticketpaygo_orders.strings.confirm_resend || 'Are you sure you want to resend tickets for this order?')) {
            // TODO: Implement ticket resending
            alert((ticketpaygo_orders.strings.tickets_resent || 'Tickets resent for Order ID: ') + orderId);
        }
    };

    window.refundOrder = function(orderId) {
        if (confirm(ticketpaygo_orders.strings.confirm_refund || 'Are you sure you want to refund this order? This action cannot be undone.')) {
            // TODO: Implement refund functionality
            alert((ticketpaygo_orders.strings.refund_initiated || 'Refund initiated for Order ID: ') + orderId);
        }
    };

    // Select all checkbox functionality
    $('#cb-select-all-1').on('change', function() {
        $('input[name="order_ids[]"]').prop('checked', this.checked);
    });
});
