<?php
/**
 * Admin Upgrade Page
 * Contextual upsell for TicketPayGo Full
 */

if (!defined('ABSPATH')) {
    exit;
}

// Verify user capabilities
if (!current_user_can('manage_options')) {
    wp_die(esc_html__('You do not have sufficient permissions to access this page.', 'ticketpaygo-lite'));
}
?>

<div class="wrap tpgl-upgrade-page">
    <h1 style="margin-bottom: 0;"><?php esc_html_e('Upgrade to TicketPayGo', 'ticketpaygo-lite'); ?></h1>
    
    <!-- Hero Section -->
    <div class="tpgl-upgrade-hero">
        <img src="<?php echo esc_url(TPGL_PLUGIN_URL . 'assets/images/ticketpaygo_logo.svg'); ?>" alt="TicketPayGo">
        <h2><?php esc_html_e('Professional Event Ticketing Without Per-Ticket Fees', 'ticketpaygo-lite'); ?></h2>
        <p><?php esc_html_e('Upgrade to TicketPayGo for QR code scanning, Apple Wallet integration, advanced analytics, and unlimited events. Choose the plan that fits your needs.', 'ticketpaygo-lite'); ?></p>
        <a href="https://ticketpaygo.upkyk.com" target="_blank" class="tpgl-upgrade-cta">
            <?php esc_html_e('View Pricing & Plans', 'ticketpaygo-lite'); ?>
        </a>
    </div>
    
    <!-- Key Features Grid -->
    <div class="tpgl-features-grid">
        <div class="tpgl-feature-card">
            <div class="tpgl-feature-icon">
                <span class="dashicons dashicons-smartphone"></span>
            </div>
            <h3><?php esc_html_e('QR Code Scanner', 'ticketpaygo-lite'); ?></h3>
            <p><?php esc_html_e('Fast check-in with web-based QR scanner. Works on any device with a camera - no app installation needed.', 'ticketpaygo-lite'); ?></p>
        </div>
        
        <div class="tpgl-feature-card">
            <div class="tpgl-feature-icon">
                <span class="dashicons dashicons-smartphone"></span>
            </div>
            <h3><?php esc_html_e('Apple Wallet Integration', 'ticketpaygo-lite'); ?></h3>
            <p><?php esc_html_e('Customers can add tickets directly to Apple Wallet for easy access on iPhone and Apple Watch.', 'ticketpaygo-lite'); ?></p>
        </div>
        
        <div class="tpgl-feature-card">
            <div class="tpgl-feature-icon">
                <span class="dashicons dashicons-chart-bar"></span>
            </div>
            <h3><?php esc_html_e('Analytics Dashboard', 'ticketpaygo-lite'); ?></h3>
            <p><?php esc_html_e('Track sales, revenue, attendance trends, and customer insights with detailed analytics and reports.', 'ticketpaygo-lite'); ?></p>
        </div>
        
        <div class="tpgl-feature-card">
            <div class="tpgl-feature-icon">
                <span class="dashicons dashicons-admin-settings"></span>
            </div>
            <h3><?php esc_html_e('Multiple Payment Gateways', 'ticketpaygo-lite'); ?></h3>
            <p><?php esc_html_e('Accept payments via Stripe, PayPal, and Mollie. All payment methods included in every plan.', 'ticketpaygo-lite'); ?></p>
        </div>
        
        <div class="tpgl-feature-card">
            <div class="tpgl-feature-icon">
                <span class="dashicons dashicons-cloud"></span>
            </div>
            <h3><?php esc_html_e('Multi-Scanner Support', 'ticketpaygo-lite'); ?></h3>
            <p><?php esc_html_e('Use multiple scanners at different entrances. Real-time sync prevents duplicate check-ins.', 'ticketpaygo-lite'); ?></p>
        </div>
        
        <div class="tpgl-feature-card">
            <div class="tpgl-feature-icon">
                <span class="dashicons dashicons-money-alt"></span>
            </div>
            <h3><?php esc_html_e('No Per-Ticket Fees', 'ticketpaygo-lite'); ?></h3>
            <p><?php esc_html_e('Pay one fixed monthly price. Whether you sell 10 or 10,000 tickets, your cost stays the same.', 'ticketpaygo-lite'); ?></p>
        </div>
    </div>
    
    <!-- Feature Comparison Table -->
    <div class="tpgl-comparison-section">
        <h2><?php esc_html_e('Feature Comparison', 'ticketpaygo-lite'); ?></h2>
        
        <table class="tpgl-comparison-table">
            <thead>
                <tr>
                    <th style="text-align: left; width: 40%; color: #1e293b;"><?php esc_html_e('Feature', 'ticketpaygo-lite'); ?></th>
                    <th style="text-align: center; width: 15%; color: #1e293b;"><?php esc_html_e('Lite', 'ticketpaygo-lite'); ?></th>
                    <th style="text-align: center; width: 15%; background: #f0f7ff; color: #1e293b;"><?php esc_html_e('TicketPayGo', 'ticketpaygo-lite'); ?></th>
                    <th style="text-align: center; width: 15%; background: #e6f4ff; color: #1e293b;"><?php esc_html_e('Multi', 'ticketpaygo-lite'); ?></th>
                    <th style="text-align: center; width: 15%; background: #d9efff; color: #1e293b;">Venue</th>
                </tr>
            </thead>
                <tbody>
                    <tr>
                        <td><?php esc_html_e('Unlimited Events', 'ticketpaygo-lite'); ?></td>
                        <td style="text-align: center;"><span class="dashicons dashicons-yes" style="color: #00a32a;"></span></td>
                        <td style="text-align: center; background: #f0f7ff;"><span class="dashicons dashicons-yes" style="color: #00a32a;"></span></td>
                        <td style="text-align: center; background: #e6f4ff;"><span class="dashicons dashicons-yes" style="color: #00a32a;"></span></td>
                        <td style="text-align: center; background: #d9efff;"><span class="dashicons dashicons-yes" style="color: #00a32a;"></span></td>
                    </tr>
                    <tr>
                        <td><strong><?php esc_html_e('Multiple Ticket Types', 'ticketpaygo-lite'); ?></strong></td>
                        <td style="text-align: center;"><span class="dashicons dashicons-no" style="color: #ccc;"></span></td>
                        <td style="text-align: center; background: #f0f7ff;"><span class="dashicons dashicons-yes" style="color: #00a32a;"></span></td>
                        <td style="text-align: center; background: #e6f4ff;"><span class="dashicons dashicons-yes" style="color: #00a32a;"></span></td>
                        <td style="text-align: center; background: #d9efff;"><span class="dashicons dashicons-yes" style="color: #00a32a;"></span></td>
                    </tr>
                    <tr>
                        <td><?php esc_html_e('Recurring Events', 'ticketpaygo-lite'); ?></td>
                        <td style="text-align: center;"><span class="dashicons dashicons-yes" style="color: #00a32a;"></span></td>
                        <td style="text-align: center; background: #f0f7ff;"><span class="dashicons dashicons-yes" style="color: #00a32a;"></span></td>
                        <td style="text-align: center; background: #e6f4ff;"><span class="dashicons dashicons-yes" style="color: #00a32a;"></span></td>
                        <td style="text-align: center; background: #d9efff;"><span class="dashicons dashicons-yes" style="color: #00a32a;"></span></td>
                    </tr>
                    <tr>
                        <td><?php esc_html_e('Calendar View', 'ticketpaygo-lite'); ?></td>
                        <td style="text-align: center;"><span class="dashicons dashicons-yes" style="color: #00a32a;"></span></td>
                        <td style="text-align: center; background: #f0f7ff;"><span class="dashicons dashicons-yes" style="color: #00a32a;"></span></td>
                        <td style="text-align: center; background: #e6f4ff;"><span class="dashicons dashicons-yes" style="color: #00a32a;"></span></td>
                        <td style="text-align: center; background: #d9efff;"><span class="dashicons dashicons-yes" style="color: #00a32a;"></span></td>
                    </tr>
                    <tr>
                        <td><strong><?php esc_html_e('Calendar Downloads (iCal, Outlook, Google)', 'ticketpaygo-lite'); ?></strong></td>
                        <td style="text-align: center;"><span class="dashicons dashicons-no" style="color: #ccc;"></span></td>
                        <td style="text-align: center; background: #f0f7ff;"><span class="dashicons dashicons-yes" style="color: #00a32a;"></span></td>
                        <td style="text-align: center; background: #e6f4ff;"><span class="dashicons dashicons-yes" style="color: #00a32a;"></span></td>
                        <td style="text-align: center; background: #d9efff;"><span class="dashicons dashicons-yes" style="color: #00a32a;"></span></td>
                    </tr>
                    <tr>
                        <td><?php esc_html_e('Email & Card Customization', 'ticketpaygo-lite'); ?></td>
                        <td style="text-align: center;"><span class="dashicons dashicons-yes" style="color: #00a32a;"></span></td>
                        <td style="text-align: center; background: #f0f7ff;"><span class="dashicons dashicons-yes" style="color: #00a32a;"></span></td>
                        <td style="text-align: center; background: #e6f4ff;"><span class="dashicons dashicons-yes" style="color: #00a32a;"></span></td>
                        <td style="text-align: center; background: #d9efff;"><span class="dashicons dashicons-yes" style="color: #00a32a;"></span></td>
                    </tr>
                    <tr>
                        <td><?php esc_html_e('PayPal Payments', 'ticketpaygo-lite'); ?></td>
                        <td style="text-align: center;"><span class="dashicons dashicons-yes" style="color: #00a32a;"></span></td>
                        <td style="text-align: center; background: #f0f7ff;"><span class="dashicons dashicons-yes" style="color: #00a32a;"></span></td>
                        <td style="text-align: center; background: #e6f4ff;"><span class="dashicons dashicons-yes" style="color: #00a32a;"></span></td>
                        <td style="text-align: center; background: #d9efff;"><span class="dashicons dashicons-yes" style="color: #00a32a;"></span></td>
                    </tr>
                    <tr>
                        <td><?php esc_html_e('Manual Check-in (WP-Admin)', 'ticketpaygo-lite'); ?></td>
                        <td style="text-align: center;"><span class="dashicons dashicons-yes" style="color: #00a32a;"></span></td>
                        <td style="text-align: center; background: #f0f7ff;"><span class="dashicons dashicons-yes" style="color: #00a32a;"></span></td>
                        <td style="text-align: center; background: #e6f4ff;"><span class="dashicons dashicons-yes" style="color: #00a32a;"></span></td>
                        <td style="text-align: center; background: #d9efff;"><span class="dashicons dashicons-yes" style="color: #00a32a;"></span></td>
                    </tr>
                    <tr>
                        <td><strong><?php esc_html_e('QR Code Tickets', 'ticketpaygo-lite'); ?></strong></td>
                        <td style="text-align: center;"><span class="dashicons dashicons-no" style="color: #ccc;"></span></td>
                        <td style="text-align: center; background: #f0f7ff;"><span class="dashicons dashicons-yes" style="color: #00a32a;"></span></td>
                        <td style="text-align: center; background: #e6f4ff;"><span class="dashicons dashicons-yes" style="color: #00a32a;"></span></td>
                        <td style="text-align: center; background: #d9efff;"><span class="dashicons dashicons-yes" style="color: #00a32a;"></span></td>
                    </tr>
                    <tr>
                        <td><strong><?php esc_html_e('Web QR Scanner', 'ticketpaygo-lite'); ?></strong></td>
                        <td style="text-align: center;"><span class="dashicons dashicons-no" style="color: #ccc;"></span></td>
                        <td style="text-align: center; background: #f0f7ff;"><span class="dashicons dashicons-yes" style="color: #00a32a;"></span></td>
                        <td style="text-align: center; background: #e6f4ff;"><span class="dashicons dashicons-yes" style="color: #00a32a;"></span></td>
                        <td style="text-align: center; background: #d9efff;"><span class="dashicons dashicons-yes" style="color: #00a32a;"></span></td>
                    </tr>
                    <tr>
                        <td><strong><?php esc_html_e('Apple Wallet Integration', 'ticketpaygo-lite'); ?></strong></td>
                        <td style="text-align: center;"><span class="dashicons dashicons-no" style="color: #ccc;"></span></td>
                        <td style="text-align: center; background: #f0f7ff;"><span class="dashicons dashicons-yes" style="color: #00a32a;"></span></td>
                        <td style="text-align: center; background: #e6f4ff;"><span class="dashicons dashicons-yes" style="color: #00a32a;"></span></td>
                        <td style="text-align: center; background: #d9efff;"><span class="dashicons dashicons-yes" style="color: #00a32a;"></span></td>
                    </tr>
                    <tr>
                        <td><strong><?php esc_html_e('Stripe & Mollie Payments', 'ticketpaygo-lite'); ?></strong></td>
                        <td style="text-align: center;"><span class="dashicons dashicons-no" style="color: #ccc;"></span></td>
                        <td style="text-align: center; background: #f0f7ff;"><span class="dashicons dashicons-yes" style="color: #00a32a;"></span></td>
                        <td style="text-align: center; background: #e6f4ff;"><span class="dashicons dashicons-yes" style="color: #00a32a;"></span></td>
                        <td style="text-align: center; background: #d9efff;"><span class="dashicons dashicons-yes" style="color: #00a32a;"></span></td>
                    </tr>
                    <tr>
                        <td><strong><?php esc_html_e('Analytics Dashboard', 'ticketpaygo-lite'); ?></strong></td>
                        <td style="text-align: center;"><span class="dashicons dashicons-no" style="color: #ccc;"></span></td>
                        <td style="text-align: center; background: #f0f7ff;"><span class="dashicons dashicons-yes" style="color: #00a32a;"></span></td>
                        <td style="text-align: center; background: #e6f4ff;"><span class="dashicons dashicons-yes" style="color: #00a32a;"></span></td>
                        <td style="text-align: center; background: #d9efff;"><span class="dashicons dashicons-yes" style="color: #00a32a;"></span></td>
                    </tr>
                    <tr>
                        <td><strong><?php esc_html_e('Advanced Ticket Customization', 'ticketpaygo-lite'); ?></strong></td>
                        <td style="text-align: center;"><span class="dashicons dashicons-no" style="color: #ccc;"></span></td>
                        <td style="text-align: center; background: #f0f7ff;"><span class="dashicons dashicons-yes" style="color: #00a32a;"></span></td>
                        <td style="text-align: center; background: #e6f4ff;"><span class="dashicons dashicons-yes" style="color: #00a32a;"></span></td>
                        <td style="text-align: center; background: #d9efff;"><span class="dashicons dashicons-yes" style="color: #00a32a;"></span></td>
                    </tr>
                    <tr>
                        <td><strong><?php esc_html_e('Active Scanners', 'ticketpaygo-lite'); ?></strong></td>
                        <td style="text-align: center;">—</td>
                        <td style="text-align: center; background: #f0f7ff;"><strong>2</strong></td>
                        <td style="text-align: center; background: #e6f4ff;"><strong>4</strong></td>
                        <td style="text-align: center; background: #d9efff;"><strong>7</strong></td>
                    </tr>
                    <tr>
                        <td><strong><?php esc_html_e('Priority Support', 'ticketpaygo-lite'); ?></strong></td>
                        <td style="text-align: center;"><span class="dashicons dashicons-no" style="color: #ccc;"></span></td>
                        <td style="text-align: center; background: #f0f7ff;"><span class="dashicons dashicons-yes" style="color: #00a32a;"></span></td>
                        <td style="text-align: center; background: #e6f4ff;"><span class="dashicons dashicons-yes" style="color: #00a32a;"></span></td>
                        <td style="text-align: center; background: #d9efff;"><span class="dashicons dashicons-yes" style="color: #00a32a;"></span></td>
                    </tr>
                </tbody>
        </table>
    </div>
    
    <!-- Final CTA -->
    <div class="tpgl-final-cta">
        <h2><?php esc_html_e('Ready to Upgrade?', 'ticketpaygo-lite'); ?></h2>
        <p><?php esc_html_e('Start with TicketPayGo and scale up as your events grow. No per-ticket fees, ever.', 'ticketpaygo-lite'); ?></p>
        <a href="https://ticketpaygo.upkyk.com" target="_blank" class="button button-large">
            <?php esc_html_e('View Pricing & Plans', 'ticketpaygo-lite'); ?>
        </a>
        <p style="margin-top: 24px; margin-bottom: 0; opacity: 0.9;">
            <a href="https://ticketpaygo.upkyk.com#contact" target="_blank" style="color: white; text-decoration: underline;">
                <?php esc_html_e('Questions? Request a demo', 'ticketpaygo-lite'); ?>
            </a>
        </p>
    </div>
</div>
