<?php
/**
 * Email Settings Page (Lite Version)
 * Simplified email customization without QR Code and Apple Wallet
 * 
 * phpcs:disable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
 */

if (!defined('ABSPATH')) {
    exit;
}

// Handle test email
if (isset($_POST['send_test_email']) && isset($_POST['tpgl_test_email_nonce'])) {
    if (wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['tpgl_test_email_nonce'])), 'tpgl_test_email_action')) {
        $test_email = isset($_POST['test_email_address']) ? sanitize_email(wp_unslash($_POST['test_email_address'])) : '';
        
        if (!empty($test_email) && is_email($test_email)) {
            // Get current email settings
            $from_name = TicketPayGo_Database::get_setting('email_from_name', get_bloginfo('name'));
            $from_email = TicketPayGo_Database::get_setting('email_from_email', get_option('admin_email'));
            $subject = TicketPayGo_Database::get_setting('email_subject', 'Test Email - {event_title}');
            
            // Replace placeholders with test data
            $subject = str_replace('{event_title}', 'Sample Event', $subject);
            
            // Build test email content
            $header_bg = TicketPayGo_Database::get_setting('email_header_bg_color', '#3b82f6');
            $header_text = TicketPayGo_Database::get_setting('email_header_text', 'Order Confirmation');
            $header_subtitle = TicketPayGo_Database::get_setting('email_header_subtitle', 'Thank you for your purchase!');
            $greeting_prefix = TicketPayGo_Database::get_setting('email_greeting_prefix', 'Dear');
            $greeting_text = TicketPayGo_Database::get_setting('email_greeting_text', 'Thank you for your ticket purchase!');
            $footer_text = TicketPayGo_Database::get_setting('email_footer_text', 'Best regards,\nThe TicketPayGo Team');
            $logo = TicketPayGo_Database::get_setting('email_header_logo', '');
            
            $message = '
            <div style="font-family: Arial, sans-serif; max-width: 600px; margin: 0 auto; background: #f8fafc;">
                <div style="background: ' . esc_attr($header_bg) . '; padding: 40px 20px; text-align: center;">
                    ' . (!empty($logo) ? '<img src="' . esc_url($logo) . '" alt="Logo" style="max-width: 200px; margin-bottom: 20px;">' : '') . '
                    <h1 style="color: #ffffff; margin: 0 0 10px 0;">' . esc_html($header_text) . '</h1>
                    <p style="color: #ffffff; opacity: 0.9; margin: 0;">' . esc_html($header_subtitle) . '</p>
                </div>
                <div style="background: #ffffff; padding: 30px 20px;">
                    <p style="margin: 0 0 20px 0;"><strong>' . esc_html($greeting_prefix) . ' Test User,</strong></p>
                    <p style="margin: 0 0 20px 0;">' . nl2br(esc_html($greeting_text)) . '</p>
                    <div style="background: #f8fafc; padding: 20px; border-radius: 8px; margin: 20px 0;">
                        <h3 style="margin: 0 0 15px 0;">Event Details</h3>
                        <p style="margin: 5px 0;"><strong>Event:</strong> Sample Event</p>
                        <p style="margin: 5px 0;"><strong>Date:</strong> July 10, 2026</p>
                        <p style="margin: 5px 0;"><strong>Time:</strong> 10:00 AM</p>
                        <p style="margin: 5px 0;"><strong>Location:</strong> Sample Venue</p>
                        <p style="margin: 5px 0;"><strong>Tickets:</strong> 2x General Admission</p>
                        <p style="margin: 5px 0;"><strong>Total:</strong> €50.00</p>
                    </div>
                    <p style="margin: 20px 0 0 0; font-style: italic; color: #64748b; font-size: 14px;">This is a test email to preview your email template.</p>
                </div>
                <div style="background: #1e293b; padding: 20px; text-align: center; color: #ffffff;">
                    <p style="margin: 0; white-space: pre-line;">' . nl2br(esc_html($footer_text)) . '</p>
                </div>
            </div>';
            
            $headers = array(
                'Content-Type: text/html; charset=UTF-8',
                'From: ' . $from_name . ' <' . $from_email . '>'
            );
            
            if (wp_mail($test_email, $subject, $message, $headers)) {
                echo '<div class="notice notice-success"><p>' . esc_html__('Test email sent successfully to ', 'ticketpaygo-lite') . esc_html($test_email) . '</p></div>';
            } else {
                echo '<div class="notice notice-error"><p>' . esc_html__('Failed to send test email. Please check your email configuration.', 'ticketpaygo-lite') . '</p></div>';
            }
        } else {
            echo '<div class="notice notice-error"><p>' . esc_html__('Please enter a valid email address.', 'ticketpaygo-lite') . '</p></div>';
        }
    }
}

// Handle form submission
if (isset($_POST['save_email_settings']) && isset($_POST['tpgl_email_settings_nonce'])) {
    if (wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['tpgl_email_settings_nonce'])), 'tpgl_email_settings_action')) {
        // Save email settings
        TicketPayGo_Database::update_setting('email_notifications', isset($_POST['enable_notifications']) ? '1' : '0');
        TicketPayGo_Database::update_setting('email_from_name', isset($_POST['from_name']) ? sanitize_text_field(wp_unslash($_POST['from_name'])) : '');
        TicketPayGo_Database::update_setting('email_from_email', isset($_POST['from_email']) ? sanitize_email(wp_unslash($_POST['from_email'])) : '');
        TicketPayGo_Database::update_setting('email_subject', isset($_POST['subject']) ? sanitize_text_field(wp_unslash($_POST['subject'])) : '');
        
        // Visual builder settings
        TicketPayGo_Database::update_setting('email_header_bg_color', isset($_POST['header_bg_color']) ? sanitize_hex_color(wp_unslash($_POST['header_bg_color'])) : '#3b82f6');
        TicketPayGo_Database::update_setting('email_header_text', isset($_POST['header_text']) ? sanitize_text_field(wp_unslash($_POST['header_text'])) : 'Order Confirmation');
        TicketPayGo_Database::update_setting('email_header_text_color', isset($_POST['header_text_color']) ? sanitize_hex_color(wp_unslash($_POST['header_text_color'])) : '#ffffff');
        TicketPayGo_Database::update_setting('email_header_subtitle', isset($_POST['header_subtitle']) ? sanitize_text_field(wp_unslash($_POST['header_subtitle'])) : 'Thank you for your purchase!');
        TicketPayGo_Database::update_setting('email_greeting_prefix', isset($_POST['greeting_prefix']) ? sanitize_text_field(wp_unslash($_POST['greeting_prefix'])) : 'Dear');
        TicketPayGo_Database::update_setting('email_greeting_text', isset($_POST['greeting_text']) ? sanitize_textarea_field(wp_unslash($_POST['greeting_text'])) : '');
        TicketPayGo_Database::update_setting('email_footer_text', isset($_POST['footer_text']) ? sanitize_textarea_field(wp_unslash($_POST['footer_text'])) : '');
        TicketPayGo_Database::update_setting('email_accent_color', isset($_POST['accent_color']) ? sanitize_hex_color(wp_unslash($_POST['accent_color'])) : '#22c55e');
        TicketPayGo_Database::update_setting('email_show_event_details', isset($_POST['show_event_details']) ? '1' : '0');
        TicketPayGo_Database::update_setting('email_show_calendar_buttons', isset($_POST['show_calendar_buttons']) ? '1' : '0');
        
        // Logo settings
        TicketPayGo_Database::update_setting('email_header_logo', isset($_POST['header_logo']) ? esc_url_raw(wp_unslash($_POST['header_logo'])) : '');
        TicketPayGo_Database::update_setting('email_logo_position', isset($_POST['logo_position']) ? sanitize_text_field(wp_unslash($_POST['logo_position'])) : 'left');
        TicketPayGo_Database::update_setting('email_ticket_logo', isset($_POST['ticket_logo']) ? esc_url_raw(wp_unslash($_POST['ticket_logo'])) : '');
        
        echo '<div class="notice notice-success"><p>' . esc_html__('Email settings saved successfully!', 'ticketpaygo-lite') . '</p></div>';
    }
}

// Get current settings
$email_settings = array(
    'enable_notifications' => TicketPayGo_Database::get_setting('email_notifications', '1'),
    'from_name' => TicketPayGo_Database::get_setting('email_from_name', get_bloginfo('name')),
    'from_email' => TicketPayGo_Database::get_setting('email_from_email', get_option('admin_email')),
    'subject' => TicketPayGo_Database::get_setting('email_subject', __('Your Ticket Order Confirmation - {event_title}', 'ticketpaygo-lite')),
    'header_bg_color' => TicketPayGo_Database::get_setting('email_header_bg_color', '#3b82f6'),
    'header_text' => TicketPayGo_Database::get_setting('email_header_text', 'Order Confirmation'),
    'header_text_color' => TicketPayGo_Database::get_setting('email_header_text_color', '#ffffff'),
    'header_subtitle' => TicketPayGo_Database::get_setting('email_header_subtitle', 'Thank you for your purchase!'),
    'greeting_prefix' => TicketPayGo_Database::get_setting('email_greeting_prefix', 'Dear'),
    'greeting_text' => TicketPayGo_Database::get_setting('email_greeting_text', "Your ticket order has been confirmed! We're excited to see you at the event."),
    'footer_text' => TicketPayGo_Database::get_setting('email_footer_text', "Best regards,\nThe TicketPayGo Team"),
    'accent_color' => TicketPayGo_Database::get_setting('email_accent_color', '#22c55e'),
    'show_event_details' => TicketPayGo_Database::get_setting('email_show_event_details', '1'),
    'show_calendar_buttons' => TicketPayGo_Database::get_setting('email_show_calendar_buttons', '1'),
    'header_logo' => TicketPayGo_Database::get_setting('email_header_logo', ''),
    'logo_position' => TicketPayGo_Database::get_setting('email_logo_position', 'left'),
    'ticket_logo' => TicketPayGo_Database::get_setting('email_ticket_logo', '')
);
?>

<div class="ticketpaygo-email-settings">
    <form method="post" action="">
        <?php wp_nonce_field('tpgl_email_settings_action', 'tpgl_email_settings_nonce'); ?>
        <input type="hidden" id="header_logo" name="header_logo" value="<?php echo esc_attr($email_settings['header_logo']); ?>" />
        <input type="hidden" id="ticket_logo" name="ticket_logo" value="<?php echo esc_attr($email_settings['ticket_logo']); ?>" />
        
        <div class="section-group">
            <h2><?php esc_html_e('General Email Settings', 'ticketpaygo-lite'); ?></h2>
            
            <table class="form-table">
                <tr>
                    <th scope="row">
                        <label for="enable_notifications"><?php esc_html_e('Enable Email Notifications', 'ticketpaygo-lite'); ?></label>
                    </th>
                    <td>
                        <label>
                            <input type="checkbox" id="enable_notifications" name="enable_notifications" value="1" <?php checked($email_settings['enable_notifications'], '1'); ?> />
                            <?php esc_html_e('Send confirmation emails to customers', 'ticketpaygo-lite'); ?>
                        </label>
                    </td>
                </tr>
                
                <tr>
                    <th scope="row">
                        <label for="from_name"><?php esc_html_e('From Name', 'ticketpaygo-lite'); ?></label>
                    </th>
                    <td>
                        <input type="text" id="from_name" name="from_name" class="regular-text" value="<?php echo esc_attr($email_settings['from_name']); ?>" required />
                        <p class="description"><?php esc_html_e('The name that appears in the "From" field', 'ticketpaygo-lite'); ?></p>
                    </td>
                </tr>
                
                <tr>
                    <th scope="row">
                        <label for="from_email"><?php esc_html_e('From Email', 'ticketpaygo-lite'); ?></label>
                    </th>
                    <td>
                        <input type="email" id="from_email" name="from_email" class="regular-text" value="<?php echo esc_attr($email_settings['from_email']); ?>" required />
                        <p class="description"><?php esc_html_e('The email address that appears in the "From" field', 'ticketpaygo-lite'); ?></p>
                    </td>
                </tr>
                
                <tr>
                    <th scope="row">
                        <label for="subject"><?php esc_html_e('Email Subject', 'ticketpaygo-lite'); ?></label>
                    </th>
                    <td>
                        <input type="text" id="subject" name="subject" class="large-text" value="<?php echo esc_attr($email_settings['subject']); ?>" required />
                        <p class="description"><?php esc_html_e('Available placeholders: {event_title}, {order_id}, {customer_name}', 'ticketpaygo-lite'); ?></p>
                    </td>
                </tr>
            </table>
        </div>
        
        <div class="section-group">
            <h2><?php esc_html_e('Email Template Customization', 'ticketpaygo-lite'); ?></h2>
            <p class="description" style="margin-bottom: 15px;">
                <?php esc_html_e('Customize how your confirmation emails look. The Lite version includes a ticket image without QR code.', 'ticketpaygo-lite'); ?>
                <br><small style="color: #666;"><?php esc_html_e('Upgrade to the full plugin for QR codes and Apple Wallet integration.', 'ticketpaygo-lite'); ?></small>
            </p>
            
            <div class="builder-layout">
                <div class="builder-controls">
                    <h3><?php esc_html_e('Template Settings', 'ticketpaygo-lite'); ?></h3>
                    
                    <div class="control-group">
                        <label><?php esc_html_e('Header Logo', 'ticketpaygo-lite'); ?></label>
                        <div class="logo-upload-wrapper">
                            <button type="button" class="button" id="upload_logo_button">
                                <?php esc_html_e('Choose from Media Library', 'ticketpaygo-lite'); ?>
                            </button>
                            <button type="button" class="button" id="remove_logo_button" style="<?php echo empty($email_settings['header_logo']) ? 'display:none;' : ''; ?>">
                                <?php esc_html_e('Remove Logo', 'ticketpaygo-lite'); ?>
                            </button>
                            <div id="logo_preview" style="margin-top: 10px; <?php echo empty($email_settings['header_logo']) ? 'display:none;' : ''; ?>">
                                <img src="<?php echo esc_url($email_settings['header_logo']); ?>" style="max-width: 150px; max-height: 60px; display: block; margin-bottom: 5px;" />
                                <small><?php esc_html_e('Current logo', 'ticketpaygo-lite'); ?></small>
                            </div>
                        </div>
                        <p class="description"><?php esc_html_e('Upload a logo for the email header (recommended: 300x100px)', 'ticketpaygo-lite'); ?></p>
                    </div>
                    
                    <div class="control-group">
                        <label><?php esc_html_e('Logo Position', 'ticketpaygo-lite'); ?></label>
                        <select id="logo_position" name="logo_position">
                            <option value="left" <?php selected($email_settings['logo_position'], 'left'); ?>><?php esc_html_e('Left', 'ticketpaygo-lite'); ?></option>
                            <option value="center" <?php selected($email_settings['logo_position'], 'center'); ?>><?php esc_html_e('Center', 'ticketpaygo-lite'); ?></option>
                            <option value="right" <?php selected($email_settings['logo_position'], 'right'); ?>><?php esc_html_e('Right', 'ticketpaygo-lite'); ?></option>
                        </select>
                    </div>
                    
                    <div class="control-group">
                        <label><?php esc_html_e('Header Background Color', 'ticketpaygo-lite'); ?></label>
                        <input type="color" id="header_bg_color" name="header_bg_color" value="<?php echo esc_attr($email_settings['header_bg_color']); ?>" />
                    </div>
                    
                    <div class="control-group">
                        <label><?php esc_html_e('Header Text', 'ticketpaygo-lite'); ?></label>
                        <input type="text" id="header_text" name="header_text" class="regular-text" value="<?php echo esc_attr($email_settings['header_text']); ?>" />
                    </div>
                    
                    <div class="control-group">
                        <label><?php esc_html_e('Header Text Color', 'ticketpaygo-lite'); ?></label>
                        <input type="color" id="header_text_color" name="header_text_color" value="<?php echo esc_attr($email_settings['header_text_color']); ?>" />
                    </div>
                    
                    <div class="control-group">
                        <label><?php esc_html_e('Header Subtitle', 'ticketpaygo-lite'); ?></label>
                        <input type="text" id="header_subtitle" name="header_subtitle" class="regular-text" value="<?php echo esc_attr($email_settings['header_subtitle']); ?>" />
                    </div>
                    
                    <div class="control-group">
                        <label><?php esc_html_e('Greeting Prefix', 'ticketpaygo-lite'); ?></label>
                        <input type="text" id="greeting_prefix" name="greeting_prefix" class="regular-text" value="<?php echo esc_attr($email_settings['greeting_prefix']); ?>" />
                        <p class="description"><?php esc_html_e('Text before customer name (e.g., "Dear", "Hello", "Hi")', 'ticketpaygo-lite'); ?></p>
                    </div>
                    
                    <div class="control-group">
                        <label><?php esc_html_e('Greeting Text', 'ticketpaygo-lite'); ?></label>
                        <textarea id="greeting_text" name="greeting_text" rows="2" class="regular-text"><?php echo esc_textarea($email_settings['greeting_text']); ?></textarea>
                    </div>
                    
                    <div class="control-group">
                        <label><?php esc_html_e('Show Event Details Box', 'ticketpaygo-lite'); ?></label>
                        <input type="checkbox" id="show_event_details" name="show_event_details" value="1" <?php checked($email_settings['show_event_details'], '1'); ?> />
                    </div>
                    
                    <!-- Calendar buttons hidden in Lite version -->
                    <input type="hidden" name="show_calendar_buttons" value="0">
                    
                    <div class="control-group">
                        <label><?php esc_html_e('Ticket Design Logo', 'ticketpaygo-lite'); ?></label>
                        <div class="logo-upload-wrapper">
                            <button type="button" class="button" id="upload_ticket_logo_button">
                                <?php esc_html_e('Choose Ticket Logo', 'ticketpaygo-lite'); ?>
                            </button>
                            <button type="button" class="button" id="remove_ticket_logo_button" style="<?php echo empty($email_settings['ticket_logo']) ? 'display:none;' : ''; ?>">
                                <?php esc_html_e('Remove', 'ticketpaygo-lite'); ?>
                            </button>
                            <div id="ticket_logo_preview" style="margin-top: 10px; <?php echo empty($email_settings['ticket_logo']) ? 'display:none;' : ''; ?>">
                                <img src="<?php echo esc_url($email_settings['ticket_logo']); ?>" style="max-width: 150px; max-height: 60px; display: block; margin-bottom: 5px;" />
                                <small><?php esc_html_e('Current ticket logo', 'ticketpaygo-lite'); ?></small>
                            </div>
                        </div>
                        <p class="description"><?php esc_html_e('Logo displayed on the ticket design in emails.', 'ticketpaygo-lite'); ?></p>
                    </div>
                    
                    <div class="control-group">
                        <label><?php esc_html_e('Footer Text (Signature)', 'ticketpaygo-lite'); ?></label>
                        <textarea id="footer_text" name="footer_text" rows="2" class="regular-text"><?php echo esc_textarea($email_settings['footer_text']); ?></textarea>
                    </div>
                    
                    <div class="control-group">
                        <label><?php esc_html_e('Accent Color', 'ticketpaygo-lite'); ?></label>
                        <input type="color" id="accent_color" name="accent_color" value="<?php echo esc_attr($email_settings['accent_color']); ?>" />
                    </div>
                    
                    <button type="button" id="update_preview" class="button button-secondary" style="margin-top: 15px;">
                        <?php esc_html_e('Update Preview', 'ticketpaygo-lite'); ?>
                    </button>
                </div>
                
                <div class="builder-preview">
                    <h3><?php esc_html_e('Live Preview', 'ticketpaygo-lite'); ?></h3>
                    <div class="preview-container">
                        <iframe id="email-preview" style="width: 100%; height: 600px; border: 1px solid #ddd; background: #f4f4f4;"></iframe>
                    </div>
                    <p class="description" style="margin-top: 10px;">
                        <strong><?php esc_html_e('Note:', 'ticketpaygo-lite'); ?></strong> 
                        <?php esc_html_e('The Lite version shows a ticket image without QR code. Upgrade for QR codes and Apple Wallet.', 'ticketpaygo-lite'); ?>
                    </p>
                </div>
            </div>
        </div>
        
        <p class="submit">
            <input type="submit" name="save_email_settings" class="button button-primary" value="<?php esc_attr_e('Save Email Settings', 'ticketpaygo-lite'); ?>" style="background: linear-gradient(135deg, #0A4974 0%, #42963B 100%) !important; border: none !important;" />
        </p>
    </form>
    
    <!-- Test Email Section -->
    <div class="section-group" style="margin-top: 30px; background: #f0f8ff; border: 1px solid #0073aa; border-radius: 8px; padding: 20px;">
        <h2 style="margin-top: 0; color: #0073aa;"><?php esc_html_e('Send Test Email', 'ticketpaygo-lite'); ?></h2>
        <p><?php esc_html_e('Send a test email to preview how your email template will look.', 'ticketpaygo-lite'); ?></p>
        
        <form method="post" action="" style="margin-top: 15px;">
            <?php wp_nonce_field('tpgl_test_email_action', 'tpgl_test_email_nonce'); ?>
            <div style="display: flex; gap: 10px; align-items: flex-end;">
                <div style="flex: 1;">
                    <label for="test_email_address" style="display: block; margin-bottom: 5px; font-weight: 600;">
                        <?php esc_html_e('Email Address', 'ticketpaygo-lite'); ?>
                    </label>
                    <input type="email" 
                           id="test_email_address" 
                           name="test_email_address" 
                           class="regular-text" 
                           placeholder="<?php esc_attr_e('your@email.com', 'ticketpaygo-lite'); ?>" 
                           value="<?php echo esc_attr(get_option('admin_email')); ?>" 
                           required />
                </div>
                <div>
                    <input type="submit" 
                           name="send_test_email" 
                           class="button button-secondary" 
                           value="<?php esc_attr_e('Send Test Email', 'ticketpaygo-lite'); ?>" />
                </div>
            </div>
            <p class="description" style="margin-top: 8px;">
                <?php esc_html_e('Make sure to save your settings before sending a test email to see the latest changes.', 'ticketpaygo-lite'); ?>
            </p>
        </form>
    </div>
</div>

<style>
.ticketpaygo-email-settings .section-group {
    background: #fff;
    padding: 20px;
    margin-bottom: 20px;
    border: 1px solid #ccd0d4;
    box-shadow: 0 1px 1px rgba(0,0,0,.04);
    border-radius: 8px;
}

.ticketpaygo-email-settings .section-group h2 {
    margin-top: 0;
    padding-bottom: 10px;
    border-bottom: 1px solid #e5e5e5;
}

.builder-layout {
    display: grid;
    grid-template-columns: 350px 1fr;
    gap: 20px;
    margin-top: 20px;
}

.builder-controls {
    background: #f9f9f9;
    padding: 20px;
    border: 1px solid #ddd;
    border-radius: 4px;
    max-height: 700px;
    overflow-y: auto;
}

.builder-controls h3 {
    margin-top: 0;
    font-size: 16px;
    border-bottom: 1px solid #ddd;
    padding-bottom: 10px;
}

.control-group {
    margin-bottom: 20px;
}

.control-group label {
    display: block;
    font-weight: 600;
    margin-bottom: 8px;
    color: #1e293b;
}

.control-group input[type="text"],
.control-group input[type="color"],
.control-group textarea,
.control-group select {
    width: 100%;
    padding: 8px;
    border: 1px solid #ddd;
    border-radius: 4px;
}

.control-group input[type="color"] {
    height: 40px;
    cursor: pointer;
}

.control-group input[type="checkbox"] {
    margin-right: 8px;
}

.builder-preview {
    background: #fff;
    padding: 20px;
    border: 1px solid #ddd;
    border-radius: 4px;
}

.builder-preview h3 {
    margin-top: 0;
    font-size: 16px;
    border-bottom: 1px solid #ddd;
    padding-bottom: 10px;
}

.preview-container {
    margin-top: 15px;
}

@media (max-width: 1200px) {
    .builder-layout {
        grid-template-columns: 1fr;
    }
}
</style>

<script>
jQuery(document).ready(function($) {
    // WordPress Media Uploader for Header Logo
    var mediaUploader;
    
    $('#upload_logo_button').on('click', function(e) {
        e.preventDefault();
        
        if (mediaUploader) {
            mediaUploader.open();
            return;
        }
        
        mediaUploader = wp.media({
            title: '<?php echo esc_js(__('Choose Logo', 'ticketpaygo-lite')); ?>',
            button: { text: '<?php echo esc_js(__('Use this logo', 'ticketpaygo-lite')); ?>' },
            multiple: false,
            library: { type: 'image' }
        });
        
        mediaUploader.on('select', function() {
            var attachment = mediaUploader.state().get('selection').first().toJSON();
            $('#header_logo').val(attachment.url);
            $('#logo_preview img').attr('src', attachment.url);
            $('#logo_preview').show();
            $('#remove_logo_button').show();
            updatePreview();
        });
        
        mediaUploader.open();
    });
    
    $('#remove_logo_button').on('click', function(e) {
        e.preventDefault();
        $('#header_logo').val('');
        $('#logo_preview').hide();
        $('#remove_logo_button').hide();
        updatePreview();
    });
    
    // Ticket Logo Upload
    var ticketLogoUploader;
    
    $('#upload_ticket_logo_button').on('click', function(e) {
        e.preventDefault();
        
        if (ticketLogoUploader) {
            ticketLogoUploader.open();
            return;
        }
        
        ticketLogoUploader = wp.media({
            title: '<?php echo esc_js(__('Choose Ticket Logo', 'ticketpaygo-lite')); ?>',
            button: { text: '<?php echo esc_js(__('Use this logo', 'ticketpaygo-lite')); ?>' },
            multiple: false,
            library: { type: 'image' }
        });
        
        ticketLogoUploader.on('select', function() {
            var attachment = ticketLogoUploader.state().get('selection').first().toJSON();
            $('#ticket_logo').val(attachment.url);
            $('#ticket_logo_preview img').attr('src', attachment.url);
            $('#ticket_logo_preview').show();
            $('#remove_ticket_logo_button').show();
            updatePreview();
        });
        
        ticketLogoUploader.open();
    });
    
    $('#remove_ticket_logo_button').on('click', function(e) {
        e.preventDefault();
        $('#ticket_logo').val('');
        $('#ticket_logo_preview').hide();
        $('#remove_ticket_logo_button').hide();
        updatePreview();
    });
    
    // Update preview when colors change
    $('#header_bg_color, #header_text_color, #accent_color').on('change input', function() {
        updatePreview();
    });
    
    // Update preview button
    $('#update_preview').on('click', function() {
        updatePreview();
    });
    
    // Generate ticket preview HTML (Lite version - no QR code)
    function generateTicketPreview(logoUrl) {
        var defaultLogo = '<?php echo esc_url(TPGL_PLUGIN_URL . 'assets/images/ticketpaygo_logo.svg'); ?>';
        var displayLogo = logoUrl || defaultLogo;
        
        return `
        <div style="position: relative; max-width: 375px; margin: 0 auto;">
            <svg width="100%" viewBox="0 0 150 253" xmlns="http://www.w3.org/2000/svg" style="display: block;">
                <g transform="matrix(1,0,0,1,-63.0682,-38.8952)">
                    <g transform="matrix(1.07734,0,0,1.26331,-447.382,-565.737)">
                        <path d="M474.269,509.89L474.269,484.608C474.269,481.516 476.774,479.006 479.861,479.006L606.33,479.006C609.417,479.006 611.922,481.516 611.922,484.608L611.922,509.89C608.314,509.89 605.384,512.825 605.384,516.44C605.384,520.055 608.314,522.99 611.922,522.99L611.922,672.348C611.922,675.44 609.417,677.95 606.33,677.95L479.861,677.95C476.774,677.95 474.269,675.44 474.269,672.348L474.269,522.99C477.877,522.99 480.807,520.055 480.807,516.44C480.807,512.825 477.877,509.89 474.269,509.89Z" style="fill:white;stroke:rgb(121,121,121);stroke-width:0.85px;"/>
                    </g>
                    <g transform="matrix(1.0582,0,0,1.0582,-623.691,-445.903)">
                        <path d="M659.29,503.059L778.672,503.123" style="fill:none;stroke:rgb(128,128,128);stroke-opacity:0.24;stroke-width:0.95px;"/>
                    </g>
                </g>
                
                <image href="${displayLogo}" x="25" y="15" width="100" height="30" preserveAspectRatio="xMidYMid meet"/>
                
                <text x="20" y="65" font-family="Arial" font-size="5" fill="#64748b">Event:</text>
                <text x="20" y="72" font-family="Arial" font-size="7" font-weight="bold" fill="#1e293b">Sample Event</text>
                
                <text x="85" y="65" font-family="Arial" font-size="5" fill="#64748b">Date:</text>
                <text x="85" y="72" font-family="Arial" font-size="7" font-weight="bold" fill="#1e293b">Dec 25, 2024</text>
                
                <text x="20" y="88" font-family="Arial" font-size="5" fill="#64748b">Time:</text>
                <text x="20" y="95" font-family="Arial" font-size="6" font-weight="600" fill="#1e293b">13:00 - 17:00</text>
                
                <text x="85" y="88" font-family="Arial" font-size="5" fill="#64748b">Type:</text>
                <text x="85" y="95" font-family="Arial" font-size="6" font-weight="600" fill="#1e293b">General</text>
                
                <!-- Lite version: No QR Code - Show ticket number instead -->
                <rect x="25" y="110" width="100" height="80" fill="#f8fafc" stroke="#e2e8f0" stroke-width="1" rx="4"/>
                <text x="75" y="145" font-family="Arial" font-size="6" fill="#64748b" text-anchor="middle">Ticket Number</text>
                <text x="75" y="160" font-family="Arial" font-size="8" font-weight="bold" fill="#1e293b" text-anchor="middle">TPG-12345</text>
                <text x="75" y="175" font-family="Arial" font-size="5" fill="#94a3b8" text-anchor="middle">Present at entrance</text>
                
                <text x="75" y="205" font-family="Arial" font-size="5" fill="#64748b" text-anchor="middle">Order ID: TPG34230000110</text>
            </svg>
        </div>`;
    }
    
    // Update preview iframe
    function updatePreview() {
        var headerBg = $('#header_bg_color').val();
        var headerText = $('#header_text').val();
        var headerTextColor = $('#header_text_color').val();
        var headerSubtitle = $('#header_subtitle').val();
        var greetingPrefix = $('#greeting_prefix').val() || 'Dear';
        var greetingText = $('#greeting_text').val();
        var showEventDetails = $('#show_event_details').is(':checked');
        var showCalendarButtons = $('#show_calendar_buttons').is(':checked');
        var footerText = $('#footer_text').val().replace(/\n/g, '<br>');
        var accentColor = $('#accent_color').val();
        var logoUrl = $('#header_logo').val();
        var logoPosition = $('#logo_position').val() || 'left';
        var ticketLogoUrl = $('#ticket_logo').val();
        
        var ticketPreviewHtml = generateTicketPreview(ticketLogoUrl);
        
        var template = `<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>${headerText}</title>
</head>
<body style="margin: 0; padding: 0; font-family: Arial, sans-serif; background-color: #f4f4f4;">
    <table width="100%" cellpadding="0" cellspacing="0" style="background-color: #f4f4f4; padding: 20px 0;">
        <tr>
            <td align="center">
                <table width="600" cellpadding="0" cellspacing="0" style="background-color: #ffffff; border-radius: 8px; overflow: hidden; box-shadow: 0 2px 8px rgba(0,0,0,0.1);">
                    <tr>
                        <td style="background: ${headerBg}; padding: 40px 30px;">`;
        
        // Add logo based on position
        if (logoUrl) {
            if (logoPosition === 'center') {
                template += `
                            <div style="text-align: center; margin-bottom: 20px;">
                                <img src="${logoUrl}" alt="Logo" style="max-width: 200px; max-height: 80px; display: inline-block;" />
                            </div>
                            <h1 style="margin: 0; color: ${headerTextColor}; font-size: 28px; font-weight: bold; text-align: center;">${headerText}</h1>
                            <p style="margin: 10px 0 0 0; color: ${headerTextColor}; font-size: 16px; opacity: 0.9; text-align: center;">${headerSubtitle}</p>`;
            } else {
                var logoAlign = logoPosition === 'right' ? 'right' : 'left';
                var textAlign = logoPosition === 'right' ? 'left' : 'right';
                template += `
                            <table width="100%" cellpadding="0" cellspacing="0">
                                <tr>
                                    <td style="text-align: ${logoAlign}; vertical-align: middle; width: 40%;">
                                        <img src="${logoUrl}" alt="Logo" style="max-width: 150px; max-height: 60px; display: block;" />
                                    </td>
                                    <td style="text-align: ${textAlign}; vertical-align: middle; width: 60%;">
                                        <h1 style="margin: 0; color: ${headerTextColor}; font-size: 28px; font-weight: bold;">${headerText}</h1>
                                        <p style="margin: 10px 0 0 0; color: ${headerTextColor}; font-size: 16px; opacity: 0.9;">${headerSubtitle}</p>
                                    </td>
                                </tr>
                            </table>`;
            }
        } else {
            template += `
                            <h1 style="margin: 0; color: ${headerTextColor}; font-size: 28px; font-weight: bold; text-align: center;">${headerText}</h1>
                            <p style="margin: 10px 0 0 0; color: ${headerTextColor}; font-size: 16px; opacity: 0.9; text-align: center;">${headerSubtitle}</p>`;
        }
        
        template += `
                        </td>
                    </tr>
                    <tr>
                        <td style="padding: 40px 30px;">
                            <p style="margin: 0 0 20px 0; color: #333333; font-size: 16px; line-height: 1.6;">
                                ${greetingPrefix} <strong>John Doe</strong>,
                            </p>
                            <p style="margin: 0 0 30px 0; color: #666666; font-size: 15px; line-height: 1.6;">
                                ${greetingText}
                            </p>`;
        
        if (showEventDetails) {
            template += `
                            <table width="100%" cellpadding="0" cellspacing="0" style="background-color: #f8fafc; border-radius: 8px; border: 2px solid #e2e8f0; margin-bottom: 30px;">
                                <tr>
                                    <td style="padding: 25px;">
                                        <h2 style="margin: 0 0 20px 0; color: #1e293b; font-size: 20px; font-weight: bold;">Event Details</h2>
                                        <table width="100%" cellpadding="8" cellspacing="0">
                                            <tr>
                                                <td style="color: #64748b; font-size: 14px; font-weight: 600; width: 120px;">Event:</td>
                                                <td style="color: #1e293b; font-size: 14px; font-weight: bold;">Sample Event</td>
                                            </tr>
                                            <tr>
                                                <td style="color: #64748b; font-size: 14px; font-weight: 600;">Date:</td>
                                                <td style="color: #1e293b; font-size: 14px;">December 25, 2024</td>
                                            </tr>
                                            <tr>
                                                <td style="color: #64748b; font-size: 14px; font-weight: 600;">Time:</td>
                                                <td style="color: #1e293b; font-size: 14px;">13:00 - 17:00</td>
                                            </tr>
                                            <tr>
                                                <td style="color: #64748b; font-size: 14px; font-weight: 600;">Location:</td>
                                                <td style="color: #1e293b; font-size: 14px;">Sample Venue, City</td>
                                            </tr>
                                            <tr>
                                                <td style="color: #64748b; font-size: 14px; font-weight: 600;">Total:</td>
                                                <td style="color: ${accentColor}; font-size: 18px; font-weight: bold;">€50.00</td>
                                            </tr>
                                        </table>
                                    </td>
                                </tr>
                            </table>`;
        }
        
        // Ticket section (Lite version - no QR code)
        template += `
                            <table width="100%" cellpadding="0" cellspacing="0" style="margin-bottom: 30px;">
                                <tr>
                                    <td align="center" style="padding: 20px; background-color: #f8fafc; border-radius: 8px;">
                                        <p style="margin: 0 0 15px 0; color: #1e293b; font-size: 16px; font-weight: 600;">Your Ticket</p>
                                        ${ticketPreviewHtml}
                                        <p style="margin: 15px 0 0 0; color: #64748b; font-size: 13px;">Present this ticket at the event entrance</p>
                                    </td>
                                </tr>
                            </table>`;
        
        if (showCalendarButtons) {
            template += `
                            <table width="100%" cellpadding="0" cellspacing="0" style="margin: 20px 0;">
                                <tr>
                                    <td align="center">
                                        <p style="margin: 0 0 15px 0; color: #1e293b; font-size: 14px; font-weight: 600;">Add to Calendar</p>
                                        <div style="display: inline-block;">
                                            <a href="#" style="display: inline-block; padding: 8px 16px; background: #4285f4; color: #fff; text-decoration: none; border-radius: 4px; margin: 0 5px; font-size: 12px;">Google</a>
                                            <a href="#" style="display: inline-block; padding: 8px 16px; background: #333; color: #fff; text-decoration: none; border-radius: 4px; margin: 0 5px; font-size: 12px;">Apple</a>
                                            <a href="#" style="display: inline-block; padding: 8px 16px; background: #0078d4; color: #fff; text-decoration: none; border-radius: 4px; margin: 0 5px; font-size: 12px;">Outlook</a>
                                        </div>
                                    </td>
                                </tr>
                            </table>`;
        }
        
        template += `
                            <p style="margin: 20px 0; color: #666666; font-size: 15px; line-height: 1.6;">
                                If you have any questions, please don't hesitate to contact us.
                            </p>
                        </td>
                    </tr>
                    <tr>
                        <td style="background-color: #f8fafc; padding: 30px; text-align: center; border-top: 1px solid #e2e8f0;">
                            <p style="margin: 0 0 10px 0; color: #64748b; font-size: 14px;">
                                ${footerText}
                            </p>
                            <p style="margin: 10px 0 0 0; color: #94a3b8; font-size: 12px;">
                                This is an automated email. Please do not reply to this message.
                            </p>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>
</body>
</html>`;
        
        var iframe = document.getElementById('email-preview');
        var iframeDoc = iframe.contentDocument || iframe.contentWindow.document;
        iframeDoc.open();
        iframeDoc.write(template);
        iframeDoc.close();
    }
    
    // Initial preview
    updatePreview();
});
</script>
