<?php
/**
 * Admin Dashboard Page (Lite Version)
 * Simplified dashboard without advanced analytics
 * 
 * phpcs:disable PluginCheck.Security.DirectDB.UnescapedDBParameter
 */

if (!defined('ABSPATH')) {
    exit;
}

// Verify user capabilities
if (!current_user_can('manage_options')) {
    wp_die(esc_html__('You do not have sufficient permissions to access this page.', 'ticketpaygo-lite'));
}

function tpgl_render_dashboard_page() {
    global $wpdb;
    $tpgl_events_table = $wpdb->prefix . 'ticketpaygo_lite_events';
    $tpgl_orders_table = $wpdb->prefix . 'ticketpaygo_lite_orders';
    $tpgl_tickets_table = $wpdb->prefix . 'ticketpaygo_lite_tickets';

    $tpgl_total_events = $wpdb->get_var($wpdb->prepare("SELECT COUNT(*) FROM {$tpgl_events_table} WHERE status = %s", 'active')); // phpcs:ignore WordPress.DB.DirectDatabaseQuery,WordPress.DB.PreparedSQL.InterpolatedNotPrepared
    $tpgl_total_orders = $wpdb->get_var($wpdb->prepare("SELECT COUNT(*) FROM {$tpgl_orders_table} WHERE status = %s", 'completed')); // phpcs:ignore WordPress.DB.DirectDatabaseQuery,WordPress.DB.PreparedSQL.InterpolatedNotPrepared
    $tpgl_total_revenue = $wpdb->get_var($wpdb->prepare("SELECT SUM(total_amount) FROM {$tpgl_orders_table} WHERE status = %s", 'completed')); // phpcs:ignore WordPress.DB.DirectDatabaseQuery,WordPress.DB.PreparedSQL.InterpolatedNotPrepared
    $tpgl_total_tickets = $wpdb->get_var($wpdb->prepare("SELECT COUNT(*) FROM {$tpgl_tickets_table} WHERE status = %s", 'active')); // phpcs:ignore WordPress.DB.DirectDatabaseQuery,WordPress.DB.PreparedSQL.InterpolatedNotPrepared

    $tpgl_currency_symbol = TicketPayGo_Database::get_setting('currency_symbol', '€');

    // phpcs:disable WordPress.DB.PreparedSQL.InterpolatedNotPrepared,WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching
    $tpgl_recent_orders = $wpdb->get_results(
        $wpdb->prepare(
            "SELECT o.*, e.title as event_title 
             FROM {$tpgl_orders_table} o
             LEFT JOIN {$tpgl_events_table} e ON o.event_id = e.id
             ORDER BY o.created_at DESC 
             LIMIT %d",
            5
        ),
        ARRAY_A
    );
    // phpcs:enable WordPress.DB.PreparedSQL.InterpolatedNotPrepared,WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching

    // phpcs:disable WordPress.DB.PreparedSQL.InterpolatedNotPrepared,WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching
    $tpgl_upcoming_events = $wpdb->get_results($wpdb->prepare(
        "SELECT * FROM {$tpgl_events_table}
         WHERE status = %s AND DATE(start_date) >= CURDATE() 
         ORDER BY start_date ASC 
         LIMIT 5",
        'active'
    ), ARRAY_A);
    // phpcs:enable WordPress.DB.PreparedSQL.InterpolatedNotPrepared,WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching

?>

<div class="wrap ticketpaygo-lite-dashboard">
    <!-- Dashboard Header with Logo -->
    <div class="tpgl-header-card">
        <div class="tpgl-header-content">
            <div class="tpgl-branding">
                <div class="tpgl-logo-wrapper">
                    <img src="<?php echo esc_url(TPGL_PLUGIN_URL . 'assets/images/ticketpaygo_logo.svg'); ?>" alt="TicketPayGo" class="tpgl-logo">
                    <span class="tpgl-lite-badge"><?php esc_html_e('Lite', 'ticketpaygo-lite'); ?></span>
                </div>
                <p class="tpgl-tagline"><?php esc_html_e('Simple event ticketing for WordPress', 'ticketpaygo-lite'); ?></p>
            </div>
            <div class="tpgl-header-actions" style="display: flex; gap: 12px; align-items: center;">
                <a href="https://ticketpaygo.upkyk.com/docs" target="_blank" class="tpgl-docs-button" style="display: inline-flex; align-items: center; gap: 8px; padding: 10px 18px; background: #fff; border: 2px solid #e5e7eb; border-radius: 8px; color: #1f2937; font-weight: 600; text-decoration: none; transition: all 0.2s;">
                    <span class="dashicons dashicons-book-alt" style="font-size: 20px; width: 20px; height: 20px; color: #1f2937;"></span>
                    <span><?php esc_html_e('Documentation', 'ticketpaygo-lite'); ?></span>
                </a>
                <div class="tpgl-version-badge">
                    <div class="tpgl-version-number">v<?php echo esc_html(TPGL_VERSION); ?></div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Statistics Cards - Premium Design -->
    <div class="tpgl-stats-grid">
        <div class="tpgl-stat-card">
            <div class="tpgl-stat-icon tpgl-stat-icon-primary">
                <span class="dashicons dashicons-calendar-alt"></span>
            </div>
            <div class="tpgl-stat-content">
                <h3><?php echo esc_html(number_format($tpgl_total_events ?: 0)); ?></h3>
                <p><?php esc_html_e('Active Events', 'ticketpaygo-lite'); ?></p>
            </div>
        </div>
        
        <div class="tpgl-stat-card">
            <div class="tpgl-stat-icon tpgl-stat-icon-success">
                <span class="dashicons dashicons-tickets-alt"></span>
            </div>
            <div class="tpgl-stat-content">
                <h3><?php echo esc_html(number_format($tpgl_total_tickets ?: 0)); ?></h3>
                <p><?php esc_html_e('Tickets Sold', 'ticketpaygo-lite'); ?></p>
            </div>
        </div>
        
        <div class="tpgl-stat-card">
            <div class="tpgl-stat-icon tpgl-stat-icon-warning">
                <span class="dashicons dashicons-money-alt"></span>
            </div>
            <div class="tpgl-stat-content">
                <h3><?php echo esc_html($tpgl_currency_symbol . number_format($tpgl_total_revenue ?: 0, 2)); ?></h3>
                <p><?php esc_html_e('Total Revenue', 'ticketpaygo-lite'); ?></p>
            </div>
        </div>
        
        <div class="tpgl-stat-card">
            <div class="tpgl-stat-icon tpgl-stat-icon-info">
                <span class="dashicons dashicons-chart-bar"></span>
            </div>
            <div class="tpgl-stat-content">
                <h3><?php echo esc_html(number_format($tpgl_total_orders ?: 0)); ?></h3>
                <p><?php esc_html_e('Total Orders', 'ticketpaygo-lite'); ?></p>
            </div>
        </div>
    </div>
    
    <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 30px;">
        
        <!-- Quick Actions -->
        <div class="card" style="padding: 20px;">
            <h2 style="margin-top: 0;"><?php esc_html_e('Quick Actions', 'ticketpaygo-lite'); ?></h2>
            <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 15px;">
                <a href="<?php echo esc_url(admin_url('admin.php?page=ticketpaygo-lite-events&action=add')); ?>" class="button button-primary button-large" style="display: inline-flex; align-items: center; justify-content: center; padding: 15px; border-radius: 10px; background: linear-gradient(135deg, #0A4974 0%, #42963B 100%) !important; color: white !important; border: none !important;">
                    <span class="dashicons dashicons-plus-alt" style="margin-right: 8px; line-height: 1;"></span>
                    <?php esc_html_e('Add New Event', 'ticketpaygo-lite'); ?>
                </a>
                
                <a href="<?php echo esc_url(admin_url('admin.php?page=ticketpaygo-lite-orders')); ?>" class="button button-large" style="display: inline-flex; align-items: center; justify-content: center; padding: 15px; border-radius: 10px; border: 2px solid #0A4974; color: #0A4974;">
                    <span class="dashicons dashicons-list-view" style="margin-right: 8px; line-height: 1;"></span>
                    <?php esc_html_e('View Orders', 'ticketpaygo-lite'); ?>
                </a>
                
                <a href="<?php echo esc_url(admin_url('admin.php?page=ticketpaygo-lite-checkin')); ?>" class="button button-large" style="display: inline-flex; align-items: center; justify-content: center; padding: 15px; border-radius: 10px; border: 2px solid #0A4974; color: #0A4974;">
                    <span class="dashicons dashicons-yes-alt" style="margin-right: 8px; line-height: 1;"></span>
                    <?php esc_html_e('Check-in', 'ticketpaygo-lite'); ?>
                </a>
                
                <a href="<?php echo esc_url(admin_url('admin.php?page=ticketpaygo-lite-settings')); ?>" class="button button-large" style="display: inline-flex; align-items: center; justify-content: center; padding: 15px; border-radius: 10px; border: 2px solid #0A4974; color: #0A4974;">
                    <span class="dashicons dashicons-admin-settings" style="margin-right: 8px; line-height: 1;"></span>
                    <?php esc_html_e('Settings', 'ticketpaygo-lite'); ?>
                </a>
            </div>
        </div>
        
        <!-- Upcoming Events -->
        <div class="card" style="padding: 20px;">
            <h2 style="margin-top: 0;"><?php esc_html_e('Upcoming Events', 'ticketpaygo-lite'); ?></h2>
            <?php if (!empty($tpgl_upcoming_events)): ?>
                <table class="wp-list-table widefat fixed striped">
                    <thead>
                        <tr>
                            <th><?php esc_html_e('Event', 'ticketpaygo-lite'); ?></th>
                            <th><?php esc_html_e('Date', 'ticketpaygo-lite'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($tpgl_upcoming_events as $tpgl_event): ?>
                            <tr>
                                <td>
                                    <a href="<?php echo esc_url(admin_url('admin.php?page=ticketpaygo-lite-events&action=edit&id=' . $tpgl_event['id'])); ?>">
                                        <?php echo esc_html($tpgl_event['title']); ?>
                                    </a>
                                </td>
                                <td><?php echo esc_html(date_i18n(get_option('date_format'), strtotime($tpgl_event['start_date']))); ?></td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            <?php else: ?>
                <p style="color: #666;"><?php esc_html_e('No upcoming events. Create your first event!', 'ticketpaygo-lite'); ?></p>
                <a href="<?php echo esc_url(admin_url('admin.php?page=ticketpaygo-lite-events&action=add')); ?>" class="button button-primary" style="background: linear-gradient(135deg, #0A4974 0%, #42963B 100%) !important; color: white !important; border: none !important;">
                    <?php esc_html_e('Create Event', 'ticketpaygo-lite'); ?>
                </a>
            <?php endif; ?>
        </div>
        
    </div>
    
    <!-- Recent Orders - Full Width Expanded Table -->
    <div class="card" style="padding: 25px; margin-top: 30px; max-width: none !important; width: 100% !important;">
        <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px;">
            <h2 style="margin: 0;"><?php esc_html_e('Recent Orders', 'ticketpaygo-lite'); ?></h2>
            <a href="<?php echo esc_url(admin_url('admin.php?page=ticketpaygo-lite-orders')); ?>" class="button">
                <?php esc_html_e('View All Orders', 'ticketpaygo-lite'); ?> →
            </a>
        </div>
        <?php if (!empty($tpgl_recent_orders)): ?>
            <div style="width: 100%;">
                <table class="wp-list-table widefat striped" style="width: 100%; table-layout: auto;">
                    <thead>
                        <tr>
                            <th style="white-space: nowrap;"><?php esc_html_e('Order #', 'ticketpaygo-lite'); ?></th>
                            <th><?php esc_html_e('Customer', 'ticketpaygo-lite'); ?></th>
                            <th><?php esc_html_e('Email', 'ticketpaygo-lite'); ?></th>
                            <th><?php esc_html_e('Event', 'ticketpaygo-lite'); ?></th>
                            <th style="text-align: center; white-space: nowrap;"><?php esc_html_e('Qty', 'ticketpaygo-lite'); ?></th>
                            <th style="text-align: right; white-space: nowrap;"><?php esc_html_e('Amount', 'ticketpaygo-lite'); ?></th>
                            <th style="white-space: nowrap;"><?php esc_html_e('Payment', 'ticketpaygo-lite'); ?></th>
                            <th style="white-space: nowrap;"><?php esc_html_e('Status', 'ticketpaygo-lite'); ?></th>
                            <th style="white-space: nowrap;"><?php esc_html_e('Date', 'ticketpaygo-lite'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($tpgl_recent_orders as $tpgl_order): ?>
                            <tr>
                                <td>
                                    <a href="<?php echo esc_url(admin_url('admin.php?page=ticketpaygo-lite-orders&action=view&id=' . $tpgl_order['id'])); ?>" style="font-family: monospace; font-weight: 600; color: #0A4974;">
                                        <?php echo esc_html($tpgl_order['order_number']); ?>
                                    </a>
                                </td>
                                <td style="font-weight: 500;"><?php echo esc_html($tpgl_order['customer_name']); ?></td>
                                <td style="color: #666;">
                                    <a href="mailto:<?php echo esc_attr($tpgl_order['customer_email']); ?>" style="color: #666; text-decoration: none;">
                                        <?php echo esc_html($tpgl_order['customer_email']); ?>
                                    </a>
                                </td>
                                <td><?php echo esc_html($tpgl_order['event_title']); ?></td>
                                <td style="text-align: center; font-weight: 600;"><?php echo esc_html($tpgl_order['quantity']); ?></td>
                                <td style="text-align: right; font-weight: 600; color: #0A4974;"><?php echo esc_html($tpgl_currency_symbol . number_format($tpgl_order['total_amount'], 2)); ?></td>
                                <td>
                                    <span style="display: inline-block; padding: 3px 8px; border-radius: 4px; font-size: 11px; text-transform: uppercase; background: #f0f0f1; color: #50575e;">
                                        <?php echo esc_html(ucfirst($tpgl_order['payment_method'] ?: 'N/A')); ?>
                                    </span>
                                </td>
                                <td>
                                    <span class="status-badge status-<?php echo esc_attr($tpgl_order['status']); ?>">
                                        <?php echo esc_html(ucfirst($tpgl_order['status'])); ?>
                                    </span>
                                </td>
                                <td style="color: #666; font-size: 13px;"><?php echo esc_html(date_i18n('M j, Y g:i a', strtotime($tpgl_order['created_at']))); ?></td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
            <p style="margin-top: 15px;">
                <a href="<?php echo esc_url(admin_url('admin.php?page=ticketpaygo-lite-orders')); ?>" class="button">
                    <?php esc_html_e('View All Orders', 'ticketpaygo-lite'); ?>
                </a>
            </p>
        <?php else: ?>
            <p style="color: #666;"><?php esc_html_e('No orders yet.', 'ticketpaygo-lite'); ?></p>
        <?php endif; ?>
    </div>
    
</div>

<?php
}
tpgl_render_dashboard_page();
?>