<?php
/**
 * Customization Settings Page (Lite Version)
 * Basic customization for Event Cards, Modal, and Calendar
 * 
 * phpcs:disable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
 */

if (!defined('ABSPATH')) {
    exit;
}

// Handle form submission
if (isset($_POST['save_customization']) && isset($_POST['tpgl_customization_nonce'])) {
    if (wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['tpgl_customization_nonce'])), 'tpgl_customization_action')) {
        // Card customization
        TicketPayGo_Database::update_setting('card_primary_color', isset($_POST['card_primary_color']) ? sanitize_hex_color(wp_unslash($_POST['card_primary_color'])) : '#3b82f6');
        TicketPayGo_Database::update_setting('card_button_color', isset($_POST['card_button_color']) ? sanitize_hex_color(wp_unslash($_POST['card_button_color'])) : '#42963B');
        TicketPayGo_Database::update_setting('card_button_text_color', isset($_POST['card_button_text_color']) ? sanitize_hex_color(wp_unslash($_POST['card_button_text_color'])) : '#ffffff');
        TicketPayGo_Database::update_setting('card_text_color', isset($_POST['card_text_color']) ? sanitize_hex_color(wp_unslash($_POST['card_text_color'])) : '#333333');
        TicketPayGo_Database::update_setting('card_border_radius', isset($_POST['card_border_radius']) ? intval($_POST['card_border_radius']) : 16);
        
        // Modal customization
        TicketPayGo_Database::update_setting('modal_header_background', isset($_POST['modal_header_background']) ? sanitize_hex_color(wp_unslash($_POST['modal_header_background'])) : '#3b82f6');
        TicketPayGo_Database::update_setting('modal_body_background', isset($_POST['modal_body_background']) ? sanitize_hex_color(wp_unslash($_POST['modal_body_background'])) : '#ffffff');
        TicketPayGo_Database::update_setting('modal_text_color', isset($_POST['modal_text_color']) ? sanitize_hex_color(wp_unslash($_POST['modal_text_color'])) : '#1e293b');
        TicketPayGo_Database::update_setting('modal_button_color', isset($_POST['modal_button_color']) ? sanitize_hex_color(wp_unslash($_POST['modal_button_color'])) : '#3b82f6');
        
        // Calendar customization
        TicketPayGo_Database::update_setting('calendar_primary_color', isset($_POST['calendar_primary_color']) ? sanitize_hex_color(wp_unslash($_POST['calendar_primary_color'])) : '#3b82f6');
        TicketPayGo_Database::update_setting('calendar_event_bg', isset($_POST['calendar_event_bg']) ? sanitize_hex_color(wp_unslash($_POST['calendar_event_bg'])) : '#3b82f6');
        TicketPayGo_Database::update_setting('calendar_event_text', isset($_POST['calendar_event_text']) ? sanitize_hex_color(wp_unslash($_POST['calendar_event_text'])) : '#ffffff');
        
        echo '<div class="notice notice-success"><p>' . esc_html__('Customization settings saved!', 'ticketpaygo-lite') . '</p></div>';
    }
}

// Get current settings with defaults
$settings = array(
    // Card settings
    'card_primary_color' => TicketPayGo_Database::get_setting('card_primary_color', '#3b82f6'),
    'card_button_color' => TicketPayGo_Database::get_setting('card_button_color', '#42963B'),
    'card_button_text_color' => TicketPayGo_Database::get_setting('card_button_text_color', '#ffffff'),
    'card_text_color' => TicketPayGo_Database::get_setting('card_text_color', '#333333'),
    'card_border_radius' => TicketPayGo_Database::get_setting('card_border_radius', '16'),
    // Modal settings
    'modal_header_background' => TicketPayGo_Database::get_setting('modal_header_background', '#3b82f6'),
    'modal_body_background' => TicketPayGo_Database::get_setting('modal_body_background', '#ffffff'),
    'modal_text_color' => TicketPayGo_Database::get_setting('modal_text_color', '#1e293b'),
    'modal_button_color' => TicketPayGo_Database::get_setting('modal_button_color', '#3b82f6'),
    // Calendar settings
    'calendar_primary_color' => TicketPayGo_Database::get_setting('calendar_primary_color', '#3b82f6'),
    'calendar_event_bg' => TicketPayGo_Database::get_setting('calendar_event_bg', '#3b82f6'),
    'calendar_event_text' => TicketPayGo_Database::get_setting('calendar_event_text', '#ffffff'),
);
?>

<div class="ticketpaygo-customization">
    <p class="description" style="font-size: 14px; margin-bottom: 20px;">
        <?php esc_html_e('Customize the appearance of your event cards, booking modal, and calendar. These are global settings that apply to all events.', 'ticketpaygo-lite'); ?>
        <br><small style="color: #666;"><?php esc_html_e('Upgrade to the full plugin for advanced customization options including fonts, layouts, and per-event styling.', 'ticketpaygo-lite'); ?></small>
    </p>
    
    <div class="customization-container">
        <div class="customization-form">
            <form method="post" action="">
                <?php wp_nonce_field('tpgl_customization_action', 'tpgl_customization_nonce'); ?>
                
                <!-- Event Card Customization -->
                <div class="section-group">
                    <h2><?php esc_html_e('Event Card Appearance', 'ticketpaygo-lite'); ?></h2>
                    
                    <table class="form-table">
                        <tr>
                            <th><label for="card_primary_color"><?php esc_html_e('Primary Color', 'ticketpaygo-lite'); ?></label></th>
                            <td>
                                <input type="color" id="card_primary_color" name="card_primary_color" value="<?php echo esc_attr($settings['card_primary_color']); ?>" />
                                <p class="description"><?php esc_html_e('Used for card headers and accents', 'ticketpaygo-lite'); ?></p>
                            </td>
                        </tr>
                        <tr>
                            <th><label for="card_button_color"><?php esc_html_e('Button Background', 'ticketpaygo-lite'); ?></label></th>
                            <td>
                                <input type="color" id="card_button_color" name="card_button_color" value="<?php echo esc_attr($settings['card_button_color']); ?>" />
                                <p class="description"><?php esc_html_e('Background color for "Get Tickets" button', 'ticketpaygo-lite'); ?></p>
                            </td>
                        </tr>
                        <tr>
                            <th><label for="card_button_text_color"><?php esc_html_e('Button Text Color', 'ticketpaygo-lite'); ?></label></th>
                            <td>
                                <input type="color" id="card_button_text_color" name="card_button_text_color" value="<?php echo esc_attr($settings['card_button_text_color']); ?>" />
                            </td>
                        </tr>
                        <tr>
                            <th><label for="card_text_color"><?php esc_html_e('Text Color', 'ticketpaygo-lite'); ?></label></th>
                            <td>
                                <input type="color" id="card_text_color" name="card_text_color" value="<?php echo esc_attr($settings['card_text_color']); ?>" />
                            </td>
                        </tr>
                        <tr>
                            <th><label for="card_border_radius"><?php esc_html_e('Border Radius (px)', 'ticketpaygo-lite'); ?></label></th>
                            <td>
                                <input type="range" id="card_border_radius" name="card_border_radius" min="0" max="30" value="<?php echo esc_attr($settings['card_border_radius']); ?>" />
                                <span id="card_border_radius_value"><?php echo esc_html($settings['card_border_radius']); ?>px</span>
                            </td>
                        </tr>
                    </table>
                </div>
                
                <!-- Modal Customization -->
                <div class="section-group">
                    <h2><?php esc_html_e('Booking Modal Appearance', 'ticketpaygo-lite'); ?></h2>
                    
                    <table class="form-table">
                        <tr>
                            <th><label for="modal_header_background"><?php esc_html_e('Header Background', 'ticketpaygo-lite'); ?></label></th>
                            <td>
                                <input type="color" id="modal_header_background" name="modal_header_background" value="<?php echo esc_attr($settings['modal_header_background']); ?>" />
                                <p class="description"><?php esc_html_e('Background color for modal header (visible when no event image)', 'ticketpaygo-lite'); ?></p>
                            </td>
                        </tr>
                        <tr>
                            <th><label for="modal_body_background"><?php esc_html_e('Body Background', 'ticketpaygo-lite'); ?></label></th>
                            <td>
                                <input type="color" id="modal_body_background" name="modal_body_background" value="<?php echo esc_attr($settings['modal_body_background']); ?>" />
                            </td>
                        </tr>
                        <tr>
                            <th><label for="modal_text_color"><?php esc_html_e('Text Color', 'ticketpaygo-lite'); ?></label></th>
                            <td>
                                <input type="color" id="modal_text_color" name="modal_text_color" value="<?php echo esc_attr($settings['modal_text_color']); ?>" />
                            </td>
                        </tr>
                        <tr>
                            <th><label for="modal_button_color"><?php esc_html_e('Button Color', 'ticketpaygo-lite'); ?></label></th>
                            <td>
                                <input type="color" id="modal_button_color" name="modal_button_color" value="<?php echo esc_attr($settings['modal_button_color']); ?>" />
                            </td>
                        </tr>
                    </table>
                </div>
                
                <!-- Calendar Customization -->
                <div class="section-group">
                    <h2><?php esc_html_e('Calendar Appearance', 'ticketpaygo-lite'); ?></h2>
                    <p class="description"><?php esc_html_e('Customize the calendar view displayed via [ticketpaygo_calendar] shortcode.', 'ticketpaygo-lite'); ?></p>
                    
                    <table class="form-table">
                        <tr>
                            <th><label for="calendar_primary_color"><?php esc_html_e('Primary Color (Buttons)', 'ticketpaygo-lite'); ?></label></th>
                            <td>
                                <input type="color" id="calendar_primary_color" name="calendar_primary_color" value="<?php echo esc_attr($settings['calendar_primary_color']); ?>" />
                                <p class="description"><?php esc_html_e('Color for navigation buttons', 'ticketpaygo-lite'); ?></p>
                            </td>
                        </tr>
                        <tr>
                            <th><label for="calendar_event_bg"><?php esc_html_e('Event Background', 'ticketpaygo-lite'); ?></label></th>
                            <td>
                                <input type="color" id="calendar_event_bg" name="calendar_event_bg" value="<?php echo esc_attr($settings['calendar_event_bg']); ?>" />
                                <p class="description"><?php esc_html_e('Background color for event items', 'ticketpaygo-lite'); ?></p>
                            </td>
                        </tr>
                        <tr>
                            <th><label for="calendar_event_text"><?php esc_html_e('Event Text Color', 'ticketpaygo-lite'); ?></label></th>
                            <td>
                                <input type="color" id="calendar_event_text" name="calendar_event_text" value="<?php echo esc_attr($settings['calendar_event_text']); ?>" />
                            </td>
                        </tr>
                    </table>
                </div>
                
                <p class="submit">
                    <input type="submit" name="save_customization" class="button-primary" value="<?php esc_attr_e('Save Customization', 'ticketpaygo-lite'); ?>" style="background: linear-gradient(135deg, #0A4974 0%, #42963B 100%) !important; border: none !important;" />
                    <button type="button" id="reset_defaults" class="button"><?php esc_html_e('Reset to Defaults', 'ticketpaygo-lite'); ?></button>
                </p>
            </form>
        </div>
        
        <div class="preview-section">
            <h2><?php esc_html_e('Live Preview', 'ticketpaygo-lite'); ?></h2>
            <div class="preview-tabs">
                <button class="preview-tab active" data-tab="card"><?php esc_html_e('Card', 'ticketpaygo-lite'); ?></button>
                <button class="preview-tab" data-tab="modal"><?php esc_html_e('Modal', 'ticketpaygo-lite'); ?></button>
                <button class="preview-tab" data-tab="calendar"><?php esc_html_e('Calendar', 'ticketpaygo-lite'); ?></button>
            </div>
            <div id="card_preview" class="preview-content active"></div>
            <div id="modal_preview" class="preview-content" style="display: none;"></div>
            <div id="calendar_preview" class="preview-content" style="display: none;"></div>
            <p class="description" style="margin-top: 10px;">
                <?php esc_html_e('This preview shows how your event cards, modal, and calendar will appear on the frontend.', 'ticketpaygo-lite'); ?>
            </p>
        </div>
    </div>
</div>

<style>
.ticketpaygo-customization .customization-container {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 30px;
    margin-top: 20px;
}

.ticketpaygo-customization .customization-form {
    background: #fff;
    padding: 24px;
    border: 1px solid #e2e8f0;
    border-radius: 16px;
    box-shadow: 0 1px 3px rgba(0,0,0,0.05);
}

.ticketpaygo-customization .preview-section {
    background: #fff;
    padding: 24px;
    border: 1px solid #e2e8f0;
    border-radius: 16px;
    box-shadow: 0 1px 3px rgba(0,0,0,0.05);
    position: sticky;
    top: 32px;
    align-self: start;
}

.ticketpaygo-customization .preview-section h2 {
    margin: 0 0 20px 0;
    font-size: 18px;
    font-weight: 700;
    color: #1e293b;
}

.ticketpaygo-customization .section-group {
    margin-bottom: 30px;
    padding-bottom: 20px;
    border-bottom: 1px solid #f1f5f9;
}

.ticketpaygo-customization .section-group:last-of-type {
    border-bottom: none;
    margin-bottom: 0;
}

.ticketpaygo-customization .section-group h2 {
    margin-top: 0;
    padding-bottom: 10px;
    border-bottom: 2px solid #3b82f6;
    display: inline-block;
    font-size: 16px;
    font-weight: 700;
    color: #1e293b;
}

.ticketpaygo-customization input[type="color"] {
    width: 60px;
    height: 40px;
    padding: 2px;
    border: 1px solid #ddd;
    border-radius: 4px;
    cursor: pointer;
}

.ticketpaygo-customization input[type="range"] {
    width: 200px;
    vertical-align: middle;
}

.ticketpaygo-customization .preview-tabs {
    display: flex;
    gap: 8px;
    margin-bottom: 16px;
    border-bottom: 2px solid #e2e8f0;
}

.ticketpaygo-customization .preview-tab {
    padding: 10px 20px;
    background: none;
    border: none;
    border-bottom: 2px solid transparent;
    margin-bottom: -2px;
    cursor: pointer;
    font-weight: 600;
    color: #64748b;
    transition: all 0.2s;
}

.ticketpaygo-customization .preview-tab:hover {
    color: #3b82f6;
}

.ticketpaygo-customization .preview-tab.active {
    color: #3b82f6;
    border-bottom-color: #3b82f6;
}

.ticketpaygo-customization .preview-content {
    min-height: 300px;
    background: #f8fafc;
    border-radius: 12px;
    padding: 30px;
    display: flex;
    justify-content: center;
    align-items: center;
}

.ticketpaygo-customization #card_preview,
.ticketpaygo-customization #modal_preview {
    background: #f8fafc;
}

@media (max-width: 1200px) {
    .ticketpaygo-customization .customization-container {
        grid-template-columns: 1fr;
    }
    
    .ticketpaygo-customization .preview-section {
        position: static;
    }
}
</style>

<script>
jQuery(document).ready(function($) {
    // Render card preview
    function renderCardPreview() {
        var primaryColor = $('#card_primary_color').val() || '#3b82f6';
        var buttonColor = $('#card_button_color').val() || '#42963B';
        var buttonTextColor = $('#card_button_text_color').val() || '#ffffff';
        var textColor = $('#card_text_color').val() || '#333333';
        var borderRadius = $('#card_border_radius').val() || '16';
        
        var html = `
        <div style="background: #f8fafc; padding: 20px; border-radius: 12px; display: flex; justify-content: center; align-items: center;">
            <div style="max-width: 320px; width: 100%; border-radius: ${borderRadius}px; overflow: hidden; box-shadow: 0 12px 24px rgba(0,0,0,0.15); background: #fff;">
                <div style="height: 180px; background: linear-gradient(135deg, ${primaryColor} 0%, ${primaryColor}dd 100%); position: relative;">
                    <div style="position: absolute; bottom: 0; left: 0; right: 0; padding: 20px; background: linear-gradient(transparent, rgba(0,0,0,0.7));">
                        <h3 style="margin: 0; color: #fff; font-size: 20px; font-weight: 700;">Sample Event Title</h3>
                    </div>
                </div>
                <div style="padding: 16px 20px; color: ${textColor};">
                    <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 8px; margin-bottom: 16px; font-size: 13px;">
                        <span style="display: flex; align-items: center; gap: 6px;">📅 Dec 25, 2024</span>
                        <span style="display: flex; align-items: center; gap: 6px;">📍 Sample Venue</span>
                        <span style="display: flex; align-items: center; gap: 6px;">💰 €25.00</span>
                        <span style="display: flex; align-items: center; gap: 6px;">🎫 100 tickets</span>
                    </div>
                    <button style="width: 100%; padding: 12px 20px; border: none; border-radius: 8px; font-weight: 600; cursor: pointer; background: ${buttonColor}; color: ${buttonTextColor}; font-size: 14px;">
                        Book Tickets Now
                    </button>
                </div>
            </div>
        </div>`;
        
        $('#card_preview').html(html);
    }
    
    // Render modal preview
    function renderModalPreview() {
        var headerBg = $('#modal_header_background').val() || '#3b82f6';
        var bodyBg = $('#modal_body_background').val() || '#ffffff';
        var textColor = $('#modal_text_color').val() || '#1e293b';
        var buttonColor = $('#modal_button_color').val() || '#3b82f6';
        
        var html = `
        <div style="background: #f8fafc; padding: 20px; border-radius: 12px; display: flex; justify-content: center; align-items: center;">
            <div style="background: ${bodyBg}; border-radius: 16px; max-width: 400px; width: 100%; overflow: hidden; box-shadow: 0 20px 60px rgba(0,0,0,0.3);">
                <div style="height: 150px; background: linear-gradient(transparent, rgba(0,0,0,0.6)), ${headerBg}; display: flex; align-items: flex-end; padding: 16px;">
                    <h3 style="margin: 0; color: #fff; font-size: 20px; font-weight: 700;">Sample Event Title</h3>
                </div>
                <div style="padding: 20px; color: ${textColor};">
                    <div style="display: grid; grid-template-columns: repeat(4, 1fr); gap: 8px; padding: 12px; background: #f8fafc; border-radius: 8px; margin-bottom: 16px; text-align: center;">
                    <div style="display: flex; flex-direction: column; gap: 4px;">
                        <span style="font-size: 16px;">📅</span>
                        <span style="font-size: 10px; text-transform: uppercase; color: #64748b;">Date</span>
                        <span style="font-size: 12px; font-weight: 600;">Dec 25</span>
                    </div>
                    <div style="display: flex; flex-direction: column; gap: 4px;">
                        <span style="font-size: 16px;">📍</span>
                        <span style="font-size: 10px; text-transform: uppercase; color: #64748b;">Location</span>
                        <span style="font-size: 12px; font-weight: 600;">Venue</span>
                    </div>
                    <div style="display: flex; flex-direction: column; gap: 4px;">
                        <span style="font-size: 16px;">💰</span>
                        <span style="font-size: 10px; text-transform: uppercase; color: #64748b;">Price</span>
                        <span style="font-size: 12px; font-weight: 600;">€25.00</span>
                    </div>
                    <div style="display: flex; flex-direction: column; gap: 4px;">
                        <span style="font-size: 16px;">🎫</span>
                        <span style="font-size: 10px; text-transform: uppercase; color: #64748b;">Available</span>
                        <span style="font-size: 12px; font-weight: 600;">100</span>
                    </div>
                </div>
                <h4 style="margin: 0 0 8px 0; font-size: 16px;">About This Event</h4>
                <p style="margin: 0 0 16px 0; color: #64748b; font-size: 14px;">This is a sample event description showing how your modal will look.</p>
            </div>
            <div style="padding: 16px 20px; background: #f8fafc; border-top: 1px solid #e2e8f0;">
                <button style="width: 100%; padding: 12px; border: none; border-radius: 8px; font-weight: 600; cursor: pointer; background: ${buttonColor}; color: #fff;">
                    Book Tickets Now
                </button>
            </div>
            </div>
        </div>`;
        
        $('#modal_preview').html(html);
    }
    
    // Render calendar preview
    function renderCalendarPreview() {
        var primaryColor = $('#calendar_primary_color').val() || '#3b82f6';
        var eventBg = $('#calendar_event_bg').val() || '#3b82f6';
        var eventText = $('#calendar_event_text').val() || '#ffffff';
        
        var html = `
        <div style="background: #f8fafc; padding: 16px; border-radius: 12px; width: 100%; max-width: 500px;">
            <div style="background: #fff; border-radius: 8px; padding: 16px; border: 1px solid #e2e8f0;">
                <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 16px; padding-bottom: 12px; border-bottom: 2px solid #e2e8f0;">
                    <div style="display: flex; gap: 8px;">
                        <button style="background: ${primaryColor}; color: white; border: none; padding: 6px 12px; border-radius: 4px; font-size: 12px; font-weight: 600; cursor: pointer;">◀</button>
                        <button style="background: ${primaryColor}; color: white; border: none; padding: 6px 12px; border-radius: 4px; font-size: 12px; font-weight: 600; cursor: pointer;">▶</button>
                        <button style="background: ${primaryColor}; color: white; border: none; padding: 6px 12px; border-radius: 4px; font-size: 12px; font-weight: 600; cursor: pointer;">Today</button>
                    </div>
                    <h3 style="margin: 0; color: #1a1a2e; font-size: 16px; font-weight: 700;">July 2026</h3>
                    <div style="display: flex; gap: 4px;">
                        <button style="background: ${primaryColor}; color: white; border: none; padding: 6px 10px; border-radius: 4px; font-size: 11px; font-weight: 600; cursor: pointer;">Month</button>
                        <button style="background: transparent; color: ${primaryColor}; border: 1px solid #e2e8f0; padding: 6px 10px; border-radius: 4px; font-size: 11px; font-weight: 600; cursor: pointer;">List</button>
                    </div>
                </div>
                <div style="border: 1px solid #e2e8f0; border-radius: 6px; overflow: hidden;">
                    <div style="background: #fff; padding: 12px; border-bottom: 1px solid #e2e8f0;">
                        <div style="color: #1a1a2e; font-size: 13px; font-weight: 700;">July 10, 2026 <span style="float: right; font-weight: 600;">Friday</span></div>
                    </div>
                    <div style="background: ${eventBg}; padding: 10px 12px; border-bottom: 1px solid #e2e8f0;">
                        <div style="display: flex; justify-content: space-between; align-items: center;">
                            <span style="color: ${eventText}; opacity: 0.8; font-size: 12px; font-weight: 600; min-width: 100px;">10:00 - 12:00</span>
                            <span style="color: ${eventText}; font-size: 13px; font-weight: 600; flex: 1;">Yoga Workshop</span>
                        </div>
                    </div>
                    <div style="background: ${eventBg}; padding: 10px 12px;">
                        <div style="display: flex; justify-content: space-between; align-items: center;">
                            <span style="color: ${eventText}; opacity: 0.8; font-size: 12px; font-weight: 600; min-width: 100px;">13:00 - 18:00</span>
                            <span style="color: ${eventText}; font-size: 13px; font-weight: 600; flex: 1;">Digital Meetup</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>`;
        
        $('#calendar_preview').html(html);
    }
    
    // Tab switching
    $('.preview-tab').on('click', function() {
        var tab = $(this).data('tab');
        $('.preview-tab').removeClass('active');
        $(this).addClass('active');
        $('.preview-content').removeClass('active').hide();
        $('#' + tab + '_preview').addClass('active').show();
    });
    
    // Bind change events
    $('.customization-form').on('input change', 'input, select', function() {
        renderCardPreview();
        renderModalPreview();
        renderCalendarPreview();
        
        // Update range value displays
        var id = $(this).attr('id');
        if (id && id.indexOf('radius') !== -1) {
            $('#' + id + '_value').text($(this).val() + 'px');
        }
    });
    
    // Reset to defaults button
    $('#reset_defaults').on('click', function(e) {
        e.preventDefault();
        if (confirm('<?php echo esc_js(__('Are you sure you want to reset all customization settings to their default values?', 'ticketpaygo-lite')); ?>')) {
            $('#card_primary_color').val('#3b82f6');
            $('#card_button_color').val('#42963B');
            $('#card_button_text_color').val('#ffffff');
            $('#card_text_color').val('#333333');
            $('#card_border_radius').val('16');
            $('#card_border_radius_value').text('16px');
            $('#modal_header_background').val('#3b82f6');
            $('#modal_body_background').val('#ffffff');
            $('#modal_text_color').val('#1e293b');
            $('#modal_button_color').val('#3b82f6');
            $('#calendar_primary_color').val('#3b82f6');
            $('#calendar_event_bg').val('#3b82f6');
            $('#calendar_event_text').val('#ffffff');
            
            renderCardPreview();
            renderModalPreview();
            renderCalendarPreview();
        }
    });
    
    // Initial render
    renderCardPreview();
    renderModalPreview();
    renderCalendarPreview();
});
</script>
