jQuery(document).ready(function ($) {

    var $fetchButton = $('#mainwp-fluentsupport-fetch-btn');
    var $ticketDataBody = $('#fluentsupport-ticket-data');

    /**
     * Helper to show messages using MainWP styling.
     */
    var showSyncMessage = function(msg, type) {
        var $msgDiv = $('#mainwp-fluentsupport-message');
        $msgDiv.hide().removeClass('mainwp-notice-green mainwp-notice-red').empty();
        
        var noticeClass = type === 'success' ? 'mainwp-notice-green' : 'mainwp-notice-red';
        var prefix = type === 'success' ? '<strong>Success!</strong> ' : '<strong>Error:</strong> ';
        
        $msgDiv.addClass('mainwp-notice ' + noticeClass).html(prefix + msg).slideDown();
    };

    /**
     * FETCH TICKETS (AJAX)
     * Triggers the manual synchronization process.
     */
    $(document).on('click', '#mainwp-fluentsupport-fetch-btn', function (e) {
        e.preventDefault();
        var $btn = $(this);

        $btn.prop('disabled', true).text('Syncing...');
        $('#mainwp-fluentsupport-message').hide();
        $ticketDataBody.html('<tr class="loading-row"><td colspan="4"><i class="fa fa-spinner fa-pulse"></i> Contacting Support Site...</td></tr>');

        $.ajax({
            url: ticketStatusSync.ajaxurl,
            type: 'POST',
            data: {
                action: 'mainwp_fluentsupport_fetch_tickets',
                security: ticketStatusSync.security
            },
            success: function (response) {
                if (response.success) {
                    if (response.data.html) {
                        $ticketDataBody.html(response.data.html);
                    }
                    showSyncMessage(response.data.message, 'success');
                } else {
                    showSyncMessage(response.data.message || 'Manual sync failed.', 'error');
                }
            },
            error: function () {
                showSyncMessage('Network error occurred during manual sync.', 'error');
            },
            complete: function () {
                $btn.prop('disabled', false).text('Fetch Latest Tickets');
            }
        });
    });
});