<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              third-party-api-authentication
 * @since             1.0.0
 * @package           Third_Party_Api_Authentication
 *
 * @wordpress-plugin
 * Plugin Name:       Third Party API authentication
 * Plugin URI:        https://frakton.com/wordpress-as-a-microservice-using-third-party-authentication/
 * Description:       This is a custom plugins being used for API Authentication using third party API.
 * Version:           1.0.0
 * Author:            Frakton Developers
 * Author URI:        https://frakton.com
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       third-party-api-authentication
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define( 'THIRD_PARTY_API_AUTHENTICATION_VERSION', '1.0.0' );

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-third-party-api-authentication-activator.php
 */
function activate_thpaapauth_third_party_authentication() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-third-party-api-authentication-activator.php';
	Third_Party_Api_Authentication_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-third-party-api-authentication-deactivator.php
 */
function deactivate_thpaapauth_third_party_authentication() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-third-party-api-authentication-deactivator.php';
	Third_Party_Api_Authentication_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'activate_thpaapauth_third_party_authentication' );
register_deactivation_hook( __FILE__, 'deactivate_thpaapauth_third_party_authentication' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-third-party-api-authentication.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function run_thpaapauth_third_party_authentication() {

	$plugin = new Third_Party_Api_Authentication();
	$plugin->run();

}
run_thpaapauth_third_party_authentication();
