<?php

/**
 * Define the internationalization functionality
 *
 * Loads and defines the internationalization files for this plugin
 * so that it is ready for translation.
 *
 * @link       third-party-api-authentication
 * @since      1.0.0
 *
 * @package    Third_Party_Api_Authentication
 * @subpackage Third_Party_Api_Authentication/includes
 */

/**
 * Define the internationalization functionality.
 *
 * Loads and defines the internationalization files for this plugin
 * so that it is ready for translation.
 *
 * @since      1.0.0
 * @package    Third_Party_Api_Authentication
 * @subpackage Third_Party_Api_Authentication/includes
 * @author     Edon Sekiraqa <edon@frakton.com>
 */
class Third_Party_Api_Authentication_i18n {


	/**
	 * Load the plugin text domain for translation.
	 *
	 * @since    1.0.0
	 */
	public function load_plugin_textdomain() {

		load_plugin_textdomain(
			'third-party-api-authentication',
			false,
			dirname( dirname( plugin_basename( __FILE__ ) ) ) . '/languages/'
		);

	}



}
