jQuery(document).ready(function ($) {
    // Handle Go button click
    $("#go-button").click(function () {
        const postType = $("#post_type").val();

        if (!postType) {
            alert("Please select a post type.");
            return;
        }

        $("#loading-fields").show();

        $.post(
            thenoxport_ajax.ajax_url,
            {
                action: "tnx_fetch_fields",
                post_type: postType,
                _ajax_nonce: thenoxport_ajax.nonce,
            },
            function (response) {
                $("#loading-fields").hide();
                if (response.success) {
                    $("#fields-container").html(response.data).show();
                    $("#actions").show();
                    $("#post_type").prop("disabled", true).css("pointer-events", "none");
                    $("#go-button").prop("disabled", true);
                } else {
                    alert("Error: " + response.data);
                }
            }
        );
    });

    // Handle Generate Table button click
    $("#thenoxport-form").submit(function (event) {
        event.preventDefault();
        loadTableData(1); // Load the first page by default
    });

    // Function to load table data with pagination
    function loadTableData(paged) {
        const postType = $("#post_type").val();
        const selectedFields = $('input[name="fields[]"]:checked').map(function () {
            return $(this).val();
        }).get();
        const selectedTaxonomies = $('input[name="taxonomies[]"]:checked').map(function () {
            return $(this).val();
        }).get();

        if (!postType || selectedFields.length === 0) {
            alert("Please select a post type and at least one field.");
            return;
        }

        // Move the loading message just above the results
        $("#loading-table").insertBefore("#thenoxport-table").show();

        $.post(
            thenoxport_ajax.ajax_url,
            {
                action: "tnx_generate_table",
                post_type: postType,
                fields: selectedFields,
                taxonomies: selectedTaxonomies,
                paged: paged, // Send the current page number
                _ajax_nonce: thenoxport_ajax.nonce,
            },
            function (response) {
                $("#loading-table").hide(); // Hide the loading message once the response is received
                if (response.success) {
                    $("#thenoxport-table").html(response.data.table);
                    $("#thenoxport-pagination").html(response.data.pagination);
                    $("#result-count").text(`Results: ${response.data.total} Items`); // Display total number of results

                    // Disable form options after generating the table
                    $('input[name="fields[]"]').prop("disabled", true);
                    $('input[name="taxonomies[]"]').prop("disabled", true);
                    $("#thenoxport-form input[type='submit']").prop("disabled", true);
                } else {
                    alert("Error: " + response.data);
                }
            }
        );
    }

    // Handle pagination click
    $(document).on('click', '.pagination-link', function (e) {
        e.preventDefault();
        const paged = $(this).data('page');
        loadTableData(paged);
    });

    // Handle Start Over button click
    $("#start-over-button").click(function () {
        $("#post_type").prop("disabled", false).css("pointer-events", "auto").val("");
        $("#go-button").prop("disabled", false);
        $("#fields-container").hide().html("");
        $("#actions").hide();
        $("#result-count").text("");
        $("#thenoxport-table").html("");
        $("#thenoxport-pagination").html("");
        $("#loading-table").hide(); // Ensure the loading message is hidden when starting over
    });

    // Handle HTML This Table button click
    $("#html-this-table").click(function () {
        const postType = $("#post_type").val();
        const selectedFields = $('input[name="fields[]"]:checked').map(function () {
            return $(this).val();
        }).get();
        const selectedTaxonomies = $('input[name="taxonomies[]"]:checked').map(function () {
            return $(this).val();
        }).get();

        if (!postType || selectedFields.length === 0) {
            alert("Please select a post type and at least one field.");
            return;
        }

        // Show loading message while exporting the table
        $("#loading-table").insertBefore("#thenoxport-table").show();

        // Fetch the entire table without pagination for the HTML export
        $.post(
            thenoxport_ajax.ajax_url,
            {
                action: "tnx_generate_table",
                post_type: postType,
                fields: selectedFields,
                taxonomies: selectedTaxonomies,
                fetch_all: 'true',
                _ajax_nonce: thenoxport_ajax.nonce,
            },
            function (response) {
                $("#loading-table").hide(); // Hide the loading message after export
                if (response.success) {
                    const table = response.data.table;

                    const now = new Date();
                    const dd = String(now.getDate()).padStart(2, "0");
                    const mm = String(now.getMonth() + 1).padStart(2, "0");
                    const yyyy = now.getFullYear();
                    const hh = String(now.getHours()).padStart(2, "0");
                    const min = String(now.getMinutes()).padStart(2, "0");
                    const dateStr = `${dd}${mm}${yyyy}-${hh}${min}`;

                    const htmlContent = `<html><head><meta charset="UTF-8"><title>Table Export</title></head><body>${table}</body></html>`;

                    const blob = new Blob([htmlContent], { type: "text/html" });
                    const link = document.createElement("a");
                    link.href = URL.createObjectURL(blob);
                    link.download = `Table-${dateStr}.html`;
                    link.click();
                } else {
                    alert("Error: " + response.data);
                }
            }
        );
    });
});
