<?php

class OBFX_Social_Icons {

	private $icons = array(
		'baidu'         => '<svg viewBox="0 0 24 24"><path d="m9.154 0c-1.444 0-2.614 1.658-2.614 3.707 0 2.051 1.171 3.71 2.615 3.71 1.446 0 2.614-1.659 2.614-3.71-.001-2.049-1.169-3.707-2.615-3.707zm7.025.594c-1.319-.014-2.832 1.995-2.979 3.333-.187 1.745.25 3.487 2.179 3.735 1.933.25 3.175-1.806 3.422-3.364.252-1.555-.995-3.364-2.362-3.674a1.218 1.218 0 0 0 -.261-.03zm-12.597 4.941a2.811 2.811 0 0 0 -.156.008c-2.118.19-2.428 3.24-2.428 3.24-.287 1.41.686 4.425 3.297 3.864 2.617-.561 2.262-3.68 2.183-4.362-.125-1.018-1.292-2.773-2.896-2.75zm16.534 1.753c-2.308 0-2.617 2.119-2.617 3.616 0 1.43.121 3.425 2.988 3.362s2.553-3.238 2.553-3.988c0-.745-.62-2.99-2.924-2.99zm-8.264 2.478c-1.424.014-2.708.925-3.323 1.947-1.118 1.868-2.863 3.05-3.112 3.363-.25.309-3.61 2.116-2.864 5.42.746 3.301 3.365 3.237 3.365 3.237s1.93.19 4.171-.31c2.24-.495 4.17.123 4.17.123s5.233 1.748 6.665-1.616c1.43-3.364-.808-5.109-.808-5.109s-2.99-2.306-4.736-4.798c-1.072-1.665-2.348-2.268-3.528-2.257zm-2.234 3.84 1.542.024v8.197h-3.402c-1.47-.291-2.055-1.292-2.13-1.462-.072-.173-.488-.976-.268-2.343.635-2.049 2.447-2.196 2.447-2.196h1.81zm3.964 2.39v3.881c.096.413.612.488.612.488h1.614v-4.343h1.689v5.782h-3.915c-1.517-.39-1.59-1.465-1.59-1.465v-4.317zm-5.458 1.147c-.66.197-.978.708-1.05.928-.076.22-.247.78-.1 1.269.294 1.095 1.248 1.144 1.248 1.144h1.37v-3.34z"/></svg>',
		'bluesky'       => '<svg viewBox="0 0 24 24"><path d="m12 10.8c-1.087-2.114-4.046-6.053-6.798-7.995-2.636-1.861-3.641-1.539-4.3-1.24-.763.343-.902 1.515-.902 2.203 0 .69.378 5.65.624 6.479.815 2.736 3.713 3.66 6.383 3.364.136-.02.275-.039.415-.056-.138.022-.276.04-.415.056-3.912.58-7.387 2.005-2.83 7.078 5.013 5.19 6.87-1.113 7.823-4.308.953 3.195 2.05 9.271 7.733 4.308 4.267-4.308 1.172-6.498-2.74-7.078a8.741 8.741 0 0 1 -.415-.056c.14.017.279.036.415.056 2.67.297 5.568-.628 6.383-3.364.246-.828.624-5.79.624-6.478 0-.69-.139-1.861-.902-2.206-.659-.298-1.664-.62-4.3 1.24-2.752 1.945-5.711 5.884-6.798 7.997z"/></svg>',
		'douban'        => '<svg viewBox="0 0 24 24"><path d="m.51 3.06h22.98v-2.305h-22.98zm20.976 2.537v9.608h-2.137l-1.669 5.76h6.32v2.28h-24v-2.28h6.32l-1.67-5.76h-2.135v-9.608h18.972zm-5.066 9.608h-8.84l1.67 5.76h5.501l1.67-5.76zm1.947-7.305h-12.733v5.025h12.733z"/></svg>',
		'facebook'      => '<svg viewBox="38.658 12.828 207.085 207.085"><path d="m158.232 219.912v-94.461h31.707l4.747-36.813h-36.454v-23.504c0-10.658 2.96-17.922 18.245-17.922l19.494-.009v-32.925c-3.373-.447-14.944-1.449-28.406-1.449-28.106 0-47.348 17.155-47.348 48.661v27.149h-31.789v36.813h31.788v94.461z"/></svg>',
		'linkedin'      => '<svg viewBox="0 0 27 26"><path d="m26.325 25.325c-1.575-.0375-3.1125-.0375-4.6875 0-.3375 0-.4125-.075-.4125-.4125 0-2.775 0-5.5875 0-8.3625 0-.6375-.0375-1.275-.225-1.875-.5625-1.95-2.8125-2.6625-4.425-1.35-.8625.675-1.2 1.6125-1.2 2.7375v7.875c0 .3375-.0375.675 0 1.05.0375.3-.1125.375-.375.3375-1.6125 0-3.1875 0-4.8 0-.29999 0-.37499-.075-.37499-.375.0375-2.3625.0375-4.725.0375-7.125 0-2.925 0-5.85-.0375-8.73748 0-.3375.075-.4125.37499-.4125h4.8c.3 0 .375.075.375.375v1.91248c.1125-.1125.15-.15.1875-.1875 1.4625-2.13748 3.525-2.73748 5.9625-2.36248 2.8125.45 4.6125 2.39998 5.0625 5.39998.1125.7125.15 1.425.15 2.1375v8.9625c0 .3-.075.4125-.4125.4125z"/><path d="m6.825 17v7.875c0 .3375-.075.45-.4125.45-1.575-.0375-3.15 0-4.725 0-.3 0-.375-.075-.375-.375 0-5.2875 0-10.6125 0-15.89995 0-.2625.075-.375.375-.375h4.8375c.3375 0 .375.1125.375.4125-.075 2.62495-.075 5.24995-.075 7.91245z"/><path d="m7.08751 4.32502c-.375 1.5-1.9125 2.3625-3.675 2.0625-1.875-.3-2.925003-2.1375-2.25-3.9375.45-1.125 1.5375-1.8 2.925-1.7625 2.1-.0375 3.4875 1.65 3 3.6375z"/></svg>',
		'mail'          => '<svg viewBox="0 0 512 384"><path d="m48 0c-26.5 0-48 21.5-48 48 0 15.1 7.1 29.3 19.2 38.4l208 156c17.1 12.8 40.5 12.8 57.6 0l208-156c12.1-9.1 19.2-23.3 19.2-38.4 0-26.5-21.5-48-48-48zm-48 132v188c0 35.3 28.7 64 64 64h384c35.3 0 64-28.7 64-64v-188l-198.4 148.8c-34.1 25.6-81.1 25.6-115.2 0z"/></svg>',
		'mastodon'      => '<svg viewBox="0 0 24 24"><path d="m23.268 5.313c-.35-2.578-2.617-4.61-5.304-5.004-.454-.067-2.172-.309-6.151-.309h-.03c-3.98 0-4.835.242-5.288.309-2.613.383-4.999 2.209-5.578 4.818-.277 1.285-.307 2.71-.256 4.016.074 1.874.088 3.745.26 5.611.118 1.24.325 2.47.62 3.68.55 2.237 2.777 4.098 4.96 4.857 2.336.792 4.849.923 7.256.38.265-.061.527-.132.786-.213.585-.184 1.27-.39 1.774-.753a.057.057 0 0 0 .023-.043v-1.809a.052.052 0 0 0 -.02-.041.053.053 0 0 0 -.046-.01 20.282 20.282 0 0 1 -4.709.545c-2.73 0-3.463-1.284-3.674-1.818a5.593 5.593 0 0 1 -.319-1.433.053.053 0 0 1 .066-.054c1.517.363 3.072.546 4.632.546.376 0 .75 0 1.125-.01 1.57-.044 3.224-.124 4.768-.422.038-.008.077-.015.11-.024 2.435-.464 4.753-1.92 4.989-5.604.008-.145.03-1.52.03-1.67.002-.512.167-3.63-.024-5.545zm-3.748 9.195h-2.561v-6.218c0-1.309-.55-1.976-1.67-1.976-1.23 0-1.846.79-1.846 2.35v3.403h-2.546v-3.404c0-1.56-.617-2.35-1.848-2.35-1.112 0-1.668.668-1.67 1.977v6.218h-2.557v-6.406c0-1.31.337-2.35 1.011-3.12.696-.77 1.608-1.164 2.74-1.164 1.311 0 2.302.5 2.962 1.498l.638 1.06.638-1.06c.66-.999 1.65-1.498 2.96-1.498 1.13 0 2.043.395 2.74 1.164.675.77 1.012 1.81 1.012 3.12z"/></svg>',
		'odnoklassniki' => '<svg viewBox="0 0 24 24"><path d="m12 0a6.2 6.2 0 0 0 -6.194 6.195 6.2 6.2 0 0 0 6.195 6.192 6.2 6.2 0 0 0 6.193-6.192 6.2 6.2 0 0 0 -6.193-6.195zm0 3.63a2.567 2.567 0 0 1 2.565 2.565 2.568 2.568 0 0 1 -2.564 2.564 2.568 2.568 0 0 1 -2.565-2.564 2.567 2.567 0 0 1 2.565-2.564zm-5.193 8.97a1.814 1.814 0 0 0 -.91 3.35 11.611 11.611 0 0 0 3.597 1.49l-3.462 3.463a1.815 1.815 0 0 0 2.567 2.566l3.401-3.403 3.405 3.403a1.813 1.813 0 0 0 2.564 0c.71-.709.71-1.858 0-2.566l-3.462-3.462a11.593 11.593 0 0 0 3.596-1.49 1.814 1.814 0 1 0 -1.932-3.073 7.867 7.867 0 0 1 -8.34 0c-.318-.2-.674-.29-1.024-.278z"/></svg>',
		'pinterest'     => '<svg viewBox="0 0 32 39"><path d="m13.5195 26.7933c.7777 1.4883 3.057 2.7486 5.4771 2.7486 7.2067 0 12.3956-6.6302 12.3956-14.8626 0-7.89046-6.4425-13.79661-14.7285-13.79661-10.31063 0-15.781025 6.91844-15.781025 14.46031 0 3.5062 1.863685 7.8637 4.846925 9.2514.45587.2146.69721.1207.79777-.3151.08044-.3352.48268-1.9508.66369-2.7083.06703-.2414.0067-.5028-.1676-.6838-.98548-1.2-1.77654-3.3989-1.77654-5.4503 0-5.2693 3.98883-10.37097 10.78658-10.37097 5.8726 0 9.9821 3.99553 9.9821 9.72067 0 6.4626-3.2648 10.9408-7.515 10.9408-2.3464 0-4.1028-1.9374-3.5397-4.3173.6771-2.8425 1.9776-5.9062 1.9776-7.9576 0-1.8368-.9854-3.3653-3.0234-3.3653-2.4 0-4.32405 2.4804-4.32405 5.7988 0 2.1185.71735 3.5464.71735 3.5464s-2.36651 10.009-2.80226 11.8726c-.49609 2.1453-.26816 5.2224-.05363 7.0995.48938.1877.97206.3754 1.47486.5296.97206-1.562 2.54083-4.3106 3.09723-6.4693.2949-1.1061 1.4949-5.6715 1.4949-5.6715z"/></svg>',
		'reddit'        => '<svg viewBox="0 0 32 29"><path clip-rule="evenodd" d="m31.3757 13.1169c.388.5536.6076 1.2076.6323 1.8831.0103.6613-.1669 1.312-.5109 1.8769-.344.5648-.8408 1.0208-1.4331 1.3151.027.3515.027.7046 0 1.056 0 5.376-6.264 9.744-13.992 9.744-7.72798 0-13.99198-4.368-13.99198-9.744-.02702-.3514-.02702-.7045 0-1.056-.46162-.212-.8716-.522-1.201535-.9082-.329935-.3863-.571932-.8397-.709221-1.3288-.1372892-.4891-.16658691-1.0022-.0858627-1.5038.0807237-.5015.2695397-.9795.5533617-1.4009.283821-.4213.655857-.7759 1.090337-1.0391.43448-.2633.921-.4289 1.42585-.4854.50485-.0566 1.01595-.0026 1.4979.158.48194.1606.92319.4241 1.29317.7722 2.76545-1.8755 6.01888-2.90159 9.35998-2.95196l1.776-8.328c.02-.09641.0588-.1879.1144-.269174s.1267-.150712.2093-.204289c.0826-.053578.175-.090228.2719-.107828.0969-.017601.1963-.0158.2924.005296l5.88 1.175995c.2872-.49334.7408-.868191 1.2794-1.057248.5386-.189058 1.127-.179945 1.6595.025701s.9742.594357 1.246 1.096367c.2717.502.3556 1.08443.2366 1.64272-.1189.5583-.433 1.0559-.8858 1.4035s-1.0147.52242-1.5848.49309c-.57-.02933-1.111-.26089-1.5257-.65312-.4148-.39223-.6761-.91945-.7372-1.487l-5.136-1.08-1.56 7.48799c3.3005.0708 6.5098 1.09616 9.24 2.95196.4877-.4681 1.1004-.7851 1.7643-.9128.6638-.1277 1.3504-.0607 1.977.193.6266.2536 1.1664.6832 1.5544 1.2367zm-9.8444 6.68c1.3246 0 2.3984-1.0738 2.3984-2.3984s-1.0738-2.3984-2.3984-2.3984c-1.3247 0-2.3985 1.0738-2.3985 2.3984s1.0738 2.3984 2.3985 2.3984zm-8.7188-2.3984c0 1.3246-1.0738 2.3984-2.3984 2.3984-1.32464 0-2.39846-1.0738-2.39846-2.3984s1.07382-2.3984 2.39846-2.3984c1.3246 0 2.3984 1.0738 2.3984 2.3984zm3.2112 7.1728-.0119.0001-.0118-.0001v.0001c-1.7106.0104-2.9755-.3728-3.8034-.7483-.417-.1891-.7248-.377-.9237-.5134-.0993-.0681-.1714-.1233-.2161-.1592-.0224-.0179-.0379-.031-.0466-.0385l-.007-.0061c-.0002-.0002-.0005-.0004-.0007-.0006-.2644-.2407-.6739-.2227-.9161.0409-.24293.2643-.22556.6755.0388.9184l.001.0009.0012.0011.0029.0027.0079.0071.024.021c.0197.0169.0467.0396.0811.0671.0687.0551.1668.1298.2944.2174.2553.175.6291.4017 1.122.6252.9835.446 2.4348.8765 4.3521.8643 1.9174.0122 3.3687-.4183 4.3521-.8643.493-.2235.8668-.4502 1.122-.6252.1277-.0876.2258-.1623.2945-.2174.0344-.0275.0614-.0502.081-.0671l.0241-.021.0079-.0071.0029-.0027.0012-.0011.001-.0009c.2643-.2429.2817-.6541.0388-.9184-.2422-.2636-.6517-.2816-.9161-.0409l-.0007.0006-.007.0061c-.0087.0075-.0242.0206-.0466.0385-.0447.0359-.1168.0911-.2162.1592-.1988.1364-.5066.3243-.9237.5134-.8278.3755-2.0927.7587-3.8033.7483z" fill-rule="evenodd"/></svg>',
		'renren'        => '<svg viewBox="0 0 24 24"><path d="m5.66 9.553v-4.299a6.794 6.794 0 0 0 -4.054 11.086c2.379-1.152 4.042-3.755 4.054-6.787zm1.132 4.115c-.423 1.752-1.687 3.25-3.262 4.245a6.76 6.76 0 0 0 3.26.833 6.772 6.772 0 0 0 3.264-.833c-1.575-.996-2.84-2.494-3.262-4.245zm5.184-6.103a6.79 6.79 0 0 0 -4.052-2.31v4.265c0 3.045 1.667 5.663 4.051 6.818a6.767 6.767 0 0 1 -1.607-4.387 6.755 6.755 0 0 1 1.608-4.386zm0 0c1.003 1.183 1.655 2.714 1.655 4.387 0 1.674-.65 3.203-1.655 4.388 2.38-1.15 4.088-3.755 4.1-6.787v-4.299a6.9 6.901 0 0 0 -4.1 2.31zm6.364 1.955c0 3.046 1.667 5.663 4.053 6.82a6.793 6.793 0 0 0 -4.053-11.085zm-1.132 4.148c-.423 1.752-1.687 3.25-3.263 4.245a6.76 6.76 0 0 0 3.262.833 6.772 6.772 0 0 0 3.263-.833c-1.575-.996-2.839-2.494-3.262-4.245z"/></svg>',
		'sms'           => '<svg viewBox="0 0 24 24" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-message-circle-icon lucide-message-circle"><path d="M7.9 20A9 9 0 1 0 4 16.1L2 22Z"/></svg>',
		'telegram'      => '<svg viewBox="0 0 14 12"><path d="m12.906.224033c.1-.002.321.023.465.14.0957.083096.1567.199075.171.325.016.093.036.305999.02.471997-.18 1.898-.962 6.502-1.36 8.627-.168.89997-.499 1.20097-.82 1.22997-.696.065-1.225-.46-1.9-.902-1.056-.69297-1.653-1.12397-2.678-1.79997-1.185-.78-.417-1.21.258-1.91.177-.184 3.247-2.977 3.307-3.23.007-.032.014-.15-.056-.212s-.174-.041-.249-.024c-.106.024-1.793 1.14-5.061 3.345-.48.33-.913.49-1.302.48-.428-.008-1.252-.241-1.865-.44-.752-.245-1.349-.374-1.297-.789.027-.216.325-.437.893-.663 3.498-1.524 5.83-2.529 6.998-3.014 3.332-1.385998 4.025-1.626997 4.476-1.634997z"/></svg>',
		'threads'       => '<svg viewBox="0 0 24 24"><path d="m12.186 24h-.007c-3.581-.024-6.334-1.205-8.184-3.509-1.645-2.051-2.495-4.905-2.523-8.481v-.017c.03-3.579.879-6.43 2.525-8.482 1.848-2.306 4.603-3.487 8.183-3.511h.014c2.746.02 5.043.725 6.826 2.098 1.677 1.29 2.858 3.13 3.509 5.467l-2.04.569c-1.104-3.96-3.898-5.984-8.304-6.015-2.91.022-5.11.936-6.54 2.717-1.338 1.668-2.029 4.078-2.056 7.164.027 3.086.718 5.496 2.057 7.164 1.43 1.783 3.631 2.698 6.54 2.717 2.623-.02 4.358-.631 5.8-2.045 1.647-1.613 1.618-3.593 1.09-4.798-.31-.71-.873-1.3-1.634-1.75-.192 1.352-.622 2.446-1.284 3.272-.886 1.102-2.14 1.704-3.73 1.79-1.202.065-2.361-.218-3.259-.801-1.063-.689-1.685-1.74-1.752-2.964-.065-1.19.408-2.285 1.33-3.082.88-.76 2.119-1.207 3.583-1.291a13.853 13.853 0 0 1 3.02.142c-.126-.742-.375-1.332-.75-1.757-.513-.586-1.308-.883-2.359-.89h-.029c-.844 0-1.992.232-2.721 1.32l-1.757-1.18c.98-1.454 2.568-2.256 4.478-2.256h.044c3.194.02 5.097 1.975 5.287 5.388.108.046.216.094.321.142 1.49.7 2.58 1.761 3.154 3.07.797 1.82.871 4.79-1.548 7.158-1.85 1.81-4.094 2.628-7.277 2.65zm1.003-11.69c-.242 0-.487.007-.739.021-1.836.103-2.98.946-2.916 2.143.067 1.256 1.452 1.839 2.784 1.767 1.224-.065 2.818-.543 3.086-3.71a10.5 10.5 0 0 0 -2.215-.221z"/></svg>',
		'tumblr'        => '<svg viewBox="0 0 17 28"><path d="m10.8221 19.5755c0 2.175 1.1028 2.9103 2.8184 2.9103h2.4813v5.5142h-4.687c-4.19697 0-7.35234-2.1751-7.35234-7.3523v-8.302h-3.829317v-4.50325c4.196937-1.10284 5.973747-4.71772 6.188187-7.84245h4.38077v7.13786h5.0853v5.20784h-5.0853z"/></svg>',
		'twitter'       => '<svg viewBox="0 0 512 512"><path d="m389.2 48h70.6l-154.2 176.2 181.4 239.8h-142l-111.3-145.4-127.2 145.4h-70.7l164.9-188.5-173.9-227.5h145.6l100.5 132.9zm-24.8 373.8h39.1l-252.4-333.8h-42z"/></svg>',
		'vkontakte'     => '<svg viewBox="0 0 17 11"><path d="M2.79 0.299999H0.0500031C0.180003 6.54 3.3 10.29 8.77 10.29H9.08V6.72C11.09 6.92 12.61 8.39 13.22 10.29H16.06C15.28 7.45 13.23 5.88 11.95 5.28C13.23 4.54 15.03 2.74 15.46 0.299999H12.88C12.32 2.28 10.66 4.08 9.08 4.25V0.299999H6.5V7.22C4.9 6.82 2.88 4.88 2.79 0.299999Z"/></svg>',
		'weibo'         => '<svg viewBox="0 0 24 24"><path d="m10.098 20.323c-3.977.391-7.414-1.406-7.672-4.02-.259-2.609 2.759-5.047 6.74-5.441 3.979-.394 7.413 1.404 7.671 4.018.259 2.6-2.759 5.049-6.737 5.439zm-1.048-3.104c-.384.616-1.208.884-1.829.602-.612-.279-.793-.991-.406-1.593.379-.595 1.176-.861 1.793-.601.622.263.82.972.442 1.592zm1.27-1.627c-.141.237-.449.353-.689.253-.236-.09-.313-.361-.177-.586.138-.227.436-.346.672-.24.239.09.315.36.18.601zm.176-2.719c-1.893-.493-4.033.45-4.857 2.118-.836 1.704-.026 3.591 1.886 4.21 1.983.64 4.318-.341 5.132-2.179.8-1.793-.201-3.642-2.161-4.149zm7.563-1.224c-.346-.105-.57-.18-.405-.615.375-.977.42-1.804 0-2.404-.781-1.112-2.915-1.053-5.364-.03 0 0-.766.331-.571-.271.376-1.217.315-2.224-.27-2.809-1.338-1.337-4.869.045-7.888 3.08-2.252 2.27-3.561 4.673-3.561 6.748 0 3.981 5.099 6.395 10.086 6.395 6.536 0 10.888-3.801 10.888-6.82 0-1.822-1.547-2.854-2.915-3.284zm1.908-5.092c-.766-.856-1.908-1.187-2.96-.962-.436.09-.706.511-.616.932.09.42.511.691.932.602.511-.105 1.067.044 1.442.465.376.421.466.977.316 1.473-.136.406.089.856.51.992.405.119.857-.105.992-.512.33-1.021.12-2.178-.646-3.035zm2.418-2.195c-1.576-1.757-3.905-2.419-6.054-1.968-.496.104-.812.587-.706 1.081.104.496.586.813 1.082.707 1.532-.331 3.185.15 4.296 1.383 1.112 1.246 1.429 2.943.947 4.416-.165.48.106 1.007.586 1.157.479.165.991-.104 1.157-.586.675-2.088.241-4.478-1.338-6.235z"/></svg>',
		'whatsapp'      => '<svg viewBox="0 0 29 29"><path d="m24.7507 4.21149c-2.573-2.64865-6.1297-4.08649-9.7622-4.08649-7.71889 0-13.9243 6.28108-13.84862 13.9243 0 2.4216.68108 4.7676 1.81621 6.8865l-1.967565 7.1892 7.340545-1.8919c2.04323 1.1351 4.31353 1.6649 6.58373 1.6649 7.6433 0 13.8487-6.2811 13.8487-13.9244 0-3.7081-1.4378-7.18914-4.0108-9.76211zm-9.7622 21.34051c-2.0432 0-4.0865-.5297-5.827-1.5892l-.45406-.227-4.38918 1.1351 1.13513-4.3135-.3027-.454c-3.32973-5.373-1.74054-12.48651 3.70811-15.81624 5.4486-3.329728 12.4865-1.74054 15.8162 3.70811 3.3297 5.44863 1.7406 12.48653-3.7081 15.81623-1.7405 1.1351-3.8595 1.7405-5.9784 1.7405zm6.6595-8.4-.8324-.3784s-1.2109-.5297-1.9676-.9081c-.0757 0-.1514-.0756-.227-.0756-.2271 0-.3784.0756-.5298.1513 0 0-.0756.0757-1.1351 1.2865-.0757.1514-.227.227-.3784.227h-.0757c-.0756 0-.227-.0756-.3027-.1513l-.3783-.1514c-.8325-.3784-1.5892-.8324-2.1946-1.4378-.1514-.1514-.3784-.3027-.5298-.4541-.5297-.5297-1.0594-1.1351-1.4378-1.8162l-.0757-.1513c-.0757-.0757-.0757-.1514-.1513-.3027 0-.1514 0-.3027.0756-.3784 0 0 .3027-.3784.5298-.6054.1513-.1514.227-.3784.3784-.5297.1513-.2271.227-.5298.1513-.7568-.0757-.3784-.9838-2.42163-1.2108-2.87568-.1514-.22703-.3027-.3027-.5297-.37838h-.2271c-.1513 0-.3783 0-.60537 0-.15135 0-.3027.07568-.45405.07568l-.07568.07567c-.15135.07568-.3027.22703-.45405.30271-.15135.15135-.22703.3027-.37838.45405-.52973.68108-.83243 1.51351-.83243 2.34595 0 .6054.15135 1.2108.37837 1.7405l.07568.2271c.68108 1.4378 1.58919 2.7243 2.80001 3.8594l.3027.3027c.227.2271.454.3784.6054.6054 1.5892 1.3622 3.4054 2.346 5.4486 2.8757.2271.0757.5298.0757.7568.1514h.7568c.3783 0 .8324-.1514 1.1351-.3027.227-.1514.3784-.1514.5297-.3027l.1514-.1514c.1513-.1514.3027-.227.454-.3784.1514-.1513.3027-.3027.3784-.454.1514-.3027.227-.6811.3027-1.0595 0-.1513 0-.3784 0-.5297 0 0-.0757-.0757-.227-.1514z"/></svg>',
		'xing'          => '<svg viewBox="0 0 24 24"><path d="m18.188 0c-.517 0-.741.325-.927.66 0 0-7.455 13.224-7.702 13.657.015.024 4.919 9.023 4.919 9.023.17.308.436.66.967.66h3.454c.211 0 .375-.078.463-.22.089-.151.089-.346-.009-.536l-4.879-8.916c-.004-.006-.004-.016 0-.022l7.665-13.55c.095-.191.097-.387.006-.535-.089-.143-.251-.221-.459-.221zm-14.54 4.74c-.211 0-.385.074-.473.216-.09.149-.078.339.02.531l2.34 4.05c.004.01.004.016 0 .021l-3.675 6.493c-.099.188-.093.381 0 .529.085.142.239.234.45.234h3.461c.518 0 .766-.348.945-.667l3.734-6.609-2.378-4.155c-.172-.315-.434-.659-.962-.659h-3.462z"/></svg>',
	);

	/**
	 * Get the icon
	 *
	 * @param string $icon The icon name
	 * @return string The icon
	 */
	public function get_icon( $icon = '' ) {
		$icon = trim( $icon );

		if ( empty( $icon ) ) {
			return '';
		}

		if ( ! isset( $this->icons[ $icon ] ) ) {
			return '';
		}

		return $this->icons[ $icon ];
	}

	/**
	 * Sanitize the icon SVG
	 *
	 * @param string $svg The SVG content
	 * @return string The sanitized SVG content
	 */
	public static function sanitize_icon_svg( $svg = '' ) {
		return wp_kses(
			$svg,
			array(
				'svg'  => array(
					'viewbox' => array(),
					'xmlns'   => array(),
				),
				'path' => array(
					'd'         => array(),
					'clip-rule' => array(),
					'fill-rule' => array(),
				),
			)
		);
	}
}
