/**
 * Admin JavaScript for Popup Coupon Generator for WooCommerce
 */

(function($) {
	'use strict';
	
	$(document).ready(function() {
		
		// Delete popup
		$(document).on('click', '.popucoge-delete-popup', function(e) {
			e.preventDefault();
			
			if (!confirm('Sei sicuro di voler eliminare questo popup?')) {
				return;
			}
			
			var $button = $(this);
			var popupId = $button.data('popup-id');
			
			$.ajax({
				url: popucogeAdmin.ajax_url,
				type: 'POST',
				data: {
					action: 'popucoge_delete_popup',
					nonce: popucogeAdmin.nonce,
					popup_id: popupId
				},
				success: function(response) {
					if (response.success) {
						$button.closest('tr').fadeOut(300, function() {
							$(this).remove();
						});
					} else {
						alert(response.data.message || 'Errore durante l\'eliminazione');
					}
				},
				error: function() {
					alert('Errore di connessione. Riprova più tardi.');
				}
			});
		});
		
		// Toggle popup status
		$(document).on('click', '.popucoge-toggle-popup', function(e) {
			e.preventDefault();
			
			var $button = $(this);
			var popupId = $button.data('popup-id');
			var currentStatus = $button.data('status');
			var newStatus = currentStatus === 'active' ? 'inactive' : 'active';
			
			$.ajax({
				url: popucogeAdmin.ajax_url,
				type: 'POST',
				data: {
					action: 'popucoge_toggle_popup',
					nonce: popucogeAdmin.nonce,
					popup_id: popupId,
					status: currentStatus
				},
				success: function(response) {
					if (response.success) {
						location.reload();
					} else {
						alert(response.data.message || 'Errore durante l\'aggiornamento');
					}
				},
				error: function() {
					alert('Errore di connessione. Riprova più tardi.');
				}
			});
		});
		
		// Delete automation
		$(document).on('click', '.popucoge-delete-automation', function(e) {
			e.preventDefault();
			
			if (!confirm('Sei sicuro di voler eliminare questa automazione?')) {
				return;
			}
			
			var $button = $(this);
			var automationId = $button.data('automation-id');
			
			$.ajax({
				url: popucogeAdmin.ajax_url,
				type: 'POST',
				data: {
					action: 'popucoge_delete_automation',
					nonce: popucogeAdmin.nonce,
					automation_id: automationId
				},
				success: function(response) {
					if (response.success) {
						$button.closest('tr').fadeOut(300, function() {
							$(this).remove();
						});
					} else {
						alert(response.data.message || 'Errore durante l\'eliminazione');
					}
				},
				error: function() {
					alert('Errore di connessione. Riprova più tardi.');
				}
			});
		});
		
		// Toggle automation status
		$(document).on('click', '.popucoge-toggle-automation', function(e) {
			e.preventDefault();
			
			var $button = $(this);
			var automationId = $button.data('automation-id');
			var currentStatus = $button.data('status');
			
			$.ajax({
				url: popucogeAdmin.ajax_url,
				type: 'POST',
				data: {
					action: 'popucoge_toggle_automation',
					nonce: popucogeAdmin.nonce,
					automation_id: automationId,
					status: currentStatus
				},
				success: function(response) {
					if (response.success) {
						location.reload();
					} else {
						alert(response.data.message || 'Errore durante l\'aggiornamento');
					}
				},
				error: function() {
					alert('Errore di connessione. Riprova più tardi.');
				}
			});
		});
		
	});
	
})(jQuery);

