<?php
namespace WpTracker\Framework\Database;

use Medoo\Medoo;

class Database {

    use \PetrKnap\Php\Singleton\SingletonTrait;

    public $connection;

    private function __construct() {
        $this->addConnection();
        $this->updates();
    }
    public function checkTables() {

        global $wpdb;

        $charset_collate = $wpdb->get_charset_collate();

        $the_tracker_tracks = $wpdb->prefix . 'the_tracker_tracks';

        $the_tracker_tracks_sql = "CREATE TABLE IF NOT EXISTS $the_tracker_tracks (
            `id` BIGINT AUTO_INCREMENT,
            `client_id` BIGINT NULL,
            `session_id` BIGINT NULL,
            `from` TEXT NULL,
            `from_query` TEXT NULL,
            `location` TEXT NULL,
            `query` TEXT NULL,
            `data` TEXT NULL,
            `time` BIGINT NULL,
            PRIMARY KEY  (id)
        ) $charset_collate;";

        $the_tracker_clients = $wpdb->prefix . 'the_tracker_clients';

        $the_tracker_clients_sql = "CREATE TABLE IF NOT EXISTS $the_tracker_clients (
            `id` BIGINT AUTO_INCREMENT,
            `uid` VARCHAR(255) NULL,
            PRIMARY KEY  (id)
        ) $charset_collate;";

        $the_tracker_sessions = $wpdb->prefix . 'the_tracker_sessions';

        $the_tracker_sessions_sql = "CREATE TABLE IF NOT EXISTS $the_tracker_sessions (
            id BIGINT AUTO_INCREMENT,
            client_id BIGINT NULL,
            `uid` VARCHAR(255) NULL,
            `start` BIGINT NULL,
            `end` BIGINT NULL,
            PRIMARY KEY  (id)
        ) $charset_collate;";



        require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );
        dbDelta( $the_tracker_tracks_sql );
        dbDelta( $the_tracker_clients_sql );
        dbDelta( $the_tracker_sessions_sql );

    }
    private function addConnection() {
        global $wpdb;
        $this->connection = new Medoo([
            'database_type'    => 'mysql',
            'server'         => DB_HOST,
            'database_name'  => DB_NAME,
            'username'  => DB_USER,
            'password'  => DB_PASSWORD,
            'prefix'    => $wpdb->prefix,
        ]);
    }
    private function updates() {
        global $wpdb;
        $the_tracker_tracks = $wpdb->prefix . 'the_tracker_tracks';
        $this->connection->select('the_tracker_tracks','query',['LIMIT' => 1]);
        if( $this->connection->error()[1] == 1054 ) {
            $this->connection->query("ALTER TABLE $the_tracker_tracks
            ADD query TEXT NULL;");
        }
        $this->connection->select('the_tracker_tracks','from_query',['LIMIT' => 1]);
        if( $this->connection->error()[1] == 1054 ) {
            $this->connection->query("ALTER TABLE $the_tracker_tracks
            ADD from_query TEXT NULL;");
        }
    }
}