<?php
namespace WpTracker\Framework\Api;

use WpTracker\App\Controllers\AdminApi;

class Admin {

    use \PetrKnap\Php\Singleton\SingletonTrait;

    private $admin;

    private function __construct() {
        $this->admin = AdminApi::getInstance();
        add_action('rest_api_init', [$this, 'register']);
    }

    public function register() {
        // /wp-json/wp-tracker-plugin/v1/update-options
        register_rest_route( 'wp-tracker-plugin/v1', '/update-options', array(
            'methods' => 'POST',
            'callback' => [$this->admin, 'updateOptions'],
            'permission_callback' => function () {
              return current_user_can( 'manage_options' );
            }
          ) );
          // /wp-json/wp-tracker-plugin/v1/get-visits
          register_rest_route( 'wp-tracker-plugin/v1', '/get-visits', array(
            'methods' => 'GET',
            'callback' => [$this->admin, 'getVisits'],
            'permission_callback' => function () {
              return current_user_can( 'manage_options' );
            }
          ) );
          // /wp-json/wp-tracker-plugin/v1/get-views
          register_rest_route( 'wp-tracker-plugin/v1', '/get-views', array(
            'methods' => 'POST',
            'callback' => [$this->admin, 'getViews'],
            'permission_callback' => function () {
              return current_user_can( 'manage_options' );
            }
          ) );
          // /wp-json/wp-tracker-plugin/v1/get-views-by-page
          register_rest_route( 'wp-tracker-plugin/v1', '/get-views-by-page', array(
            'methods' => 'GET',
            'callback' => [$this->admin, 'getViewsByPage'],
            'permission_callback' => function () {
              return current_user_can( 'manage_options' );
            }
          ) );
    }
}