<?php
namespace WpTracker\App\Controllers;

use WpTracker\App\Models\Track;
use WpTracker\App\Models\Client;
use WpTracker\App\Models\Session;
use Josantonius\Cookie\Cookie;
use WpTracker\Framework\Utility\Unique;

class Controller {

    use \PetrKnap\Php\Singleton\SingletonTrait;

    private $client;

    private $session;

    private $time; 

    private $cookies = [
        'client' => 'the_wp_tracker_client',
        'session' => 'the_wp_tracker_session',
    ];

    private function __construct() {
        Cookie::setPrefix('the_wp_tracker_');
        add_action('init',[$this, 'check']);
    }
    public function check() {
        if(wp_doing_ajax() || strpos($_SERVER['REQUEST_URI'], 'wp-json') || strpos($_SERVER['REQUEST_URI'], 'wp-cron')){
            return;
        }
        if(is_admin()){
            $this->admin();
            return;
        }
        $this->public();
    }
    private function admin() {

    }
    private function public() {
        $cookies = Cookie::get();
        $this->time = time();
        foreach($this->cookies AS $method => $name) {
            if(isset($cookies[$name])){
                $this->$method($cookies[$name]);
            }else{
                $this->$method(false);
            }
        }
        $this->track();
    }
    private function track() {
        $track = new Track();
        $track->client_id = $this->client->id;
        $track->session_id = $this->session->id;
        $from_url = isset($_SERVER['HTTP_REFERER']) ? $_SERVER['HTTP_REFERER'] : NULL;
        $from_parsed_url = parse_url($from_url);
        $track->from = $from_parsed_url['scheme'].'://'.$from_parsed_url['host'].$from_parsed_url['path'];
        $track->from_query = $from_parsed_url['query'];
        $url = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
        $parsed_url = parse_url($url);
        $track->location = $parsed_url['scheme'].'://'.$parsed_url['host'].$parsed_url['path'];
        $track->query = $parsed_url['query'];
        $track->time = $this->time;
        $track->data = json_encode($_SERVER);
        $track->save(Track::$table);
    }
    private function session($cookie) {
        $string = '';
        if($cookie){
            $cookie = explode('.',$cookie);
            if($this->time >= ( 86400 + $cookie[1] ) ) {
                Cookie::destroy('session');
                $this->createSession();
            }
            if(!$this->session) $this->session = Session::where(Session::$table,'uid',$cookie[0]); 
            return;
        }
        $this->createSession();
        return;
    }
    private function client($cookie) {
        $string = '';
        if($cookie){
            $this->client = Client::where(Client::$table,'uid', $cookie);
            return;
        }
        $this->client = new Client();
        $this->client->uid = Unique::uid();
        $this->client->save(Client::$table); 
        $string = $this->client->uid;
        Cookie::set('client', $string);
        return;
    }
    private function createSession() {
        $this->session = new Session();
        $this->session->uid = Unique::uid();
        $this->session->start = $this->time;
        $this->session->client_id = $this->client->id;
        $this->session->save(Session::$table); 
        $string = $this->session->uid . '.' . $this->session->start;
        Cookie::set('session', $string);
    }
}  