<?php
namespace WpTracker\App\Controllers;

use WpTracker\App\Services\OptionService;
use WpTracker\App\Models\Track;

class AdminApi { 

    use \PetrKnap\Php\Singleton\SingletonTrait;

    private $optionService;

    private function __construct() {
        $this->optionService = OptionService::getInstance();
    }

    public function updateOptions($request) {
        $options = ['test' => 'testing'];
        $this->optionService->update($options);
    }
    public function getVisits($request) {
        $visits = [
            'total' => 0,
            'today' => 0,
        ];
        $time = time();
        $beginOfDay = strtotime("midnight", $time);
        $endOfDay   = strtotime("tomorrow", $beginOfDay) - 1;
        $visits['today'] = Track::count(Track::$table,[
            'time' => [
                'whereBetween',
                [$beginOfDay, $endOfDay],
            ]
        ]);
        $visits['total'] = Track::count(Track::$table);
        return [
            'visits' => $visits,
        ];
        die();
    }
    public function getViews($request) {
        $now = time();
        $visits = [];
        foreach($request['days'] AS $day) {
            $beginOfDay = strtotime("midnight", $day);
            $endOfDay   = strtotime("tomorrow", $beginOfDay) - 1;
            $visits[$day] = Track::count(Track::$table,[
                'time' => [
                    'whereBetween',
                    [$beginOfDay, $endOfDay],
                ]
            ]);
        }
        return [
            'days' => $visits,
        ];
        die();
    }
    public function getViewsByPage($request) {
        $tracks = Track::all(Track::$table,[]);
        $views = [];
        foreach($tracks AS $track) {
            $views[$track['location']][] = $track;
        }
        return [
            'views' => $views,
        ];
        die();
    }
}