<?php
namespace WpTracker\App\Controllers;

class Admin {

    use \PetrKnap\Php\Singleton\SingletonTrait;

    private $pages = [
        'toplevel_page_wp_tracker'
    ];

    private function __construct() {
        add_action('admin_menu', [$this, 'Pages']);
        //add_action('admin_enqueue_scripts', [$this,'Enqueue']);
    }
    public function Enqueue($hook = false) {
        //if ( !in_array($hook, $this->pages) ) {
        //    return;
        //}
        wp_enqueue_style( 'wp_tracker_admin_css', THEWPTRACKERURL . '/core/Public/dist/admin.css' );
        wp_enqueue_script( 'wp_tracker_admin_js_vendor', THEWPTRACKERURL . '/core/Public/dist/vendors~admin.js', ['jquery'], THEWPTRACKERVERSION );
        wp_register_script( 'wp_tracker_admin_js', THEWPTRACKERURL . '/core/Public/dist/admin.js', ['wp_tracker_admin_js_vendor','jquery'], THEWPTRACKERVERSION );
        wp_localize_script( 'wp_tracker_admin_js', 'wptrackerdata', [
            'nonce' => wp_create_nonce( 'wp_rest' ),
            'root' => esc_url_raw( rest_url() ),
        ] );
        wp_enqueue_script( 'wp_tracker_admin_js' );
    }
    public function Pages() {
        add_menu_page( 
            'WP Tracker',
            'WP Tracker',
            'manage_options',
            'wp_tracker',
            [$this, 'Tracker'],
            'dashicons-chart-area'//plugins_url( 'wp-tracker-plugin/core/Public/images/icon.png' )
        ); 
    }
    public function Tracker() {
        $this->Enqueue();
        echo '<div id="wp-tracker">Loading...<div>';
    }
}