<?php
/**
 * Helper class.
 *
 * @package RT_TPG
 */

namespace RT\ThePostGrid\Helpers;

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

// @formatter:off

/**
 * Helper class.
 */
class Svg {
	public static function get_svg( $name, $size = '15', $color = 'currentColor' ) {
		if ( 'settings' == $name ) : ?>
            <svg xmlns="http://www.w3.org/2000/svg" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" width="<?php echo esc_attr( $size ) ?>" height="<?php echo esc_attr( $size ) ?>" x="0" y="0" viewBox="0 0 682.667 682.667" style="enable-background:new 0 0 512 512" xml:space="preserve" class=""><g><defs><clipPath id="a" clipPathUnits="userSpaceOnUse"><path d="M0 512h512V0H0Z" fill="<?php echo esc_attr( $color ) ?>" opacity="1" data-original="<?php echo esc_attr( $color ) ?>"></path></clipPath></defs><g clip-path="url(#a)" transform="matrix(1.33333 0 0 -1.33333 0 682.667)"><path d="M0 0c-43.446 0-78.667-35.22-78.667-78.667 0-43.446 35.221-78.666 78.667-78.666 43.446 0 78.667 35.22 78.667 78.666C78.667-35.22 43.446 0 0 0Zm220.802-22.53-21.299-17.534c-24.296-20.001-24.296-57.204 0-77.205l21.299-17.534c7.548-6.214 9.497-16.974 4.609-25.441l-42.057-72.845c-4.889-8.467-15.182-12.159-24.337-8.729l-25.835 9.678c-29.469 11.04-61.688-7.561-66.862-38.602l-4.535-27.213c-1.607-9.643-9.951-16.712-19.727-16.712h-84.116c-9.776 0-18.12 7.069-19.727 16.712l-4.536 27.213c-5.173 31.041-37.392 49.642-66.861 38.602l-25.834-9.678c-9.156-3.43-19.449.262-24.338 8.729l-42.057 72.845c-4.888 8.467-2.939 19.227 4.609 25.441l21.3 17.534c24.295 20.001 24.295 57.204 0 77.205l-21.3 17.534c-7.548 6.214-9.497 16.974-4.609 25.441l42.057 72.845c4.889 8.467 15.182 12.159 24.338 8.729l25.834-9.678c29.469-11.04 61.688 7.561 66.861 38.602l4.536 27.213c1.607 9.643 9.951 16.711 19.727 16.711h84.116c9.776 0 18.12-7.068 19.727-16.711l4.535-27.213c5.174-31.041 37.393-49.642 66.862-38.602l25.835 9.678c9.155 3.43 19.448-.262 24.337-8.729l42.057-72.845c4.888-8.467 2.939-19.227-4.609-25.441z"style="stroke-width:40;stroke-linecap:round;stroke-linejoin:round;stroke-miterlimit:10;stroke-dasharray:none;stroke-opacity:1" transform="translate(256 334.666)" fill="none" stroke="currentColor" stroke-width="40" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" stroke-dasharray="none" stroke-opacity="" data-original="currentColor" class=""></path></g></g></svg>
		<?php elseif ( 'code' == $name ): ?>
            <svg xmlns="http://www.w3.org/2000/svg" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" width="<?php echo esc_attr( $size ) ?>" height="<?php echo esc_attr( $size ) ?>" x="0" y="0" viewBox="0 0 512 512" style="enable-background:new 0 0 512 512" xml:space="preserve" class=""><g><path d="M492 134v164c0 55.228-44.772 100-100 100H119.979C64.762 398 20 353.238 20 298.021V134C20 78.772 64.772 34 120 34h272c55.228 0 100 44.772 100 100zM352 478H160m194-321 39.217 39.124c11.711 11.675 11.711 30.605 0 42.28L354 277M160 157l-39.217 39.124c-11.711 11.675-11.711 30.605 0 42.28L160 277m74 20 46-160" style="stroke-width:40;stroke-linecap:round;stroke-linejoin:round;stroke-miterlimit:10;" fill="none" stroke="<?php echo esc_attr( $color ) ?>" stroke-width="40" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" data-original="<?php echo esc_attr( $color ) ?>" class=""></path></g></svg>
		<?php elseif ( 'share' == $name ): ?>
            <svg xmlns="http://www.w3.org/2000/svg" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" width="<?php echo esc_attr( $size ) ?>" height="<?php echo esc_attr( $size ) ?>" x="0" y="0" viewBox="0 0 24 24" style="enable-background:new 0 0 512 512" xml:space="preserve" class=""><g><path d="M18 15a3.989 3.989 0 0 0-3.222 1.65l-5.015-3.343a3.722 3.722 0 0 0 0-2.614l5.015-3.343A3.985 3.985 0 1 0 14 5a3.883 3.883 0 0 0 .044.435L8.653 9.029a4 4 0 1 0 0 5.942l5.391 3.594A3.883 3.883 0 0 0 14 19a4 4 0 1 0 4-4zm0-12a2 2 0 1 1-2 2 2 2 0 0 1 2-2zM6 14a2 2 0 1 1 2-2 2 2 0 0 1-2 2zm12 7a2 2 0 1 1 2-2 2 2 0 0 1-2 2z" fill="<?php echo esc_attr( $color ) ?>" opacity="1" data-original="<?php echo esc_attr( $color ) ?>"></path></g></svg>
		<?php elseif ( 'ai' == $name ): ?>
            <svg xmlns="http://www.w3.org/2000/svg" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" width="<?php echo esc_attr( $size ) ?>" height="<?php echo esc_attr( $size ) ?>" x="0" y="0" viewBox="0 0 32 32" style="enable-background:new 0 0 512 512" xml:space="preserve" class=""><g><path d="M21.98 17.156c.487-.174.814-.639.814-1.156s-.327-.982-.812-1.156l-2.23-.804a7.81 7.81 0 0 1-4.714-4.714l-.804-2.23a1.232 1.232 0 0 0-1.154-.812h-.001c-.516 0-.98.326-1.156.812l-.803 2.23a7.807 7.807 0 0 1-4.715 4.714l-2.228.804c-.487.175-.814.639-.814 1.156s.327.981.812 1.156l2.23.804a7.808 7.808 0 0 1 4.714 4.714l.804 2.231c.175.485.64.811 1.156.811h.001c.516 0 .98-.327 1.154-.812l.804-2.23a7.81 7.81 0 0 1 4.714-4.714zm-2.906-1.078a9.802 9.802 0 0 0-5.918 5.918l-.078.216-.078-.216a9.807 9.807 0 0 0-5.918-5.918L6.867 16l.216-.078a9.802 9.802 0 0 0 5.918-5.918l.078-.216.078.216a9.803 9.803 0 0 0 5.917 5.918l.216.078zM18.548 7.463l1.129.407a3.463 3.463 0 0 1 2.09 2.09l.406 1.128c.159.442.581.739 1.05.739s.892-.297 1.05-.738l.407-1.129a3.46 3.46 0 0 1 2.09-2.09l1.13-.407c.439-.159.736-.58.737-1.047s-.293-.89-.737-1.052l-1.13-.407a3.465 3.465 0 0 1-2.09-2.09l-.407-1.129a1.117 1.117 0 0 0-2.099 0l-.407 1.129a3.463 3.463 0 0 1-2.09 2.09l-1.132.408c-.44.16-.736.583-.735 1.051s.298.889.738 1.047zm4.676-3.008a5.437 5.437 0 0 0 1.958 1.958 5.437 5.437 0 0 0-1.958 1.958 5.444 5.444 0 0 0-1.958-1.958 5.452 5.452 0 0 0 1.958-1.958zM27.899 24.537l-1.129-.407a3.465 3.465 0 0 1-2.09-2.09l-.407-1.129a1.118 1.118 0 0 0-2.1 0l-.407 1.129a3.46 3.46 0 0 1-2.09 2.09l-1.128.406c-.441.158-.738.58-.739 1.048s.294.891.738 1.052l1.129.407a3.458 3.458 0 0 1 2.09 2.09l.406 1.128a1.118 1.118 0 0 0 2.102.001l.407-1.129a3.465 3.465 0 0 1 2.09-2.09l1.134-.408c.439-.161.734-.583.733-1.051s-.299-.888-.739-1.047zm-4.675 3.008a5.437 5.437 0 0 0-1.958-1.958 5.444 5.444 0 0 0 1.958-1.958 5.444 5.444 0 0 0 1.958 1.958 5.444 5.444 0 0 0-1.958 1.958z" fill="<?php echo esc_attr( $color ) ?>" opacity="1" data-original="<?php echo esc_attr( $color ) ?>"></path></g></svg>
		<?php elseif ( 'user' == $name ): ?>
            <svg xmlns="http://www.w3.org/2000/svg" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" width="<?php echo esc_attr( $size ) ?>" height="<?php echo esc_attr( $size ) ?>" x="0" y="0" viewBox="0 0 512 512" style="enable-background:new 0 0 512 512" xml:space="preserve" class=""><g><path d="M333.187 237.405c32.761-23.893 54.095-62.561 54.095-106.123C387.282 58.893 328.389 0 256 0S124.718 58.893 124.718 131.282c0 43.562 21.333 82.23 54.095 106.123-81.44 31.165-139.428 110.126-139.428 202.39 0 39.814 32.391 72.205 72.205 72.205h288.82c39.814 0 72.205-32.391 72.205-72.205 0-92.264-57.988-171.225-139.428-202.39zM164.103 131.282c0-50.672 41.225-91.897 91.897-91.897s91.897 41.225 91.897 91.897S306.672 223.18 256 223.18s-91.897-41.226-91.897-91.898zM400.41 472.615H111.59c-18.097 0-32.82-14.723-32.82-32.821 0-97.726 79.504-177.231 177.231-177.231s177.231 79.504 177.231 177.231c-.001 18.098-14.724 32.821-32.822 32.821z" fill="<?php echo esc_attr( $color ) ?>" opacity="1" data-original="<?php echo esc_attr( $color ) ?>" class=""></path></g></svg>
		<?php elseif ( 'calender' == $name ): ?>
            <svg xmlns="http://www.w3.org/2000/svg" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" width="<?php echo esc_attr( $size ) ?>" height="<?php echo esc_attr( $size ) ?>" x="0" y="0" viewBox="0 0 512 512" style="enable-background:new 0 0 512 512" xml:space="preserve" class=""><g><path d="M140 20v80M340 20v80M196.703 460H100c-44.182 0-80-35.818-80-80V140c0-44.185 35.818-80 80-80h280c44.182 0 80 35.815 80 80v40H20M100 260h0M180 260h0M100 340h0M180 340h0" style="stroke-width:40;stroke-linecap:round;stroke-linejoin:round;stroke-miterlimit:10;" fill="none" stroke="<?php echo esc_attr( $color ) ?>" stroke-width="40" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" data-original="<?php echo esc_attr( $color ) ?>" class=""></path><circle cx="372" cy="372" r="120" style="stroke-width:40;stroke-linecap:round;stroke-linejoin:round;stroke-miterlimit:10;" fill="none" stroke="<?php echo esc_attr( $color ) ?>" stroke-width="40" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" data-original="<?php echo esc_attr( $color ) ?>" class=""></circle><path d="M372 372v-40M412 372h-40" style="stroke-width:40;stroke-linecap:round;stroke-linejoin:round;stroke-miterlimit:10;" fill="none" stroke="<?php echo esc_attr( $color ) ?>" stroke-width="40" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" data-original="<?php echo esc_attr( $color ) ?>" class=""></path></g></svg>
		<?php elseif ( 'tools' == $name ): ?>
            <svg xmlns="http://www.w3.org/2000/svg" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" width="<?php echo esc_attr( $size ) ?>" height="<?php echo esc_attr( $size ) ?>" x="0" y="0" viewBox="0 0 512.002 512.002" style="enable-background:new 0 0 512 512" xml:space="preserve" class=""><g><path d="m361.24 276.391-30.99-30.99 81.901-81.901 10.607 10.606c6.868 6.868 18.426 5.515 23.468-2.889l63.638-106.063a14.997 14.997 0 0 0-2.256-18.323L465.182 4.406a15 15 0 0 0-18.323-2.256L340.796 65.788c-8.37 5.022-9.777 16.58-2.889 23.468l10.607 10.606-81.902 81.901-30.99-30.99c10.908-40.758-.218-85.074-31.071-115.928-38.593-38.592-96.366-44.7-141.547-20.363a15 15 0 0 0-3.493 23.813l56.292 56.292c5.849 5.849 5.849 15.365 0 21.212-5.849 5.849-15.364 5.85-21.213 0L38.298 59.506a14.998 14.998 0 0 0-23.813 3.493C-9.76 108.011-3.874 165.822 34.85 204.545c30.785 30.785 75.078 42.005 115.928 31.072l9.774 9.773L22.001 383.944c-29.326 29.326-29.344 76.723 0 106.068 29.243 29.242 76.824 29.244 106.068 0l138.55-138.554 9.776 9.776c-10.908 40.758.218 85.074 31.071 115.928 38.593 38.593 96.366 44.701 141.547 20.364a15 15 0 0 0 3.493-23.813l-56.292-56.292c-5.849-5.849-5.849-15.365 0-21.212 5.849-5.849 15.365-5.848 21.213 0l56.292 56.292a15.002 15.002 0 0 0 23.813-3.493c24.245-45.012 18.36-102.823-20.364-141.546-30.785-30.784-75.078-42.004-115.928-31.071zM452.251 33.9l25.862 25.862-47.727 79.546-57.682-57.68L452.251 33.9zm-82.525 87.175 21.212 21.212-81.901 81.901-21.213-21.212 81.902-81.901zm-262.87 347.726c-17.546 17.546-46.096 17.546-63.643 0-17.605-17.605-17.616-46.027 0-63.643l138.55-138.554 63.643 63.643-138.55 138.554zm372.075-53.513-40.291-40.291c-17.544-17.543-46.092-17.544-63.638 0-17.544 17.544-17.544 46.092 0 63.638l40.291 40.291c-30.612 8.358-63.515.122-86.613-22.975-24.447-24.447-32.748-61.302-21.147-93.893a14.998 14.998 0 0 0-3.525-15.636L165.591 208.005a14.999 14.999 0 0 0-15.636-3.525c-32.592 11.601-69.446 3.299-93.893-21.147-23.098-23.098-31.333-56-22.975-86.612l40.291 40.291c17.544 17.544 46.092 17.543 63.638 0 17.544-17.544 17.544-46.092 0-63.638L96.725 33.083c30.611-8.36 63.515-.123 86.613 22.975 24.447 24.447 32.748 61.302 21.147 93.893a14.998 14.998 0 0 0 3.525 15.636l138.416 138.416a15 15 0 0 0 15.636 3.525c32.59-11.601 69.446-3.299 93.893 21.147 23.099 23.1 31.334 56.001 22.976 86.613z" fill="<?php echo esc_attr( $color ) ?>" opacity="1" data-original="<?php echo esc_attr( $color ) ?>" class=""></path><path d="M195.03 319.984c-5.858-5.857-15.354-5.857-21.212 0L82.16 411.645c-5.857 5.858-5.857 15.354 0 21.212 5.859 5.858 15.354 5.857 21.212 0l91.657-91.661c5.857-5.858 5.857-15.355.001-21.212z" fill="<?php echo esc_attr( $color ) ?>" opacity="1" data-original="<?php echo esc_attr( $color ) ?>" class=""></path></g></svg>
		<?php elseif ( 'unlock' == $name ): ?>
            <svg xmlns="http://www.w3.org/2000/svg" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" width="<?php echo esc_attr( $size ) ?>" height="<?php echo esc_attr( $size ) ?>" x="0" y="0" viewBox="0 0 24 24" style="enable-background:new 0 0 512 512" xml:space="preserve" class=""><g><path fill="<?php echo esc_attr( $color ) ?>" fill-rule="evenodd" d="M6 8a6 6 0 0 1 11.5-2.4 1 1 0 0 1-1.832.8A4.001 4.001 0 0 0 8 8v1.002C8.238 9 8.49 9 8.759 9h6.482c.805 0 1.47 0 2.01.044.563.046 1.08.145 1.565.392a4 4 0 0 1 1.748 1.748c.247.485.346 1.002.392 1.564.044.541.044 1.206.044 2.01v1.483c0 .805 0 1.47-.044 2.01-.046.563-.145 1.08-.392 1.565a4 4 0 0 1-1.748 1.748c-.485.247-1.002.346-1.564.392-.541.044-1.206.044-2.01.044H8.758c-.805 0-1.47 0-2.01-.044-.563-.046-1.08-.145-1.565-.392a4 4 0 0 1-1.748-1.748c-.247-.485-.346-1.002-.392-1.564C3 17.71 3 17.046 3 16.242v-1.483c0-.805 0-1.47.044-2.01.046-.563.145-1.08.392-1.565a4 4 0 0 1 1.748-1.748c.262-.134.533-.224.816-.286zm.911 3.038c-.438.035-.663.1-.819.18a2 2 0 0 0-.874.874c-.08.156-.145.38-.18.819C5 13.361 5 13.943 5 14.8v1.4c0 .857 0 1.439.038 1.889.035.438.1.663.18.819a2 2 0 0 0 .874.874c.156.08.38.145.819.18C7.361 20 7.943 20 8.8 20h6.4c.857 0 1.439 0 1.889-.038.438-.035.663-.1.819-.18a2 2 0 0 0 .874-.874c.08-.156.145-.38.18-.819.037-.45.038-1.032.038-1.889v-1.4c0-.857 0-1.439-.038-1.889-.035-.438-.1-.663-.18-.819a2 2 0 0 0-.874-.874c-.156-.08-.38-.145-.819-.18C16.639 11 16.057 11 15.2 11H8.8c-.857 0-1.439 0-1.889.038zM12 13.5a1 1 0 0 1 1 1v2a1 1 0 1 1-2 0v-2a1 1 0 0 1 1-1z" clip-rule="evenodd" opacity="1" data-original="<?php echo esc_attr( $color ) ?>" class=""></path></g></svg>
		<?php elseif ( 'popup' == $name ): ?>
            <svg xmlns="http://www.w3.org/2000/svg" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" width="<?php echo esc_attr( $size ) ?>" height="<?php echo esc_attr( $size ) ?>" x="0" y="0" viewBox="0 0 682.667 682.667" style="enable-background:new 0 0 512 512" xml:space="preserve" class=""><g><defs><clipPath id="b" clipPathUnits="userSpaceOnUse"><path d="M0 512h512V0H0Z" fill="<?php echo esc_attr( $color ) ?>" opacity="1" data-original="<?php echo esc_attr( $color ) ?>"></path></clipPath></defs><mask id="a"><rect width="100%" height="100%" fill="#ffffff" opacity="1" data-original="#ffffff"></rect></mask><g mask="url(#a)"><g clip-path="url(#b)" transform="matrix(1.33333 0 0 -1.33333 0 682.667)"><path d="M0 0h-392c-22.091 0-40-17.909-40-40v-302c0-22.091 17.909-40 40-40h115l81-81 81 81H0c22.091 0 40 17.909 40 40v302C40-17.909 22.091 0 0 0Z" style="stroke-width:40;stroke-linecap:butt;stroke-linejoin:miter;stroke-miterlimit:10;stroke-dasharray:none;stroke-opacity:1" transform="translate(452 492)" fill="none" stroke="<?php echo esc_attr( $color ) ?>" stroke-width="40" stroke-linecap="butt" stroke-linejoin="miter" stroke-miterlimit="10" stroke-dasharray="none" stroke-opacity="" data-original="<?php echo esc_attr( $color ) ?>" class=""></path><path d="M0 0h-292" style="stroke-width:40;stroke-linecap:butt;stroke-linejoin:miter;stroke-miterlimit:10;stroke-dasharray:none;stroke-opacity:1" transform="translate(402 382)" fill="none" stroke="<?php echo esc_attr( $color ) ?>" stroke-width="40" stroke-linecap="butt" stroke-linejoin="miter" stroke-miterlimit="10" stroke-dasharray="none" stroke-opacity="" data-original="<?php echo esc_attr( $color ) ?>" class=""></path><path d="M0 0h-292" style="stroke-width:40;stroke-linecap:butt;stroke-linejoin:miter;stroke-miterlimit:10;stroke-dasharray:none;stroke-opacity:1" transform="translate(402 302)" fill="none" stroke="<?php echo esc_attr( $color ) ?>" stroke-width="40" stroke-linecap="butt" stroke-linejoin="miter" stroke-miterlimit="10" stroke-dasharray="none" stroke-opacity="" data-original="<?php echo esc_attr( $color ) ?>" class=""></path><path d="M0 0h-196" style="stroke-width:40;stroke-linecap:butt;stroke-linejoin:miter;stroke-miterlimit:10;stroke-dasharray:none;stroke-opacity:1" transform="translate(306 222)" fill="none" stroke="<?php echo esc_attr( $color ) ?>" stroke-width="40" stroke-linecap="butt" stroke-linejoin="miter" stroke-miterlimit="10" stroke-dasharray="none" stroke-opacity="" data-original="<?php echo esc_attr( $color ) ?>" class=""></path></g></g></g></svg>
        <?php elseif ( 'ordering' == $name ): ?>
            <svg xmlns="http://www.w3.org/2000/svg" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" width="<?php echo esc_attr( $size ) ?>" height="<?php echo esc_attr( $size ) ?>" x="0" y="0" viewBox="0 0 24 24" style="enable-background:new 0 0 512 512" xml:space="preserve" class=""><g><path d="M22.707 15.293a1 1 0 0 0-1.414 0L18 18.586V3a1 1 0 0 0-2 0v15.586l-3.293-3.293a1 1 0 0 0-1.414 1.414l5 5a1 1 0 0 0 1.416 0l5-5a1 1 0 0 0-.002-1.414zM12.707 7.293l-5-5a.99.99 0 0 0-.326-.217 1 1 0 0 0-.764 0 .99.99 0 0 0-.326.217l-5 5a1 1 0 1 0 1.416 1.414L6 5.414V21a1 1 0 0 0 2 0V5.414l3.293 3.293a1 1 0 0 0 1.414-1.414z" fill="#000000" opacity="1" data-original="#000000" class=""></path></g></svg>
        <?php endif;
	}
}

// @formatter:on