<?php
/**
 * Plugin Name: The Analects 论语
 * Description: Confucius’ Analects for WordPress: full search (keywords/chapters/characters/arguments/proverbs) and Daily Analects. DailyAnalects Widget. Shortcodes: [analects_search], [analects_daily].
 * Version: 1.3.0
 * Author: www.lunyu.xyz
 * Author URI: https://www.lunyu.xyz
 * Text Domain: the-analects
 * License: GPL2
 */


if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

define( 'ANALECTS_SDK_VERSION', '1.3.3' );
define( 'ANALECTS_SDK_PLUGIN_URL', plugin_dir_url( __FILE__ ) );

class Analects_Daily_Widget extends WP_Widget {

    public function __construct() {
        parent::__construct(
            'analects_daily_widget',
            __( 'Daily Analects(每日论语)', 'the-analects-sdk' ),
            [ 'description' => __( 'Displays the Daily Analect from the SDK.', 'the-analects-sdk' ) ]
        );
    }

    public function widget( $args, $instance ) {
        echo $args['before_widget'];
        if ( ! empty( $instance['title'] ) ) {
            echo $args['before_title'] . apply_filters( 'widget_title', $instance['title'] ) . $args['after_title'];
        }

        // **FIXED**: Added a wrapper div here for proper styling.
        echo '<div class="analects-widget-content-wrapper">';
        echo '<div class="analects-daily-widget-container" id="analects-daily-widget-container-' . esc_attr($this->number) . '"></div>';
        echo '</div>';

        echo $args['after_widget'];
    }

    public function form( $instance ) {
        $title = ! empty( $instance['title'] ) ? $instance['title'] : '';
        ?>
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php _e( 'Title:' ); ?></label>
            <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>">
        </p>
        <p><?php _e( 'This widget displays the Daily Analect. No other settings are required.', 'the-analects-sdk' ); ?></p>
        <?php
    }

    public function update( $new_instance, $old_instance ) {
        $instance = [];
        $instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
        return $instance;
    }
}

function register_analects_widget() {
    register_widget( 'Analects_Daily_Widget' );
}
add_action( 'widgets_init', 'register_analects_widget' );

class The_Analects_SDK_Plugin {

    private static $instance;

    public static function get_instance() {
        if ( null === self::$instance ) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    private function __construct() {
        add_action( 'wp_enqueue_scripts', [ $this, 'enqueue_scripts' ] );
        add_shortcode( 'analects_search', [ $this, 'render_search_shortcode' ] );
        add_shortcode( 'analects_daily', [ $this, 'render_daily_shortcode' ] );
    }

    public function enqueue_scripts() {
        $load_scripts = false;
        if ( is_singular() && ( has_shortcode( get_the_content(), 'analects_search' ) || has_shortcode( get_the_content(), 'analects_daily' ) ) ) {
            $load_scripts = true;
        }
        if ( is_active_widget( false, false, 'analects_daily_widget', true ) ) {
            $load_scripts = true;
        }

        if ( ! $load_scripts ) {
            return;
        }
        
        // =================================================================
        $supabase_url = 'https://btqbtibvevglwcpiewyu.supabase.co';
        $supabase_key = 'sb_publishable_Kl_dygwfqk0Uey1G-0rj3A_4sbCgnet'; 
        // =================================================================

        if ( empty( $supabase_url ) || empty( $supabase_key ) || strpos($supabase_url, 'your-supabase-url') !== false ) {
            return;
        }

        wp_enqueue_script( 'supabase-client', 'https://cdn.jsdelivr.net/npm/@supabase/supabase-js@2', [], '2.0', true );
        wp_enqueue_style( 'analects-sdk-style', ANALECTS_SDK_PLUGIN_URL . 'assets/css/analects-sdk-embed.css', [], ANALECTS_SDK_VERSION );
        wp_enqueue_script( 'analects-sdk-script', ANALECTS_SDK_PLUGIN_URL . 'assets/js/analects-sdk-embed.js', [ 'supabase-client' ], ANALECTS_SDK_VERSION, true );
        wp_localize_script(
            'analects-sdk-script',
            'analectsSdkSettings',
            [
                'config' => [ 'supabaseUrl' => $supabase_url, 'supabaseKey' => $supabase_key ],
                'targets' => [
                    'search' => 'analects-search-container',
                    'daily' => 'analects-daily-container',
                    'dailyWidgetSelector' => '.analects-daily-widget-container',
                ]
            ]
        );
    }

    public function render_search_shortcode() {
        return '<div id="analects-search-container"></div>';
    }

    public function render_daily_shortcode() {
        return '<div id="analects-daily-container"></div>';
    }
}

The_Analects_SDK_Plugin::get_instance();
