export const CategoryIcon = () => {
    return (
        <svg fill="#1B73E8" xmlns="http://www.w3.org/2000/svg" width={16} height={16}>
            <path d="M15.132 1.6h-6.28a.725.725 0 0 0-.721.721v3.226a.725.725 0 0 0 .721.721h.549v1.27a.235.235 0 0 0 .137.206c.034 0 .069.034.103.034a.178.178 0 0 0 .137-.069l1.681-1.441h3.672a.725.725 0 0 0 .721-.721V2.321a.75.75 0 0 0-.721-.721zm-4.495 2.231-.343.343.069.446a.126.126 0 0 1-.006.055.14.14 0 0 1-.029.048h-.103l-.412-.206-.377.172h-.103a.132.132 0 0 1-.029-.048.13.13 0 0 1-.006-.055l.069-.446-.343-.343a.132.132 0 0 1-.029-.048.13.13 0 0 1-.006-.055c.034 0 .069-.034.103-.034l.48-.069.206-.412c0-.034.034-.034.069-.034a.12.12 0 0 1 .069.034l.206.412.48.069a.077.077 0 0 1 .069.069.128.128 0 0 1-.006.055.14.14 0 0 1-.029.048zm2.128 0-.343.343.069.446a.126.126 0 0 1-.006.055.14.14 0 0 1-.029.048h-.103l-.412-.206-.377.172h-.103a.132.132 0 0 1-.029-.048.13.13 0 0 1-.006-.055l.069-.446-.343-.343a.132.132 0 0 1-.029-.048.13.13 0 0 1-.006-.055.077.077 0 0 1 .069-.069l.48-.069.206-.412c0-.034.034-.034.069-.034a.12.12 0 0 1 .069.034l.206.412.515.103a.077.077 0 0 1 .069.069.128.128 0 0 1-.006.055.14.14 0 0 1-.029.048zm2.128 0-.343.343.069.446a.126.126 0 0 1-.006.055.14.14 0 0 1-.029.048h-.103l-.412-.206-.377.172h-.103a.132.132 0 0 1-.035-.103l.069-.446-.343-.343a.132.132 0 0 1-.029-.048.13.13 0 0 1-.006-.055.077.077 0 0 1 .069-.069l.48-.069.206-.412c0-.034.034-.034.069-.034a.12.12 0 0 1 .069.034l.206.412.515.103a.077.077 0 0 1 .069.069.128.128 0 0 1-.006.055.14.14 0 0 1-.029.048zm-9.747 0c-1.544 0-2.402.789-2.368 2.334.034 2.093.927 3.363 2.368 3.363 0 0 2.368.103 2.368-3.363 0-1.544-.789-2.334-2.368-2.334zM9.333 11.106l-2.368-.927-.549-.48a.378.378 0 0 0-.515.034l-.755.755-.789-.755a.41.41 0 0 0-.515-.034l-.515.48-2.368.961c-.755.309-.755 3.02-.824 3.26H10.19c-.069-.274-.069-2.985-.858-3.294z" />
        </svg>);
};

export const TestimonialIcon = () => {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            width={24}
            height={24}
            fill="none"
        >
            <g fill="#1B73E8" clipPath="url(#a)">
                <path d="M3 0h4v2H3c-.55 0-1 .45-1 1v18c0 .55.45 1 1 1h4v2H3a3.01 3.01 0 0 1-3-3V3a3.01 3.01 0 0 1 3-3zm18 0h-4v2h4c.55 0 1 .45 1 1v18c0 .55-.45 1-1 1h-4v2h4a3.01 3.01 0 0 0 3-3V3a3.01 3.01 0 0 0-3-3zm-2.642 6.299h-5.594a.646.646 0 0 0-.642.642v2.873a.646.646 0 0 0 .642.642h.489v1.131c.001.039.013.077.035.109s.052.058.087.074c.031 0 .061.03.092.03a.146.146 0 0 0 .068-.017.16.16 0 0 0 .054-.044l1.498-1.284h3.271A.646.646 0 0 0 19 9.813V6.941a.667.667 0 0 0-.642-.642zm-4.004 1.987-.306.306.061.397c.002.017 0 .033-.005.049s-.014.03-.026.042h-.092l-.367-.183-.336.153h-.092a.14.14 0 0 1-.026-.042.102.102 0 0 1-.005-.049l.061-.397-.306-.306a.14.14 0 0 1-.026-.042.102.102 0 0 1-.005-.049c.031 0 .061-.031.092-.031l.428-.061.183-.367c0-.031.031-.031.061-.031a.103.103 0 0 1 .061.031l.183.367.428.061c.016.001.03.008.042.019s.018.026.019.042 0 .033-.005.049-.014.03-.026.042zm1.895 0-.306.306.061.397c.002.017 0 .033-.005.049s-.014.03-.026.042h-.092l-.367-.183-.336.153h-.092c-.012-.012-.02-.027-.026-.042s-.007-.033-.005-.049l.061-.397-.306-.306a.14.14 0 0 1-.026-.042c-.006-.015-.007-.033-.005-.049s.008-.031.02-.042.026-.018.042-.019l.428-.061.183-.367c0-.031.031-.031.061-.031a.103.103 0 0 1 .061.031l.183.367.458.092c.016.001.03.008.042.019s.018.026.019.042 0 .033-.005.049-.014.03-.026.042zm1.895 0-.306.306.061.397c.002.017 0 .033-.005.049s-.014.03-.026.042h-.092l-.367-.183-.336.153h-.092c-.012-.012-.02-.027-.026-.042s-.007-.033-.005-.049l.061-.397-.306-.306a.14.14 0 0 1-.026-.042c-.006-.015-.007-.033-.005-.049s.008-.031.02-.042.026-.018.042-.019l.428-.061.183-.367c0-.031.031-.031.061-.031a.103.103 0 0 1 .061.031l.183.367.458.092a.068.068 0 0 1 .062.061c.002.016 0 .033-.005.049s-.014.03-.026.042zm-8.681 0c-1.376 0-2.14.703-2.109 2.079.031 1.865.825 2.996 2.109 2.996 0 0 2.109.092 2.109-2.996 0-1.375-.703-2.079-2.109-2.079z" />
                <path d="m13.192 14.766-2.109-.825-.489-.428a.33.33 0 0 0-.458.031l-.673.673-.703-.673a.367.367 0 0 0-.459-.031l-.459.428-2.109.856c-.672.275-.672 2.69-.734 2.904h8.956c-.061-.245-.061-2.659-.764-2.934z" />
            </g>
            <defs>
                <clipPath id="a">
                    <path fill="#fff" d="M0 0h24v24H0z" />
                </clipPath>
            </defs>
        </svg>
    );
};

export const TestimonialFormIcon = () => {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            width={24}
            height={24}
            fill="none"
        >
            <g fill="#1B73E8" clipPath="url(#a)">
                <path d="m18.3 8.55.75-.75.75-.75c.15-.15.15-.3.15-.45V3.3a3.33 3.33 0 0 0-3.3-3.3H3.3A3.33 3.33 0 0 0 0 3.3v17.55C0 22.5 1.5 24 3.3 24h13.65a3.33 3.33 0 0 0 3.3-3.3v-3.15c0-.3-.3-.3-.45-.15L18 19.05c-.15.15-.15.3-.15.45v1.35c0 .6-.45 1.05-1.05 1.05H3.3c-.6 0-1.05-.45-1.05-1.05V3.3c0-.6.45-1.05 1.05-1.05h13.65c.6 0 1.05.45 1.05 1.05v5.1c-.15.15.15.3.3.15zM14.7 6.3H5.55c-.6.15-1.2-.3-1.2-.9S4.8 4.2 5.4 4.2h9.15c.6 0 1.05.45 1.2 1.05S15.3 6.3 14.7 6.3zm0 4.5H5.55c-.6.15-1.2-.3-1.2-.9S4.8 8.7 5.4 8.7h9.15c.6 0 1.05.45 1.2 1.05s-.45 1.05-1.05 1.05zm-1.05 2.85-1.5 1.5c-.15.15-.3.15-.45.15H5.4c-.6 0-1.2-.45-1.2-1.2 0-.6.45-1.2 1.2-1.2h8.1c.3.3.45.6.15.75zm-4.5 6.15H5.4c-.6 0-1.05-.45-1.2-1.05 0-.6.45-1.2 1.05-1.2H9c.6 0 1.05.45 1.2 1.05.15.75-.3 1.2-1.05 1.2zM20.1 9.75s-.15-.15-.3-.15-.15 0-.3.15l-6.9 6.9-.15.15-.45 2.7c0 .15 0 .3.15.3.15.15.15.15.3.15l2.55-.6c.15 0 .15 0 .3-.15l6.9-6.9s.15-.15.15-.3 0-.15-.15-.3l-2.1-1.95zm3.75.3-2.1-2.1s-.15-.15-.3-.15-.15 0-.3.15L20.4 9s-.15.15-.15.3 0 .15.15.3l2.1 1.95s.15.15.3.15.15 0 .3-.15l.9-.9v-.3c0-.15 0-.15-.15-.3z" />
            </g>
            <defs>
                <clipPath id="a">
                    <path fill="#fff" d="M0 0h24v24H0z" />
                </clipPath>
            </defs>
        </svg>
    );
};

export const TestimonialPreviewImage = () => {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            xmlnsXlink="http://www.w3.org/1999/xlink"
            viewBox="0 0 250 148"
        >
            <style>
                {
                    ".X{fill-rule:evenodd}.Y{fill:#fff}.Z{font-family:Lato-Regular}.a{font-size:4.776px}.b{fill:#92653d}.c{stroke-miterlimit:10}.d{fill:#f5be92}.e{stroke-width:.638}"
                }
            </style>
            <g className="Y">
                <path d="M0 0h250v148H0z" />
                <path d="M0 0h250v148H0z" />
                <path
                    stroke="#d8d8d8"
                    strokeWidth={1.085}
                    d="M16.4 134h217.3c2.4 0 4.4-2 4.4-4.4V18.4c0-2.4-2-4.4-4.4-4.4H16.4C14 14 12 16 12 18.4v111.3c0 2.3 2 4.3 4.4 4.3z"
                    className="c"
                />
            </g>
            <text className="Z a" transform="translate(36.26 72.146)">
                {
                    "I was looking for a really good testimonial plugin for our business website and was not"
                }
            </text>
            <text className="Z a" transform="translate(36.762 78.522)">
                {
                    "having any luck finding one I liked or fulfilled our requirements. I was about to give up"
                }
            </text>
            <text className="Z a" transform="translate(40.353 84.87)">
                {
                    "and then I came across Testimonial-Best Testimonials Showcase Plugin for Word"
                }
            </text>
            <text className="Z a" transform="translate(207.127 84.87)">
                {"-"}
            </text>
            <text className="Z a" transform="translate(66.246 91.246)">
                {"Press. I bought the best testimonial plugin. Easy Enough!"}
            </text>
            <path d="M84.2 61.9c.2 0 .3 0 .4-.1l.3-.1V61h-.6v-.5h1.3V62c-.1.1-.2.1-.3.2s-.2.1-.3.1l-.4.1h-.4c-.3 0-.5-.1-.8-.1-.2-.1-.4-.2-.6-.4s-.3-.4-.4-.6-.1-.5-.1-.8.1-.5.1-.8c.1-.2.2-.4.4-.6s.4-.3.6-.4c.3-.1.5-.1.8-.1s.5 0 .8.1c.2.1.4.2.6.4l-.2.3c0 .1-.1.1-.2.1s-.1 0-.1-.1-.1-.1-.2-.1-.1-.1-.2-.1-.1-.1-.3-.1h-.3c-.2 0-.4 0-.5.1s-.3.2-.4.3-.2.3-.3.4c-.1.2-.1.4-.1.5 0 .2 0 .4.1.6s.1.3.3.4c.1.1.3.2.4.3.2.2.4.1.6.2zm2 .5v-2.7h.5l.1.1v.3c.1-.2.2-.3.3-.4s.3-.1.4-.1.3 0 .3.1l-.1.5v.1h-.4c-.1 0-.3 0-.4.1l-.3.3v1.7h-.4zm3.3-2.8a.9.9 0 0 1 .5.1c.1.1.3.1.4.3.1.1.2.2.3.4.1.1.1.3.1.5v.2H88.9c0 .3.1.5.2.6s.3.2.5.2h.3c.1 0 .1-.1.2-.1l.1-.1h.2l.1.1.2.3c-.1.1-.2.2-.3.2-.1.1-.2.1-.3.1l-.3.1h-.3c-.2 0-.4 0-.5-.1-.2 0-.3-.1-.4-.3-.1-.1-.2-.3-.3-.4-.1-.2-.1-.4-.1-.6s0-.4.1-.5c.1-.2.1-.3.3-.4.1-.1.3-.2.4-.3a.55.55 0 0 1 .5-.3zm0 .5c-.2 0-.3.1-.4.2a.76.76 0 0 0-.2.4h1.2v-.3c0-.1-.1-.1-.1-.1 0-.1-.1-.1-.2-.1-.1-.1-.2-.1-.3-.1zm3.8 2.3h-.4l-.1-.1-.1-.3-.2.2c-.1.1-.1.1-.2.1l-.2.1h-.3c-.1 0-.2 0-.3-.1-.1 0-.2-.1-.3-.1L91 62c-.1-.1-.1-.2-.1-.3s0-.2.1-.3l.3-.3c.2-.1.3-.1.5-.2s.5-.1.8-.1v-.2c0-.2 0-.3-.1-.4s-.2-.1-.3-.1h-.3c-.1 0-.1.1-.2.1l-.1.1h-.2l-.1-.1V60c.3-.3.7-.4 1.1-.4.2 0 .3 0 .4.1s.2.1.3.2.1.2.2.3.1.3.1.4l-.1 1.8zm-1.2-.5h.2c.1 0 .1 0 .2-.1l.1-.1c.1 0 .1-.1.1-.1v-.4h-.5l-.3.1c-.1 0-.1.1-.2.1 0 .1-.1.1-.1.2s0 .2.1.3c.2 0 .3.1.4 0zm2.8.5c-.2 0-.4-.1-.5-.2s-.2-.3-.2-.5v-1.5h-.4v-.4l.4-.1.1-.8s0-.1.1-.1h.4v.9h.7v.5h-.7v1.5c0 .1 0 .1.1.2s.1.1.2.1h.5v.1l.2.3c-.1.1-.2.1-.3.2-.3-.2-.4-.2-.6-.2zm2.9-1.4v1.4h-.7v-3.9h1.2c.3 0 .5 0 .7.1s.3.1.5.3c.1.1.2.3.3.4.1.2.1.3.1.5s0 .4-.1.5c-.1.2-.2.3-.3.4s-.3.2-.5.3h-1.2zm0-.5h.5c.1 0 .2 0 .3-.1s.2-.1.3-.1c.1-.1.1-.1.1-.2s.1-.2.1-.3 0-.2-.1-.3c0-.1-.1-.2-.1-.2 0-.1-.1-.1-.3-.1-.1 0-.2-.1-.3-.1h-.5v1.4zm3.3-2.1v4h-.7v-4h.7zm1.3 1.3v1.7c0 .2 0 .3.1.4s.2.1.3.1.2 0 .3-.1.2-.1.3-.2v-2h.7v2.7h-.4c-.1 0-.1 0-.2-.1l-.1-.2-.2.2c-.1.1-.1.1-.2.1s-.1.1-.2.1h-.3c-.1 0-.3 0-.4-.1s-.2-.1-.3-.2-.1-.2-.2-.3c0-.1-.1-.3-.1-.4v-1.7h.9zM105.8 59.6h.3l.3.1h.8v.4s-.1 0-.1.1l-.3.1V60.6c0 .1 0 .2-.1.4-.1.1-.1.2-.2.3s-.2.1-.3.2c-.1 0-.3.1-.4.1h-.3c-.1.1-.1.1-.1.2s0 .1.1.1.1.1.2.1h.6c.1 0 .2 0 .3.1l.3.1c.1 0 .1.1.2.2s.1.2.1.3 0 .2-.1.4c-.1.1-.1.2-.3.3s-.3.2-.4.2c-.2.1-.4.1-.5.1-.2 0-.4 0-.5-.1a.76.76 0 0 1-.4-.2c-.1-.1-.2-.1-.2-.2-.1-.1-.1-.2-.1-.3s0-.2.1-.3.2-.2.3-.2c-.1 0-.1-.1-.2-.1 0-.1-.1-.1-.1-.3v-.1c0-.1 0-.1.1-.1 0-.1.1-.1.1-.1.1 0 .1-.1.2-.1-.1-.1-.3-.2-.3-.3-.1-.1-.1-.3-.1-.4s0-.2.1-.4c.1-.1.1-.2.2-.3s.2-.1.3-.2c.1-.4.3-.4.4-.4zm.7 2.9c0-.1 0-.1-.1-.1s-.1-.1-.1-.1c-.1 0-.1 0-.2-.1s-.1 0-.2 0h-.6c-.1 0-.1.1-.2.1-.1.1-.1.1-.1.2v.1c0 .1.1.1.1.1.1 0 .1.1.2.1h.6l.2-.1c.1 0 .1-.1.1-.1.3 0 .3-.1.3-.1zm-.7-1.5h.2l.1-.1.1-.1v-.2c0-.1 0-.3-.1-.3-.1-.1-.2-.1-.4-.1s-.3 0-.3.1c-.1.1-.1.2-.1.3v.2c0 .1.1.1.1.1l.1.1h.3zm2.6-2.1v.2c0 .1-.1.1-.1.1l-.1.1h-.4l-.1-.1-.1-.1v-.4c0-.1.1-.1.1-.1l.1-.1h.4c.1 0 .1.1.1.1l.1.1v.2zm-.1.8v2.7h-.7v-2.7h.7zm.7 2.7v-2.7h.4c.1 0 .1 0 .2.1l.1.2.2-.2c.1-.1.1-.1.2-.1s.1-.1.2-.1h.3c.1 0 .3 0 .4.1s.2.1.3.2.1.2.2.3.1.3.1.4v1.7h-.7v-1.7c0-.2 0-.3-.1-.4s-.2-.1-.3-.1-.2 0-.3.1-.2.1-.3.2v2h-.9zm3.8-2.7h.6l.1.1.4 1.4c0 .1 0 .2.1.2v.2l.1-.2.1-.2.4-1.4s0-.1.1-.1h.5l.1.1.4 1.5c0 .1.1.1.1.2l.1.2v-.2c0-.1 0-.2.1-.2l.4-1.4s0-.1.1-.1h.6l-.9 2.7h-.6c-.1 0-.1 0-.1-.1l-.5-1.6c0-.1 0-.1-.1-.2v-.2.2c0 .1 0 .1-.1.2l-.5 1.6c0 .1-.1.1-.1.1h-.5l-.9-2.8zm5.3-.8v.2c0 .1-.1.1-.1.1l-.1.1h-.4l-.1-.1-.1-.1v-.4l.1-.1.1-.1h.4c.1 0 .1.1.1.1l.1.1v.2zm-.1.8v2.7h-.7v-2.7h.7zm1.6 2.7c-.2 0-.4-.1-.5-.2s-.2-.3-.2-.5v-1.5h-.4v-.4l.4-.1.1-.8s0-.1.1-.1h.4v.9h.7v.5h-.7v1.5c0 .1 0 .1.1.2s.1.1.2.1h.5v.1l.2.3c-.1.1-.2.1-.3.2-.3-.2-.5-.2-.6-.2zm1.2 0v-4h.7v1.5c.1-.1.2-.2.4-.3.1-.1.3-.1.4-.1s.3 0 .4.1.2.1.3.2.1.2.2.3.1.3.1.4v1.7h-.6v-1.7c0-.2 0-.3-.1-.4s-.2-.1-.3-.1-.2 0-.3.1-.2.1-.3.2v2l-.9.1zm7.4 0h-.5c-.1 0-.1 0-.1-.1l-.1-.1-.3-.8h-1.6l-.3.8-.1.1-.1.1h-.5l1.5-3.9h.7l1.4 3.9zm-2.5-1.5h1.2l-.5-1.3c0-.1-.1-.1-.1-.2l-.1-.3-.1.3c0 .1-.1.1-.1.2l-.3 1.3zm2.5-1.2h.6l.1.1.4 1.4c0 .1 0 .2.1.2v.2l.1-.2.1-.2.4-1.4s0-.1.1-.1h.5l.1.1.4 1.5c0 .1.1.1.1.2l.1.2v-.2c0-.1 0-.2.1-.2l.4-1.4s0-.1.1-.1h.6l-.9 2.7h-.5c-.1 0-.1 0-.1-.1l-.5-1.6c0-.1 0-.1-.1-.2v-.2.2c0 .1 0 .1-.1.2l-.5 1.6c0 .1-.1.1-.1.1h-.7l-.8-2.8zm5.7-.1a.9.9 0 0 1 .5.1c.1.1.3.1.4.3a1.38 1.38 0 0 1 .3.4c.1.2.1.3.1.5v.2H133.3c0 .3.1.5.2.6s.3.2.5.2h.3c.1 0 .1-.1.2-.1l.1-.1h.2l.1.1.2.3c-.1.1-.2.2-.3.2-.1.1-.2.1-.3.1l-.3.1h-.3c-.2 0-.4 0-.5-.1a1.38 1.38 0 0 1-.4-.3c-.1-.1-.2-.3-.3-.4-.1-.2-.1-.4-.1-.6s0-.4.1-.5c.1-.2.1-.3.3-.4.1-.1.3-.2.4-.3a.55.55 0 0 1 .5-.3zm0 .5c-.2 0-.3.1-.4.2a.76.76 0 0 0-.2.4h1.2v-.3c0-.1-.1-.1-.1-.2-.1-.1-.1-.1-.2-.1h-.3zm3.3.1c-.1.1-.1.1-.2.1h-.1s-.1 0-.1-.1c-.1 0-.1-.1-.2-.1h-.2c-.1 0-.2 0-.3.1s-.1.1-.1.2 0 .1.1.1.1.1.1.1.1.1.2.1l.5.2c.1 0 .1.1.2.1.1.1.1.1.1.2s.1.2.1.3 0 .2-.1.4c-.1.1-.1.2-.2.3s-.2.1-.3.2-.3.1-.5.1h-.3c-.1 0-.2 0-.3-.1-.1 0-.2-.1-.2-.1-.1 0-.1-.1-.2-.1l.1-.3.1-.1h.2l.1.1.2.1h.5l.1-.1.1-.1v-.1c0-.1 0-.1-.1-.2 0-.1-.1-.1-.1-.1-.1 0-.1-.1-.2-.1l-.3-.1-.3-.1-.2-.1c-.1-.1-.1-.1-.1-.2s-.1-.2-.1-.3 0-.2.1-.3.1-.2.2-.3.2-.1.3-.2c.1 0 .3-.1.4-.1.2 0 .4 0 .5.1s.3.1.4.3l.1.2zm1.9-.6c.2 0 .4 0 .5.1a1.38 1.38 0 0 1 .4.3c.1.1.2.3.3.4.1.2.1.4.1.6s0 .4-.1.6a1.38 1.38 0 0 1-.3.4c-.1.1-.3.2-.4.3-.2.1-.4.1-.5.1s-.4 0-.5-.1a1.38 1.38 0 0 1-.4-.3c-.1-.1-.2-.3-.3-.4-.1-.2-.1-.4-.1-.6s0-.4.1-.6a1.38 1.38 0 0 1 .3-.4c.1-.1.3-.2.4-.3.1 0 .3-.1.5-.1zm0 2.3c.2 0 .4-.1.5-.2s.2-.4.2-.7-.1-.5-.2-.7-.3-.2-.5-.2-.4.1-.5.2c-.1.2-.2.4-.2.7s.1.5.2.7c.1.1.3.2.5.2zm1.9.5v-2.7h.4c.1 0 .1 0 .2.1l.1.2.1-.1c.1-.1.1-.1.2-.1s.1-.1.2-.1h.2c.1 0 .3 0 .4.1a1.38 1.38 0 0 1 .3.4c.1-.1.1-.2.2-.2l.2-.2c.1 0 .2-.1.3-.1h.3c.1 0 .3 0 .4.1.1 0 .2.1.3.2s.1.2.2.3c0 .1.1.3.1.4v1.7h-.7v-1.7c0-.2 0-.3-.1-.4s-.2-.1-.3-.1h-.2c-.1 0-.1.1-.1.1-.1.1-.1.1-.1.2v1.9h-.7v-1.7c0-.2 0-.3-.1-.4s-.2-.1-.3-.1-.2 0-.3.1-.2.1-.2.2v2c-.4-.1-1-.1-1-.1zm5.5-2.8a.9.9 0 0 1 .5.1c.1.1.3.1.4.3a1.38 1.38 0 0 1 .3.4c.1.1.1.3.1.5v.2H145.9c0 .3.1.5.2.6s.3.2.5.2h.3c.1 0 .1-.1.2-.1l.1-.1h.2l.1.1.2.3c-.1.1-.2.2-.3.2-.1.1-.2.1-.3.1l-.3.1h-.3c-.2 0-.4 0-.5-.1a1.38 1.38 0 0 1-.4-.3c-.1-.1-.2-.3-.3-.4-.1-.2-.1-.4-.1-.6s0-.4.1-.5c.1-.2.1-.3.3-.4.1-.1.3-.2.4-.3a.55.55 0 0 1 .5-.3zm0 .5c-.2 0-.3.1-.4.2a.76.76 0 0 0-.2.4h1.2v-.3c0-.1-.1-.1-.1-.2s-.1-.1-.2-.1h-.3zm4.9-.9c-.1.1-.1.1 0 0-.1.1-.1.1-.2.1h-.1c-.1 0-.1-.1-.2-.1s-.1-.1-.2-.1h-.6c-.1 0-.1.1-.2.1s-.1.1-.1.1v.2c0 .1 0 .2.1.2l.2.2c.1.1.2.1.3.1s.2.1.3.1.2.1.3.1c.1.1.2.1.3.2s.1.2.2.3.1.3.1.4c0 .2 0 .3-.1.5s-.1.3-.3.4c-.1.1-.3.2-.4.3-.2.1-.4.1-.5.1h-.4l-.3-.1c-.1-.1-.2-.1-.3-.2s-.2-.1-.3-.2l.2-.3.1-.1h.1c.1 0 .1 0 .1.1s.1.1.2.1c.1.1.2.1.3.1s.2.1.3.1c.2 0 .3 0 .5-.1.1-.1.2-.2.2-.4 0-.1 0-.2-.1-.3l-.2-.2c-.1-.1-.2-.1-.3-.1l-.3-.1c-.1 0-.2-.1-.3-.1-.1-.1-.2-.1-.3-.2s-.1-.2-.2-.3-.1-.3-.1-.4 0-.3.1-.4.1-.3.3-.4c.1-.1.3-.2.4-.3.2-.1.3-.1.5-.1s.4 0 .6.1.4.2.5.3l-.2.3zm1.3.5v1.7c0 .2 0 .3.1.4s.2.1.3.1.2 0 .3-.1.2-.1.3-.2v-2h.7v2.7h-.4c-.1 0-.1 0-.2-.1l-.1-.2-.2.2c-.1.1-.1.1-.2.1s-.1.1-.2.1h-.3c-.1 0-.3 0-.4-.1s-.2-.1-.3-.2-.1-.2-.2-.3c0-.1-.1-.3-.1-.4v-1.7h.9zm2.4 3.6v-3.6h.5l.1.1.1.3a1.38 1.38 0 0 1 .4-.3c.1-.1.3-.1.5-.1.1 0 .3 0 .4.1l.3.3a.76.76 0 0 1 .2.4c.1.2.1.4.1.6s0 .4-.1.5c-.1.2-.1.3-.2.4s-.2.2-.4.3-.3.1-.5.1-.3 0-.4-.1-.2-.1-.3-.2v1.1l-.7.1zm1.3-3.2c-.1 0-.3 0-.4.1s-.2.1-.3.3v1.2c.1.1.2.2.3.2s.2.1.3.1.2 0 .3-.1l.2-.2c.1-.1.1-.2.1-.3s.1-.3.1-.4v-.4l-.1-.3c0-.1-.1-.1-.2-.1-.1-.1-.2-.1-.3-.1zm1.7 3.2v-3.6h.5l.1.1.1.3a1.38 1.38 0 0 1 .4-.3c.1-.1.3-.1.5-.1.1 0 .3 0 .4.1l.3.3a.76.76 0 0 1 .2.4c.1.2.1.4.1.6s0 .4-.1.5c-.1.2-.1.3-.2.4s-.2.2-.4.3-.3.1-.5.1c-.1 0-.3 0-.4-.1s-.2-.1-.3-.2v1.1l-.7.1zm1.3-3.2c-.1 0-.3 0-.4.1s-.2.1-.3.3v1.2c.1.1.2.2.3.2s.2.1.3.1.2 0 .3-.1l.2-.2c.1-.1.1-.2.1-.3s.1-.3.1-.4v-.4l-.1-.3c-.1-.1-.1-.1-.2-.1-.1-.1-.2-.1-.3-.1zm2.9-.5c.2 0 .4 0 .5.1a1.38 1.38 0 0 1 .4.3c.1.1.2.3.3.4.1.2.1.4.1.6s0 .4-.1.6a1.38 1.38 0 0 1-.3.4c-.1.1-.3.2-.4.3-.2.1-.4.1-.5.1s-.4 0-.5-.1a1.38 1.38 0 0 1-.4-.3c-.1-.1-.2-.3-.3-.4-.1-.2-.1-.4-.1-.6s0-.4.1-.6a1.38 1.38 0 0 1 .3-.4c.1-.1.3-.2.4-.3.1 0 .3-.1.5-.1zm0 2.3c.2 0 .4-.1.5-.2s.2-.4.2-.7-.1-.5-.2-.7-.3-.2-.5-.2-.4.1-.5.2c-.1.2-.2.4-.2.7s.1.5.2.7.3.2.5.2zm1.8.5v-2.7h.5l.1.1v.3a1.38 1.38 0 0 1 .3-.4c.1-.1.3-.1.4-.1s.3 0 .3.1l-.1.5v.1h-.4c-.1 0-.3 0-.4.1l-.3.3v1.7h-.4zm3.1 0c-.2 0-.4-.1-.5-.2s-.2-.3-.2-.5v-1.5h-.4v-.4l.4-.1.1-.8s0-.1.1-.1h.4v.9h.7v.5h-.7v1.5c0 .1 0 .1.1.2s.1.1.2.1h.5v.1l.2.3c-.1.1-.2.1-.3.2-.3-.2-.5-.2-.6-.2z" />
            <path
                fill="#ffae04"
                d="m113.4 104.8.7 1.7 1.8.1c.1 0 .2.2.1.3l-1.3 1.2.4 1.7c0 .1-.1.2-.2.1l-1.5-.9-1.5.9c-.1.1-.3 0-.2-.1l.4-1.7-1.3-1.2c-.1-.1-.1-.2.1-.3l1.8-.1.7-1.7c-.2-.1 0-.1 0 0zm5.9 0 .7 1.7 1.8.1c.1 0 .2.2.1.3l-1.3 1.2.4 1.7c0 .1-.1.2-.2.1l-1.5-.9-1.5.9c-.1.1-.3 0-.2-.1l.4-1.7-1.3-1.2c-.1-.1-.1-.2.1-.3l1.8-.1.7-1.7c-.2-.1-.1-.1 0 0zm5.8 0 .7 1.7 1.8.1c.1 0 .2.2.1.3l-1.3 1.2.4 1.7c0 .1-.1.2-.2.1l-1.5-.9-1.5.9c-.1.1-.3 0-.2-.1l.4-1.7-1.3-1.2c-.1-.1-.1-.2.1-.3l1.8-.1.7-1.7c-.2-.1 0-.1 0 0zm5.9 0 .7 1.7 1.8.1c.1 0 .2.2.1.3l-1.3 1.2.4 1.7c0 .1-.1.2-.2.1l-1.5-.9-1.5.9c-.1.1-.3 0-.2-.1l.4-1.7-1.3-1.2c-.1-.1-.1-.2.1-.3l1.8-.1.7-1.7c-.2-.1 0-.1 0 0zm5.9 0 .7 1.7 1.8.1c.1 0 .2.2.1.3l-1.3 1.2.4 1.7c0 .1-.1.2-.2.1l-1.5-.9-1.5.9c-.1.1-.3 0-.2-.1l.4-1.7-1.3-1.2c-.1-.1-.1-.2.1-.3l1.8-.1.7-1.7c-.2-.1-.1-.1 0 0z"
            />
            <path
                fill="#454545"
                d="m24.8 72.9 1.5-1.5.1-.1s0-.1-.1-.1l-.1-.1-.1-.1c-.1 0-.1 0-.1.1l-1.8 1.8-.1.1c0 .1 0 .1.1.1l1.8 1.8.1.1c.1 0 .1 0 .1-.1l.1-.1c.1-.1.1-.2 0-.3l-1.5-1.6zm200.4 0-1.5 1.5-.1.1c0 .1 0 .1.1.1l.1.1.1.1c.1 0 .1 0 .1-.1l1.8-1.8.1-.1c0-.1 0-.1-.1-.1l-1.8-1.8-.1-.1c-.1 0-.1 0-.1.1l-.1.1c-.1.1-.1.2 0 .3l1.5 1.6z"
            />
            <use xlinkHref="#B" fill="#ddd" />
            <defs>
                <filter
                    id="A"
                    width={21.7}
                    height={21.7}
                    x={114.2}
                    y={29.3}
                    filterUnits="userSpaceOnUse"
                >
                    <feColorMatrix values="1 0 0 0 0 0 1 0 0 0 0 0 1 0 0 0 0 0 1 0" />
                </filter>
                <path
                    id="B"
                    d="M125 51c6 0 10.8-4.9 10.8-10.8 0-6-4.9-10.8-10.8-10.8-6 0-10.8 4.9-10.8 10.8S119 51 125 51z"
                />
            </defs>
            <mask
                id="C"
                width={21.7}
                height={21.7}
                x={114.2}
                y={29.3}
                maskUnits="userSpaceOnUse"
            >
                <path
                    d="M125 51c6 0 10.8-4.9 10.8-10.8 0-6-4.9-10.8-10.8-10.8-6 0-10.8 4.9-10.8 10.8S119 51 125 51z"
                    className="Y"
                    filter="url(#A)"
                />
            </mask>
            <g mask="url(#C)">
                <use xlinkHref="#B" fill="#ddd" />
            </g>
            <defs>
                <filter
                    id="D"
                    width={16.2}
                    height={18.9}
                    x={117}
                    y={32.2}
                    filterUnits="userSpaceOnUse"
                >
                    <feColorMatrix values="1 0 0 0 0 0 1 0 0 0 0 0 1 0 0 0 0 0 1 0" />
                </filter>
            </defs>
            <mask
                id="E"
                width={16.2}
                height={18.9}
                x={117}
                y={32.2}
                maskUnits="userSpaceOnUse"
            >
                <path
                    d="M125 51c6 0 10.8-4.9 10.8-10.8 0-6-4.9-10.8-10.8-10.8-6 0-10.8 4.9-10.8 10.8S119 51 125 51z"
                    className="Y"
                    filter="url(#D)"
                />
            </mask>
            <g mask="url(#E)">
                <path
                    d="M121.3 39.3c.3-.1.4-.6.2-1.1s-.6-.9-.9-.8-.4.6-.2 1.1.6.9.9.8zm8.4-.7c.2-.5.1-1-.2-1.1s-.7.2-.9.8-.1 1 .2 1.1.7-.3.9-.8z"
                    className="d"
                />
                <path
                    d="M127.9 33.4c.8.1 1.3.7 1.5 1.5.5 2-.5 6.4-4.3 6.5-1.9 0-3.3-.5-3.8-2-.5-1.6-.7-4.1.4-5.5 1.3-1.9 4.3-1.9 6.2-.5z"
                    className="X b"
                />
                <path
                    fill="#4c9dd2"
                    stroke="#4c9dd2"
                    strokeLinejoin="round"
                    strokeWidth={0.346}
                    d="M123.5 43.7c-3.5 1.5-4.6 2.4-4.9 2.7-.6.5-1 2.7-1.4 4.5H133c-.4-1.8-.7-4-1.3-4.5-.4-.4-1.4-1.2-4.9-2.7h-3.3z"
                    className="X c"
                />
                <path
                    d="M123.3 40.7v4.2c1 1.1 2.5 1.1 3.4 0v-4.1c.1-2.2-3.4-2.2-3.4-.1z"
                    className="X d"
                />
                <path
                    d="M125.1 33.7c-5.7 0-3.6 7.4-3.3 8 .4.6 2.4 1.7 3.3 1.7s2.9-1.2 3.3-1.8c.3-.6 2.4-7.9-3.3-7.9z"
                    className="X d"
                />
                <path
                    d="M122.3 35.5c1 .6 1.8-.3 2.7.1s3.5-.7 4 3.4c.9-3-.6-5.5-3.9-5.6-3.5-.1-4.9 2.6-3.9 5.5-.1-1.6.3-2.6 1.1-3.4z"
                    className="X b"
                />
                <path
                    stroke="#fff"
                    d="m123.2 43.7-1.2.6 1.8 2.4 1.3-1.2-1.9-1.8z"
                    className="X Y c e"
                />
                <path
                    stroke="#fff"
                    d="m126.9 43.7 1.2.6-1.8 2.4-1.3-1.2 1.9-1.8z"
                    className="X Y c e"
                />
                <path
                    d="M122.2 35.2c.1.5.8.5 1.2.6.8.1 1.7-.2 2.3-.7.1 0 0-.1 0-.1-.7 0-1.3.4-1.9.5-.5.1-1.2 0-1.6-.3z"
                    className="b"
                />
                <path
                    d="M122.7 38.9s.2.3.8.3.7-.3.7-.4c0 0-.2-.4-.7-.4s-.8.5-.8.5z"
                    className="Y"
                />
                <radialGradient
                    id="F"
                    cx={561.701}
                    cy={-137.201}
                    r={1}
                    gradientTransform="matrix(.3255 0 0 -.3255 -59.368 -5.784)"
                    gradientUnits="userSpaceOnUse"
                >
                    <stop offset={0} stopColor="#624a2e" />
                    <stop offset={0.036} stopColor="#6d5633" />
                    <stop offset={0.122} stopColor="#816b3d" />
                    <stop offset={0.223} stopColor="#907c45" />
                    <stop offset={0.348} stopColor="#9b884a" />
                    <stop offset={0.523} stopColor="#a18f4d" />
                    <stop offset={1} stopColor="#a3914e" />
                </radialGradient>
                <path
                    fill="url(#F)"
                    d="M123.4 39.2c.2 0 .3-.1.3-.3s-.1-.3-.3-.3-.3.1-.3.3c0 .1.2.3.3.3z"
                />
                <path
                    fill="#624a2e"
                    d="M123.4 38.6c.2 0 .3.1.3.3s-.1.3-.3.3-.3-.1-.3-.3c.1-.2.2-.3.3-.3zm0-.1c-.2 0-.4.2-.4.4s.2.4.4.4.4-.2.4-.4-.1-.4-.4-.4z"
                />
                <path d="M123.4 39c.1 0 .1-.1.1-.1 0-.1-.1-.1-.1-.1l-.1.1.1.1z" />
                <path
                    d="M127.4 38.9s-.2.3-.8.3c-.5 0-.7-.3-.7-.4 0 0 .2-.4.7-.4.5.1.8.5.8.5z"
                    className="Y"
                />
                <radialGradient
                    id="G"
                    cx={-1109.701}
                    cy={688.101}
                    r={1}
                    gradientTransform="matrix(-.3255 0 0 .3255 -234.548 -185.089)"
                    gradientUnits="userSpaceOnUse"
                >
                    <stop offset={0} stopColor="#624a2e" />
                    <stop offset={0.036} stopColor="#6d5633" />
                    <stop offset={0.122} stopColor="#816b3d" />
                    <stop offset={0.223} stopColor="#907c45" />
                    <stop offset={0.348} stopColor="#9b884a" />
                    <stop offset={0.523} stopColor="#a18f4d" />
                    <stop offset={1} stopColor="#a3914e" />
                </radialGradient>
                <path
                    fill="url(#G)"
                    d="M126.7 39.2c.2 0 .3-.1.3-.3s-.1-.3-.3-.3-.3.1-.3.3c-.1.1.1.3.3.3z"
                />
                <path
                    fill="#624a2e"
                    d="M126.7 38.6c.2 0 .3.1.3.3s-.1.3-.3.3-.3-.1-.3-.3c-.1-.2.1-.3.3-.3zm0-.1c-.2 0-.4.2-.4.4s.2.4.4.4.4-.2.4-.4c-.1-.2-.3-.4-.4-.4z"
                />
                <path d="M126.7 39c.1 0 .1-.1.1-.1 0-.1-.1-.1-.1-.1l-.1.1c-.1 0 0 .1.1.1z" />
                <path
                    fill="#e48f67"
                    d="M124.4 40.4c-.1.1-.1.1 0 .2.2.1.4.1.5.1.2 0 .4 0 .6-.1.1-.1.1-.2 0-.3h-.1v.1c0 .1-.1.1-.1.1-.1.1-.3.1-.4.1s-.6.1-.5-.2zm-.4 1.5c.6.4 1.6.3 2.2-.1-.8.3-1.5.4-2.2.1 0 0 0-.1 0 0z"
                />
                <path
                    d="M122.1 37.6c.7-.1 1.4-.2 2 .2.1 0 .1-.1.1-.1-.6-.4-1.6-.5-2.1-.1zm5.9 0c-.5-.4-1.6-.3-2.1.1-.1 0 0 .1.1.1.6-.4 1.3-.3 2-.2z"
                    className="b"
                />
                <path
                    fill="#0a6f90"
                    d="M126.6 40.3c1-.1 1.2-.5 1.3-1s.1-.8.3-.8c.1 0 .1-.2.1-.3s0-.2-.2-.2c-.1-.1-.9-.1-1.4-.1v.1c.4 0 .9 0 1 .1.3.2.2 1.1 0 1.5-.2.3-.6.4-1 .5l-.1.2zm-1.6-2.1c-.2 0-1-.2-1.6-.3h-.1v.1c.5 0 1 .1 1.1.4.3.4-.2 1.4-.6 1.6-.1.1-.3.1-.5.1v.1c.8 0 1-.5 1.1-.7.2-.3.1-.8.6-.8.4 0 .4.5.5.8.1.2.3.8 1.1.7v-.1c-.2 0-.4 0-.5-.1-.4-.2-.8-1.2-.5-1.6.2-.3.6-.4 1.1-.4v-.1h-.1c-.5 0-1.2.3-1.6.3zm-1.7-.3c-.5 0-1.3 0-1.4.1-.2.1-.2.1-.2.2s0 .3.1.3c.1.1.1.3.2.8s.3.9 1.1 1h.1v-.2c-.4 0-.9-.1-1-.5-.2-.4-.3-1.3.1-1.5.1-.1.5-.1 1-.1v-.1z"
                    className="X"
                />
                <path
                    d="M128.7 36.8c-.2 0-.3-.1-.4-.2s-.1-.1-.1-.2 0-.1-.1-.2c0 0-.1-.1-.1 0V36c0-.1-.1-.2-.2-.1-.1 0-.1.1-.1.1 0-.1-.1-.2-.2-.2h-.4v-.1c-.1-.2-.2-.3-.3-.4s-.3-.1-.3.1c0-.1-.1-.1-.1-.1-.1-.1-.1-.1-.2 0v.2c-.1 0-.1.1-.2.1l-.6-.3c-.1-.1-.1-.1-.2 0-.1-.1-.2-.1-.3.1-.3.5-.5 0-.8-.1-.1-.1-.2 0-.2.1v.1s0-.1-.1-.1c-.1-.1-.2-.1-.3 0-.2.2-.5.3-.8.3h-.1c.1 0 .1-.1.1-.1 0-.1 0-.1-.1-.1s-.2-.1-.3-.1-.1.1-.1.1c-.1-.1-.2-.1-.3-.2h-.1c-.2.9 1.1.8 1.8.5.4.5 1.4.6 1.7 0 .2.2.5.3.8.2.1 0 .2 0 .2-.1l.3.3c.3.2.6.2 1 .1.1 0 .1-.1.1-.1 0 .2.1.4.2.5.2.3.5.4.9.4 0 0 .1-.2-.1-.3zm-6.9-2.6c.1-.1.1-.1 0 0 .2-.1.3-.1.3-.2 0-.3 0-.4.3-.5.2-.1.4 0 .6 0 .1 0 .2-.2.1-.3s-.2-.1-.3-.2c.1 0 .1-.1.1-.1h.1v.2c0 .1.1.1.1 0s0-.1.1-.2c.1 0 .1.1.2 0 .1 0 .1-.1.1-.1.1 0 .1.1.2.1l.2.2c.1 0 .1 0 .1-.1s-.1-.2-.2-.3c.1-.2.3-.2.5-.1 0 .1 0 .1.1.1l.2.1c0 .1 0 .2.1.3s.1.1.1 0c0-.4.3-.4.5-.4a.76.76 0 0 1 .4.2l.3.3c.1 0 .1 0 .1-.1.1-.4-.6-.7-.9-.7-.2 0-.4 0-.5.1l-.1.1c-.3-.3-1-.3-1.1.1h-.4c-.2 0-.4 0-.5.1s-.2.1-.3.3v.1c-.2 0-.4 0-.5.1-.4.1-.4.5-.4.8-.4.1-.8.7-.6 1 0 .1.1.2.1.3-.2 0-.3.1-.3.3-.3.3-.3.7 0 1 0 0 0 .1.1.1h.1c.1 0 .3-.1.2-.3-.1-.1-.1-.3-.1-.5 0-.1 0-.1.1-.1h.1c.1 0 .1-.1.2-.1h.1c.2 0 .1-.2 0-.3.1-.1.1-.2 0-.3-.2-.2 0-.5.3-.7 0-.2.1-.2.1-.3z"
                    className="b"
                />
            </g>
            <text
                fontFamily="Lato-Heavy"
                fontSize={4.455}
                transform="translate(107.455 101.021)"
            >
                {"Mechiel Couvaras"}
            </text>
            <text
                fontFamily="Lato-Bold"
                fontSize={4.455}
                transform="translate(106.404 117.422)"
            >
                {"CEO - SmartGeeky"}
            </text>
        </svg>
    );
};

export const TestimonialFormPreviewImage = () => {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            xmlnsXlink="http://www.w3.org/1999/xlink"
            viewBox="0 0 250 234"
        >
            <g fill="#fff">
                <path d="M0-.2h250v234.3H0z" />
                <path
                    stroke="#d8d8d8"
                    strokeMiterlimit={10}
                    strokeWidth={1.43}
                    d="M17.8 222.2h212.4c3.2 0 5.8-2.6 5.8-5.8V17.6c0-3.2-2.6-5.8-5.8-5.8H17.8c-3.2 0-5.8 2.6-5.8 5.8v198.9c0 3.1 2.6 5.7 5.8 5.7z"
                />
            </g>
            <path d="M59.5 24.5c0-.1 0-.2-.1-.3 0-.1-.1-.2-.2-.3s-.2-.1-.3-.2c-.1 0-.2-.1-.3-.1-.3 0-.5.1-.6.2-.2.2-.2.4-.3.6h1.8zm-1.8.5c0 .2 0 .4.1.5s.1.3.2.4.2.2.3.2.3.1.4.1h.4c.1 0 .2-.1.3-.1s.1-.1.2-.1.1-.1.2-.1.1 0 .1.1l.2.3-.3.3c-.1.1-.2.1-.3.2-.1 0-.2.1-.4.1h-.4c-.2 0-.5 0-.7-.1s-.4-.2-.5-.4c-.2-.2-.3-.4-.4-.6-.1-.4-.1-.7-.1-1 0-.2 0-.5.1-.7s.2-.4.3-.5c.1-.2.3-.3.5-.4s.4-.1.7-.1c.2 0 .4 0 .6.1s.3.2.5.3c.1.1.2.3.3.5s.1.4.1.7v.2l-.1.1h-2.3zm-6.2 1.6v-3.5h.4c.1 0 .2 0 .2.1v.3l.2-.2.2-.2c.1 0 .2-.1.3-.1h.6c.1 0 .2.1.2.1l.2.2c.1.1.1.2.1.3.1-.1.1-.2.2-.3s.2-.2.3-.2c.1-.1.2-.1.3-.1h.3c.2 0 .4 0 .5.1s.3.1.4.3a.76.76 0 0 1 .2.4c0 .1.1.4.1.6v2.2h-.7v-2.2c0-.2-.1-.4-.2-.6-.1-.1-.3-.2-.5-.2h-.3c-.1 0-.2.1-.2.1-.1.1-.1.1-.1.2s-.1.2-.1.3v2.2h-.7v-2.2c0-.3-.1-.4-.2-.6-.1-.1-.3-.2-.5-.2-.1 0-.3 0-.4.1l-.3.3v2.6h-.5zm-1.6-1.5c-.3 0-.5 0-.7.1-.2 0-.3.1-.4.1-.1.1-.2.1-.2.2s-.1.1-.1.2v.2c0 .1.1.1.1.1s.1.1.2.1h.2c.2 0 .4 0 .5-.1s.3-.2.4-.3v-.6zm-2-1.5c.4-.4.9-.6 1.4-.6.2 0 .4 0 .5.1a1.38 1.38 0 0 1 .4.3.76.76 0 0 1 .2.4.9.9 0 0 1 .1.5v2.2H50l-.1-.1.1-.2c-.1.1-.2.2-.3.2-.1.1-.2.1-.3.2-.1 0-.2.1-.3.1h-.3c-.1 0-.3 0-.4-.1-.1 0-.2-.1-.3-.2s-.2-.2-.2-.3c-.1-.1-.1-.3-.1-.4s0-.3.1-.4a1.38 1.38 0 0 1 .4-.3c.2-.1.4-.2.7-.3s.6-.1 1-.1v-.2c0-.3-.1-.4-.2-.6-.1-.1-.3-.2-.5-.2-.1 0-.3 0-.4.1-.1 0-.2.1-.3.1s-.1.1-.2.1-.1.1-.2.1h-.1l-.1-.1-.1-.3zm-.8-1.9v4.9H46.5l-.1-.1-2.7-3.5v3.6H43v-4.9h.7l.1.1 2.7 3.5v-3.6h.6zm-6.9-.1v5.1h-.7v-5.1h.7zm-1.6 0v5.1h-.7v-5.1h.7zm-1.7 1.5v3.5h-.4c-.1 0-.2 0-.2-.1l-.1-.3c-.1.1-.2.1-.2.2-.1.1-.2.1-.3.2-.1 0-.2.1-.3.1h-.3c-.2 0-.4 0-.5-.1s-.3-.2-.4-.3a.76.76 0 0 1-.2-.4v-2.7h.7v2.2c0 .2.1.4.2.5s.3.2.5.2.3 0 .5-.1c.1-.1.3-.2.4-.3v-2.5h.6zm-5.6-.7V24h1.9v.6h-1.9v2.1h-.8v-4.9h3.1v.6h-2.3z" />
            <path
                fill="#58707f"
                fillRule="evenodd"
                d="M217.7 32.1H32.4c-.5 0-.9.3-.9.7v9c0 .4.4.7.9.7h185.3c.5 0 .9-.3.9-.7v-9c0-.3-.4-.7-.9-.7zm-185.3-.7c-1 0-1.8.7-1.8 1.5v9c0 .8.8 1.5 1.8 1.5h185.3c1 0 1.8-.7 1.8-1.5v-9c0-.8-.8-1.5-1.8-1.5H32.4z"
            />
            <path d="M72.3 53.2s-.1 0 0 0l-.1.1h-.1s-.1-.1-.2-.1-.1-.1-.2-.1h-.5c-.1 0-.1.1-.2.1s-.1.1-.1.1v.2c0 .1 0 .2.1.2.1.1.1.1.2.1s.2.1.3.1.2.1.3.1.2.1.3.1.2.1.3.2.1.2.2.3.1.2.1.4 0 .3-.1.5c-.1.1-.1.3-.3.4s-.3.2-.4.2c-.2.1-.4.1-.6.1h-.4c-.1 0-.2 0-.3-.1-.1 0-.2-.1-.3-.1-.1-.1-.2-.1-.2-.2l.2-.3s0-.1.1-.1h.2s.1.1.2.1.1.1.2.1h.6c.1 0 .1-.1.2-.1s.1-.1.1-.2v-.2c0-.1 0-.2-.1-.2-.1-.1-.1-.1-.2-.1s-.2-.1-.3-.1-.2-.1-.3-.1-.2-.1-.3-.1-.2-.1-.3-.2-.1-.2-.2-.3-.1-.2-.1-.4c0-.1 0-.3.1-.4s.1-.2.2-.3.2-.2.4-.2c.2-.1.3-.1.6-.1.2 0 .4 0 .6.1s.4.2.5.3l-.2.2zm-3 0-.1.1h-.1s-.1-.1-.2-.1-.1-.1-.2-.1h-.5c-.1 0-.1.1-.2.1s-.1.1-.1.1v.2c0 .1 0 .2.1.2.1.1.1.1.2.1s.2.1.3.1.2.1.3.1.2.1.3.1.2.1.3.2.1.2.2.3.1.2.1.4 0 .3-.1.5c-.1.1-.1.3-.3.4s-.3.2-.4.2c-.2.1-.4.1-.6.1h-.4c-.1 0-.2 0-.3-.1-.1 0-.2-.1-.3-.1-.1-.1-.2-.1-.2-.2l.2-.3s0-.1.1-.1h.2s.1.1.2.1.1.1.2.1h.6c.1 0 .1-.1.2-.1s.1-.1.1-.2v-.2c0-.1 0-.2-.1-.2-.1-.1-.1-.1-.2-.1s-.2-.1-.3-.1-.2-.1-.3-.1-.2-.1-.3-.1-.2-.1-.3-.2-.1-.2-.2-.3-.1-.2-.1-.4c0-.1 0-.3.1-.4s.1-.2.2-.3.2-.2.4-.2c.2-.1.3-.1.6-.1.2 0 .4 0 .6.1s.4.2.5.3l-.2.2zm-3.4.7c0-.1 0-.2-.1-.3 0-.1-.1-.2-.2-.3s-.2-.1-.3-.2c0-.1-.1-.1-.3-.1-.3 0-.5.1-.6.2-.2.2-.3.4-.3.6h1.8zm-1.8.4c0 .2 0 .4.1.5s.1.3.2.4.2.2.3.2.3.1.4.1h.4c.1 0 .2-.1.3-.1s.1-.1.2-.1.1-.1.2-.1.1 0 .1.1l.2.3-.3.3c-.1.1-.2.1-.3.2-.1 0-.3.1-.4.1h-.4c-.2 0-.5 0-.7-.1s-.4-.2-.5-.4c-.2-.2-.3-.4-.4-.6s-.1-.5-.1-.8c0-.2 0-.5.1-.7s.2-.4.3-.5c.1-.2.3-.3.5-.4s.4-.1.7-.1c.2 0 .4 0 .6.1s.3.2.5.3c.1.1.2.3.3.5s.1.4.1.7v.2l-.1.1h-2.3zM61.9 53.2c.1-.2.2-.4.4-.5s.3-.2.6-.2h.2c.1 0 .1 0 .2.1l-.1.6v.1h-.7c-.1 0-.1.1-.2.1l-.2.2c0 .1-.1.2-.1.3V56h-.7v-3.5H61.9l.1.1-.1.6zm-2.4.2-.3-.3c-.1-.1-.3-.1-.4-.1-.3 0-.5.1-.7.3s-.2.5-.2.9c0 .2 0 .4.1.6 0 .2.1.3.2.4l.2.2c.1 0 .2.1.3.1.2 0 .3 0 .5-.1.1-.1.3-.2.4-.3v-1.7zm.8-2.4v5h-.4c-.1 0-.2 0-.2-.1l-.1-.4c-.1.2-.3.3-.5.4s-.4.2-.6.2-.4 0-.5-.1c-.2-.1-.3-.2-.4-.3-.1-.2-.2-.3-.3-.6-.1-.2-.1-.5-.1-.8s0-.5.1-.7l.3-.6c.1-.2.3-.3.5-.4s.4-.1.6-.1.4 0 .5.1.3.2.4.3V51h.7zm-4.6 2.4-.3-.3c-.1-.1-.3-.1-.4-.1-.3 0-.5.1-.7.3s-.2.5-.2.9c0 .2 0 .4.1.6 0 .2.1.3.2.4l.2.2c.1 0 .2.1.3.1.2 0 .3 0 .5-.1.1-.1.3-.2.4-.3v-1.7zm.7-2.4v5H56c-.1 0-.2 0-.2-.1l-.1-.4c-.1.2-.3.3-.5.4s-.4.2-.6.2-.4 0-.5-.1c-.2-.1-.3-.2-.4-.3-.1-.2-.2-.3-.3-.6-.1-.2-.1-.5-.1-.8s0-.5.1-.7l.3-.6c.1-.2.3-.3.5-.4s.4-.1.6-.1.4 0 .5.1.3.2.4.3V51h.7zm-4.9 3.2-.7-1.8c-.1-.1-.1-.3-.2-.5 0 .1-.1.2-.1.3s-.1.2-.1.2l-.7 1.8h1.8zm1.6 1.8h-.6c-.1 0-.1 0-.2-.1l-.1-.1-.4-1.1h-2.1l-.4 1.1-.1.1s-.1.1-.2.1h-.6l2-4.9h.8l1.9 4.9zm-6.7-5v5h-.7v-5h.7zm-1.7 1.5V56H44v-3.5h.7zm.1-1v.2c0 .1-.1.1-.1.2 0 0-.1.1-.2.1h-.4c-.1 0-.1-.1-.2-.1 0 0-.1-.1-.1-.2v-.4c0-.1.1-.1.1-.2 0 0 .1-.1.2-.1h.4c.1 0 .1.1.2.1 0 0 .1.1.1.2v.2zm-2.4 3c-.3 0-.5 0-.7.1-.2 0-.3.1-.4.1-.1.1-.2.1-.2.2s-.1.1-.1.2v.2c0 .1.1.1.1.1s.1.1.2.1h.2c.2 0 .4 0 .5-.1s.3-.2.4-.3v-.6zm-2-1.5c.4-.4.9-.6 1.4-.6.2 0 .4 0 .5.1.2.1.3.2.4.3a.76.76 0 0 1 .2.4.9.9 0 0 1 .1.5V56h-.5l-.1-.1-.1-.3c-.1.1-.2.2-.3.2-.1.1-.2.1-.3.2-.1 0-.2.1-.3.1h-.3c-.1 0-.3 0-.4-.1-.1 0-.2-.1-.3-.2s-.2-.2-.2-.3c-.1-.1-.1-.3-.1-.4s0-.3.1-.4.2-.2.4-.3.4-.2.7-.3.6-.1 1-.1v-.2c0-.3-.1-.4-.2-.6-.1-.1-.3-.2-.5-.2-.1 0-.3 0-.4.1-.1 0-.2.1-.2.1-.1 0-.1.1-.2.1s-.1.1-.2.1h-.1l-.1-.1V53zm-5.6 3v-3.5h.4c.1 0 .2 0 .2.1v.3l.2-.2.2-.2c.1 0 .2-.1.3-.1h.6c.1 0 .2.1.2.1l.2.2c.1.1.1.2.1.3.1-.1.1-.2.2-.3s.2-.2.3-.2c.1-.1.2-.1.3-.1h.3c.2 0 .4 0 .5.1s.3.1.4.3a.76.76 0 0 1 .2.4c.1.2.1.4.1.6V56h-.7v-2.2c0-.2-.1-.4-.2-.6-.1-.1-.3-.2-.5-.2h-.3c-.1 0-.2.1-.2.1-.1.1-.1.1-.1.2s-.1.2-.1.3V56h-.7v-2.2c0-.3-.1-.4-.2-.6-.1-.1-.3-.2-.5-.2-.1 0-.3 0-.4.1l-.3.3V56h-.5zm-.6-.6v.6h-3.1v-4.9h3.1v.6h-2.3v1.5h1.8v.6h-1.8v1.5h2.3z" />
            <path
                fill="#58707f"
                fillRule="evenodd"
                d="M217.6 63.6H32.3c-.5 0-.9.3-.9.7v9c0 .4.4.7.9.7h185.3c.5 0 .9-.3.9-.7v-9c0-.3-.4-.7-.9-.7zm-185.3-.7c-1 0-1.8.7-1.8 1.5v9c0 .8.8 1.5 1.8 1.5h185.3c1 0 1.8-.7 1.8-1.5v-9c0-.8-.8-1.5-1.8-1.5H32.3z"
            />
            <use xlinkHref="#a" />
            <path d="M60.5 84c.3 0 .5 0 .7.1s.4.2.5.4.3.3.3.6c.1.2.1.5.1.7 0 .3 0 .5-.1.7l-.3.6c-.1.2-.3.3-.5.4s-.4.1-.7.1-.5 0-.7-.1-.4-.2-.5-.4-.3-.3-.3-.6c-.1-.2-.1-.5-.1-.7 0-.3 0-.5.1-.7l.3-.6c.1-.2.3-.3.5-.4s.5-.1.7-.1zm0 3c.3 0 .5-.1.7-.3s.2-.5.2-.9-.1-.7-.2-.9c-.2-.2-.4-.3-.7-.3s-.6.1-.7.3c-.2.2-.2.5-.2.9s.1.7.2.9c.2.2.4.3.7.3zm-2.4.5h-.7v-2.9h-1.7v2c0 .1 0 .2.1.3 0 .1.1.1.2.1h.4s.1 0 .1.1l.2.4c-.1.1-.2.2-.4.2-.2.1-.3.1-.5.1-.3 0-.5-.1-.7-.2-.2-.2-.2-.4-.2-.7v-2h-.5v-.4l.6-.1.2-1s0-.1.1-.1h.5v1.1h2.4v3.1zm.1-4.5v.2c0 .1-.1.1-.1.2 0 0-.1.1-.2.1h-.4c-.1 0-.1-.1-.2-.1 0 0-.1-.1-.1-.2v-.4c0-.1.1-.1.1-.2 0 0 .1-.1.2-.1h.4c.1 0 .1.1.2.1 0 0 .1.1.1.2v.2zm-5 3c-.3 0-.5 0-.7.1-.2 0-.3.1-.4.1-.1.1-.2.1-.2.2s-.1.1-.1.2v.2c0 .1.1.1.1.1s.1.1.2.1h.2c.2 0 .4 0 .5-.1s.3-.2.4-.3V86zm-2-1.5c.4-.4.9-.6 1.4-.6.2 0 .4 0 .5.1a1.38 1.38 0 0 1 .4.3.76.76 0 0 1 .2.4c.1.2.1.3.1.5v2.2h-.5l-.1-.1-.1-.3c-.1.1-.2.2-.3.2-.1.1-.2.1-.3.2-.1 0-.2.1-.3.1h-.3c-.1 0-.3 0-.4-.1-.1 0-.2-.1-.3-.2s-.2-.2-.2-.3c-.1-.1-.1-.3-.1-.4s0-.3.1-.4a1.38 1.38 0 0 1 .4-.3c.2-.1.4-.2.7-.3s.6-.1 1-.1v-.2c0-.3-.1-.4-.2-.6-.1-.1-.3-.2-.5-.2-.1 0-.3 0-.4.1-.1 0-.2.1-.2.1-.1 0-.1.1-.2.1s-.1.1-.2.1h-.1l-.1-.1v-.2z" />
            <use xlinkHref="#a" x={-15.5} />
            <path d="M45.1 85.8c.2 0 .4-.1.5-.2s.2-.3.2-.5-.1-.3-.2-.5c-.1-.1-.3-.2-.5-.2s-.4.1-.5.2-.2.3-.2.5v.3c0 .1.1.1.1.2.1.1.1.1.2.1.2 0 .3.1.4.1zm1 1.9c0-.1 0-.1-.1-.2 0 0-.1-.1-.2-.1s-.2 0-.3-.1H44.6c-.1.1-.2.1-.3.2s-.1.2-.1.3 0 .1.1.2c0 .1.1.1.2.2.1 0 .2.1.3.1h.4c.3 0 .6-.1.7-.2.2-.1.2-.2.2-.4zm.8-3.5v.3c0 .1-.1.1-.2.2l-.3.1c.1.1.1.3.1.4 0 .2 0 .3-.1.5-.1.1-.2.3-.3.4a.76.76 0 0 1-.4.2c-.2.1-.3.1-.5.1h-.4c-.1 0-.1.1-.1.1v.1c0 .1 0 .1.1.2.1 0 .2.1.3.1h.8c.1 0 .3 0 .4.1.1 0 .3.1.4.1.1.1.2.1.3.2s.1.2.1.4 0 .3-.1.4-.2.3-.3.4-.3.2-.5.3-.4.1-.7.1-.5 0-.7-.1-.4-.1-.5-.2l-.3-.3c-.1-.1-.1-.2-.1-.3 0-.2.1-.3.2-.4a1.38 1.38 0 0 1 .4-.3c-.1 0-.2-.1-.2-.2-.1-.1-.1-.2-.1-.3s0-.2.1-.3l.3-.3a.78.78 0 0 1-.4-.4c-.1-.2-.2-.3-.2-.6 0-.2 0-.3.1-.5.1-.1.2-.3.3-.4a.76.76 0 0 1 .4-.2c.2-.1.3-.1.5-.1.3 0 .6.1.8.2h.8zm-4-.2v3.5h-.7V84h.7zm.2-1v.2c0 .1-.1.1-.1.2 0 0-.1.1-.2.1h-.4c-.1 0-.1-.1-.2-.1 0 0-.1-.1-.1-.2v-.4c0-.1.1-.1.1-.2 0 0 .1-.1.2-.1h.4c.1 0 .1.1.2.1 0 0 .1.1.1.2-.1.1 0 .1 0 .2zm-1.8 1.7c-.1 0-.1 0 0 0l-.1.1h-.1s-.1-.1-.2-.1-.1-.1-.2-.1h-.5c-.1 0-.1.1-.2.1s-.1.1-.1.1v.2c0 .1 0 .2.1.2.1.1.1.1.2.1s.2.1.3.1.2.1.3.1.2.1.3.1.2.1.3.2.1.2.2.3.1.2.1.4 0 .3-.1.5c-.1.1-.1.3-.3.4a.76.76 0 0 1-.4.2c-.2.1-.4.1-.6.1h-.4c-.1 0-.2 0-.3-.1-.1 0-.2-.1-.3-.1-.1-.1-.2-.1-.2-.2l.2-.3s0-.1.1-.1h.2s.1.1.2.1.1.1.2.1h.6c.1 0 .1-.1.2-.1s.1-.1.1-.2v-.2c0-.1 0-.2-.1-.2-.1-.1-.1-.1-.2-.1s-.2-.1-.3-.1-.2-.1-.3-.1-.2-.1-.3-.1-.2-.1-.3-.2-.1-.2-.2-.3c-.2-.2-.2-.3-.2-.5 0-.1 0-.3.1-.4s.1-.2.2-.3.2-.2.4-.2c.2-.1.3-.1.6-.1.2 0 .4 0 .6.1s.4.2.5.3l-.1.3zm-3.5.7c0-.1 0-.2-.1-.3 0-.1-.1-.2-.2-.3s-.2-.1-.3-.2c-.1 0-.2-.1-.3-.1-.3 0-.5.1-.6.2-.2.2-.3.4-.3.6h1.8zm-1.7.4c0 .2 0 .4.1.5s.1.3.2.4.2.2.3.2.3.1.4.1h.4c.1 0 .2-.1.3-.1s.1-.1.2-.1.1-.1.2-.1.1 0 .1.1l.2.3-.3.3c-.1.1-.2.1-.3.2-.1 0-.3.1-.4.1h-.4c-.2 0-.5 0-.7-.1s-.4-.2-.5-.4c-.2-.2-.3-.4-.4-.6s-.1-.5-.1-.8c0-.2 0-.5.1-.7s.2-.4.3-.5c.1-.2.3-.3.5-.4.2-.2.4-.2.7-.2.2 0 .4 0 .6.1s.3.2.5.3c.1.1.2.3.3.5s.1.4.1.7v.2l-.1.1h-2.3zm-1.3-.7c0 .4-.1.7-.2 1s-.3.6-.5.8-.5.4-.8.5-.6.2-1 .2h-1.9v-4.9h1.9c.4 0 .7.1 1 .2s.6.3.8.5.4.5.5.8c.2.2.2.5.2.9zm-.8 0c0-.3 0-.5-.1-.8l-.3-.6c-.1-.2-.3-.3-.5-.4s-.4-.1-.7-.1h-1.1v3.6h1.1c.3 0 .5 0 .7-.1s.4-.2.5-.4.3-.3.3-.6c.1-.1.1-.3.1-.6z" />
            <path
                fill="#58707f"
                fillRule="evenodd"
                d="M217.6 94.1H32.3c-.5 0-.9.3-.9.7v9c0 .4.4.7.9.7h185.3c.5 0 .9-.3.9-.7v-9c0-.4-.4-.7-.9-.7zm-185.3-.8c-1 0-1.8.7-1.8 1.5v9c0 .8.8 1.5 1.8 1.5h185.3c1 0 1.8-.7 1.8-1.5v-9c0-.8-.8-1.5-1.8-1.5H32.3z"
            />
            <path d="M90.2 118.1c-.3 0-.5-.1-.7-.2-.2-.2-.2-.4-.2-.7v-2h-.5v-.4l.6-.1.2-1s0-.1.1-.1h.5v1.1h1v.5h-1v2c0 .1 0 .2.1.3s.1.1.2.1h.4s.1 0 .1.1l.2.4c-.1.1-.2.2-.4.2-.3-.3-.4-.2-.6-.2z" />
            <use xlinkHref="#b" />
            <path d="M84 115.9c0-.1 0-.2-.1-.3 0-.1-.1-.2-.2-.3s-.2-.1-.3-.2c-.1 0-.2-.1-.3-.1-.3 0-.5.1-.6.2-.2.2-.3.4-.3.6H84zm-1.8.4c0 .2 0 .4.1.5s.1.3.2.4.2.2.3.2.3.1.4.1h.4c.1 0 .2-.1.3-.1s.1-.1.2-.1.1-.1.2-.1.1 0 .1.1l.2.3-.3.3c-.1.1-.2.1-.3.2-.1 0-.2.1-.4.1h-.4c-.2 0-.5 0-.7-.1s-.4-.2-.5-.4c-.2-.2-.3-.4-.4-.6s-.1-.5-.1-.8c0-.2 0-.5.1-.7s.2-.4.3-.5c.1-.2.3-.3.5-.4s.4-.1.7-.1c.2 0 .4 0 .6.1s.3.2.5.3c.1.1.2.3.3.5s.1.4.1.7v.2l-.1.1h-2.3zm-1.9 1.8c-.3 0-.5-.1-.7-.2-.2-.2-.2-.4-.2-.7v-2h-.5v-.4l.6-.1.2-1s0-.1.1-.1h.5v1.1h1v.5h-1v2c0 .1 0 .2.1.3s.1.1.2.1h.4s.1 0 .1.1l.2.4c-.1.1-.2.2-.4.2-.3-.3-.4-.2-.6-.2z" />
            <use xlinkHref="#b" x={-9.9} />
            <path d="M73 114.4c.3 0 .5 0 .7.1s.4.2.5.4.3.3.3.6.1.5.1.7c0 .3 0 .5-.1.7l-.3.6c-.1.2-.3.3-.5.4s-.4.1-.7.1-.5 0-.7-.1-.4-.2-.5-.4-.3-.3-.3-.6c-.1-.2-.1-.5-.1-.7 0-.3 0-.5.1-.7l.3-.6c.1-.2.3-.3.5-.4.2 0 .4-.1.7-.1zm0 3.1c.3 0 .5-.1.7-.3s.2-.5.2-.9-.1-.7-.2-.9c-.2-.2-.4-.3-.7-.3s-.6.1-.7.3c-.2.2-.2.5-.2.9s.1.7.2.9.4.3.7.3zm-2.4-.6s.1 0 .1.1l.3.3c-.2.2-.4.4-.7.6-.3.1-.6.2-1 .2s-.7-.1-1-.2-.5-.3-.7-.5-.4-.5-.5-.8-.2-.6-.2-1 .1-.7.2-1 .3-.6.5-.8.5-.4.8-.5.6-.2 1-.2.7.1.9.2c.3.1.5.3.7.5l-.3.4-.1.1h-.1s-.1 0-.2-.1c-.1 0-.1-.1-.2-.1-.1-.1-.2-.1-.3-.1s-.3-.1-.5-.1-.5 0-.6.1c-.2.1-.4.2-.5.4s-.3.3-.3.6c-.1.2-.1.5-.1.8s0 .5.1.8l.3.6c.1.2.3.3.5.4s.4.1.6.1h.4c.1 0 .2 0 .3-.1.1 0 .2-.1.3-.1.1-.1.2-.1.2-.2 0-.4 0-.4.1-.4zm-6.2-4v5.1h-.7v-5.1h.7zm-2.3 3.6c-.3 0-.5 0-.7.1-.2 0-.3.1-.4.1-.1.1-.2.1-.2.2s-.1.1-.1.2v.2c0 .1.1.1.1.1s.1.1.2.1h.2c.2 0 .4 0 .5-.1s.3-.2.4-.3v-.6zm-2-1.5c.4-.4.9-.6 1.4-.6.2 0 .4 0 .5.1a1.38 1.38 0 0 1 .4.3.76.76 0 0 1 .2.4.9.9 0 0 1 .1.5v2.2h-.5l-.1-.1-.1-.3c-.1.1-.2.2-.3.2-.1.1-.2.1-.3.2-.1 0-.2.1-.3.1h-.3c-.1 0-.3 0-.4-.1-.1 0-.2-.1-.3-.2s-.2-.2-.2-.3c-.1-.1-.1-.3-.1-.4s0-.3.1-.4.2-.2.4-.3.4-.2.7-.3.6-.1 1-.1v-.2c0-.3-.1-.4-.2-.6-.1-.1-.3-.2-.5-.2-.1 0-.3 0-.4.1-.1 0-.2.1-.3.1s-.1.1-.2.1-.1.1-.2.1h-.1l-.1-.1.1-.2zm-.8-.5v3.5h-.7v-3.5h.7zm.1-1.1v.2c0 .1-.1.1-.1.2 0 0-.1.1-.2.1h-.4c-.1 0-.1-.1-.2-.1 0 0-.1-.1-.1-.2v-.4c0-.1.1-.1.1-.2 0 0 .1-.1.2-.1h.4c.1 0 .1.1.2.1 0 0 .1.1.1.2v.2zm-4 1.6c.1-.1.2-.1.2-.2.1-.1.2-.1.3-.2.1 0 .2-.1.3-.1h.3c.2 0 .4 0 .5.1s.3.2.4.3a.76.76 0 0 1 .2.4c.1.2.1.3.1.5v2.2H57v-2.2c0-.2-.1-.4-.2-.5s-.3-.2-.5-.2-.3 0-.5.1c-.1.1-.3.2-.4.3v2.5h-.7v-3.5h.4c.1 0 .2 0 .2.1l.1.4zm-3.1-.6c.3 0 .5 0 .7.1s.4.2.5.4.3.3.3.6c.1.2.1.5.1.7 0 .3 0 .5-.1.7l-.3.6c-.1.2-.3.3-.5.4s-.4.1-.7.1-.5 0-.7-.1-.4-.2-.5-.4-.3-.3-.3-.6c-.1-.2-.1-.5-.1-.7 0-.3 0-.5.1-.7l.3-.6c.1-.2.3-.3.5-.4.2 0 .4-.1.7-.1zm0 3.1c.3 0 .5-.1.7-.3s.2-.5.2-.9-.1-.7-.2-.9c-.2-.2-.4-.3-.7-.3s-.6.1-.7.3c-.2.2-.2.5-.2.9s.1.7.2.9.3.3.7.3zm-7.2.5v-3.5h.4c.1 0 .2 0 .2.1v.3l.2-.2.2-.2c.1 0 .2-.1.3-.1h.6c.1 0 .2.1.2.1l.2.2c.1.1.1.2.1.3.1-.1.1-.2.2-.3s.2-.2.3-.2c.1-.1.2-.1.3-.1h.3c.2 0 .4 0 .5.1s.3.1.4.3a.76.76 0 0 1 .2.4c.1.2.1.4.1.6v2.2h-.7v-2.2c0-.2-.1-.4-.2-.6-.1-.1-.3-.2-.5-.2h-.3c-.1 0-.2.1-.2.1-.1.1-.1.1-.1.2s-.1.2-.1.3v2.2H47v-2.2c0-.3-.1-.4-.2-.6-.1-.1-.3-.2-.5-.2-.1 0-.3 0-.4.1l-.3.3v2.6h-.5zm-1 0h-.7v-2.9h-1.7v2c0 .1 0 .2.1.3s.1.1.2.1h.4s.1 0 .1.1l.2.4c-.1.1-.2.2-.4.2-.2.1-.3.1-.5.1-.3 0-.5-.1-.7-.2-.2-.2-.2-.4-.2-.7v-2h-.5v-.4l.6-.1.2-1s0-.1.1-.1h.5v1.1h2.4v3.1zm.2-4.6v.2c0 .1-.1.1-.1.2 0 0-.1.1-.2.1h-.4c-.1 0-.1-.1-.2-.1 0 0-.1-.1-.1-.2v-.4c0-.1.1-.1.1-.2 0 0 .1-.1.2-.1h.4c.1 0 .1.1.2.1 0 0 .1.1.1.2v.2zm-4.5 1.7c0 .1 0 .1 0 0l-.1.1h-.1s-.1-.1-.2-.1-.1-.1-.2-.1h-.6c-.1 0-.1.1-.2.1s-.1.1-.1.1v.2c0 .1 0 .2.1.2.1.1.1.1.2.1s.2.1.3.1.2.1.3.1.2.1.3.1.2.1.3.2.1.2.2.3.1.2.1.4 0 .3-.1.5c-.1.1-.1.3-.3.4s-.3.2-.4.2c-.2.1-.4.1-.6.1h-.4c-.1 0-.2 0-.3-.1-.1 0-.2-.1-.3-.1-.1-.1-.2-.1-.2-.2l.2-.3s0-.1.1-.1h.2s.1.1.2.1.1.1.2.1h.6c.1 0 .1-.1.2-.1s.1-.1.1-.2v-.2c0-.1 0-.2-.1-.2-.1-.1-.1-.1-.2-.1s-.2-.1-.3-.1-.2-.1-.3-.1-.2-.1-.3-.1-.2-.1-.3-.2-.1-.2-.2-.3-.1-.2-.1-.4c0-.1 0-.3.1-.4s.1-.2.2-.3.2-.2.4-.2c.2-.1.3-.1.6-.1.2 0 .4 0 .6.1s.4.2.5.3l-.1.2zm-3.4.8c0-.1 0-.2-.1-.3 0-.1-.1-.2-.2-.3s-.2-.1-.3-.2c-.1 0-.2-.1-.3-.1-.3 0-.5.1-.6.2-.2.2-.2.4-.3.6h1.8zm-1.8.4c0 .2 0 .4.1.5s.1.3.2.4.2.2.3.2.3.1.4.1h.4c.1 0 .2-.1.3-.1s.1-.1.2-.1.1-.1.2-.1.1 0 .1.1l.2.3-.3.3c-.1.1-.2.1-.3.2-.1 0-.2.1-.4.1h-.4c-.2 0-.5 0-.7-.1s-.4-.2-.5-.4c-.2-.2-.3-.4-.4-.6s-.1-.5-.1-.8c0-.2 0-.5.1-.7s.2-.4.3-.5c.1-.2.3-.3.5-.4s.4-.1.7-.1c.2 0 .4 0 .6.1s.3.2.5.3c.1.1.2.3.3.5s.1.4.1.7v.2l-.1.1h-2.3zm-.2-2.6h-1.5v4.3h-.8v-4.3h-1.5v-.7h3.9v.7z" />
            <path
                fill="#58707f"
                fillRule="evenodd"
                d="M217.6 123.6H32.3c-.5 0-.9.4-.9 1V159c0 .5.4 1 .9 1h185.3c.5 0 .9-.4.9-1v-34.4c0-.6-.4-1-.9-1zm-185.3-1c-1 0-1.8.9-1.8 1.9V159c0 1.1.8 1.9 1.8 1.9h185.3c1 0 1.8-.9 1.8-1.9v-34.4c0-1.1-.8-1.9-1.8-1.9H32.3z"
            />
            <path d="M61.5 171.8c.2 0 .4-.1.5-.2s.2-.3.2-.5-.1-.3-.2-.5c-.1-.1-.3-.2-.5-.2s-.4.1-.5.2-.2.3-.2.5v.3c0 .1.1.1.1.2.1.1.1.1.2.1.2.1.3.1.4.1zm1 1.9c0-.1 0-.1-.1-.2 0 0-.1-.1-.2-.1s-.2 0-.3-.1H61c-.1.1-.2.1-.3.2s-.1.2-.1.3 0 .1.1.2c0 .1.1.1.2.2.1 0 .2.1.3.1h.4c.3 0 .6-.1.7-.2s.2-.2.2-.4zm.8-3.5v.3c0 .1-.1.1-.2.2l-.3.1c.1.1.1.3.1.4 0 .2 0 .3-.1.5-.1.1-.2.3-.3.4a.76.76 0 0 1-.4.2c-.2.1-.3.1-.5.1h-.4c-.1 0-.1.1-.1.1v.1c0 .1 0 .1.1.2.1 0 .2.1.3.1h.8c.1 0 .3 0 .4.1.1 0 .3.1.4.1.1.1.2.1.3.2s.1.2.1.4 0 .3-.1.4-.2.3-.3.4-.3.2-.5.3-.4.1-.7.1-.5 0-.7-.1-.4-.1-.5-.2l-.3-.3c-.1-.1-.1-.2-.1-.3 0-.2.1-.3.2-.4s.2-.2.4-.3c-.1 0-.2-.1-.2-.2-.1-.1-.1-.2-.1-.3s0-.2.1-.3l.3-.3a.78.78 0 0 1-.4-.4c-.1-.2-.2-.3-.2-.6 0-.2 0-.3.1-.5.1-.1.2-.3.3-.4a.76.76 0 0 1 .4-.2c.2-.1.3-.1.5-.1.3 0 .6.1.8.2h.8zm-6.2.3c.1-.1.2-.1.2-.2.1-.1.2-.1.3-.2.1 0 .2-.1.3-.1h.3c.2 0 .4 0 .5.1s.3.2.4.3a.76.76 0 0 1 .2.4.9.9 0 0 1 .1.5v2.2h-.7v-2.2c0-.2-.1-.4-.2-.5s-.3-.2-.5-.2-.3 0-.5.1c-.1.1-.3.2-.4.3v2.5h-.7V170h.4c.1 0 .2 0 .2.1l.1.4zm-1.6 3.1h-.7v-2.9H53v2c0 .1 0 .2.1.3s.1.1.2.1h.4s.1 0 .1.1l.2.4c-.1.1-.2.2-.4.2a.9.9 0 0 1-.5.1c-.3 0-.5-.1-.7-.2-.2-.2-.2-.4-.2-.7v-2h-.5v-.4l.6-.1.2-1s0-.1.1-.1h.4v1.1h2.4v3.1zm.1-4.6v.2c0 .1-.1.1-.1.2 0 0-.1.1-.2.1h-.4c-.1 0-.1-.1-.2-.1 0 0-.1-.1-.1-.2v-.4c0-.1.1-.1.1-.2 0 0 .1-.1.2-.1h.4c.1 0 .1.1.2.1 0 0 .1.1.1.2v.2zm-5 3c-.3 0-.5 0-.7.1-.2 0-.3.1-.4.1-.1.1-.2.1-.2.2s-.1.1-.1.2v.2c0 .1.1.1.1.1s.1.1.2.1h.2c.2 0 .4 0 .5-.1s.3-.2.4-.3v-.6zm-2-1.4c.4-.4.9-.6 1.4-.6.2 0 .4 0 .5.1a1.38 1.38 0 0 1 .4.3.76.76 0 0 1 .2.4.9.9 0 0 1 .1.5v2.2h-.5l-.1-.1-.1-.3c-.1.1-.2.2-.3.2-.1.1-.2.1-.3.2-.1 0-.2.1-.3.1h-.3c-.1 0-.3 0-.4-.1-.1 0-.2-.1-.3-.2s-.2-.2-.2-.3c-.1-.1-.1-.3-.1-.4s0-.3.1-.4a1.38 1.38 0 0 1 .4-.3c.2-.1.4-.2.7-.3s.6-.1 1-.1v-.2c0-.3-.1-.4-.2-.6-.1-.1-.3-.2-.5-.2-.1 0-.3 0-.4.1-.1 0-.2.1-.2.1-.1 0-.1.1-.2.1s-.1.1-.2.1h-.1l-.1-.1v-.2zm-2.6.4c.2 0 .3 0 .5-.1.1 0 .3-.1.3-.2.1-.1.2-.2.2-.3s.1-.2.1-.4c0-.3-.1-.5-.3-.6s-.4-.2-.8-.2h-.7v1.7h.7zm2.3 2.6h-.7c-.1 0-.2-.1-.3-.2l-1.2-1.7c0-.1-.1-.1-.1-.1H45.4v2h-.8v-4.9H46c.3 0 .6 0 .8.1l.6.3c.2.1.3.3.3.4.1.2.1.4.1.6s0 .3-.1.5c-.1.1-.1.3-.2.4s-.2.2-.4.3c-.1.1-.3.2-.5.2.1.1.2.1.3.2l1.4 1.9zm-7.3-2.9c.1-.2.2-.4.4-.5s.3-.2.6-.2h.2c.1 0 .1 0 .2.1l-.1.6v.1h-.7c-.1 0-.1.1-.2.1l-.2.2c-.1.1-.1.2-.1.3v2.2h-.7v-3.5H41l.1.1-.1.5zm-2.3 1.3c-.3 0-.5 0-.7.1-.2 0-.3.1-.4.1-.1.1-.2.1-.2.2s-.1.1-.1.2v.2c0 .1.1.1.1.1s.1.1.2.1h.2c.2 0 .4 0 .5-.1s.3-.2.4-.3v-.6zm-1.9-1.4c.4-.4.9-.6 1.4-.6.2 0 .4 0 .5.1a1.38 1.38 0 0 1 .4.3.76.76 0 0 1 .2.4.9.9 0 0 1 .1.5v2.2h-.5l-.1-.1-.1-.3c-.1.1-.2.2-.3.2-.1.1-.2.1-.3.2-.1 0-.2.1-.3.1h-.3c-.1 0-.3 0-.4-.1-.1 0-.2-.1-.3-.2s-.2-.2-.2-.3c-.1-.1-.1-.3-.1-.4s0-.3.1-.4a1.38 1.38 0 0 1 .4-.3c.2-.1.4-.2.7-.3s.6-.1 1-.1v-.2c0-.3-.1-.4-.2-.6-.1-.1-.3-.2-.5-.2-.1 0-.3 0-.4.1-.1 0-.2.1-.3.1s-.1.1-.2.1-.1.1-.2.1h-.1l-.1-.1.1-.2z" />
            <use xlinkHref="#c" />
            <path d="M33.5 169.5s-.1 0 0 0c-.1.1-.1.1-.2.1 0 0-.1 0-.1-.1-.1 0-.1-.1-.2-.1s-.2-.1-.3-.1-.2-.1-.4-.1c-.1 0-.3 0-.4.1-.1 0-.2.1-.3.1l-.2.2c0 .1-.1.2-.1.3s0 .2.1.3.2.2.3.2c.1.1.2.1.4.2.1 0 .3.1.4.1.1.1.3.1.4.2s.3.1.4.2a1.38 1.38 0 0 1 .3.4c.1.1.1.3.1.5s0 .4-.1.6-.2.4-.3.5-.3.3-.5.3c-.2.1-.4.1-.7.1h-.5c-.1 0-.3-.1-.4-.1-.1-.1-.3-.1-.4-.2l-.3-.3.2-.4s0-.1.1-.1h.1c.1 0 .1 0 .2.1.1 0 .1.1.2.2s.2.1.3.2c.1 0 .3.1.5.1.3 0 .5-.1.7-.2s.2-.3.2-.6c0-.1 0-.3-.1-.3-.1-.1-.2-.2-.3-.2-.1-.1-.2-.1-.4-.2-.1 0-.3-.1-.4-.1a.76.76 0 0 1-.4-.2c-.1-.1-.3-.1-.4-.2s-.2-.2-.3-.4-.1-.3-.1-.6c0-.2 0-.4.1-.5.1-.2.2-.3.3-.4s.3-.2.5-.3.4-.1.7-.1.5 0 .8.1c.2.1.4.2.6.4l-.1.3z" />
            <g fill="#ffae04">
                <use xlinkHref="#d" />
                <use xlinkHref="#d" x={7.7} />
                <use xlinkHref="#d" x={15.3} />
                <use xlinkHref="#d" x={22.9} />
                <path d="m64.6 179.4 1.1 2.3 2.3.3-1.6 1.8.4 2.5-2.3-1.1-2.3 1.1.4-2.5L61 182l2.3-.3 1.3-2.3z" />
            </g>
            <path
                fill="#1b73e8"
                stroke="#1b73e8"
                strokeWidth={1.524}
                d="M33.6 194.6h87.3a2.26 2.26 0 0 1 2.3 2.3v12.2a2.26 2.26 0 0 1-2.3 2.3H33.6a2.26 2.26 0 0 1-2.3-2.3v-12.2a2.26 2.26 0 0 1 2.3-2.3z"
            />
            <g fill="#fff">
                <path d="M105.2 200.6v5.1h-.7v-5.1h.7zm-2.4 3.5c-.3 0-.5 0-.7.1-.2 0-.3.1-.4.1-.1.1-.2.1-.2.2s-.1.1-.1.2v.2c0 .1.1.1.1.1s.1.1.2.1h.2c.2 0 .4 0 .5-.1s.3-.2.4-.3v-.6zm-1.9-1.4c.4-.4.9-.6 1.4-.6.2 0 .4 0 .5.1a1.38 1.38 0 0 1 .4.3.76.76 0 0 1 .2.4.9.9 0 0 1 .1.5v2.2h-.5l-.1-.1-.1-.3c-.1.1-.2.2-.3.2-.1.1-.2.1-.3.2-.1 0-.2.1-.3.1h-.3c-.1 0-.3 0-.4-.1-.1 0-.2-.1-.3-.2s-.2-.2-.2-.3c-.1-.1-.1-.3-.1-.4s0-.3.1-.4a1.38 1.38 0 0 1 .4-.3c.2-.1.4-.2.7-.3s.6-.1 1-.1v-.2c0-.3-.1-.4-.2-.6-.1-.1-.3-.2-.5-.2-.1 0-.3 0-.4.1-.1 0-.2.1-.2.1-.1 0-.1.1-.2.1s-.1.1-.2.1h-.1l-.1-.1v-.2zm-.9-.5v3.5h-.7v-3.5h.7zm.2-1.1v.2c0 .1-.1.1-.1.2 0 0-.1.1-.2.1h-.4c-.1 0-.1-.1-.2-.1 0 0-.1-.1-.1-.2v-.4c0-.1.1-.1.1-.2 0 0 .1-.1.2-.1h.4c.1 0 .1.1.2.1 0 0 .1.1.1.2v.2z" />
                <use xlinkHref="#b" x={10.1} y={87.6} />
                <path d="M93 202.1c.3 0 .5 0 .7.1s.4.2.5.4.3.3.3.6c.1.2.1.5.1.7 0 .3 0 .5-.1.7l-.3.6c-.1.2-.3.3-.5.4s-.4.1-.7.1-.5 0-.7-.1-.4-.2-.5-.4-.3-.3-.3-.6c-.1-.2-.1-.5-.1-.7 0-.3 0-.5.1-.7l.3-.6c.1-.2.3-.3.5-.4.2 0 .5-.1.7-.1zm0 3.1c.3 0 .5-.1.7-.3s.2-.5.2-.9-.1-.7-.2-.9c-.2-.2-.4-.3-.7-.3s-.6.1-.7.3c-.2.2-.2.5-.2.9s.1.7.2.9c.2.1.4.3.7.3z" />
                <use xlinkHref="#e" />
                <path d="M84.9 205.7h-.7v-2.9h-1.7v2c0 .1 0 .2.1.3s.1.1.2.1h.4s.1 0 .1.1l.2.4c-.1.1-.2.2-.4.2-.2.1-.3.1-.5.1-.3 0-.5-.1-.7-.2-.2-.2-.2-.4-.2-.7v-2h-.5v-.4l.6-.1.2-1s0-.1.1-.1h.5v1.1H85v3.1zm.2-4.6v.2c0 .1-.1.1-.1.2 0 0-.1.1-.2.1h-.4c-.1 0-.1-.1-.2-.1 0 0-.1-.1-.1-.2v-.4c0-.1.1-.1.1-.2 0 0 .1-.1.2-.1h.4c.1 0 .1.1.2.1 0 0 .1.1.1.2-.1.1 0 .1 0 .2zm-4.5 1.7s0 .1 0 0l-.1.1h-.1s-.1-.1-.2-.1-.1-.1-.2-.1h-.6c-.1 0-.1.1-.2.1s-.1.1-.1.1v.2c0 .1 0 .2.1.2.1.1.1.1.2.1s.2.1.3.1.2.1.3.1.2.1.3.1.2.1.3.2.1.2.2.3.1.2.1.4 0 .3-.1.5c-.1.1-.1.3-.3.4a.76.76 0 0 1-.4.2c-.2.1-.4.1-.6.1h-.4c-.1 0-.2 0-.3-.1-.1 0-.2-.1-.3-.1-.1-.1-.2-.1-.2-.2l.2-.3s0-.1.1-.1h.2s.1.1.2.1.1.1.2.1h.6c.1 0 .1-.1.2-.1s.1-.1.1-.2v-.2c0-.1 0-.2-.1-.2-.1-.1-.1-.1-.2-.1s-.2-.1-.3-.1-.2-.1-.3-.1-.2-.1-.3-.1-.2-.1-.3-.2-.1-.2-.2-.3-.1-.2-.1-.4c0-.1 0-.3.1-.4s.1-.2.2-.3.2-.2.4-.2c.2-.1.3-.1.6-.1.2 0 .4 0 .6.1s.4.2.5.3l-.1.2zm-3.4.7c0-.1 0-.2-.1-.3 0-.1-.1-.2-.2-.3s-.2-.1-.3-.2c-.1 0-.2-.1-.3-.1-.3 0-.5.1-.6.2-.2.2-.3.4-.3.6h1.8zm-1.8.5c0 .2 0 .4.1.5s.1.3.2.4.2.2.3.2.3.1.4.1h.4c.1 0 .2-.1.3-.1s.1-.1.2-.1.1-.1.2-.1.1 0 .1.1l.2.3-.3.3c-.1.1-.2.1-.3.2-.1 0-.2.1-.4.1h-.4c-.2 0-.5 0-.7-.1s-.4-.2-.5-.4c-.2-.2-.3-.4-.4-.6s-.1-.5-.1-.8c0-.2 0-.5.1-.7s.2-.4.3-.5c.1-.2.3-.3.5-.4s.4-.1.7-.1c.2 0 .4 0 .6.1s.3.2.5.3c.1.1.2.3.3.5s.1.4.1.7v.2l-.1.1h-2.3zm-.2-2.6h-1.5v4.3h-.8v-4.3h-1.5v-.7h3.9v.7z" />
                <use xlinkHref="#c" x={33.3} y={32.1} />
                <path d="M66.7 202.2v3.5H66v-3.5h.7zm.1-1.1v.2c0 .1-.1.1-.1.2 0 0-.1.1-.2.1h-.4c-.1 0-.1-.1-.2-.1 0 0-.1-.1-.1-.2v-.4c0-.1.1-.1.1-.2 0 0 .1-.1.2-.1h.4c.1 0 .1.1.2.1 0 0 .1.1.1.2v.2z" />
                <use xlinkHref="#e" x={-25.5} />
                <path d="m57.1 204.8.3.3c.1.1.3.1.4.1.3 0 .5-.1.7-.3s.2-.5.2-1c0-.4-.1-.7-.2-.9s-.3-.3-.6-.3c-.2 0-.3 0-.5.1-.1.1-.3.2-.4.3v1.7zm0-2.2c.1-.2.3-.3.5-.4s.4-.1.6-.1.4 0 .5.1a1.38 1.38 0 0 1 .4.3c.1.1.2.3.3.5s.1.4.1.7 0 .5-.1.8l-.3.6c-.1.2-.3.3-.5.4s-.4.1-.6.1h-.3c-.1 0-.2-.1-.3-.1s-.2-.1-.2-.1l-.2-.2v.3c0 .1 0 .1-.1.1h-.6v-5.1h.7v2.1zm-1.6-.4v3.5H55c-.1 0-.2 0-.2-.1l-.1-.3c-.1.1-.2.1-.2.2-.1.1-.2.1-.3.2-.1 0-.2.1-.3.1h-.3c-.2 0-.4 0-.5-.1s-.3-.2-.4-.3a.76.76 0 0 1-.2-.4c-.1-.2-.1-.3-.1-.5v-2.2h.7v2.2c0 .2.1.4.2.5s.3.2.5.2.3 0 .5-.1c.1-.1.3-.2.4-.3v-2.5h.8zm-3.9-.6s-.1.1 0 0c-.1.1-.1.1-.2.1 0 0-.1 0-.1-.1-.1 0-.1-.1-.2-.1s-.2-.1-.3-.1-.2-.1-.4-.1c-.1 0-.3 0-.4.1-.1 0-.2.1-.3.1l-.2.2c0 .1-.1.2-.1.3s0 .2.1.3.2.2.3.2c.1.1.2.1.4.2.1 0 .3.1.4.1.1.1.3.1.4.2s.3.1.4.2.2.2.3.4c.1.1.1.3.1.5s0 .4-.1.6-.2.4-.3.5-.3.3-.5.3c-.2.1-.4.1-.7.1h-.5c-.1 0-.3-.1-.4-.1-.1-.1-.3-.1-.4-.2l-.3-.3.2-.4s0-.1.1-.1h.1c.1 0 .1 0 .2.1.1 0 .1.1.2.2s.2.1.3.2c.1 0 .3.1.5.1.3 0 .5-.1.7-.2s.2-.3.2-.6c0-.1 0-.3-.1-.3-.1-.1-.2-.2-.3-.2-.1-.1-.2-.1-.4-.2-.1 0-.3-.1-.4-.1a.76.76 0 0 1-.4-.2c-.1-.1-.3-.1-.4-.2s-.2-.2-.3-.4-.1-.3-.1-.6c0-.2 0-.4.1-.5a1.38 1.38 0 0 1 .3-.4c.1-.1.3-.2.5-.3s.4-.1.7-.1.5 0 .8.1c.2.1.4.2.6.4l-.1.3z" />
            </g>
            <defs>
                <path
                    id="a"
                    d="M63.6 84.5c.1-.1.2-.1.2-.2.1-.1.2-.1.3-.2.1 0 .2-.1.3-.1h.3c.2 0 .4 0 .5.1s.3.2.4.3a.76.76 0 0 1 .2.4.9.9 0 0 1 .1.5v2.2h-.7v-2.2c0-.2-.1-.4-.2-.5s-.3-.2-.5-.2-.3 0-.5.1c-.1.1-.3.2-.4.3v2.5h-.7V84h.4c.1 0 .2 0 .2.1l.1.4z"
                />
                <path
                    id="b"
                    d="M86 115c.1-.1.2-.1.2-.2.1-.1.2-.1.3-.2.1 0 .2-.1.3-.1h.3c.2 0 .4 0 .5.1s.3.2.4.3a.76.76 0 0 1 .2.4.9.9 0 0 1 .1.5v2.2h-.7v-2.2c0-.2-.1-.4-.2-.5s-.3-.2-.5-.2-.3 0-.5.1c-.1.1-.3.2-.4.3v2.5h-.7v-3.5h.4c.1 0 .2 0 .2.1l.1.4z"
                />
                <path
                    id="c"
                    d="M35.5 173.6c-.3 0-.5-.1-.7-.2-.2-.2-.2-.4-.2-.7v-2h-.5v-.4l.6-.1.2-1s0-.1.1-.1h.5v1.1h1v.5h-1v2c0 .1 0 .2.1.3s.1.1.2.1h.4s.1 0 .1.1l.2.4c-.1.1-.2.2-.4.2-.3-.2-.5-.2-.6-.2z"
                />
                <path
                    id="d"
                    d="m34.1 179.4 1.1 2.3 2.3.3-1.6 1.8.4 2.5-2.3-1.1-2.3 1.1.4-2.5-1.6-1.8 2.3-.3 1.3-2.3z"
                />
                <path
                    id="e"
                    d="M85.8 205.7v-3.5h.4c.1 0 .2 0 .2.1v.3l.2-.2.2-.2c.1 0 .2-.1.3-.1h.6c.1 0 .2.1.2.1l.2.2c.1.1.1.2.1.3.1-.1.1-.2.2-.3s.2-.2.3-.2c.1-.1.2-.1.3-.1h.3c.2 0 .4 0 .5.1s.3.1.4.3a.76.76 0 0 1 .2.4c.1.2.1.4.1.6v2.2h-.7v-2.2c0-.2-.1-.4-.2-.6-.1-.1-.3-.2-.5-.2h-.3c-.1 0-.2.1-.2.1-.1.1-.1.1-.1.2s-.1.2-.1.3v2.2h-.7v-2.2c0-.3-.1-.4-.2-.6-.1-.1-.3-.2-.5-.2-.1 0-.3 0-.4.1l-.3.3v2.6h-.5z"
                />
            </defs>
        </svg>
    );
};