<?php
/**
 * Triggered when the plugin is uninstalled.
 *
 * @package Temporary Login by Softfix
 */

if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
	exit;
}

delete_option( 'soft_fix_login_logs' );

$users = get_users( array( 'search' => 'soft_fix_user_%' ) );

foreach ( $users as $user ) {
	$expire = get_user_meta( $user->ID, 'soft_fix_meta_expire', true );
	if ( $expire ) {
		wp_delete_user( $user->ID );
	}
}
