<?php
/**
 * Plugin Name: Temporary Login by Softfix
 * Description: Generate temporary login links for users with expiration, role assignment, and login tracking.
 * Version: 1.0.3
 * Author: Softfix<support@softfixin>
 * Text Domain: temporary-login-by-softfix
 * License: GPLv2 or later
 * License URI: https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

define( 'SOFT_FIX_TEMPLOGIN_PATH', plugin_dir_path( __FILE__ ) );
define( 'SOFT_FIX_TEMPLOGIN_URL', plugin_dir_url( __FILE__ ) );

require_once SOFT_FIX_TEMPLOGIN_PATH . 'includes/functions.php';
require_once SOFT_FIX_TEMPLOGIN_PATH . 'includes/logger.php';
require_once SOFT_FIX_TEMPLOGIN_PATH . 'includes/admin-page.php';
add_action(
	'admin_enqueue_scripts',
	function () {
		$screen = get_current_screen();

		if('users_page_soft-fix-temp-login' == $screen->id){

			wp_enqueue_style( 'softfix-main-css', SOFT_FIX_TEMPLOGIN_URL . '/assets/css/main.css', array(), '1.0.3' );
		}
	}
);

register_activation_hook( __FILE__, 'soft_fix_schedule_cleanup' );
register_deactivation_hook( __FILE__, 'soft_fix_clear_schedule' );
register_activation_hook( __FILE__, 'soft_fix_create_log_table' );
