<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

function soft_fix_log_event( $user_id, $event, $url = '', $email = '' ) {
	global $wpdb;
	$table = $wpdb->prefix . 'soft_fix_login_logs';

	$wpdb->insert(
		$table,
		[
			'user_id'    => $user_id,
			'email'      => sanitize_email( $email ),
			'event'      => sanitize_text_field( $event ),
			'event_time' => current_time( 'mysql' ),
			'login_url'  => esc_url_raw( $url ),
		],
		[ '%d', '%s', '%s', '%s', '%s' ]
	);
}
