<?php
if (!defined('ABSPATH')) exit;

get_header();

$slug = get_post_meta(get_the_ID(), '_telo_aff_slug', true);

// Fallback: si no existiera meta → buscar en el contenido
if (!$slug) {
    $content = get_post_field('post_content', get_the_ID());
    if (preg_match('/telo_affiliate_dashboard\s+slug="([^"]+)"/', (string) $content, $m)) {
        $slug = sanitize_key($m[1]);
    }
}
?>
<main id="primary" class="telo-aff-page">
    <div class="telo-aff-container">
        <?php
        if ($slug) {
            echo do_shortcode(
                '[telo_affiliate_dashboard slug="' . esc_attr($slug) . '"]'
            );
        } else {
            echo '<p>' .
                esc_html__('Esta página aún no está vinculada a ningún afiliado.', 'telo-affiliates-lite') .
                '</p>';
        }
        ?>
    </div>
</main>
<?php get_footer();
