<?php
// includes/template-affiliate-page.php
if (!defined('ABSPATH')) exit;

// 1) Anunciar el template al selector de plantillas
add_filter('theme_page_templates', function ($templates) {
    $templates['telo-affiliates/affiliate-page.php'] = __('TELO – Panel de Afiliado (sin sidebar)', 'telo-affiliates-lite');
    return $templates;
});

// 2) Devolver la ruta del template cuando se seleccione
add_filter('template_include', function ($template) {
    if (is_singular('page')) {
        $tpl = get_page_template_slug(get_queried_object_id());
        if ($tpl === 'telo-affiliates/affiliate-page.php') {
            $plugin_tpl = TELO_AFFILIATES_DIR . 'templates/affiliate-page.php';
            if (file_exists($plugin_tpl)) return $plugin_tpl;
        }
    }
    return $template;
});

// 3) Añadir una clase al <body> para escopar estilos
add_filter('body_class', function ($classes) {
    if (is_singular('page') && get_page_template_slug(get_queried_object_id()) === 'telo-affiliates/affiliate-page.php') {
        $classes[] = 'telo-aff-template';
    }
    return $classes;
});

// 4) Encolar CSS sólo en este template
add_action('wp_enqueue_scripts', function () {
    if (is_singular('page') && get_page_template_slug(get_queried_object_id()) === 'telo-affiliates/affiliate-page.php') {
        wp_enqueue_style(
            'telo-affiliate-template',
            TELO_AFFILIATES_URL . 'assets/css/telo-affiliate-template.css',
            [],
            TELO_AFFILIATES_VERSION
        );
    }
});
